/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.vos.ResultBeanExtra;
import com.digiwin.chatbi.common.AdtServiceInvoker;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.controller.ScrumBIController;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.MessageUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataRetrievalExecutorSingleThread {
    private static final Logger log = LoggerFactory.getLogger(DataRetrievalExecutorSingleThread.class);
    @Autowired
    private ScrumBIController scrumBIController;

    public Output doProcess(JSONObject param, String token, String routerKey, String locale) {
        Output output = this.sequentialDataRetrieval(param, token, routerKey, locale);
        return output != null ? output : Output.through();
    }

    private Question buildQuestion(JSONObject param, String token, String routerKey) {
        Question question = new Question();
        question.setMessage(this.getSafeString(param, "message", ""));
        question.setAppCode(this.getSafeString(param, "appCode", ""));
        question.setProductVersion(this.getSafeString(param, "productVersion", "V2"));
        question.setAsaCode(this.getSafeString(param, "asaCode", ""));
        question.setAppVersion(this.getSafeString(param, "appVersion", "V2"));
        question.setMessageId4Ania(this.getSafeString(param, "messageId4Ania", ""));
        question.setMultiDialogue(this.getSafeBoolean(param, "multiDialogue", false));
        question.setCloseStream(this.getSafeBoolean(param, "closeStream", true));
        question.setEnableDataRecommend(this.getSafeBoolean(param, "enableDataRecommend", false));
        question.setMetricIdList(this.getSafeList(param, "metricIdList"));
        question.setDatasetIdList(this.getSafeList(param, "datasetIdList"));
        question.setToken(token);
        question.setRouterKey(routerKey);
        return question;
    }

    private String getSafeString(JSONObject param, String key, String defaultValue) {
        String value = param.getString(key);
        return value != null ? value : defaultValue;
    }

    private boolean getSafeBoolean(JSONObject param, String key, boolean defaultValue) {
        Boolean value = param.getBoolean(key);
        return value != null ? value : defaultValue;
    }

    private List<String> getSafeList(JSONObject param, String key) {
        JSONArray array = param.getJSONArray(key);
        return array != null ? array.toJavaList(String.class) : Collections.emptyList();
    }

    private Output sequentialDataRetrieval(JSONObject param, String token, String routerKey, String locale) {
        Question question = this.buildQuestion(param, token, routerKey);
        try {
            Object dataRetrievalParam = this.scrumBIController.doChat4StreamV2(question, locale);
            return this.retrievalData(question.getMessage(), dataRetrievalParam, token, routerKey, locale);
        }
        catch (Exception e) {
            log.error("\u8bed\u4e49\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private Output retrievalData(String question, Object dataRetrievalParam, String token, String routerKey, String locale) {
        JSONObject dataset = this.parseDataset(dataRetrievalParam);
        if (dataset == null) {
            log.error("\u6570\u636e\u6e90\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6548\u7684dataRetrievalParam\u7c7b\u578b");
            return null;
        }
        JSONObject datasetObj = dataset.getJSONObject("dataset");
        if (datasetObj == null) {
            log.error("\u6570\u636e\u96c6\u7ed3\u6784\u5f02\u5e38\uff0c\u7f3a\u5c11dataset\u5b57\u6bb5");
            return null;
        }
        if ("REPLY".equals(datasetObj.getString("type"))) {
            String replyMessage = datasetObj.getString("reply");
            if (StringUtils.isNotBlank((CharSequence)replyMessage)) {
                String finalReply = replyMessage;
                String messageByLangName = ((MessageUtils)SpringContextUtil.getBean(MessageUtils.class)).getMessageByLangName("message.scrumbi.no.metric.4.sentence", locale);
                if (messageByLangName.equals(replyMessage)) {
                    finalReply = "\u6ca1\u6709\u627e\u5230\u76f8\u5173\u8868";
                }
                log.info("\u68c0\u6d4b\u5230REPLY\u7c7b\u578b\u6570\u636e\uff0c\u8fd4\u56de\u56de\u590d\u4fe1\u606f: {}", (Object)finalReply);
                return Output.through((String)"reply", (Object)finalReply).keep("type", (Object)"REPLY");
            }
            log.error("REPLY\u7c7b\u578b\u6570\u636e\u4e2dreply\u5b57\u6bb5\u4e3a\u7a7a");
            return null;
        }
        AdtServiceInvoker adtServiceInvoker = (AdtServiceInvoker)SpringContextUtil.getBean(AdtServiceInvoker.class);
        JSONObject result = adtServiceInvoker.autodataGetdata(question, datasetObj.getJSONArray("datasetList").toJavaList(JSONObject.class), datasetObj.getString("appCode"), datasetObj.getJSONArray("solutionStep"), datasetObj.getJSONObject("showDefine"), token, routerKey);
        if (result == null || !result.getBooleanValue("queryResult")) {
            log.error("ADT\u67e5\u8be2\u5931\u8d25: queryResult=false");
            return null;
        }
        if (result.getBooleanValue("exceedSummarizeSize")) {
            log.error("ADT\u67e5\u8be2\u5931\u8d25: \u8d85\u51fatoken\u91cf");
            return null;
        }
        String summarizeData = result.getString("summarizeData");
        String snapshotId = result.getString("snapshotId");
        if (StringUtils.isBlank((CharSequence)summarizeData)) {
            log.error("ADT\u67e5\u8be2\u5931\u8d25: summarizeData\u4e3a\u7a7a");
            return null;
        }
        return Output.through((String)"retrievalDatas", (Object)summarizeData).keep("snapshotId", (Object)(snapshotId != null ? snapshotId : ""));
    }

    private JSONObject parseDataset(Object dataRetrievalParam) {
        if (dataRetrievalParam instanceof ResultBeanExtra) {
            ResultBeanExtra bean = (ResultBeanExtra)dataRetrievalParam;
            Object dataObj = bean.getData();
            return dataObj instanceof JSONObject ? (JSONObject)dataObj : JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataObj));
        }
        if (dataRetrievalParam instanceof JSONObject) {
            return (JSONObject)dataRetrievalParam;
        }
        return null;
    }
}

