/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.DataProcessAfterSearchExecutor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.DataSetPermissionFilterExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMatchestFieldAndDataSetsExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchMatchestFieldAndDataSetsExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        List dataSets = this.searchDatasetsByQuestionMsg(context, question);
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            log.info("\u672a\u68c0\u7d22\u5230\u76f8\u5173\u6570\u636e\u96c6");
            return Output.through();
        }
        Map matchedFieldsAndDataSetsMap = this.getMatchedFieldsAndDataSetsMap(question, dataSets);
        if (MapUtils.isEmpty((Map)matchedFieldsAndDataSetsMap)) {
            log.error("\u672a\u68c0\u7d22\u5230\u76f8\u5173\u5b57\u6bb5\u548c\u6570\u636e\u96c6\u7684\u6620\u5c04");
            return Output.through();
        }
        Map matchestFieldsAndDataSetsMap = this.getMatchestFieldsAndDataSetsMap(question, matchedFieldsAndDataSetsMap);
        if (MapUtils.isEmpty((Map)matchestFieldsAndDataSetsMap)) {
            log.error("\u6700\u957f\u8bcd\u8fc7\u6ee4\u540e\u4e3a\u7a7a");
            return Output.through();
        }
        Map matchestFieldsAndDataSetsMapWithPermission = this.filterMatchestFieldsAndDataSetsMap(context, matchestFieldsAndDataSetsMap);
        if (MapUtils.isEmpty((Map)matchestFieldsAndDataSetsMapWithPermission)) {
            log.error("\u6743\u9650\u8fc7\u6ee4\u540e\u4e3a\u7a7a");
            return Output.through();
        }
        return Output.through((String)"matchestFieldsAndDataSetsMap", (Object)matchestFieldsAndDataSetsMapWithPermission);
    }

    private Map<String, Set<JSONObject>> filterMatchestFieldsAndDataSetsMap(JSONObject context, Map<String, Set<JSONObject>> matchestFieldsAndDataSetsMap) {
        HashMap<String, Set<JSONObject>> matchestFieldsAndDataSetsMapWithPermission = new HashMap<String, Set<JSONObject>>();
        List matchestDataSets = matchestFieldsAndDataSetsMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toList());
        if (ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue()) {
            List dataSetsWithPermission = new DataSetPermissionFilterExecutor().filterMetricPermission(context, matchestDataSets);
            List idsWithPermission = dataSetsWithPermission.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList());
            for (Map.Entry<String, Set<JSONObject>> entry2 : matchestFieldsAndDataSetsMap.entrySet()) {
                Set<JSONObject> value = entry2.getValue();
                Set collect = value.stream().filter(v -> idsWithPermission.contains(v.getString("datasetId"))).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty(collect)) continue;
                matchestFieldsAndDataSetsMapWithPermission.put(entry2.getKey(), collect);
            }
        } else {
            return matchestFieldsAndDataSetsMap;
        }
        return matchestFieldsAndDataSetsMapWithPermission;
    }

    private Map<String, Set<JSONObject>> getMatchestFieldsAndDataSetsMap(Question question, Map<String, Set<JSONObject>> matchedFieldsAndDataSetsMap) {
        List words = matchedFieldsAndDataSetsMap.entrySet().stream().map(entry -> {
            JSONObject word = new JSONObject();
            word.put("compare_field", entry.getKey());
            return word;
        }).collect(Collectors.toList());
        List matchestWords = DataProcessAfterSearchExecutor.getMatchestWords(words, (String)question.getMessage());
        List matchestFileds = matchestWords.stream().map(matchestWord -> matchestWord.getString("compare_field")).collect(Collectors.toList());
        return matchedFieldsAndDataSetsMap.entrySet().stream().filter(stringSetEntry -> matchestFileds.contains(stringSetEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Set<JSONObject>> getMatchedFieldsAndDataSetsMap(Question question, List<JSONObject> dataSets) {
        String userMessage = question.getMessage();
        HashMap<String, Set<JSONObject>> fieldAndDataSetsMap = new HashMap<String, Set<JSONObject>>();
        for (JSONObject dataSet : dataSets) {
            List matchedFields = dataSet.getJSONArray("fieldSchema").stream().map(JSONObject.class::cast).flatMap(fieldShcema -> {
                ArrayList<String> fields = new ArrayList<String>();
                if (userMessage.contains(fieldShcema.getString("title"))) {
                    fields.add(fieldShcema.getString("title"));
                }
                if (MapUtils.isNotEmpty((Map)fieldShcema.getJSONObject("lang")) && MapUtils.isNotEmpty((Map)fieldShcema.getJSONObject("lang").getJSONObject("title"))) {
                    String ZH_TW = fieldShcema.getJSONObject("lang").getJSONObject("title").getString("zh_TW");
                    String ZH_CN = fieldShcema.getJSONObject("lang").getJSONObject("title").getString("zh_CN");
                    if (userMessage.contains(ZH_TW)) {
                        fields.add(ZH_TW);
                    }
                    if (userMessage.contains(ZH_CN)) {
                        fields.add(ZH_CN);
                    }
                }
                return fields.stream();
            }).distinct().collect(Collectors.toList());
            for (String matchedField : matchedFields) {
                Set matchedDataSets = fieldAndDataSetsMap.getOrDefault(matchedField, new HashSet());
                matchedDataSets.add(dataSet);
                fieldAndDataSetsMap.put(matchedField, matchedDataSets);
            }
        }
        return fieldAndDataSetsMap;
    }

    private List<JSONObject> searchDatasetsByQuestionMsg(JSONObject context, Question question) {
        String productVersion = question.getProductVersion();
        context.put("userMessage", (Object)question.getMessage());
        Retrieve retrieve = ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion) ? Retrieve.MATCH_DATASETS_BY_QUESTIONMSG_V2 : Retrieve.MATCH_DATASETS_BY_QUESTIONMSG_V1;
        return Optional.ofNullable(retrieve.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
    }
}

