/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.vos.ChatResultVo;
import com.digiwin.chatbi.common.enums.ChatResultCode;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.common.enums.KnowledgeDatabase;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import groovy.lang.Tuple3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputDataExecutor
implements Executor {
    public static final String OUTPUT_KEY = "finalResult";
    public static final List<String> RIGHT_SORT_WORDS = Arrays.asList("desc", "asc");
    public static final List<String> LIMIT_REQUIRE_FIELDS = Arrays.asList("startPos", "endPos", "direction");
    public static final List<String> REMOVE_OP_FIELDS = Arrays.asList("ITEMNAME", "CUSTOMERNAME", "EMPLOYEENAME", "ADMINUNITNAME");
    private static final Logger log = LoggerFactory.getLogger(OutputDataExecutor.class);
    private final EnumMap<IntentType, Function<JSONObject, Output>> intentMap = new EnumMap(IntentType.class);

    public OutputDataExecutor() {
        this.intentMap.put(IntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofKmModel(arg_0), ChatResultCode.KNOWLEDGE_GRAPH));
        this.intentMap.put(IntentType.PANEL, context -> this.finishWithResultVo(context, arg_0 -> this.ofKmModel(arg_0), ChatResultCode.KNOWLEDGE_GRAPH));
        this.intentMap.put(IntentType.MODEL_CENTER, context -> this.finishWithResultVo(context, arg_0 -> this.ofModelCenter(arg_0), ChatResultCode.MODEL_CENTER));
        this.intentMap.put(IntentType.OTHER, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResultCode)ChatResultCode.OTHER_QUESTION)));
        this.intentMap.put(IntentType.NOT_AVAILABLE, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.UN_SPECIFIED, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.DATA_SOURCE_NOT_MATCH, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"reply"), ChatResultCode.DATA_SOURCE_NOT_MATCH));
        this.intentMap.put(IntentType.FILTER_IN_NOT_SUPPORT, context -> this.finishWithResultVo(context, msg -> IntentType.FILTER_IN_NOT_SUPPORT.getDesc(), ChatResultCode.OTHER_QUESTION));
        this.intentMap.put(IntentType.ERROR, context -> this.finishWithResultVo(context, msg -> msg.get((Object)"error"), ChatResultCode.SYSTEM_ERROR));
    }

    public Output doProcess(JSONObject context) {
        if (context.containsKey((Object)"requiredField")) {
            return Output.finish((String)OUTPUT_KEY, (Object)ChatResultVo.createResult((JSONObject)context, msg -> context.get((Object)"requiredField"), (ChatResultCode)ChatResultCode.MODEL_CENTER_FAIL));
        }
        if (context.containsKey((Object)"usageExcept")) {
            return Output.finish((String)OUTPUT_KEY, (Object)ChatResultVo.createResult((JSONObject)context, msg -> context.get((Object)"usageExcept"), (ChatResultCode)ChatResultCode.USAGE_EXCEPT));
        }
        IntentType intentType = IntentType.OTHER;
        if (context.containsKey((Object)"have_scene_flag") && context.getBoolean("have_scene_flag").booleanValue()) {
            intentType = IntentType.GRAPH;
        }
        Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, msg -> msg, ChatResultCode.UNKNOWN));
        return action.apply(context);
    }

    private List<JSONObject> ofKmModel(JSONObject context) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (context.containsKey((Object)"Filter")) {
            JSONObject filterJsonObject = new JSONObject();
            filterJsonObject.put("name", (Object)"filter");
            filterJsonObject.put("technique", (Object)"filter");
            if (!Objects.isNull(context.getJSONObject("Filter"))) {
                filterJsonObject.put("condition", Optional.ofNullable(context.getJSONObject("Filter").get((Object)"condition")).map(item -> {
                    JSONObject conJ = (JSONObject)item;
                    JSONArray schemasNames = context.getJSONArray("schemasNames");
                    JSONArray schemas = context.getJSONObject("schemas").getJSONArray("Schemas");
                    Map synon2Detail = context.containsKey((Object)"synonymsMap") ? (Map)context.get((Object)"synonymsMap") : Collections.emptyMap();
                    JSONArray dimensionArr = Optional.ofNullable(context.getJSONObject("Dimension")).map(e -> e.getJSONArray("group_by")).orElse(new JSONArray());
                    Optional.ofNullable(conJ.getJSONArray("items")).ifPresent(jsonArray -> {
                        Iterator iterator = jsonArray.iterator();
                        while (iterator.hasNext()) {
                            AtomicBoolean isDone = new AtomicBoolean(false);
                            JSONObject itemJson = (JSONObject)iterator.next();
                            if (schemasNames.contains((Object)itemJson.getString("right"))) {
                                itemJson.put("type", (Object)"column");
                            }
                            if (schemasNames.contains((Object)itemJson.getString("left")) && synon2Detail.keySet().contains(itemJson.getString("right"))) {
                                String standardName = (String)((Tuple3)synon2Detail.get(itemJson.getString("right"))).getV1();
                                String field_name_en = (String)((Tuple3)synon2Detail.get(itemJson.getString("right"))).getV2();
                                if (!Objects.isNull(field_name_en) && field_name_en.equals(itemJson.getString("left"))) {
                                    itemJson.put("right", (Object)standardName);
                                }
                            }
                            schemas.stream().forEach(json -> {
                                JSONObject scheJSON = (JSONObject)json;
                                if (StringUtils.equals((CharSequence)scheJSON.getString("name"), (CharSequence)itemJson.getString("left")) && StringUtils.equals((CharSequence)scheJSON.getString("title"), (CharSequence)itemJson.getString("right"))) {
                                    iterator.remove();
                                    isDone.set(true);
                                }
                            });
                            if (isDone.get() || !CollectionUtils.isNotEmpty((Collection)dimensionArr) || "nin".equals(itemJson.getString("op"))) continue;
                            dimensionArr.remove((Object)itemJson.getString("left"));
                        }
                    });
                    return conJ;
                }).orElse(null));
            }
            this.addToListWhenConditionNotBlank(result, filterJsonObject, con -> con instanceof JSONObject && CollectionUtils.isEmpty((Collection)((JSONObject)con).getJSONArray("items")));
        }
        if (context.containsKey((Object)"SortAndLimit")) {
            JSONObject limitJsonObject = new JSONObject();
            limitJsonObject.put("name", (Object)"limit");
            limitJsonObject.put("technique", (Object)"group");
            if (!Objects.isNull(context.getJSONObject("SortAndLimit"))) {
                limitJsonObject.put("condition", (Object)Optional.ofNullable(context.getJSONObject("SortAndLimit").get((Object)"limit")).map(j -> {
                    JSONObject conJ = (JSONObject)j;
                    if (!conJ.containsKey((Object)"statistics")) {
                        return conJ;
                    }
                    List statistics = conJ.getJSONArray("statistics").stream().filter(item -> ((JSONObject)item).keySet().containsAll(LIMIT_REQUIRE_FIELDS)).collect(Collectors.toList());
                    conJ.put("statistics", statistics);
                    return conJ;
                }).orElse(new JSONObject()));
            }
            this.addToListWhenConditionNotBlank(result, limitJsonObject, con -> con instanceof JSONObject && CollectionUtils.isEmpty((Collection)((JSONObject)con).getJSONArray("statistics")));
            JSONObject sortJsonObject = new JSONObject();
            sortJsonObject.put("name", (Object)"sort");
            sortJsonObject.put("technique", (Object)"group");
            if (!Objects.isNull(context.getJSONObject("SortAndLimit"))) {
                sortJsonObject.put("condition", (Object)Optional.ofNullable(context.getJSONObject("SortAndLimit").get((Object)"sort")).map(j -> {
                    JSONObject conJ = (JSONObject)j;
                    if (!conJ.containsKey((Object)"statistics")) {
                        return conJ;
                    }
                    List checkSortCol = conJ.getJSONArray("statistics").stream().filter(sta -> {
                        String typeValue = ((JSONObject)sta).getString("type");
                        return RIGHT_SORT_WORDS.contains(typeValue);
                    }).collect(Collectors.toList());
                    conJ.put("statistics", checkSortCol);
                    return conJ;
                }).orElse(new JSONObject()));
            }
            this.addToListWhenConditionNotBlank(result, sortJsonObject, con -> con instanceof JSONObject && CollectionUtils.isEmpty((Collection)((JSONObject)con).getJSONArray("statistics")));
        }
        if (context.containsKey((Object)"Having")) {
            JSONObject havingJsonObject = new JSONObject();
            havingJsonObject.put("name", (Object)"having");
            havingJsonObject.put("technique", (Object)"filter");
            havingJsonObject.put("condition", context.get((Object)"Having"));
            this.addToListWhenConditionNotBlank(result, havingJsonObject, con -> false);
        }
        return result;
    }

    private JSONObject ofModelCenter(JSONObject context) {
        String prefix = KnowledgeDatabase.MODEL.toString();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("filter", context.getJSONObject(prefix + "Filter").get((Object)"filter"));
        jsonObject.put("measures", context.getJSONObject(prefix + "DM").get((Object)"measures"));
        jsonObject.put("dimensions", context.getJSONObject(prefix + "DM").get((Object)"dimensions"));
        jsonObject.put("dataType", context.getJSONObject(prefix + "DM").get((Object)"dataType"));
        jsonObject.put("chartType", context.getJSONObject(prefix + "DM").get((Object)"chartType"));
        jsonObject.put("sortFields", context.getJSONObject(prefix + "DistinctAndSort").get((Object)"sortFields"));
        jsonObject.put("distinct", context.getJSONObject(prefix + "DistinctAndSort").get((Object)"distinct"));
        jsonObject.put("computedFields", context.getJSONObject(prefix + "Computed").get((Object)"computedFields"));
        jsonObject.put("modelId", context.get((Object)PipelineFactory.PipelineKey.DATASOURCE_ID.getKey()));
        return jsonObject;
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, ?> replyGetter, ChatResultCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultVo.createResult((JSONObject)context, replyGetter, (ChatResultCode)resultCode));
    }

    private <T> void addToListWhenConditionNotBlank(List<JSONObject> result, JSONObject obj, Predicate<T> predicate) {
        Object checkObject = obj.get((Object)"condition");
        if (Objects.isNull(checkObject) || predicate.test(checkObject)) {
            return;
        }
        if (checkObject instanceof JSONArray) {
            if (CollectionUtils.isNotEmpty((Collection)((JSONArray)checkObject))) {
                result.add(obj);
            }
        } else if (checkObject instanceof JSONObject) {
            if (!((JSONObject)checkObject).isEmpty()) {
                result.add(obj);
            }
        } else if (checkObject instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)checkObject))) {
                result.add(obj);
            }
        } else {
            result.add(obj);
        }
    }
}

