/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.List;
import java.util.Map;

public class R2RemoveORule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        for (StepNode step : steps) {
            List orderBy = step.getO();
            WNode whereClause = step.getW();
            List limit = step.getL();
            if (orderBy == null || orderBy.isEmpty() || whereClause == null || !this.isSingleRowResult(whereClause, limit)) continue;
            step.setO(null);
            changed = true;
        }
        return changed;
    }

    private boolean isSingleRowResult(WNode whereClause, List<Integer> limit) {
        Map conditions;
        if (limit != null && !limit.isEmpty()) {
            if (limit.size() >= 2 && limit.get(1) == 1) {
                return true;
            }
            if (limit.size() == 1 && limit.get(0) == 1) {
                return true;
            }
        }
        if ((conditions = whereClause.getConditions()) != null) {
            if (conditions.containsKey("id eq")) {
                return true;
            }
            if (conditions.containsKey("unique_field eq")) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return "R2: W\u7cbe\u7b5b \u2192 \u79fb\u9664O\u5b50\u53e5";
    }
}

