/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PPTGenerateReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PPTRefineReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionPlanningReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionReGenerateReq;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import com.digiwin.chatbi.reasoning.search.config.ModelConfig;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PPTGenerationProcess {
    private static final Logger log = LoggerFactory.getLogger(PPTGenerationProcess.class);
    @Autowired
    private SseSendService sseSendService;

    public JSONObject doQuestionPlanning(QuestionPlanningReq questionPlanningReq) {
        Output output = Strategy.QUESTION_PLANNING.getPipeline().accept("questionPlanningReq", (Object)questionPlanningReq);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        res.put("timeTrace", (Object)timeTrace);
        res.put("outputTrace", (Object)outputTrace);
        log.info("doQuestionPlanning#res: {}", (Object)JSONObject.toJSONString((Object)res));
        return res;
    }

    public void doQuestionPlanning4Stream(QuestionPlanningReq questionPlanningReq) {
        JSONObject res = this.doQuestionPlanning(questionPlanningReq);
        res.remove((Object)"timeTrace");
        res.remove((Object)"outputTrace");
        this.sseSendService.sendPPTResult(questionPlanningReq, JSONObject.toJSONString((Object)res));
        if (Objects.nonNull(SseContext.getSseEmitter((String)questionPlanningReq.getId()))) {
            SseContext.getSseEmitter((String)questionPlanningReq.getId()).complete();
        }
        SseContext.cleanUpPPT((String)questionPlanningReq.getId());
    }

    public JSONObject doQuestionReGenarate(QuestionReGenerateReq questionReGenarateReq) {
        Output output = Strategy.QUESTION_REGENARATE_REQ.getPipeline().accept("questionReGenarateReq", (Object)questionReGenarateReq);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        return res;
    }

    public JSONObject doPPTGenarate(PPTGenerateReq pPTGenerateReq) {
        Output output = Strategy.PPT_GENERATE.getPipeline().accept("pPTGenerateReq", (Object)pPTGenerateReq);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        return res;
    }

    public String pPTRefine(PPTRefineReq req) {
        String gptRes;
        JSONObject context = new JSONObject();
        try {
            gptRes = ExecutorFactory.PPT_TEMPLATE_OPTIMIZE.callGpt(this.systemMessage(context, "ppt_template_optimize"), JSONObject.toJSONString((Object)req), null, Integer.valueOf(16384), null, Pipeline.getUserToken());
        }
        catch (Exception e) {
            log.error("ppt\u63d0\u70bc\u5f02\u5e38");
            return null;
        }
        return gptRes;
    }

    public String systemMessage(JSONObject context, String name, String type) {
        ModelConfig modelConfig = (ModelConfig)SpringContextUtil.getBean(ModelConfig.class);
        GroundModelConfig groundModelConfig = (GroundModelConfig)SpringContextUtil.getBean(GroundModelConfig.class);
        String enableCustomModel = modelConfig.getEnableCustomModel();
        if ("local".equals(groundModelConfig.getGroundDeployment()) && !"true".equals(enableCustomModel)) {
            type = "prompts_ground";
        }
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(type, name).getContent((Map)context);
    }

    public String systemMessage(JSONObject context, String name) {
        return this.systemMessage(context, name, "PPTPrompts");
    }
}

