/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.api.iam;

import com.digiwin.dap.middleware.iam.util.RSAUtils;
import com.digiwin.dap.middleware.util.AESUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class Login {
    private static final Logger logger = LoggerFactory.getLogger(Login.class);
    private static final String DigiwinCloud = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE1MzczMjY2ODk0NjEsInNpZCI6NDA3MTI4ODI1NTM0NDY0MSwiaWQiOiJEaWdpd2luQ2xvdWQifQ.XGPl3brNeNTCivWN_bIYj8TfcxqlkQ0sFV2woPOr0TY";

    public static void main(String[] args) {
        Map<String, String> requestJson = Login.loginRequestJson();
        System.out.println(requestJson);
    }

    public static String loginInternal() {
        String uri = "http://172.16.2.141:32511/api/iam/v2/identity/login/internal";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", DigiwinCloud);
            HashMap<String, String> requestEntity = new HashMap<String, String>(3);
            requestEntity.put("tenantId", "99990000");
            requestEntity.put("userId", "integration");
            requestEntity.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
            HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("token"));
        }
        catch (HttpStatusCodeException e) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getResponseBodyAsString(), (Object)e);
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public static String login() {
        String uri = "http://172.16.2.141:32511/api/iam/v2/identity/login";
        try {
            HashMap<String, String> keyMap = Login.getKeyPairMap();
            if (keyMap != null) {
                String clientPublicKey = keyMap.get("publicKey");
                String privateKey = keyMap.get("privateKey");
                String serverPublicKey = Login.getServerPublicky();
                String encryptPublicKey = RSAUtils.encryptByPublicKey(clientPublicKey, serverPublicKey);
                String encryptAesKey = Login.getAesPublicky(encryptPublicKey);
                String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64((String)encryptAesKey), privateKey));
                String passwordHash = AESUtils.aesEncryptByBase64("cloudent", aesKey);
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("digi-middleware-auth-app", DigiwinCloud);
                HashMap<String, String> requestEntity = new HashMap<String, String>(3);
                requestEntity.put("identityType", "token");
                requestEntity.put("userId", "cloudent");
                requestEntity.put("passwordHash", passwordHash);
                requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
                HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
                return String.valueOf(((Map)response.getBody()).get("token"));
            }
        }
        catch (Exception ex) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    public static Map<String, String> loginRequestJson() {
        try {
            HashMap<String, String> keyMap = Login.getKeyPairMap();
            if (keyMap != null) {
                String clientPublicKey = keyMap.get("publicKey");
                String privateKey = keyMap.get("privateKey");
                String serverPublicKey = Login.getServerPublicky();
                String encryptPublicKey = RSAUtils.encryptByPublicKey(clientPublicKey, serverPublicKey);
                String encryptAesKey = Login.getAesPublicky(encryptPublicKey);
                String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64((String)encryptAesKey), privateKey));
                String passwordHash = AESUtils.aesEncryptByBase64("cloudent", aesKey);
                HashMap<String, String> requestEntity = new HashMap<String, String>(3);
                requestEntity.put("identityType", "token");
                requestEntity.put("userId", "cloudent");
                requestEntity.put("passwordHash", passwordHash);
                requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
                return requestEntity;
            }
        }
        catch (Exception ex) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    private static String getServerPublicky() {
        String uri = "http://172.16.2.141:32511/api/iam/v2/identity/publickey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", DigiwinCloud);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("publicKey"));
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static String getAesPublicky(String encryptPublicKey) {
        String uri = "http://172.16.2.141:32511/api/iam/v2/identity/aeskey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", DigiwinCloud);
            HashMap<String, String> requestEntity = new HashMap<String, String>(1);
            requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
            HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("encryptAesKey"));
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }
}

