/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static final String IV_STRING = "ghUb#er57HBh(u%g";

    public static String aesEncryptByBase64(String src, String aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), "AES");
            byte[] initParam = IV_STRING.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, ivParameterSpec);
            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(ciphertextBytes);
        }
        catch (Exception ex) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25[{}]", (Object)src);
            return src;
        }
    }

    public static String aesEncrypt(String src, String aesKey) {
        try {
            SecretKeySpec key = AESUtils.generateMySQLAESKey(aesKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byte[] cleartext = src.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return new String(Hex.encodeHexString((byte[])ciphertextBytes)).toUpperCase();
        }
        catch (Exception ex) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25[{}]", (Object)src);
            return src;
        }
    }

    public static String aesDecrypt(String content, String aesKey) {
        try {
            SecretKeySpec key = AESUtils.generateMySQLAESKey(aesKey);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] cleartext = Hex.decodeHex((char[])content.toCharArray());
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            return new String(ciphertextBytes, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            logger.error("AES\u89e3\u5bc6\u5931\u8d25[{}]", (Object)content);
            return content;
        }
    }

    public static SecretKeySpec generateMySQLAESKey(String key) {
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : key.getBytes(StandardCharsets.UTF_8)) {
            int n = i++ % 16;
            finalKey[n] = (byte)(finalKey[n] ^ b);
        }
        return new SecretKeySpec(finalKey, "AES");
    }

    public static byte[] encryptIv(byte[] data, byte[] key, String transformation) {
        try {
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec params = new IvParameterSpec(iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, (Key)secretKeySpec, params);
            byte[] encrypted = cipher.doFinal(data);
            byte[] combined = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, combined, 0, iv.length);
            System.arraycopy(encrypted, 0, combined, iv.length, encrypted.length);
            return combined;
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    public static byte[] decryptIv(byte[] data, byte[] key, String transformation) {
        try {
            IvParameterSpec params = new IvParameterSpec(data, 0, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, (Key)secretKeySpec, params);
            return cipher.doFinal(data, 16, data.length - 16);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }
}

