/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.service.permission.auth;

import com.digiwin.service.permission.auth.DWAuthorizationVerifier;
import com.digiwin.service.permission.auth.param.DeductAuthorizationCountParam;
import com.digiwin.service.permission.auth.param.SubscriptionApiPermissionParam;
import com.digiwin.service.permission.auth.param.TenantPermissionParam;
import com.digiwin.service.permission.auth.param.UserPermissionParam;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class DWIAMAuthorizationVerifier
implements DWAuthorizationVerifier {
    private static Log log = LogFactory.getLog(DWIAMAuthorizationVerifier.class);
    static final String API_TOKEN_ANALYZE = "/api/iam/v2/identity/token/analyze";
    static final String USER_ACCESS_ANALYZE = "/api/ram/v2/access/srv/user/analyze";
    static final String TENANT_ACCESS_ANALYZE = "/api/ram/v2/access/srv/tenant/analyze";
    static final String SUBSCRIPTION_ACCESS_ANALYZE = "/api/ram/v2/access/api/analyze";
    static final String DEDUCT_AUTHORIZATION_COUNT = "/api/cac/v3/counting/decrease";
    static final String KEY_IAM_USER_ID = "id";
    static final String KEY_IAM_USER_NAME = "name";
    static final String KEY_IAM_USER_SID = "sid";

    @Override
    public Map<String, Object> verifyUserToken(String hostUrl, String userToken, String appToken) throws Exception {
        String url = this.processHostUrl(hostUrl) + API_TOKEN_ANALYZE;
        HttpPost post = new HttpPost(url);
        post.addHeader("digi-middleware-auth-user", userToken);
        post.addHeader("digi-middleware-auth-app", appToken);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return this.parseResponse((HttpResponse)response);
    }

    @Override
    public Map<String, Object> verifyUserServicePermission(String hostUrl, UserPermissionParam param) throws Exception {
        String url = this.processHostUrl(hostUrl) + USER_ACCESS_ANALYZE;
        HttpPost post = this.buildPost(url, null, param);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return this.parseAccessResponse((HttpResponse)response);
    }

    @Override
    public Map<String, Object> verifyTenantServicePermission(String hostUrl, TenantPermissionParam param) throws Exception {
        String url = this.processHostUrl(hostUrl) + TENANT_ACCESS_ANALYZE;
        HttpPost post = this.buildPost(url, null, param);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return this.parseAccessResponse((HttpResponse)response);
    }

    @Override
    public Map<String, Object> verifySubscriptionApiPermission(String hostUrl, Map<String, String> requestHeaders, SubscriptionApiPermissionParam param) throws Exception {
        String url = this.processHostUrl(hostUrl) + SUBSCRIPTION_ACCESS_ANALYZE;
        HttpPost post = this.buildPost(url, requestHeaders, param);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        return this.parseAccessResponse((HttpResponse)response);
    }

    @Override
    public Map<String, Object> deductAuthorizationCount(String cacHostUrl, String appToken, DeductAuthorizationCountParam param) throws Exception {
        HashMap<String, Object> result;
        String url = this.processHostUrl(cacHostUrl) + DEDUCT_AUTHORIZATION_COUNT;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("digi-middleware-auth-app", appToken);
        requestHeaders.put("digi-middleware-auth-secret-key", param.getAuthSecretKey());
        requestHeaders.put("digi-middleware-auth-user", param.getIamUserToken());
        LinkedHashMap<String, Integer> paramMap = new LinkedHashMap<String, Integer>();
        paramMap.put("decreaseCount", param.getDecreaseCount());
        HttpPost post = this.buildPost(url, requestHeaders, param);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        log.info((Object)("Call CAC deduct API: " + param));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (status != 200) {
            log.error((Object)String.format("CAC deduct API response failed! status: %s, response body: %s", status, body));
            result = new HashMap();
            result.put("success", false);
            result.put("return-status", status);
            result.put("failed-result", body);
        } else {
            try {
                JSONObject jsonObject = new JSONObject(body);
                result = jsonObject.toMap();
                if (result.containsKey("success") && !Boolean.TRUE.equals(result.get("success"))) {
                    log.error((Object)String.format("CAC deduct API result failed! return body: %s", body));
                }
            }
            catch (Exception e) {
                log.error((Object)"CAC deduct API result deserialization exception!", (Throwable)e);
                result = new HashMap<String, Object>();
                result.put("success", "unknown");
                result.put("return-status", status);
                result.put("result", "can't deserialize to map");
                result.put("original-result", body);
            }
        }
        return result;
    }

    private String processHostUrl(String hostUrl) {
        if (hostUrl.endsWith("/")) {
            hostUrl = hostUrl.substring(0, hostUrl.length() - 1);
        }
        return hostUrl;
    }

    private HttpPost buildPost(String url, Map<String, String> requestHeaders, Object param) throws Exception {
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-type", "application/json; charset=utf-8");
        post.addHeader("Accept", "application/json");
        if (Objects.nonNull(requestHeaders)) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        String reqData = new JSONObject(param).toString();
        post.setEntity((HttpEntity)new StringEntity(reqData, "utf-8"));
        return post;
    }

    private Map<String, Object> parseResponse(HttpResponse response) throws Exception {
        int status = response.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (200 != status) {
            throw new RuntimeException(body);
        }
        JSONObject obj = new JSONObject(body);
        String sysId = null;
        if (obj.has("sysId")) {
            sysId = obj.getString("sysId");
        }
        Long sysSid = null;
        if (obj.has("sysSid")) {
            sysSid = obj.getLong("sysSid");
        }
        String tenantId = null;
        if (obj.has("tenantId")) {
            tenantId = obj.getString("tenantId");
        }
        String tenantName = null;
        if (obj.has("tenantName")) {
            tenantName = obj.getString("tenantName");
        }
        Long tenantSid = null;
        if (obj.has("tenantSid")) {
            tenantSid = obj.getLong("tenantSid");
        }
        String userId = null;
        if (obj.has("userId")) {
            userId = obj.getString("userId");
        } else if (obj.has(KEY_IAM_USER_ID)) {
            userId = obj.getString(KEY_IAM_USER_ID);
        }
        String userName = null;
        if (obj.has("userName")) {
            userName = obj.getString("userName");
        } else if (obj.has(KEY_IAM_USER_NAME)) {
            userName = obj.getString(KEY_IAM_USER_NAME);
        }
        Long userSid = null;
        if (obj.has("userSid")) {
            userSid = obj.getLong("userSid");
        } else if (obj.has(KEY_IAM_USER_SID)) {
            userSid = obj.getLong(KEY_IAM_USER_SID);
        }
        HashMap<String, Object> profile = new HashMap<String, Object>();
        if (Objects.nonNull(sysId)) {
            profile.put("sysId", sysId);
        }
        if (Objects.nonNull(sysSid)) {
            profile.put("sysSid", sysSid);
        }
        if (Objects.nonNull(tenantId)) {
            profile.put("tenantId", tenantId);
        }
        if (Objects.nonNull(tenantName)) {
            profile.put("tenantName", tenantName);
        }
        if (Objects.nonNull(tenantSid)) {
            profile.put("tenantSid", tenantSid);
        }
        if (Objects.nonNull(userId)) {
            profile.put("userId", userId);
        }
        if (Objects.nonNull(userName)) {
            profile.put("userName", userName);
        }
        if (Objects.nonNull(userSid)) {
            profile.put("userSid", userSid);
        }
        return profile;
    }

    private Map<String, Object> parseAccessResponse(HttpResponse response) throws Exception {
        int status = response.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (200 != status) {
            throw new RuntimeException(body);
        }
        JSONObject obj = new JSONObject(body);
        return obj.toMap();
    }
}

