/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.DWSecurityToken;
import com.digiwin.service.permission.util.AESUtil;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public final class DWSecurityTokenUtil {
    static final long A_MINUTE = 60000L;
    static final int DEFAULT_EFFECTIVE_MINUTES = 10;

    DWSecurityTokenUtil() {
    }

    public static String generateSecurityToken(DWSecurityContext context) throws Exception {
        return DWSecurityTokenUtil.generateSecurityToken(context, 10);
    }

    public static String generateSecurityToken(DWSecurityContext context, int effectiveMinutes) throws Exception {
        DWSecurityToken securityToken = new DWSecurityToken();
        Map<String, Object> profile = context.getProfile();
        Object userSid = null;
        Object tenantSid = null;
        if (Objects.nonNull(profile)) {
            if (Objects.nonNull(profile.get("userSid"))) {
                userSid = profile.get("userSid");
                profile.put("userSid", Objects.toString(userSid));
            }
            if (Objects.nonNull(profile.get("tenantSid"))) {
                tenantSid = profile.get("tenantSid");
                profile.put("tenantSid", Objects.toString(tenantSid));
            }
        }
        securityToken.setContext(context);
        securityToken.setExpirationTime(Instant.now().toEpochMilli() + (long)effectiveMinutes * 60000L);
        String result = AESUtil.encrypt(DWGsonProvider.getGson().toJson((Object)securityToken));
        if (Objects.nonNull(profile)) {
            if (Objects.nonNull(userSid)) {
                profile.put("userSid", userSid);
            }
            if (Objects.nonNull(tenantSid)) {
                profile.put("tenantSid", tenantSid);
            }
        }
        return result;
    }

    public static DWSecurityToken parseSecurityToken(String securityToken) throws Exception {
        try {
            String decryptToken = AESUtil.decrypt(securityToken);
            DWSecurityToken token = (DWSecurityToken)DWGsonProvider.getGson().fromJson(decryptToken, DWSecurityToken.class);
            DWSecurityContext context = token.getContext();
            Map<String, Object> profile = context.getProfile();
            if (Objects.nonNull(profile)) {
                if (Objects.nonNull(profile.get("userSid"))) {
                    profile.put("userSid", Long.parseLong(Objects.toString(profile.get("userSid"))));
                }
                if (Objects.nonNull(profile.get("tenantSid"))) {
                    profile.put("tenantSid", Long.parseLong(Objects.toString(profile.get("tenantSid"))));
                }
            }
            return token;
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6548\u7684security-token\uff01");
        }
    }
}

