/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.aop.InitTraceId;
import java.lang.reflect.Method;
import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class InitTraceIdAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitTraceIdAspect.class);

    @Pointcut(value="@annotation(com.digiwin.smartdata.agiledataengine.aop.InitTraceId)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        InitTraceId InitTraceId2 = method.getAnnotation(InitTraceId.class);
        if (InitTraceId2 == null) {
            return joinPoint.proceed();
        }
        String ptxId = ThreadContext.get((String)"PtxId");
        if (!StringUtils.hasText((String)ptxId)) {
            String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
            LOGGER.error("\u63a5\u6536\u7684messageId\u4e3a:{} ", (Object)messageId);
            ThreadContext.put((String)"PtxId", (String)messageId);
            ThreadContext.put((String)"traceId", (String)messageId);
        }
        return joinPoint.proceed();
    }
}

