/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.client;

import com.digiwin.smartdata.agiledataengine.client.ExecutorAdmin;
import com.digiwin.smartdata.agiledataengine.core.util.XxlJobRemotingUtil;
import com.digiwin.smartdata.agiledataengine.pojo.request.xxl.XxlJobInfo;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExecutorAdminClient
implements ExecutorAdmin {
    @Value(value="${xxl.job.admin.addresses}")
    private String addressUrl;
    @Value(value="${xxl.job.accessToken}")
    private String accessToken;
    @Autowired
    private XxlJobRemotingUtil xxlJobRemotingUtil;
    private int timeout = 3;

    public ExecutorAdminClient() {
    }

    public ExecutorAdminClient(String addressUrl, String accessToken) {
        this.addressUrl = addressUrl;
        this.accessToken = accessToken;
        if (!this.addressUrl.endsWith("/")) {
            this.addressUrl = this.addressUrl + "/";
        }
    }

    @Override
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        return this.xxlJobRemotingUtil.postBodyForFormData(this.addressUrl + "jobinfo/add", this.accessToken, this.timeout, jobInfo, String.class);
    }

    @Override
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        return this.xxlJobRemotingUtil.postBody(this.addressUrl + "jobinfo/update", this.accessToken, this.timeout, jobInfo, String.class);
    }

    @Override
    public ReturnT<String> remove(int id) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("id", id);
        return this.xxlJobRemotingUtil.postBodyForFormData(this.addressUrl + "jobinfo/remove", this.accessToken, this.timeout, paramMap, String.class);
    }

    @Override
    public ReturnT<String> pause(int id) {
        return this.xxlJobRemotingUtil.postBody(this.addressUrl + "jobinfo/stop", this.accessToken, this.timeout, id, String.class);
    }

    @Override
    public ReturnT<String> start(int id) {
        return this.xxlJobRemotingUtil.postBody(this.addressUrl + "jobinfo/start", this.accessToken, this.timeout, id, String.class);
    }
}

