/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.component.mapping.data;

import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataNode;
import com.digiwin.smartdata.agiledataengine.core.holder.ReadContextHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DataMappingHandler {
    private ReadContextHolder readContextHolder;
    private HashMap<String, DataNode> mappingDataCollection;
    private Map<String, String> idxPathToNode;

    public boolean pathIsExistsInData(String path) {
        return this.idxPathToNode.containsKey(path);
    }

    public DataMappingHandler(HashMap<String, DataNode> mappingDataCollection, ReadContextHolder readContextHolder) {
        this.mappingDataCollection = mappingDataCollection;
        if (readContextHolder == null) {
            readContextHolder = new ReadContextHolder();
        }
        this.readContextHolder = readContextHolder;
        this.idxPathToNode = new HashMap<String, String>();
        if (!mappingDataCollection.isEmpty()) {
            for (Map.Entry<String, DataNode> mappingData : mappingDataCollection.entrySet()) {
                this.idxPathToNode.put(mappingData.getValue().getParamPath(), mappingData.getKey());
            }
        }
    }

    protected HashMap<String, DataNode> getDataCollection() {
        return this.mappingDataCollection;
    }

    private void setIdxPathToNode(DataNode dataNode) {
        if (dataNode != null && !this.idxPathToNode.containsKey(dataNode.getParamPath())) {
            this.idxPathToNode.put(dataNode.getParamPath(), dataNode.getNodeId());
        }
    }

    private List<String> convertToJsonRoute(String paramPath) {
        if (StringUtils.isEmpty((CharSequence)paramPath)) {
            return null;
        }
        ArrayList<String> jsonRoute = new ArrayList<String>();
        String path = paramPath;
        int pos = path.lastIndexOf(".");
        while (pos > 0) {
            jsonRoute.add(this.idxPathToNode.get(path));
            path = path.substring(0, pos);
            pos = path.lastIndexOf(".");
        }
        jsonRoute.add(this.idxPathToNode.get(path));
        Collections.reverse(jsonRoute);
        return jsonRoute;
    }

    public DataNode createNode(boolean isRootNode, String nodeName, String parentNodeId, String lastCollectionNode, int totalCnt, boolean isObject, boolean isArray, boolean isArrayAsObject, String pathTemplate, String paramPath) {
        String name = nodeName;
        if (isRootNode) {
            name = ".ROOT";
        }
        DataNode dataNode = new DataNode(name, parentNodeId, lastCollectionNode, totalCnt, isObject, isArray, isArrayAsObject, pathTemplate, paramPath, null);
        this.setIdxPathToNode(dataNode);
        this.mappingDataCollection.put(dataNode.getNodeId(), dataNode);
        if (!isRootNode) {
            dataNode.setJsonRoute(this.convertToJsonRoute(paramPath));
        }
        return dataNode;
    }

    public DataNode createNode(String nodeName, Object jsonDataPart, DataNode parentNode, String subFieldParamPath, Object jsonDataWhole) {
        boolean isArray = false;
        boolean isObject = false;
        if (jsonDataPart instanceof List) {
            isArray = true;
            List subCollection = (List)jsonDataPart;
            if (subCollection.size() > 0 && subCollection.get(0) instanceof Map) {
                isObject = true;
            }
        }
        if (jsonDataPart instanceof Map) {
            isObject = true;
        }
        String pathTemplate = this.getPathTemplate(parentNode) + "." + nodeName;
        if (isArray) {
            pathTemplate = pathTemplate + "[*]";
        }
        int totalCnt = 0;
        String parentDataNodeId = this.getDataNodeId(parentNode);
        String lastCollectionNode = this.isArray(parentNode) ? this.getDataNodeId(parentNode) : this.getLastCollectionNode(parentNode);
        DataNode dataNode = this.createNode(false, nodeName, parentDataNodeId, lastCollectionNode, totalCnt, isObject, isArray, false, pathTemplate, subFieldParamPath);
        this.mappingDataCollection.put(dataNode.getNodeId(), dataNode);
        return dataNode;
    }

    public int calcZoneSize(DataNode dataNode, Object jsonDataWhole, String key, String jsonLengthPath) {
        int zoneSize = 1;
        if (dataNode.isArray()) {
            String concretePathForLength = jsonLengthPath + ".length()";
            zoneSize = (Integer)this.readContextHolder.getData(key, jsonDataWhole, concretePathForLength);
        }
        return zoneSize;
    }

    public void setZone(String concreteJsonPath, String parentConcretePath, DataNode dataNode, int zoneSize) {
        if (!this.isExistZone(dataNode, parentConcretePath)) {
            this.addZone(dataNode, parentConcretePath, zoneSize);
        }
    }

    public void appendTotalCnt(DataNode dataNode, int count) {
        dataNode.addTotalCnt(count);
    }

    public DataNode getDataNode(String nodeId) {
        return this.mappingDataCollection.get(nodeId);
    }

    public String getDataNodeId(DataNode dataNode) {
        if (dataNode == null) {
            return null;
        }
        return dataNode.getNodeId();
    }

    public String getDataNodeName(DataNode dataNode) {
        if (dataNode == null) {
            return null;
        }
        return dataNode.getNodeName();
    }

    public DataNode getDataNodeByParamPath(String paramPath) {
        String nodeId = this.idxPathToNode.get(paramPath);
        if (nodeId == null || nodeId.isEmpty()) {
            return null;
        }
        return this.mappingDataCollection.get(nodeId);
    }

    public String getParamPath(DataNode dataNode) {
        return dataNode.getParamPath();
    }

    public String getParamPath(String nodeId) {
        if (!this.mappingDataCollection.containsKey(nodeId)) {
            return null;
        }
        return this.mappingDataCollection.get(nodeId).getParamPath();
    }

    public String getNodeName(DataNode dataNode) {
        return dataNode.getNodeName();
    }

    public String getNodeName(String nodeId) {
        if (!this.mappingDataCollection.containsKey(nodeId)) {
            return null;
        }
        return this.mappingDataCollection.get(nodeId).getNodeName();
    }

    public String getPathTemplate(DataNode dataNode) {
        return dataNode.getPathTemplate();
    }

    public String getPathTemplate(String nodeId) {
        if (!this.mappingDataCollection.containsKey(nodeId)) {
            return null;
        }
        return this.mappingDataCollection.get(nodeId).getPathTemplate();
    }

    public String getPathTemplateByPath(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        return dataNode == null ? null : dataNode.getPathTemplate();
    }

    public void setEmptyMapNode(String nodeId) {
        this.getDataNode(nodeId).setEmptyMap();
    }

    public void setEmptyMapNode(DataNode dataNode) {
        dataNode.setEmptyMap();
    }

    public List<String> getChildrenId(DataNode dataNode) {
        if (dataNode == null || dataNode.getChildren() == null) {
            return null;
        }
        return dataNode.getChildren();
    }

    public List<String> getChildrenId(String nodeId) {
        return this.getChildrenId(this.mappingDataCollection.get(nodeId));
    }

    private int getLastCollectionZonePos(DataNode node) {
        if (".ROOT".equals(node.getNodeName())) {
            return 0;
        }
        DataNode parentNode = this.getDataNode(node.getParentNodeId());
        return parentNode.getZonePos();
    }

    private String getJsonPathInst(DataNode node) {
        String parentNodeId = node.getParentNodeId();
        String jsonPathInst = "";
        if (!".ROOT".equals(node.getNodeName())) {
            jsonPathInst = this.getJsonPathInst(this.mappingDataCollection.get(parentNodeId));
            jsonPathInst = jsonPathInst + "." + node.getNodeName();
        } else {
            jsonPathInst = "$";
        }
        if (node.isArray()) {
            jsonPathInst = jsonPathInst + "[" + node.getZonePos() + "]";
        }
        return jsonPathInst;
    }

    private int getZoneSize(DataNode node) {
        Map<String, Integer> zone = node.getZone();
        String jsonPathInst = this.getJsonPathInst(node);
        int pos = jsonPathInst.lastIndexOf(".");
        jsonPathInst = pos > 0 ? jsonPathInst.substring(0, pos) : "$";
        System.out.println(jsonPathInst);
        Integer zoneSize = zone.get(jsonPathInst);
        return zoneSize == null ? 0 : zoneSize;
    }

    public int getZoneDataSize(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        int size = 0;
        if (dataNode != null) {
            if (".ROOT".equals(dataNode.getNodeName())) {
                size = dataNode.getZone().get("$");
            } else {
                String zoneKey = this.getConcreteJsonPath(this.getParentNode(dataNode));
                size = this.getSizeInZone(dataNode, zoneKey);
            }
        }
        return size;
    }

    public int getZoneDataSize(String paramPath, String fixedPath) {
        int size = 0;
        if (paramPath == null || paramPath.isEmpty() || fixedPath == null || fixedPath.isEmpty()) {
            return size;
        }
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        if (dataNode != null) {
            if (".ROOT".equals(dataNode.getNodeName())) {
                size = dataNode.getZone().get("$");
            } else {
                String zoneKey = fixedPath.substring(0, fixedPath.lastIndexOf("."));
                size = this.getSizeInZone(dataNode, zoneKey);
            }
        }
        return size;
    }

    public int getPathDataSize(String paramPath, String fixedPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        int size = 0;
        if (dataNode == null) {
            return size;
        }
        if (fixedPath != null && "".equals(fixedPath)) {
            size = dataNode.getTotalCnt();
        } else if (dataNode.getZone() != null && dataNode.getZone().size() != 0) {
            for (Map.Entry<String, Integer> zoneSize : dataNode.getZone().entrySet()) {
                if (!zoneSize.getKey().contains(fixedPath)) continue;
                Integer sizeValue = zoneSize.getValue();
                size += sizeValue == null ? 0 : sizeValue;
            }
        }
        return size;
    }

    public int getPathDataSize(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        if (dataNode == null) {
            return 0;
        }
        if (".ROOT".equals(dataNode.getNodeName())) {
            return dataNode.getTotalCnt();
        }
        DataNode parentNode = this.getParentNode(dataNode);
        String fixedPath = this.concatJsonPath(parentNode);
        return this.getPathDataSize(paramPath, fixedPath);
    }

    public int countCollectionInPath(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        return this.countCollectionInPath(dataNode);
    }

    private int countCollectionInPath(DataNode dataNode) {
        if (dataNode != null && dataNode.getLastCollectionNode() != null) {
            return this.countCollectionInPath(this.getDataNode(dataNode.getLastCollectionNode())) + 1;
        }
        return 0;
    }

    public List<String> getCollectionParamPathList(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        List<String> pathList = this.getCollectionParamPathList(dataNode);
        Collections.sort(pathList);
        return pathList;
    }

    private List<String> getCollectionParamPathList(DataNode dataNode) {
        ArrayList<String> paramPathList = new ArrayList<String>();
        if (dataNode != null && dataNode.getLastCollectionNode() != null) {
            DataNode parentNode = this.getDataNode(dataNode.getLastCollectionNode());
            paramPathList.add(parentNode.getParamPath());
            paramPathList.addAll(this.getCollectionParamPathList(parentNode));
        }
        return paramPathList;
    }

    public boolean isCollectionParam(String paramPath) {
        return this.getDataNodeByParamPath(paramPath) == null ? true : this.getDataNodeByParamPath(paramPath).isArray();
    }

    public boolean isObjectCollectionParam(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        return dataNode.isArray() && dataNode.isObject();
    }

    private int isExistZone(DataNode node) {
        int lastCollectionZonePos = -1;
        String zoneKey = this.getConcreteJsonPath(node);
        if (!node.getZone().containsKey(zoneKey)) {
            System.out.println("----> \u5f53\u524d\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u6307\u5b9a:" + zoneKey);
            lastCollectionZonePos = this.nextPos(this.mappingDataCollection.get(node.getLastCollectionNode()));
        }
        return lastCollectionZonePos;
    }

    private int nextPos(DataNode node) {
        int zoneSize = this.getZoneSize(node);
        int zonePos = node.getZonePos();
        if (node.isArray()) {
            if (zonePos + 1 < zoneSize) {
                int tmp = zonePos++;
                System.out.println("\u6570\u636e\u5145\u8db3\uff0cnode.Name:" + node.getNodeName() + " pos from " + tmp + " to " + zonePos);
                node.setZonePos(zonePos);
                return zonePos;
            }
            int lastCollectionZonePos = -1;
            if (node.getLastCollectionNode() != null) {
                System.out.println("\u5373\u5c06\u8fdb\u5165\uff1a" + this.mappingDataCollection.get(node.getLastCollectionNode()).getNodeName());
                lastCollectionZonePos = this.nextPos(this.mappingDataCollection.get(node.getLastCollectionNode()));
                if (lastCollectionZonePos >= 0) {
                    int tmp = zonePos;
                    zonePos = 0;
                    System.out.println("nextPos: node.Name:" + node.getNodeName() + " pos from " + tmp + " to " + zonePos);
                    node.setZonePos(zonePos);
                }
            }
            return lastCollectionZonePos;
        }
        System.out.println("\u5373\u5c06\u8fdb\u5165\uff1a" + this.mappingDataCollection.get(node.getLastCollectionNode()).getNodeName());
        return this.nextPos(this.mappingDataCollection.get(node.getLastCollectionNode()));
    }

    public boolean next(String paramPath, String limitPath) {
        return this.nextPos(this.getDataNodeByParamPath(paramPath)) >= 0;
    }

    public String getConcreteJson(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        return this.getConcreteJsonPath(dataNode);
    }

    public String getConcreteJsonPath(DataNode node) {
        if (node == null || node.getChildren() == null) {
            return null;
        }
        String concretePath = node.getPathTemplate();
        List<String> nodeIdList = node.getJsonRoute();
        int pos = 0;
        for (String nodeId : nodeIdList) {
            DataNode nodeInRoute = this.getDataNode(nodeId);
            if (!nodeInRoute.isArray()) continue;
            pos = this.getZonePos(nodeInRoute);
            concretePath = concretePath.replaceFirst("\\*", String.valueOf(pos));
        }
        return concretePath;
    }

    public String getConcreteJsonPath(String currentNodeId) {
        return this.getConcreteJsonPath(this.mappingDataCollection.get(currentNodeId));
    }

    public int getZonePos(DataNode dataNode) {
        return dataNode.getZonePos();
    }

    public String getLastCollectionNode(DataNode dataNode) {
        return dataNode.getLastCollectionNode();
    }

    public String getLastCollectionNodeParamPath(String paramPath) {
        DataNode node = this.getDataNodeByParamPath(paramPath);
        if (node == null) {
            return null;
        }
        DataNode lastCollectionNode = this.getDataNode(node.getLastCollectionNode());
        if (lastCollectionNode == null) {
            return null;
        }
        return lastCollectionNode.getParamPath();
    }

    public boolean isArray(DataNode dataNode) {
        return dataNode.isArray();
    }

    public boolean isArray(String paramPath) {
        return this.getDataNodeByParamPath(paramPath).isArray();
    }

    public boolean isExistZone(DataNode dataNode, String zonePath) {
        Map<String, Integer> zone = dataNode.getZone();
        return zone.containsKey(zonePath);
    }

    public void addZone(DataNode dataNode, String zonePath, int zoneSize) {
        Integer size = new Integer(zoneSize);
        dataNode.addZone(zonePath, size);
    }

    public void addChildNode(DataNode parentNode, DataNode childNode) {
        parentNode.addChildren(childNode.getNodeId());
    }

    public int getSizeInZone(DataNode dataNode, String zonePath) {
        Integer size = dataNode.getZone().get(zonePath);
        return size == null ? 0 : size;
    }

    public int getSizeInZone(String nodeId, String zonePath) {
        DataNode dataNode = this.mappingDataCollection.get(nodeId);
        return this.getSizeInZone(dataNode, zonePath);
    }

    public DataNode getParentNode(DataNode dataNode) {
        String parentNodeId = dataNode.getParentNodeId();
        if (parentNodeId == null) {
            return null;
        }
        DataNode parentDataNode = this.mappingDataCollection.get(parentNodeId);
        return parentDataNode;
    }

    public DataNode getParentNode(String nodeId) {
        return this.getParentNode(this.mappingDataCollection.get(nodeId));
    }

    public void setParentNodePosition(String paramPath, int pos) {
        DataNode dataNode = this.getParentNode(this.getDataNodeByParamPath(paramPath).getNodeId());
        if (dataNode != null && dataNode.isArray()) {
            dataNode.setGlobalPos(pos);
        }
    }

    public void setNodePosition(String paramPath, int pos) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        if (dataNode != null && dataNode.isArray()) {
            dataNode.setGlobalPos(pos);
        }
    }

    public String getDataJsonPath(String paramPath) {
        DataNode dataNode = this.getDataNodeByParamPath(paramPath);
        if (dataNode == null) {
            return null;
        }
        return this.concatJsonPath(dataNode);
    }

    private String concatJsonPath(DataNode dataNode) {
        String jsonPath;
        if (".ROOT".equals(dataNode.getNodeName())) {
            jsonPath = "$";
        } else {
            jsonPath = this.concatJsonPath(this.getParentNode(dataNode.getNodeId()));
            jsonPath = jsonPath + "." + dataNode.getNodeName();
        }
        if (dataNode.isArray() && dataNode.isObject()) {
            jsonPath = jsonPath + "[" + dataNode.getGlobalPos() + "]";
        }
        return jsonPath;
    }

    public Set<String> getLeafParamPath() {
        if (MapUtils.isEmpty(this.mappingDataCollection)) {
            return new HashSet<String>();
        }
        LinkedHashSet<String> allLeafParamPathSet = new LinkedHashSet<String>();
        for (Map.Entry<String, DataNode> entry : this.mappingDataCollection.entrySet()) {
            DataNode dataNode = entry.getValue();
            if (!this.isLeafNode(dataNode)) continue;
            allLeafParamPathSet.add(dataNode.getParamPath());
        }
        return allLeafParamPathSet;
    }

    protected boolean isLeafNode(DataNode node) {
        return node != null && !node.isObject();
    }

    public boolean isLeafNode(String paramPath) {
        return this.isLeafNode(this.getDataNodeByParamPath(paramPath));
    }

    public String getParentParamPath(String paramPath) {
        DataNode node = this.getDataNodeByParamPath(paramPath);
        if (node == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)node.getParentNodeId())) {
            return null;
        }
        return this.getDataNode(node.getParentNodeId()).getParamPath();
    }

    public Map<String, Integer> getZoneByParamPath(String paramPath) {
        return this.getDataNodeByParamPath(paramPath).getZone();
    }

    public int getTotalCountByParamPath(String paramPath) {
        return this.getDataNodeByParamPath(paramPath).getTotalCnt();
    }

    public boolean isRootNode(String paramPath) {
        return ".ROOT".equalsIgnoreCase(this.getDataNodeByParamPath(paramPath).getNodeName());
    }

    public List<String> getChildrenParamPath(String paramPath) {
        List<String> nodeIds = this.getChildrenId(this.getDataNodeByParamPath(paramPath));
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Lists.newArrayList();
        }
        ArrayList<String> paramPathList = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            DataNode node = this.getDataNode(nodeId);
            if (node == null) continue;
            paramPathList.add(node.getParamPath());
        }
        return paramPathList;
    }
}

