/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.component.mapping.data;

import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataMappingHandler;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataNode;
import com.digiwin.smartdata.agiledataengine.core.holder.ReadContextHolder;
import com.digiwin.smartdata.agiledataengine.model.input.ExecutionInputParamModule;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class DataMappingManager {
    private Map<String, HashMap<String, DataNode>> dataCollection;
    private Map<String, HashMap<String, DataNode>> dataPackCollection;
    private Map<String, Object> actionResponseMap = new HashMap<String, Object>();
    private ExecutionInputParamModule inputParam;
    private Map<String, DataMappingHandler> handlerCollection;
    private ReadContextHolder readContextHolder;
    private final ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();

    public DataMappingManager(Map<String, Object> actionResponseMap, ExecutionInputParamModule inputParam) {
        this.dataCollection = new ConcurrentHashMap<String, HashMap<String, DataNode>>();
        this.handlerCollection = new ConcurrentHashMap<String, DataMappingHandler>();
        this.dataPackCollection = new ConcurrentHashMap<String, HashMap<String, DataNode>>();
        this.actionResponseMap = actionResponseMap;
        this.inputParam = inputParam;
    }

    public DataMappingManager(Object data) {
        this.dataCollection = new ConcurrentHashMap<String, HashMap<String, DataNode>>();
        this.handlerCollection = new ConcurrentHashMap<String, DataMappingHandler>();
        this.dataPackCollection = new ConcurrentHashMap<String, HashMap<String, DataNode>>();
        this.inputParam = new ExecutionInputParamModule();
        this.inputParam.setActionId("ExecutionParam");
        if (data != null) {
            if (data instanceof Map) {
                this.inputParam.setParam((Map)data);
            } else if (data instanceof List) {
                this.inputParam.setParas((List)data);
            }
        }
        this.inputParam.setTenantId("");
        this.actionResponseMap.put("ExecutionParam", data);
    }

    private HashMap<String, DataNode> addNewCollection(String actionId) {
        HashMap data = new HashMap();
        this.dataCollection.put(actionId, data);
        if (!this.dataCollection.containsKey(actionId)) {
            this.dataCollection.put(actionId, data);
        }
        return this.dataCollection.get(actionId);
    }

    private void createPackHandler(String dataPackKey, HashMap<String, DataNode> pack) {
        this.handlerCollection.put(dataPackKey, new DataMappingHandler(pack, this.readContextHolder));
    }

    public String getDataPackKey(String requestActionId, String responseActionId) {
        return requestActionId + "-" + responseActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, DataNode> createPack(String requestActionId, String responseActionId) {
        Object lock;
        Object object = lock = this.lockMap.computeIfAbsent(responseActionId, k -> new Object());
        synchronized (object) {
            if (!this.dataCollection.containsKey(responseActionId)) {
                this.generateCollection(responseActionId, this.addNewCollection(responseActionId));
            }
        }
        String dataPackKey = this.getDataPackKey(requestActionId, responseActionId);
        if (this.dataPackCollection.containsKey(dataPackKey)) {
            return this.dataPackCollection.get(dataPackKey);
        }
        HashMap<String, DataNode> pack = new HashMap<String, DataNode>();
        pack.putAll((Map)this.dataCollection.get(responseActionId));
        this.dataPackCollection.put(dataPackKey, pack);
        return pack;
    }

    private HashMap<String, DataNode> getPack(String requestActionId, String responseActionId) {
        String dataPackKey = this.getDataPackKey(requestActionId, responseActionId);
        if (!this.dataPackCollection.containsKey(dataPackKey)) {
            this.createPackHandler(dataPackKey, this.createPack(requestActionId, responseActionId));
        }
        return this.dataPackCollection.get(dataPackKey);
    }

    public DataMappingHandler getDatMappingHandler(String requestActionId, String responseActionId) {
        if (this.getPack(requestActionId, responseActionId) == null) {
            // empty if block
        }
        return this.handlerCollection.get(this.getDataPackKey(requestActionId, responseActionId));
    }

    private void generateCollection(String reqonseActionId, HashMap<String, DataNode> data) {
        Object responseData = null;
        responseData = "ExecutionParam".equals(reqonseActionId) ? (this.inputParam.getParam() == null ? this.inputParam.getParas() : this.inputParam.getParam()) : ("ExecutionSysParam".equals(reqonseActionId) ? this.inputParam.getSysParam() : this.actionResponseMap.get(reqonseActionId));
        if (responseData == null) {
            return;
        }
        DataMappingHandler handler = new DataMappingHandler(data, this.readContextHolder);
        this.handlerCollection.put(reqonseActionId, handler);
        boolean isRootNode = true;
        String nodeName = ".ROOT";
        String parentNodeId = null;
        int totalCnt = 1;
        String lastCollectionNode = null;
        boolean isArrayAsObject = false;
        String pathTemplate = "$";
        if (responseData instanceof List) {
            pathTemplate = pathTemplate + "[*]";
        }
        String paramPath = "$";
        boolean isObject = false;
        boolean isArray = false;
        if (responseData instanceof List) {
            isArray = true;
            isObject = this.checkElementIsObject((List)responseData);
        }
        if (responseData instanceof Map) {
            isObject = true;
        }
        DataNode rootNode = handler.createNode(isRootNode, nodeName, parentNodeId, lastCollectionNode, totalCnt, isObject, isArray, isArrayAsObject, pathTemplate, paramPath);
        String concreteJsonPath = "$";
        int zoneSize = handler.calcZoneSize(rootNode, responseData, reqonseActionId, concreteJsonPath);
        handler.setZone(concreteJsonPath, concreteJsonPath, rootNode, zoneSize);
        handler.appendTotalCnt(rootNode, zoneSize);
        this.analiyzeData(reqonseActionId, responseData, responseData, rootNode, concreteJsonPath);
        this.dataCollection.put(reqonseActionId, handler.getDataCollection());
    }

    private boolean checkElementIsObject(List responseData) {
        if (CollectionUtils.isEmpty((Collection)responseData)) {
            return false;
        }
        for (Object element : responseData) {
            if (element == null || !(element instanceof Map)) continue;
            return true;
        }
        return false;
    }

    private void analiyzeData(String reqonseActionId, Object data, Object originData, DataNode parentDataNode, String parentConcretePath) {
        block7: {
            block6: {
                if (!this.handlerCollection.containsKey(reqonseActionId)) {
                    // empty if block
                }
                DataMappingHandler nodeHandler = this.handlerCollection.get(reqonseActionId);
                if (!(data instanceof Map)) break block6;
                Map mapData = (Map)data;
                if (mapData.size() <= 0) {
                    nodeHandler.setEmptyMapNode(parentDataNode);
                    return;
                }
                String parentParamPath = nodeHandler.getParamPath(parentDataNode);
                for (Map.Entry subField : mapData.entrySet()) {
                    String subFieldParamPath = parentParamPath + "." + (String)subField.getKey();
                    DataNode dataNode = nodeHandler.getDataNodeByParamPath(subFieldParamPath);
                    if (dataNode == null) {
                        dataNode = nodeHandler.createNode((String)subField.getKey(), subField.getValue(), parentDataNode, subFieldParamPath, this.actionResponseMap.get(reqonseActionId));
                    }
                    this.updateIsObject(subField.getValue(), dataNode);
                    String concreteJsonPath = parentConcretePath + "." + (String)subField.getKey();
                    int zoneSize = nodeHandler.calcZoneSize(dataNode, originData, reqonseActionId, concreteJsonPath);
                    nodeHandler.setZone(concreteJsonPath, parentConcretePath, dataNode, zoneSize);
                    nodeHandler.appendTotalCnt(dataNode, zoneSize);
                    nodeHandler.addChildNode(parentDataNode, dataNode);
                    this.analiyzeData(reqonseActionId, subField.getValue(), originData, dataNode, concreteJsonPath);
                }
                break block7;
            }
            if (!(data instanceof List)) break block7;
            List listData = (List)data;
            if (listData.size() <= 0) {
                return;
            }
            int listIndex = 0;
            for (Object subData : listData) {
                String concreteJsonPath = parentConcretePath + "[" + listIndex + "]";
                this.analiyzeData(reqonseActionId, subData, originData, parentDataNode, concreteJsonPath);
                ++listIndex;
            }
        }
    }

    private void updateIsObject(Object jsonDataPart, DataNode dataNode) {
        List subCollection;
        if (dataNode.isArray() && dataNode.isObject()) {
            return;
        }
        if (jsonDataPart instanceof List && (subCollection = (List)jsonDataPart).size() > 0 && subCollection.get(0) instanceof Map) {
            dataNode.setObject(true);
        }
    }

    public void setReadContextHolder(ReadContextHolder readContextHolder) {
        this.readContextHolder = readContextHolder;
    }

    public void release(String sourceKey, String currentKey) {
        String key = sourceKey + "-" + currentKey;
        this.handlerCollection.remove(key);
        this.handlerCollection.remove(currentKey);
        this.dataPackCollection.remove(key);
        this.dataCollection.remove(currentKey);
    }
}

