/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.component.mapping.data;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataMappingHandler;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataNode;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponse;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponseData;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class MetaGenerator {
    private DataMappingHandler dataMappingHandler;
    private String actionId;

    public MetaGenerator(DataMappingHandler dataMappingHandler) {
        this.dataMappingHandler = dataMappingHandler;
    }

    public MetaGenerator(DataMappingHandler dataMappingHandler, String actionId) {
        this.dataMappingHandler = dataMappingHandler;
        this.actionId = actionId;
    }

    public JSONObject generate() {
        Set<String> leafParamPath = this.dataMappingHandler.getLeafParamPath();
        HashSet<String> nodeIdList = new HashSet<String>();
        ArrayList<Map<String, Object>> responseMetas = new ArrayList<Map<String, Object>>(leafParamPath.size());
        for (String paramPath : leafParamPath) {
            HashMap<String, Object> responseMeta = new HashMap<String, Object>();
            this.dataMappingHandler.getDataNodeByParamPath(paramPath);
            responseMetas.add(this.generate(paramPath, responseMeta, nodeIdList));
        }
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("data_name", "data");
        data.put("data_type", "object");
        data.put("required", "true");
        data.put("is_datakey", null);
        data.put("is_array", false);
        data.put("field", responseMetas);
        HashMap<String, HashMap<String, Object>> response = new HashMap<String, HashMap<String, Object>>(1);
        response.put("data", data);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("actionId", this.actionId);
        meta.put("request", new HashMap());
        meta.put("response", response);
        meta.put("name", null);
        meta.put("sceneNodeType", null);
        return JSONObject.parseObject((String)JsonUtil.getJsonString(meta));
    }

    private Map<String, Object> generate(String paramPath, Map<String, Object> childMetaNode, Set<String> nodeIdList) {
        if (this.dataMappingHandler.isRootNode(paramPath)) {
            return childMetaNode;
        }
        DataNode dataNode = this.dataMappingHandler.getDataNodeByParamPath(paramPath);
        if (nodeIdList.contains(dataNode.getNodeId())) {
            return childMetaNode;
        }
        nodeIdList.add(paramPath);
        Map<String, Object> meta = this.generateMetaDefineNode(dataNode);
        if (!CollectionUtils.isEmpty(childMetaNode)) {
            this.generateMetaChildrenNode(meta, childMetaNode);
        }
        String parentParamPath = this.dataMappingHandler.getParentParamPath(paramPath);
        return this.generate(parentParamPath, meta, nodeIdList);
    }

    private Map<String, Object> generateMetaDefineNode(DataNode dataNode) {
        HashMap<String, Object> metaDefineNode = new HashMap<String, Object>();
        metaDefineNode.put("data_name", dataNode.getNodeName());
        metaDefineNode.put("data_type", "string");
        metaDefineNode.put("required", "true");
        metaDefineNode.put("is_datakey", null);
        metaDefineNode.put("is_array", dataNode.isArray() ? "true" : "false");
        metaDefineNode.put("is_businesskey", "false");
        metaDefineNode.put("can_sort", "false");
        metaDefineNode.put("can_filter", "false");
        metaDefineNode.put("percent", null);
        metaDefineNode.put("decimal", null);
        metaDefineNode.put("field", null);
        metaDefineNode.put("description", "");
        return metaDefineNode;
    }

    private void generateMetaChildrenNode(Map<String, Object> meta, Map<String, Object> metaNode) {
        if (meta.get("field") == null) {
            ArrayList<Map<String, Object>> fieldsMeta = new ArrayList<Map<String, Object>>();
            fieldsMeta.add(metaNode);
            meta.put("field", fieldsMeta);
        } else {
            List fields = (List)meta.get("field");
            fields.add(metaNode);
        }
    }

    public JSONObject merge(JSONObject newMeta, JSONObject orgMeta) {
        if (orgMeta.get((Object)"actionMetadatas") != null && !CollectionUtils.isEmpty((Collection)((Collection)orgMeta.get((Object)"actionMetadatas")))) {
            List metadatas = (List)orgMeta.get((Object)"actionMetadatas");
            for (Map metadata : metadatas) {
                if (!metadata.get("actionId").equals(newMeta.get((Object)"actionId"))) continue;
                newMeta.put("request", metadata.get("request"));
                MetaDataResponseData newResponseData = ((MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)newMeta.get((Object)"response")), MetaDataResponse.class)).getData();
                MetaDataResponseData orgResponseData = ((MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString(metadata.get("response")), MetaDataResponse.class)).getData();
                if (newResponseData.getData_name().equals(orgResponseData.getData_name())) {
                    newResponseData.buildMetaDataResponseData(orgResponseData);
                    this.buildField(newResponseData.getField(), orgResponseData.getField());
                }
                MetaDataResponse response = new MetaDataResponse();
                response.setData(newResponseData);
                newMeta.put("response", (Object)response);
            }
        } else {
            return newMeta;
        }
        return newMeta;
    }

    private void buildField(List<MetaDataResponseData> newResponseDataField, List<MetaDataResponseData> orgResponseDataField) {
        block0: for (MetaDataResponseData newField : newResponseDataField) {
            for (MetaDataResponseData orgfield : orgResponseDataField) {
                if (!newField.getData_name().equals(orgfield.getData_name())) continue;
                newField.buildMetaDataResponseData(orgfield);
                if (CollectionUtils.isEmpty((Collection)newField.getField())) continue block0;
                this.buildField(newField.getField(), orgfield.getField());
                continue block0;
            }
        }
    }
}

