/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.core.base;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.smartdata.agiledataengine.core.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseDao {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;

    protected int update(String statement, Object ... params) {
        return this.dao.update(statement, params);
    }

    protected int insert(String statement, Object ... params) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return this.dao.update((IDWSQLOptions)option, statement, params);
    }

    protected List<Map<String, Object>> select(String statement, Object ... params) {
        return this.dao.select(statement, params);
    }

    protected <T> List<T> select(Class<T> cls, String statement, Object ... params) {
        List<Map<String, Object>> resultLit = this.select(statement, params);
        if (CollectionUtil.isEmpty(resultLit)) {
            return new ArrayList();
        }
        return resultLit.stream().map(JsonUtil::getJsonString).map(itemStr -> JsonUtil.getObject((String)itemStr, (Class)cls)).collect(Collectors.toList());
    }
}

