/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.core.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.CollectionUtils;

public class AddSecurityTokenHeaderInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddSecurityTokenHeaderInterceptor.class);
    public static final String SECURITY_TOKEN = "security-token";

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            if (!CollectionUtils.isEmpty((Map)DWServiceContext.getContext().getProfile())) {
                String SecurityToken = DWSecurityTokenGenerator.generateSecurityToken((DWSecurityContext)this.genDWSecurityContext(DWServiceContext.getContext().getProfile()));
                HttpHeaders headers = request.getHeaders();
                headers.add(SECURITY_TOKEN, SecurityToken);
            }
        }
        catch (Exception e) {
            LOGGER.info("{}", (Object)e.getMessage());
        }
        return execution.execute(request, body);
    }

    public DWSecurityContext genDWSecurityContext(Map<String, Object> profile) {
        String iamApToken = DWApplicationConfigUtils.getProperty((String)"iamApToken");
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        securityContext.setAppToken(iamApToken);
        securityContext.setProfile(profile);
        securityContext.setTokenVerified();
        return securityContext;
    }
}

