/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.core.config;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class HttpConnectionCloseCron {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionCloseCron.class);
    private final HttpClientConnectionManager httpClientConnectionManager;

    public HttpConnectionCloseCron(HttpClientConnectionManager httpClientConnectionManager) {
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    @Scheduled(cron="0 0/5 * * * ?")
    public void execute() {
        LOGGER.info("close http pool expire and idle connection...");
        this.httpClientConnectionManager.closeExpiredConnections();
        this.httpClientConnectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
    }
}

