/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.core.config;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.core.config.RabbitMQProp;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.SendRetryContextAccessor;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.RetryContext;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableRabbit
public class RabbitMQConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQConfig.class);
    @Autowired
    private RabbitMQProp property;
    @Autowired
    private RabbitAdmin amqpAdmin;

    public RabbitMQConfig(RabbitMQProp property, RabbitTemplate rabbitTemplate) {
        this.property = property;
        rabbitTemplate.setConfirmCallback((correlationData, ack, cause) -> {
            if (!ack) {
                LOGGER.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25,ID\u4e3a: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)correlationData.getId(), (Object)cause);
            }
        });
    }

    @Bean
    public RabbitAdmin amqpAdmin(ConnectionFactory connectionFactory) {
        RabbitAdmin rabbitAdmin = new RabbitAdmin(connectionFactory);
        rabbitAdmin.setAutoStartup(true);
        return rabbitAdmin;
    }

    @Bean
    public Queue getAdeQueue() {
        Queue queue = new Queue(DWApplicationPropertiesUtils.getProperty((String)"application", (String)"agiledataengine.rabbit.connect.queue"), true, false, false);
        this.amqpAdmin.declareQueue(queue);
        return queue;
    }

    public RabbitTemplate rabbitTemplate(ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        return rabbitTemplate;
    }

    @Bean
    public RabbitAdmin snapshotSendRabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    public DirectExchange getDirectExchange() {
        return new DirectExchange(this.property.getExchange(), true, false, null);
    }

    @Bean
    public Queue getQueue() {
        HashMap<String, Object> arguments = new HashMap<String, Object>(4);
        arguments.put("x-message-ttl", this.property.getTtl());
        arguments.put("x-dead-letter-exchange", this.property.getDdlExchange());
        arguments.put("x-dead-letter-routing-key", this.property.getDdlRoutingKey());
        return new Queue(this.property.getQueue(), true, false, false, arguments);
    }

    @Bean
    public Queue getQueuePtm() {
        HashMap<String, Integer> arguments = new HashMap<String, Integer>(4);
        arguments.put("x-message-ttl", this.property.getTtl());
        return new Queue(this.property.getQueuePtm(), true, false, false, arguments);
    }

    @Bean
    public Queue getQueueTask() {
        HashMap<String, Integer> arguments = new HashMap<String, Integer>(4);
        arguments.put("x-message-ttl", this.property.getTtl());
        return new Queue(this.property.getQueueTaskEngine(), true, false, false, arguments);
    }

    @Bean
    public Binding binding() {
        return BindingBuilder.bind((Queue)this.getQueue()).to(this.getDirectExchange()).with(this.property.getRoutingKey());
    }

    @Bean
    public Binding bindingPtm() {
        return BindingBuilder.bind((Queue)this.getQueuePtm()).to(this.getDirectExchange()).with(this.property.getRoutingKeyPtm());
    }

    @Bean
    public Binding bindingTask() {
        return BindingBuilder.bind((Queue)this.getQueueTask()).to(this.getDirectExchange()).with(this.property.getRoutingKeyTaskEngine());
    }

    @Bean
    public DirectExchange getDeadLetterDirectExchange() {
        return new DirectExchange(this.property.getDdlExchange(), true, false, null);
    }

    @Bean
    public Binding bindingDeadLetter() {
        return BindingBuilder.bind((Queue)this.getDeadLetterQueue()).to(this.getDeadLetterDirectExchange()).with(this.property.getDdlRoutingKey());
    }

    @Bean
    public Queue getDeadLetterQueue() {
        return new Queue(this.property.getDdlQueue(), true, false, false);
    }

    @Bean
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        factory.setConcurrentConsumers(Integer.valueOf(this.property.getSimpleConcurrency()));
        factory.setMaxConcurrentConsumers(Integer.valueOf(this.property.getSimpleMaxConcurrency()));
        factory.setPrefetchCount(Integer.valueOf(this.property.getSimplePrefetch()));
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setMultiplier((double)this.property.getSimpleMultiplier());
        backOffPolicy.setInitialInterval((long)this.property.getSimpleInitialInterval());
        backOffPolicy.setMaxInterval((long)this.property.getSimpleMaxInterval());
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        factory.setRetryTemplate(retryTemplate);
        factory.setReplyRecoveryCallback(ctx -> {
            Message failed = SendRetryContextAccessor.getMessage((RetryContext)ctx);
            Address replyTo = SendRetryContextAccessor.getAddress((RetryContext)ctx);
            Throwable t = ctx.getLastThrowable();
            StringBuilder message = new StringBuilder("\u6d88\u606f\u4e3a\uff1a");
            message.append(new String(failed.getBody(), StandardCharsets.UTF_8));
            message.append(", \u54cd\u5e94\u56de\u7ed9exchangeName\uff1a");
            message.append(replyTo.getExchangeName());
            message.append(", routingKey\uff1a");
            message.append(replyTo.getRoutingKey());
            message.append(" \u7684\u76f8\u5173\u64cd\u4f5c\u91cd\u8bd5\u540e\u8fd8\u662f\u5931\u8d25\uff01\u8bf7\u6ce8\u610f\uff01");
            LOGGER.error(message.toString(), t);
            return null;
        });
        return factory;
    }
}

