/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.core.config;

import com.digiwin.smartdata.agiledataengine.core.config.AddSecurityTokenHeaderInterceptor;
import java.util.Arrays;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;

@EnableRetry
@Configuration
@EnableAsync(proxyTargetClass=true)
public class RestTemplateConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateConfig.class);
    @Value(value="${httpClientMaxTotal}")
    private int maxTotal;
    @Value(value="${httpClientMaxPerRoute}")
    private int maxPerRoute;
    @Value(value="${httpClientRequestTimeOutMilliSecond}")
    private int requestTimeOutMilliSecond;
    @Value(value="${httpClientConnectTimeOutMilliSecond}")
    private int connectTimeOutMilliSecond;
    @Value(value="${httpClientSocketTimeOutMilliSecond}")
    private int socketTimeOutMilliSecond;
    private static final int MAX_RETRY = 5;

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate(this.httpRequestFactory());
        AddSecurityTokenHeaderInterceptor interceptor = new AddSecurityTokenHeaderInterceptor();
        restTemplate.setInterceptors(Arrays.asList(interceptor));
        return restTemplate;
    }

    private ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClient());
    }

    private HttpClient httpClient() {
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeOutMilliSecond).setConnectTimeout(this.connectTimeOutMilliSecond).setConnectionRequestTimeout(this.requestTimeOutMilliSecond).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((exception, executionCount, context) -> {
            if (exception instanceof NoHttpResponseException && executionCount <= 5) {
                LOGGER.error("[HttpClient]No response from server on " + executionCount + " call");
                return true;
            }
            return false;
        }).build();
    }

    @Bean(value={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }
}

