/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.job;

import com.alibaba.fastjson.JSON;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleDetailModel;
import com.digiwin.smartdata.agiledataengine.service.impl.CustomHttpClient;
import com.digiwin.smartdata.agiledataengine.service.srp.db.IScheduleDefineService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduleJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleJob.class);
    @Autowired
    private CustomHttpClient customHttpClient;
    @Autowired
    private IScheduleDefineService defineService;

    @XxlJob(value="agileSubscribe")
    public ReturnT exeScheduleJob() {
        String instanceId = Optional.ofNullable(JSON.parseObject((String)XxlJobHelper.getJobParam())).map(json -> json.getString("instance_id")).orElse("");
        LOGGER.info("ScheduleJob#exeScheduleJob instanceId: {}", (Object)instanceId);
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return ReturnT.SUCCESS;
        }
        try {
            ScheduleDetailModel scheduleDetailModel = this.defineService.getScheduleInfoByInstanceId(instanceId);
            String realTimeTenantToken = this.customHttpClient.getRealTimeTenantToken(scheduleDetailModel.getTenantId());
            LOGGER.info("ScheduleJob#exeScheduleJob scheduleDetailModel: {}, realTimeTenantToken: {}", (Object)JSON.toJSONString((Object)scheduleDetailModel), (Object)realTimeTenantToken);
            this.customHttpClient.postExecuteTrigger(scheduleDetailModel, realTimeTenantToken);
        }
        catch (Exception e) {
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }
}

