/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.producer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.core.config.RabbitMQProp;
import com.digiwin.smartdata.agiledataengine.core.util.AgileParamsAssemble;
import com.digiwin.smartdata.agiledataengine.core.util.StringUtil;
import com.digiwin.smartdata.agiledataengine.service.impl.CustomHttpClient;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProducer.class);
    public static final String ROUTING_KEY = "routingKey.schedule.execute";
    public static final String AGILE_CALLER = "agileSubscribe";
    @Autowired
    private RabbitTemplate template;
    @Autowired
    private RabbitMQProp rabbitMQProperty;
    @Autowired
    private CustomHttpClient customHttpClient;

    public String sendMessage(Map<String, Object> paramMap) {
        String routingKey;
        String messageId = UUID.randomUUID().toString();
        String string = routingKey = StringUtil.isEmpty(MapUtils.getString(paramMap, (Object)"caller")) ? this.rabbitMQProperty.getRoutingKey() : ROUTING_KEY + MapUtils.getString(paramMap, (Object)"caller");
        if (AGILE_CALLER.equals(MapUtils.getString(paramMap, (Object)"caller"))) {
            LOGGER.info("MessageProducer#sendMessage trigger send message :{}, ruleId{} ,exchangeAgile :{}, agileRoutingKey :{}, v-host :{}", new Object[]{paramMap, paramMap.get("ruleId"), this.rabbitMQProperty.getExchangeAgile(), this.rabbitMQProperty.getRoutingKeyAgile(), this.rabbitMQProperty.getVirtualHost()});
            String tenantId = MapUtils.getString(paramMap, (Object)"tenantId");
            if (StringUtils.isBlank((CharSequence)tenantId)) {
                return "";
            }
            String realTimeTenantToken = this.customHttpClient.getRealTimeTenantToken(tenantId);
            MessageProperties messageProperties = new MessageProperties();
            messageProperties.setHeader("token", (Object)realTimeTenantToken);
            messageProperties.setHeader("routerKey", (Object)tenantId);
            Map<String, Object> resultMap = AgileParamsAssemble.assembleMqMesssage(this.getCheckMap(paramMap, "scheduleParam"));
            LOGGER.error("\u53d1\u9001\u7ed9ADT\u7684\u6d88\u606f\uff1aMessageProducer#sendMessage tenantId :{}, token :{}, resultMap :{} , ", new Object[]{tenantId, realTimeTenantToken, JsonUtil.getJsonString(resultMap)});
            Message message = new Message(JSONObject.toJSONString(resultMap).getBytes(), messageProperties);
            this.template.convertAndSend(this.rabbitMQProperty.getExchangeAgile(), this.rabbitMQProperty.getRoutingKeyAgile(), (Object)message, new CorrelationData(messageId));
        } else {
            this.template.convertAndSend(this.rabbitMQProperty.getExchangeAgile(), routingKey, paramMap, new CorrelationData(messageId));
        }
        return messageId;
    }

    private Map<String, Object> getCheckMap(Map<String, Object> paramMap, String scheduleCustomParam) {
        if (paramMap.containsKey(scheduleCustomParam) && paramMap.get(scheduleCustomParam) instanceof String) {
            if (JSON.parseObject((String)((String)paramMap.get(scheduleCustomParam)), HashMap.class) != null && ((HashMap)JSON.parseObject((String)((String)paramMap.get(scheduleCustomParam)), HashMap.class)).get(scheduleCustomParam) != null) {
                Map scheduleCustom = (Map)JSON.parseObject((String)((String)paramMap.get(scheduleCustomParam)), HashMap.class);
                String appCode = (String)scheduleCustom.get("appCode");
                Map scheduleCustomParams = MapUtils.getMap((Map)scheduleCustom, (Object)scheduleCustomParam);
                scheduleCustomParams.put("appCode", appCode);
                scheduleCustomParams.put("ruleId", scheduleCustom.get("ruleId"));
                return scheduleCustomParams;
            }
            return (Map)JSON.parseObject((String)((String)paramMap.get(scheduleCustomParam)), HashMap.class);
        }
        return MapUtils.getMap(paramMap, (Object)scheduleCustomParam);
    }
}

