/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.resource.DWModuleMessageResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.anylaze.IAnalyzer;
import com.digiwin.smartdata.agiledataengine.aop.InitTraceId;
import com.digiwin.smartdata.agiledataengine.dto.ResultDto;
import com.digiwin.smartdata.agiledataengine.metric.model.MetadataItem;
import com.digiwin.smartdata.agiledataengine.model.AdeBaseRequest;
import com.digiwin.smartdata.agiledataengine.model.AdeInstantRequest;
import com.digiwin.smartdata.agiledataengine.model.AdeRequest;
import com.digiwin.smartdata.agiledataengine.model.AdeSnapshotRequest;
import com.digiwin.smartdata.agiledataengine.model.AttributionDimensionRequest;
import com.digiwin.smartdata.agiledataengine.model.AttributionDimensionResponse;
import com.digiwin.smartdata.agiledataengine.model.ChartConvertRequest;
import com.digiwin.smartdata.agiledataengine.model.ChartTypeEnum;
import com.digiwin.smartdata.agiledataengine.model.Context;
import com.digiwin.smartdata.agiledataengine.model.DmcFileResponse;
import com.digiwin.smartdata.agiledataengine.model.KMQueryDataRequest;
import com.digiwin.smartdata.agiledataengine.model.Snapshot;
import com.digiwin.smartdata.agiledataengine.model.StructureModel;
import com.digiwin.smartdata.agiledataengine.pojo.BizParams;
import com.digiwin.smartdata.agiledataengine.pojo.PullData;
import com.digiwin.smartdata.agiledataengine.service.BmdService;
import com.digiwin.smartdata.agiledataengine.service.DataSnapshotService;
import com.digiwin.smartdata.agiledataengine.service.DcpService;
import com.digiwin.smartdata.agiledataengine.service.IamService;
import com.digiwin.smartdata.agiledataengine.service.SendService;
import com.digiwin.smartdata.agiledataengine.service.ThemeMapService;
import com.digiwin.smartdata.agiledataengine.service.client.IAdeEntryService;
import com.digiwin.smartdata.agiledataengine.service.impl.DmcServiceImpl;
import com.digiwin.smartdata.agiledataengine.util.ChartConvertDataCompletionUtil;
import com.digiwin.smartdata.agiledataengine.util.ChartConvertUtil;
import com.digiwin.smartdata.agiledataengine.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.util.DateTimeUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="AdeEntryService")
public class AdeEntryService
implements IAdeEntryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdeEntryService.class);
    @Autowired
    private IAnalyzer analyzer;
    @Autowired
    private SendService sendService;
    @Autowired
    private IamService iamService;
    @Autowired
    private DataSnapshotService dataSnapshotService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private BmdService bmdService;
    @Autowired
    private DcpService dcpService;
    @Autowired
    private DmcServiceImpl dmcService;

    @InitTraceId
    public ResultDto<Snapshot> postInstantAgileData(AdeInstantRequest request) {
        Long time;
        Snapshot snapshot;
        Long startTime = System.currentTimeMillis();
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a{},token:{}", (Object)JsonUtil.getJsonString((Object)request), (Object)token);
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        request.setMessageId(messageId);
        switch (StructureModel.of((String)request.getMethod())) {
            case METRIC: {
                AdeRequest adeMetricRequest = new AdeRequest();
                BeanUtils.copyProperties((Object)request, (Object)adeMetricRequest);
                snapshot = this.analyzer.doAnalyzeMetric(adeMetricRequest, "instant");
                break;
            }
            case DATASET: {
                AdeRequest adeDataSetRequest = new AdeRequest();
                BeanUtils.copyProperties((Object)request, (Object)adeDataSetRequest);
                snapshot = this.analyzer.doAnalyzeDataSet(adeDataSetRequest, "instant");
                break;
            }
            default: {
                snapshot = this.analyzer.doAnalyze(AdeRequest.buildAdeRequest((AdeInstantRequest)request), "instant");
            }
        }
        Long endTime = System.currentTimeMillis();
        if (snapshot == null) {
            return ResultDto.buildError((String)"empty_dataSet");
        }
        if (snapshot != null && snapshot.getSnapshotId() != null && snapshot.getSnapshotId().equals(request.getSnapshotId())) {
            time = endTime - startTime;
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
            return ResultDto.buildOK().setData((Object)snapshot);
        }
        if (StringUtil.isBlank((String)snapshot.getSnapshotId()) || !snapshot.getSnapshotId().contains("ADE_Snapshot")) {
            return ResultDto.buildError((String)snapshot.getSnapshotId());
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getCode())) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)snapshot.getContext().getCode(), (Object[])Optional.ofNullable(snapshot.getContext().getPatternArguments()).map(List::toArray).orElse(new String[]{"Undefined"})));
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getErrorCode())) {
            return ResultDto.buildError((String)snapshot.getContext().getErrorMessage());
        }
        time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
        return ResultDto.buildOK().setData((Object)snapshot);
    }

    @InitTraceId
    public ResultDto<Snapshot> getDataSetFieldList(AdeInstantRequest request) {
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        Long startTime = System.currentTimeMillis();
        LOGGER.error("agiledata_adt_\u83b7\u53d6\u6570\u636e\u96c6\u5b57\u6bb5_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        request.setMessageId(messageId);
        AdeRequest adeRequest = new AdeRequest();
        BeanUtils.copyProperties((Object)request, (Object)adeRequest);
        Snapshot snapshot = this.analyzer.doAnalyzeDataSet(adeRequest, "instant_table_fields");
        Long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u83b7\u53d6\u6570\u636e\u96c6\u5b57\u6bb5_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
        if (!StringUtil.isEmpty((String)snapshot.getContext().getCode())) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)snapshot.getContext().getCode(), (Object[])Optional.ofNullable(snapshot.getContext().getPatternArguments()).map(List::toArray).orElse(new String[]{"Undefined"})));
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getErrorCode())) {
            return ResultDto.buildError((String)snapshot.getContext().getErrorMessage());
        }
        return ResultDto.buildOK().setData((Object)snapshot);
    }

    public ResultDto<String> postDownLoadDetail(AdeInstantRequest request) {
        Long startTime = System.currentTimeMillis();
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        request.setMessageId(messageId);
        AdeRequest adeDataSetRequest = new AdeRequest();
        BeanUtils.copyProperties((Object)request, (Object)adeDataSetRequest);
        String fileDetailUrl = this.analyzer.getFileDetailUrl(adeDataSetRequest);
        Long endTime = System.currentTimeMillis();
        Long time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + fileDetailUrl);
        if (!fileDetailUrl.contains("/api/dmc/v2/")) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)fileDetailUrl, (Object[])new Object[0]));
        }
        return ResultDto.buildOK().setData((Object)fileDetailUrl);
    }

    public ResultDto<String> postDownLoadDetailDataset(AdeInstantRequest request) {
        Long startTime = System.currentTimeMillis();
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        request.setMessageId(messageId);
        AdeRequest adeDataSetRequest = new AdeRequest();
        BeanUtils.copyProperties((Object)request, (Object)adeDataSetRequest);
        String fileDetailUrl = this.analyzer.getFileDetailUrlV2(adeDataSetRequest);
        Long endTime = System.currentTimeMillis();
        Long time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + fileDetailUrl);
        if (!fileDetailUrl.contains("/api/dmc/v2/")) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)fileDetailUrl, (Object[])new Object[0]));
        }
        return ResultDto.buildOK().setData((Object)fileDetailUrl);
    }

    public ResultDto<Snapshot> postInstantHasAnswerAgileData(AdeInstantRequest request) {
        Long startTime = System.currentTimeMillis();
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        Snapshot snapshot = this.analyzer.doAnalyze(AdeRequest.buildAdeRequest((AdeInstantRequest)request), request.getRequestType());
        Long endTime = System.currentTimeMillis();
        if (snapshot.getSnapshotId() != null && snapshot.getSnapshotId().equals(request.getSnapshotId())) {
            Long time = endTime - startTime;
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
            return ResultDto.buildOK().setData((Object)snapshot);
        }
        if (StringUtil.isBlank((String)snapshot.getSnapshotId()) || !snapshot.getSnapshotId().contains("ADE_Snapshot")) {
            return ResultDto.buildError((String)snapshot.getSnapshotId());
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getCode())) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)snapshot.getContext().getCode(), (Object[])new Object[0]));
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getErrorCode())) {
            return ResultDto.buildError((String)snapshot.getContext().getErrorMessage());
        }
        Long time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
        return ResultDto.buildOK().setData((Object)snapshot);
    }

    public ResultDto<Object> postSnapshotAgileData(AdeSnapshotRequest request) {
        String locale;
        LOGGER.info("\u8fdb\u5165\u4fa6\u6d4b\u83b7\u53d6\u6570\u636e\u8fdb\u884c\u5904\u7406\uff0c\u6570\u636e\u8bf7\u6c42\u5185\u5bb9\uff1a" + JsonUtil.getJsonString((Object)request));
        if (StringUtil.isEmpty((String)request.getTenantId()) || StringUtil.isEmpty((String)request.getActionId())) {
            LOGGER.error("\u4fa6\u6d4b\u6570\u636e\u4e0d\u9f50\uff0ctenantId\u4e3a[{}],actionId\u4e3a[{}]", (Object)request.getTenantId(), (Object)request.getActionId());
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)"missing_params", (Object[])new Object[0]));
        }
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (!StringUtil.isEmpty((String)token)) {
            request.setUserToken(token);
        }
        if (!StringUtil.isEmpty((String)(locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale")))) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        LOGGER.info("\u5f00\u59cb\u53d1\u9001\u4fa6\u6d4b\u6570\u636e\u5230\u961f\u5217\u4e2d....");
        Boolean sendSuccess = this.sendService.sendMessage(JsonUtil.getJsonString((Object)AdeRequest.buildAdeRequest((AdeSnapshotRequest)request)), "direct", "");
        if (Boolean.TRUE.equals(sendSuccess)) {
            return ResultDto.buildOK().setData((Object)"");
        }
        return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)"send_error", (Object[])new Object[0]));
    }

    private <T extends AdeBaseRequest> String getLocale(T request) {
        String locale = request.getLocale();
        if (!StringUtils.hasLength((String)locale)) {
            locale = this.iamService.getLanguageByTenantId(request.getUserToken(), request.getTenantId(), request.getLocale());
            request.setLocale(locale);
        }
        return locale;
    }

    @InitTraceId
    public ResultDto<Snapshot> postScreenInstantAgileData(AdeInstantRequest request) {
        Long startTime = System.currentTimeMillis();
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        request.setRequestTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        request.setMessageId(messageId);
        if (request.getSceneCode() == null) {
            request.setSceneCode(Optional.ofNullable(request.getScreen()).map(e -> (String)e.get("sceneCode")).orElse(""));
            ArrayList<JSONObject> objects = new ArrayList<JSONObject>(1);
            objects.add(new JSONObject());
            HashMap<String, ArrayList<JSONObject>> childMap = new HashMap<String, ArrayList<JSONObject>>(1);
            childMap.put(request.getSceneCode(), objects);
            request.setRecast(childMap);
        }
        Optional.ofNullable(DWServiceContext.getContext().getProfile()).ifPresent(e -> {
            if (StringUtil.isBlank((String)request.getTenantId())) {
                request.setTenantId((String)DWServiceContext.getContext().getProfile().get("tenantId"));
            }
        });
        Snapshot snapshot = this.analyzer.doAnalyze(AdeRequest.buildAdeRequest((AdeInstantRequest)request), Optional.ofNullable(request.getScreen()).map(e -> (String)e.get("requestType")).orElse("sync-instant"));
        Long endTime = System.currentTimeMillis();
        if (snapshot.getSnapshotId() != null && snapshot.getSnapshotId().equals(request.getSnapshotId())) {
            Long time = endTime - startTime;
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
            return ResultDto.buildOK().setData((Object)snapshot);
        }
        if (StringUtil.isBlank((String)snapshot.getSnapshotId()) || !snapshot.getSnapshotId().contains("ADE_Snapshot")) {
            return ResultDto.buildError((String)snapshot.getSnapshotId());
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getCode())) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)snapshot.getContext().getCode(), (Object[])Optional.ofNullable(snapshot.getContext().getPatternArguments()).map(List::toArray).orElse(null)));
        }
        if (!StringUtil.isEmpty((String)snapshot.getContext().getErrorCode())) {
            return ResultDto.buildError((String)snapshot.getContext().getErrorMessage());
        }
        Long time = endTime - startTime;
        LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6" + time + "\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)snapshot));
        return ResultDto.buildOK().setData((Object)snapshot);
    }

    @InitTraceId
    public Object queryDataCollectGroupConfig(KMQueryDataRequest request) {
        request.setTenantId((String)DWServiceContext.getContext().getProfile().get("tenantId"));
        request.setUserId((String)DWServiceContext.getContext().getProfile().get("userId"));
        String locale = Optional.ofNullable((String)DWServiceContext.getContext().getRequestHeader().get("locale")).orElse("zh_CN");
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        } else {
            request.setLocale(this.getLocale(request));
        }
        HashMap<String, KMQueryDataRequest.CollectGroupItem> reqMap = new HashMap<String, KMQueryDataRequest.CollectGroupItem>();
        reqMap.put("config", request.getConfig());
        Map boardList = this.themeMapService.queryDataCollectGroupConfig(request.getTenantId(), token, locale, reqMap);
        List sysDataList = boardList.containsKey("sysData") ? (List)boardList.get("sysData") : new ArrayList(4);
        List roleListByUser = this.iamService.getRoleListByUser(request.getTenantId(), request.getLocale(), token, request.getUserId());
        AtomicBoolean isAdmin = new AtomicBoolean(false);
        if (CollectionUtil.isNotEmpty((Collection)roleListByUser)) {
            roleListByUser.forEach(e -> {
                if ("superadmin".equals(e.getId())) {
                    isAdmin.set(true);
                }
            });
        }
        if (!isAdmin.get() && CollectionUtil.isNotEmpty(sysDataList)) {
            List userPermissionList = sysDataList.stream().map(item -> (String)item.get("appCode")).filter(org.apache.commons.lang3.StringUtils::isNotBlank).distinct().map(appCode -> this.iamService.getUserPermission(request.getTenantId(), locale, token, request.getUserId(), appCode)).flatMap(Collection::stream).filter(e -> StringUtils.isEmpty(e.get("denyReason"))).collect(Collectors.toList());
            List groupIds = Optional.ofNullable(userPermissionList).map(perList -> perList.stream().filter(e -> "board".equalsIgnoreCase((String)e.get("moduleId"))).collect(Collectors.mapping(item -> (String)item.get("id"), Collectors.toList()))).orElse(Collections.emptyList());
            List permissionList = sysDataList.stream().filter(e -> groupIds.contains(e.get("groupId"))).collect(Collectors.toList());
            boardList.put("sysData", permissionList);
        }
        return boardList;
    }

    @InitTraceId
    public ResultDto<Object> getEssentialFactor(AdeInstantRequest request) {
        request.setLocale((String)DWServiceContext.getContext().getRequestHeader().get("locale"));
        request.setUserToken((String)DWServiceContext.getContext().getRequestHeader().get("token"));
        LOGGER.error("agiledata_adt_\u6d41\u5f0f\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a{},token:{}", (Object)JsonUtil.getJsonString((Object)request), (Object)request.getUserToken());
        String actionId = Optional.ofNullable(request.getShowDefine()).map(df -> (List)((Map)df).get("showType")).map(stList -> {
            if (CollectionUtil.isEmpty((Collection)stList)) {
                return "";
            }
            return (String)((Map)stList.get(0)).get("actionId");
        }).orElse("");
        if (request.isMetric().booleanValue() && actionId.split("-").length > 1) {
            actionId = actionId.split("-")[1];
        }
        String result = this.analyzer.getEssentialFactor(request, actionId);
        LOGGER.error("agiledata_adt_\u6d41\u5f0f\u8bf7\u6c42\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)result);
        return ResultDto.buildOK().setData((Object)result);
    }

    @InitTraceId
    public ResultDto<Snapshot> postChartConvert(ChartConvertRequest request) {
        ResultDto<Snapshot> validationError = this.validateRequestParams(request);
        if (validationError != null) {
            return validationError;
        }
        Map headers = Optional.ofNullable(DWServiceContext.getContext()).map(DWServiceContext::getRequestHeader).orElseGet(Collections::emptyMap);
        String locale = (String)headers.get("locale");
        String tenantId = (String)headers.get("routerKey");
        try {
            List dimensionFields;
            Snapshot snapshot;
            Snapshot requestSnapshot = request.getSnapshot();
            LOGGER.error("agiledata_adt_\u56fe\u8868\u5207\u6362\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a{},token:{}", (Object)JsonUtil.getJsonString((Object)request), headers.get("token"));
            if (ObjectUtils.isEmpty((Object)requestSnapshot)) {
                String token = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
                if (!StringUtils.hasLength((String)token)) {
                    return ResultDto.buildError((String)"DMC Service Failed");
                }
                snapshot = this.dmcService.downloadDmcFile(token, locale, tenantId, "asada", request.getOriginalSnapshotDataFileId());
                if (snapshot == null) {
                    DmcFileResponse dmcFileInfo = this.dmcService.getDmcFileInfo(token, locale, tenantId, request.getOriginalSnapshotDataFileId());
                    if (dmcFileInfo == null || dmcFileInfo.getMetadata() == null) {
                        return ResultDto.buildError((String)"DMC Service Failed");
                    }
                    String jsonStr = JSON.toJSONString((Object)dmcFileInfo.getMetadata());
                    snapshot = (Snapshot)JSON.parseObject((String)jsonStr, Snapshot.class);
                }
            } else {
                snapshot = requestSnapshot;
            }
            LOGGER.error("agiledata_adt_\u56fe\u8868\u5207\u6362DMC\u8fd4\u56de\u7684\u5feb\u7167ID\uff1a{},token:{}", (Object)snapshot.getSnapshotId(), headers.get("token"));
            Context context = Optional.ofNullable(snapshot.getContext()).orElseGet(Context::new);
            BizParams bizParams = Optional.ofNullable(context.getBizParams()).orElseGet(BizParams::new);
            bizParams.setLocale(locale);
            List pullDataList = Optional.ofNullable(context.getPullData()).orElseGet(Collections::emptyList);
            if (pullDataList.isEmpty()) {
                return ResultDto.buildError((String)"PullData is empty");
            }
            PullData pullData = (PullData)pullDataList.get(0);
            Object data = pullData.getData();
            Object metadata = pullData.getMetadata();
            if (ObjectUtils.isEmpty((Object)pullData) || ObjectUtils.isEmpty((Object)data) || ObjectUtils.isEmpty((Object)metadata)) {
                return ResultDto.buildError((String)"PullData is empty");
            }
            List dataList = ChartConvertUtil.parseDataList((Object)data);
            MetadataItem metadataItem = ChartConvertUtil.parseMetadata((Object)metadata);
            if (!(ObjectUtils.isEmpty((Object)metadataItem) || (dimensionFields = ChartConvertUtil.getFieldsByType((MetadataItem)metadataItem, (String[])new String[]{"string", "date", "datetime"})).size() == 1 && ChartTypeEnum.INDICATOR_CARD.getChartType().equals(request.getChartType()))) {
                ChartConvertUtil.completeTimeUnit((List)dataList, (BizParams)bizParams);
            }
            ChartConvertDataCompletionUtil.compensateData((PullData)pullData);
            pullData.setDimensionRelationShip(ChartConvertUtil.buildDimensionRelationShip((Object)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)pullData.getMetadata()), MetadataItem.class), (Object)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)pullData.getData()))));
            PullData transform = ChartConvertUtil.transform((BizParams)bizParams, (PullData)pullData, (ChartTypeEnum)ChartTypeEnum.of((String)request.getChartType()));
            if (ChartConvertUtil.conditionCheck((PullData)pullData, (String)bizParams.getChartType())) {
                ChartConvertDataCompletionUtil.compensateData((PullData)transform);
            }
            context.setPullData(Collections.singletonList(transform));
            snapshot.setContext(context);
            LOGGER.error("agiledata_adt_\u56fe\u8868\u5207\u6362\u8bf7\u6c42\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)JsonUtil.getJsonString((Object)snapshot));
            return ResultDto.buildOK().setData((Object)snapshot);
        }
        catch (Exception e) {
            LOGGER.error("agiledata_adt_\u56fe\u8868\u5207\u6362\u5f02\u5e38,\u5165\u53c2\uff1a{}, \n token:{}, \n error:{}", new Object[]{JsonUtil.getJsonString((Object)request), headers.get("token"), e.getMessage()});
            return ResultDto.buildError((String)"Chart Conversion Error");
        }
    }

    @InitTraceId
    public ResultDto<List<String>> postSnapshotConvertChart(ChartConvertRequest request) {
        LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a{},token:{}", (Object)JsonUtil.getJsonString((Object)request), DWServiceContext.getContext().getRequestHeader().get("token"));
        Snapshot snapshot = request.getSnapshot();
        if (ObjectUtils.isEmpty((Object)snapshot)) {
            LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u5165\u53c2\u5feb\u7167\u4e3a\u7a7a");
            return ResultDto.buildOK().setData(new ArrayList());
        }
        Context context = snapshot.getContext();
        BizParams bizParams = context.getBizParams();
        if (ObjectUtils.isEmpty((Object)snapshot) || ObjectUtils.isEmpty((Object)bizParams)) {
            LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u5165\u53c2\u9519\u8bef\uff1a{},\u5165\u53c2\u4e3a:{}", (Object)"context/bizParams is null", (Object)JSONObject.toJSONString((Object)request));
            return ResultDto.buildOK().setData(new ArrayList());
        }
        List pullDataList = context.getPullData();
        PullData pullData = (PullData)pullDataList.get(0);
        Object metadata = pullData.getMetadata();
        if (ObjectUtils.isEmpty((Object)pullData) || ObjectUtils.isEmpty((Object)metadata)) {
            LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u5165\u53c2\u9519\u8bef\uff1a{},\u5165\u53c2\u4e3a:{}", (Object)"pullData/metadata is null", (Object)JSONObject.toJSONString((Object)request));
            return ResultDto.buildOK().setData(new ArrayList());
        }
        try {
            List dataList = ChartConvertUtil.parseDataList((Object)pullData.getData());
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u5165\u53c2\u9519\u8bef\uff1a{},\u5165\u53c2\u4e3a:{}", (Object)"pullData.data is null", (Object)JSONObject.toJSONString((Object)request));
                return ResultDto.buildOK().setData((Object)bizParams.getTransIds());
            }
            ChartConvertUtil.handleChartType((BizParams)bizParams, (Object)metadata, (List)dataList, (String)bizParams.getChartType());
        }
        catch (Exception e) {
            LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u5f02\u5e38\uff1a\u5165\u53c2:{} \n \u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)request), (Object)e.getMessage());
            return ResultDto.buildOK().setData(new ArrayList());
        }
        LOGGER.error("agiledata_adt_\u6839\u636e\u5feb\u7167\u8fdb\u884c\u56fe\u8868\u8f6c\u6362\u63a5\u53e3\u8bf7\u6c42\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)bizParams.getTransIds()));
        return ResultDto.buildOK().setData((Object)bizParams.getTransIds());
    }

    public ResultDto<AttributionDimensionResponse> postAttributionDimension(AttributionDimensionRequest request) {
        Long startTime = System.currentTimeMillis();
        LOGGER.error("agiledata_adt_\u7ef4\u5ea6\u5f52\u56e0_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a\uff1a" + JsonUtil.getJsonString((Object)request));
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isEmpty((String)token)) {
            return ResultDto.buildError((String)"token is empty");
        }
        request.setUserToken(token);
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (!StringUtil.isEmpty((String)locale)) {
            request.setLocale(locale);
        }
        if (StringUtil.isBlank((String)request.getLocale())) {
            return ResultDto.buildError((String)"locale is empty");
        }
        if (CollectionUtils.isEmpty((Collection)request.getDatasetList())) {
            return ResultDto.buildError((String)"empty_dataSet");
        }
        AttributionDimensionResponse response = null;
        try {
            response = this.analyzer.getAttributionDimension(request);
        }
        catch (Exception e) {
            LOGGER.error("agiledata_adt_\u7ef4\u5ea6\u5f52\u56e0_\u8bf7\u6c42\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)e.getMessage()));
        }
        if (response != null && !StringUtil.isEmpty((String)response.getCode())) {
            return ResultDto.buildError((String)DWModuleMessageResourceBundleUtils.getString((String)response.getCode(), (Object[])Optional.ofNullable(response.getPatternArguments()).map(List::toArray).orElse(null)));
        }
        Long costTime = System.currentTimeMillis() - startTime;
        LOGGER.error("agiledata_adt_\u7ef4\u5ea6\u5f52\u56e0_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6{}\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a\uff1a{}", (Object)costTime, (Object)JSONObject.toJSONString((Object)response));
        return ResultDto.buildOK().setData((Object)response);
    }

    private ResultDto<Snapshot> validateRequestParams(ChartConvertRequest request) {
        if (request == null) {
            return ResultDto.buildError((String)"request cannot be null");
        }
        if (ObjectUtils.isEmpty((Object)request.getSnapshot()) && StringUtil.isEmpty((String)request.getOriginalSnapshotDataFileId())) {
            return ResultDto.buildError((String)"originalSnapshotDataFileId is null");
        }
        if (StringUtil.isEmpty((String)request.getChartType())) {
            return ResultDto.buildError((String)"chartType is null");
        }
        return null;
    }
}

