/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.provider;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.smartdata.agiledataengine.core.aop.MyExceptionHandler;
import com.digiwin.smartdata.agiledataengine.core.aop.RouterKey;
import com.digiwin.smartdata.agiledataengine.core.message.ErrorCode;
import com.digiwin.smartdata.agiledataengine.pojo.request.OpsScheduleReq;
import com.digiwin.smartdata.agiledataengine.service.IDevOpsService;
import com.digiwin.smartdata.agiledataengine.service.facade.IOpsFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="DevOpsService")
@MyExceptionHandler
public class DevOpsService
implements IDevOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevOpsService.class);
    private IOpsFacadeService service;

    public DevOpsService(IOpsFacadeService service) {
        this.service = service;
    }

    @RouterKey
    public void clearDirtyData(OpsScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u5220\u9664\u65e0\u6548\u7684\u6392\u7a0b\uff1a{}", (Object)rule);
        if (null == rule) {
            throw new DWRuntimeException(ErrorCode.PARAM_RULE_EMPTY_CODE.getCode(), ErrorCode.PARAM_RULE_EMPTY_CODE.getMessage());
        }
        this.service.deleteInvalidSchedule(rule);
    }
}

