/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.provider;

import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.core.aop.MyExceptionHandler;
import com.digiwin.smartdata.agiledataengine.core.aop.RouterKey;
import com.digiwin.smartdata.agiledataengine.pojo.request.ExeTriggerReq;
import com.digiwin.smartdata.agiledataengine.producer.MessageProducer;
import com.digiwin.smartdata.agiledataengine.service.IExecuteService;
import com.digiwin.smartdata.agiledataengine.service.facade.IScheduleFacadeService;
import com.digiwin.smartdata.agiledataengine.service.impl.CustomHttpClient;
import com.digiwin.smartdata.agiledataengine.service.srp.db.IScheduleDefineService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ExecuteService")
@MyExceptionHandler
public class ExecuteService
implements IExecuteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteService.class);
    private MessageProducer rabbitMQProducer;
    private IScheduleDefineService defineService;
    @Autowired
    private CustomHttpClient customHttpClient;
    @Autowired
    private IScheduleFacadeService service;

    public ExecuteService(MessageProducer rabbitMQProducer, IScheduleDefineService defineService) {
        this.rabbitMQProducer = rabbitMQProducer;
        this.defineService = defineService;
    }

    @RouterKey
    public DWJobResult post(Map<String, Object> paramMap) {
        return this.executeJob(paramMap);
    }

    public DWJobResult postExecuteRemoteJob(Map<String, Object> param) {
        DWJobResult result = new DWJobResult();
        String messageBody = this.sendMessage(param);
        result.setMessage(messageBody);
        result.setExecuteStatus("completed");
        LOGGER.info("remoteJob\u6392\u7a0b\u63a5\u6536\u5230\u6d88\u606f\u53d1\u9001\u5230MQ\uff1a{}, routerKey\uff1a{}", param, DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        return result;
    }

    public DWJobResult executeJob(Map<String, Object> paramMap) {
        String instanceId;
        DWJobResult result = new DWJobResult();
        String ruleId = paramMap.get("ruleId") == null ? "" : String.valueOf(paramMap.get("ruleId"));
        String string = instanceId = paramMap.get("instance_id") == null ? "" : String.valueOf(paramMap.get("instance_id"));
        if (StringUtils.isBlank((CharSequence)instanceId) || StringUtils.isBlank((CharSequence)ruleId)) {
            result.setExecuteStatus("completed");
        }
        ExeTriggerReq rule = new ExeTriggerReq();
        rule.setInstanceId(instanceId);
        rule.setCaller((String)paramMap.get("caller"));
        rule.setRuleId(ruleId);
        rule.setTenantId((String)paramMap.get("tenantId"));
        rule.setScheduleParam(JsonUtil.getJsonString((Object)paramMap.get("scheduleParam")));
        this.service.executeTrigger(rule);
        result.setMessage(JsonUtil.getJsonString((Object)paramMap.get("scheduleParam")));
        result.setExecuteStatus("completed");
        LOGGER.info("job\u6392\u7a0b\u63a5\u6536\u5230\u6d88\u606f\u53d1\u9001\u5230MQ\uff1a{}, routerKey\uff1a{}", paramMap, DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        return result;
    }

    private String sendMessage(Map<String, Object> paramMap) {
        String messageId = this.rabbitMQProducer.sendMessage(paramMap);
        paramMap.put("messageId", messageId);
        return JsonUtil.getJsonString(paramMap);
    }
}

