/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.core.aop.MyExceptionHandler;
import com.digiwin.smartdata.agiledataengine.core.aop.RouterKey;
import com.digiwin.smartdata.agiledataengine.pojo.request.BatchScheduleReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ExeTriggerReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleUpdateReq;
import com.digiwin.smartdata.agiledataengine.service.IScheduleOpsService;
import com.digiwin.smartdata.agiledataengine.service.facade.IScheduleFacadeService;
import com.digiwin.smartdata.agiledataengine.service.srp.db.impl.TenantService;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ScheduleOpsProvider")
@MyExceptionHandler
public class ScheduleOpsProvider
implements IScheduleOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleOpsProvider.class);
    private IScheduleFacadeService service;
    private TenantService tenantService;

    public ScheduleOpsProvider(IScheduleFacadeService service, TenantService tenantService) {
        this.service = service;
        this.tenantService = tenantService;
    }

    public void create(BatchScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u521b\u5efa\u6392\u7a0b\uff1a{}", (Object)rule);
        this.initContext(rule.getTenantId());
        this.service.createSchedule(rule);
    }

    @RouterKey
    public void delete(ScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u5220\u9664\u6392\u7a0b\uff1a{}", (Object)rule);
        this.service.deleteSchedule(rule);
    }

    @RouterKey
    public JSONObject getSchedule(ScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u67e5\u8be2\u6392\u7a0b\uff1a{}", (Object)rule);
        return this.service.getSchedule(rule);
    }

    @RouterKey
    public void edit(ScheduleUpdateReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u66f4\u65b0\u6392\u7a0b\uff1a{}", (Object)rule);
        this.service.updateSchedule(rule, rule.getEnableStatus());
    }

    @RouterKey
    public void stop(ScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u505c\u7528\u6392\u7a0b\uff1a{}", (Object)rule);
        this.service.stopSchedule(rule);
    }

    @RouterKey
    public void start(ScheduleReq rule) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u8c03\u7528\u542f\u7528\u6392\u7a0b\uff1a{}", (Object)rule);
        this.initContext(rule.getTenantId());
        this.service.startSchedule(rule);
    }

    private void initContext(String tenantId) {
        DWServiceContext.getContext().setProfile(this.tenantService.getProfile(tenantId));
    }

    public void executeTrigger(@Valid ExeTriggerReq rule) {
        this.service.executeTrigger(rule);
    }
}

