/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.repository.dao.impl;

import com.digiwin.smartdata.agiledataengine.core.base.BaseDao;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleDetailModel;
import com.digiwin.smartdata.agiledataengine.repository.dao.IScheduleDefineDao;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduleDefineDao
extends BaseDao
implements IScheduleDefineDao {
    @Override
    public void saveScheduleDefine(ScheduleDetailModel model, boolean isXxlJob) {
        if (isXxlJob) {
            String insert = "insert into sd_schedule_detail (rule_id,tenantid,instance_id,action_id,triggers,caller,valid, job_id, schedule_param -${tenantName}) values (?,?,?,?,?,?,?,?,? -${tenantValue})";
            this.update(insert, model.getRuleId(), model.getTenantId(), model.getInstanceId(), model.getActionId(), model.getTriggers(), model.getCaller(), model.getValid(), model.getJobId(), model.getScheduleParam());
        } else {
            String insert = "insert into sd_schedule_detail (rule_id,tenantid,instance_id,action_id,triggers,caller,valid -${tenantName}) values (?,?,?,?,?,?,? -${tenantValue})";
            this.update(insert, model.getRuleId(), model.getTenantId(), model.getInstanceId(), model.getActionId(), model.getTriggers(), model.getCaller(), model.getValid());
        }
    }

    @Override
    public void deleteScheduleDefine(String instanceId) {
        String update = "update sd_schedule_detail set valid = ? where instance_id = ? -${tenantsid}";
        this.update(update, 0, instanceId);
    }

    @Override
    public int updateTrigger(String trigger, String schduleParam, String instanceId) {
        String updateTrigger = "update sd_schedule_detail set triggers = ?, schedule_param =? where instance_id = ? -${tenantsid}";
        return this.update(updateTrigger, trigger, instanceId);
    }

    @Override
    public List<ScheduleDetailModel> getScheduleInfoByRuleId(String ruleId, boolean isXxlJob) {
        String getScheduleInfo = isXxlJob ? "select instance_id,triggers,job_id from sd_schedule_detail where rule_id = ? and valid = 1 -${tenantsid}" : "select instance_id,triggers from sd_schedule_detail where rule_id = ? and valid = 1 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId);
    }

    @Override
    public List<ScheduleDetailModel> getValidScheduleInfoByRuleId(String ruleId) {
        String getScheduleInfo = "select instance_id from sd_schedule_detail where rule_id = ? and valid = 0 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId);
    }

    @Override
    public boolean isNotExist(String ruleId, String instanceId) {
        String getScheduleInfo = "select instance_id from sd_schedule_detail where rule_id = ? and instance_id = ? and valid = 1 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, ruleId, instanceId).isEmpty();
    }

    @Override
    public void updateSchedueInfo(ScheduleDetailModel scheduleDetailModel) {
        String getScheduleInfo = "update sd_schedule_detail set  instance_id = ?, schedule_param = ? and valid = 1 and  where instance_id = ?  -${tenantsid}";
    }

    @Override
    public List<ScheduleDetailModel> getScheduleInfoByInstanceId(String instanceId) {
        String getScheduleInfo = "select instance_id,triggers,schedule_param,job_id,caller,tenantid from sd_schedule_detail where instance_id = ? and valid = 1 -${tenantsid}";
        return this.select(ScheduleDetailModel.class, getScheduleInfo, instanceId);
    }
}

