/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.anylaze.IAnalyzer;
import com.digiwin.smartdata.agiledataengine.metric.model.DataEnum;
import com.digiwin.smartdata.agiledataengine.metric.model.DatasetListItem;
import com.digiwin.smartdata.agiledataengine.metric.model.DebugMode;
import com.digiwin.smartdata.agiledataengine.metric.model.FieldSchemaItem;
import com.digiwin.smartdata.agiledataengine.metric.model.FilterItem;
import com.digiwin.smartdata.agiledataengine.metric.model.KMMetricData;
import com.digiwin.smartdata.agiledataengine.metric.model.LangItem;
import com.digiwin.smartdata.agiledataengine.metric.model.MetricDebugInfo;
import com.digiwin.smartdata.agiledataengine.metric.model.MetricListItem;
import com.digiwin.smartdata.agiledataengine.metric.model.SolutionStepItem;
import com.digiwin.smartdata.agiledataengine.metric.model.TemplateReplaceVars;
import com.digiwin.smartdata.agiledataengine.model.ActionMetric;
import com.digiwin.smartdata.agiledataengine.model.AdeInstantRequest;
import com.digiwin.smartdata.agiledataengine.model.AdeRequest;
import com.digiwin.smartdata.agiledataengine.model.AnalysisFilterItem;
import com.digiwin.smartdata.agiledataengine.model.AttributionDimensionRequest;
import com.digiwin.smartdata.agiledataengine.model.AttributionDimensionResponse;
import com.digiwin.smartdata.agiledataengine.model.Context;
import com.digiwin.smartdata.agiledataengine.model.DataFilter;
import com.digiwin.smartdata.agiledataengine.model.DataFilterItem;
import com.digiwin.smartdata.agiledataengine.model.DmcFileRequest;
import com.digiwin.smartdata.agiledataengine.model.DmcFileResponse;
import com.digiwin.smartdata.agiledataengine.model.DmcShareFileRequest;
import com.digiwin.smartdata.agiledataengine.model.ErrorCodeDto;
import com.digiwin.smartdata.agiledataengine.model.GroupAnalysis;
import com.digiwin.smartdata.agiledataengine.model.IAMColPermission;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponse;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponseData;
import com.digiwin.smartdata.agiledataengine.model.ReportScene;
import com.digiwin.smartdata.agiledataengine.model.Snapshot;
import com.digiwin.smartdata.agiledataengine.pojo.BizParams;
import com.digiwin.smartdata.agiledataengine.pojo.PullData;
import com.digiwin.smartdata.agiledataengine.repository.dao.IDynamicDao;
import com.digiwin.smartdata.agiledataengine.service.AdeService;
import com.digiwin.smartdata.agiledataengine.service.AgileDataEchoService;
import com.digiwin.smartdata.agiledataengine.service.DmcService;
import com.digiwin.smartdata.agiledataengine.service.IamService;
import com.digiwin.smartdata.agiledataengine.service.SendService;
import com.digiwin.smartdata.agiledataengine.service.ThemeMapService;
import com.digiwin.smartdata.agiledataengine.service.trans.SolutionStepConvertToSql;
import com.digiwin.smartdata.agiledataengine.util.AgileDataEchoUtil;
import com.digiwin.smartdata.agiledataengine.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.util.DateTimeUtil;
import com.digiwin.smartdata.agiledataengine.util.ExcelUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import com.digiwin.smartdata.agiledataengine.util.MapUtils;
import com.digiwin.smartdata.agiledataengine.util.StringReplaceUtil;
import com.digiwin.smartdata.agiledataengine.util.StringUtil;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="analyzer")
public class Analyzer
implements IAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Analyzer.class);
    @Autowired
    private SendService sendService;
    @Autowired
    private AdeService adeService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AgileDataEchoService agileDataEchoService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private IamService iamService;
    @Autowired
    private IDynamicDao dynamicMapper;
    public static final List<String> SCREEN_TYPES = Arrays.asList("sync-instant", "sync-snapshot");
    public static final InheritableThreadLocal<String> analyzerTL = new InheritableThreadLocal();
    public static final InheritableThreadLocal<Map<String, Object>> dataModelTL = new InheritableThreadLocal();
    public static final InheritableThreadLocal<Map<String, List<String>>> elementsTL = new InheritableThreadLocal();
    public static final InheritableThreadLocal<String> localeTL = new InheritableThreadLocal();

    public Snapshot doAnalyze(AdeRequest data, String analyzeType) {
        String pinpointId = ThreadContext.get((String)"PtxId");
        data.setPinpointId(pinpointId);
        ReportScene reportScene = null;
        if (!"special".equals(analyzeType) && StringUtil.isNotBlank((String)data.getSceneCode())) {
            reportScene = this.themeMapService.querySceneMaps(data.getTenantId(), data.getUserToken(), data.getLocale(), data.getSceneCode());
            if (!org.springframework.util.StringUtils.hasLength((String)reportScene.getActionId())) {
                LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff0c\u95ee\u9898\u4f4d\u7f6e\uff1a\u83b7\u53d6\u573a\u666f\u914d\u7f6e\uff0c\u573a\u666fid:" + data.getSceneCode() + "\uff0c\u95ee\u9898\u63cf\u8ff0\uff1a\u573a\u666f\u4e0d\u5b58\u5728\uff0c\u53d1\u751f\u65f6\u95f4\uff1a" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\uff0c\u9519\u8bef\u5185\u5bb9\uff1a\u573a\u666fid:" + data.getSceneCode() + "\uff0c\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u573a\u666f\u662f\u5426\u88ab\u8bef\u5220\u9664");
                this.agileDataEchoService.exceptionSubmit(data.getUserToken(), data.getTenantId(), data.getLocale(), AgileDataEchoUtil.buildSubmitParams((String)data.getMessageId(), (String)data.getPinpointId(), (String)"ade", (String)"ade", (String)"\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)->\u77e5\u8bc6\u56fe\u8c31\u7ec4\u4ef6(KM),\u573a\u666f\u4e0d\u5b58\u5728", (String)("\u573a\u666fid:" + data.getSceneCode()), (String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u573a\u666f\u662f\u5426\u88ab\u8bef\u5220\u9664"));
            } else {
                data.setActionId(reportScene.getActionId());
            }
        }
        Context context = Context.processingRequest((AdeRequest)data, (String)analyzeType, reportScene, null);
        context.getBizParams().setBuiltClassifications(Objects.isNull(reportScene) ? null : (Objects.isNull(reportScene.getClassification()) ? null : Arrays.asList(reportScene.getClassification())));
        Snapshot snapshot = "special".equalsIgnoreCase(analyzeType) ? this.adeService.buildContextBySpecial(context, reportScene, data.getSnapshotId()) : ("snapshot".equalsIgnoreCase(analyzeType) ? this.adeService.buildContextBySnapshot(context, reportScene, data.getSnapshotId()) : ("instant".equalsIgnoreCase(analyzeType) ? this.adeService.buildContextByInstant(context, reportScene, data.getSnapshotId()) : (SCREEN_TYPES.contains(analyzeType) ? this.adeService.buildScreenContextBySnapshot(context, reportScene, data.getSnapshotId()) : new Snapshot())));
        if (snapshot == null) {
            snapshot = new Snapshot();
            context.setCode("user_permissions_not_match");
            snapshot.setContext(context);
            return snapshot;
        }
        if (snapshot.getContext() == null || CollectionUtils.isEmpty((Collection)snapshot.getContext().getPullData())) {
            LOGGER.error("\u6ca1\u6293\u5230Pulling\u6570\u636e\uff0c\u6545\u76f4\u63a5\u8df3\u8fc7");
            context.setCode("empty_data");
            snapshot.setContext(context);
            return snapshot;
        }
        if (!StringUtil.isBlank((String)snapshot.getContext().getCode()) || !StringUtil.isBlank((String)snapshot.getContext().getErrorCode())) {
            return snapshot;
        }
        if ("sync-instant".equalsIgnoreCase(analyzeType)) {
            return snapshot;
        }
        if (org.springframework.util.StringUtils.hasLength((String)data.getSnapshotId())) {
            snapshot.setSnapshotId(data.getSnapshotId());
        }
        Snapshot.hasData((Snapshot)snapshot);
        String snapshotId = this.adeService.saveDataSnapshot(data.getTenantId(), snapshot.getContext().getBizParams().getLocale(), data.getUserToken(), snapshot);
        if (!org.springframework.util.StringUtils.hasLength((String)data.getSnapshotId()) && !snapshotId.contains("ADE_Snapshot")) {
            return snapshot.setSnapshotId(snapshotId);
        }
        context.getBizParams().setSnapshotTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("snapshotId", snapshot.getSnapshotId());
        params.put("tenantId", data.getTenantId());
        params.put("isMock", data.getMock());
        params.put("token", data.getUserToken());
        this.sendService.sendMessage(JsonUtil.getJsonString(params), "direct", "athena.event.message.adt");
        return snapshot;
    }

    public String getFileDetailUrl(AdeRequest data) {
        Object dataList;
        List kmDataSetDataList;
        if (CollectionUtils.isEmpty((Collection)data.getActionMetricList())) {
            return "empty_actionId";
        }
        String actionId = ((ActionMetric)data.getActionMetricList().get(0)).getActionId();
        data.setActionId(actionId);
        String[] dataSetIdArray = data.getActionId().split("-");
        int from = 1;
        if (dataSetIdArray.length == 1) {
            from = 0;
        }
        if (CollectionUtils.isEmpty((Collection)(kmDataSetDataList = this.themeMapService.queryMetricOrDataSetData(data.getTenantId(), data.getUserToken(), data.getLocale(), Arrays.asList(Arrays.copyOfRange(dataSetIdArray, from, dataSetIdArray.length)))))) {
            return null;
        }
        Context context = Context.processingRequest((AdeRequest)data, (String)"instant", null, CollectionUtils.isEmpty((Collection)kmDataSetDataList) ? null : (KMMetricData)kmDataSetDataList.get(0));
        this.converDynamicTime(context, kmDataSetDataList);
        try {
            dataList = this.adeService.getMetricData(context, data.getActionId(), (KMMetricData)kmDataSetDataList.get(0));
        }
        catch (Throwable throwable) {
            LOGGER.error("\u83b7\u53d6\u6307\u6807\u6216\u6570\u636e\u96c6\u660e\u7ec6\u6570\u636e\u5f02\u5e38{}", (Object)throwable.getMessage());
            return "download_error";
        }
        if (ObjectUtils.isEmpty((Object)dataList)) {
            return "download_quantity_limit";
        }
        if (dataList instanceof ErrorCodeDto) {
            return "download_error";
        }
        String fileName = ExcelUtil.createExcel((String)data.getQuestion(), (Object)dataList, (String)data.getLocale());
        if (!org.springframework.util.StringUtils.hasLength((String)fileName)) {
            return "download_error";
        }
        String token = this.dmcService.getDMCUserToken(data.getTenantId(), "asada", "asadaM8@15f");
        if (!org.springframework.util.StringUtils.hasLength((String)token)) {
            return "download_error";
        }
        DmcFileResponse fileResponse = this.dmcService.uploadFile(token, data.getLocale(), data.getTenantId(), DmcFileRequest.build((String)fileName, (String)data.getQuestion(), (String)data.getTenantId()), "file");
        if (fileResponse != null) {
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setAllowCount(Integer.valueOf(1));
            fileRequest.setDeleteFile(Boolean.valueOf(true));
            fileRequest.setFileId(fileResponse.getId());
            String url = this.dmcService.getShareUrl(token, data.getLocale(), data.getTenantId(), fileRequest);
            if (org.springframework.util.StringUtils.hasLength((String)url)) {
                return url;
            }
        }
        return "download_error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot doAnalyzeMetric(AdeRequest request, String analyzetype) {
        Snapshot snapshot;
        block14: {
            Context context;
            block15: {
                block13: {
                    String actionId = Optional.ofNullable(request.getShowDefine()).map(df -> (List)((Map)df).get("showType")).map(stList -> {
                        if (CollectionUtil.isEmpty((Collection)stList)) {
                            return "";
                        }
                        return (String)((Map)stList.get(0)).get("actionId");
                    }).orElse("");
                    request.setActionId(actionId);
                    String[] metricIdArray = actionId.split("-");
                    List<String> idList = request.isDataSetV1() != false ? Context.achieveDataSetIds((AdeRequest)request) : Context.achieveMetricIds((AdeRequest)request);
                    ArrayList classifications = Lists.newArrayListWithCapacity((int)8);
                    snapshot = null;
                    List kmMetricDataList = this.themeMapService.queryMetricOrDataSetData(request.getTenantId(), request.getUserToken(), request.getLocale(), (List)(CollectionUtil.isEmpty((Collection)idList) ? Arrays.asList(Arrays.copyOfRange(metricIdArray, 1, metricIdArray.length)) : idList));
                    kmMetricDataList.forEach(data -> {
                        if (Objects.nonNull(data.getClassification())) {
                            classifications.add(data.getClassification());
                        }
                    });
                    context = Context.processingRequest((AdeRequest)request, (String)analyzetype, null, CollectionUtils.isEmpty((Collection)kmMetricDataList) ? null : (KMMetricData)kmMetricDataList.get(0));
                    this.converDynamicTime(context, kmMetricDataList);
                    context.getBizParams().setBuiltClassifications((List)classifications);
                    if (CollectionUtils.isEmpty((Collection)kmMetricDataList) || Objects.isNull(kmMetricDataList.get(0))) {
                        snapshot = new Snapshot();
                        snapshot.setSnapshotId(request.getTenantId(), null, CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
                        if (request.isDataSetV1().booleanValue()) {
                            context.setCode("empty_dataSet");
                            LogUtils.buildAgileDataEngineLog((String)"queryDatasetData", (String)"U.ADE.501.xxxx", (String)JSON.toJSONString((Object)kmMetricDataList), (String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u96c6", (String)"1.\u91cd\u65b0\u6267\u884c\u7684\u53d1\u7248\u5207\u7248\u64cd\u4f5c\u3002\n2.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\u3002\n3.\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                        } else {
                            context.setCode("empty_metric");
                            LogUtils.buildAgileDataEngineLog((String)"queryMetricData", (String)"U.ADE.501.0102", (String)JSON.toJSONString((Object)kmMetricDataList), (String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6307\u6807", (String)"1.\u91cd\u65b0\u6267\u884c\u7684\u53d1\u7248\u5207\u7248\u64cd\u4f5c\u3002\n2.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\u3002\n3.\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                        }
                        snapshot.setContext(context);
                        return snapshot;
                    }
                    String locale = Optional.ofNullable(request.getLocale()).orElse("zh_CN");
                    localeTL.set(locale);
                    CompletionStage asynCf = null;
                    asynCf = request.isDataSetV1() != false ? CompletableFuture.runAsync(() -> {
                        List solutionStepItems = context.getBizParams().getSolutionStepItems();
                        HashMap<String, Object> dataModels = new HashMap<String, Object>();
                        Boolean lastStep = false;
                        block0: for (int i = 0; i < solutionStepItems.size(); ++i) {
                            SolutionStepItem item = (SolutionStepItem)solutionStepItems.get(i);
                            ArrayList<Map<String, Object>> newSolutionSteps = new ArrayList<Map<String, Object>>(1);
                            Map step = JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)item));
                            if (i == solutionStepItems.size() - 1) {
                                lastStep = true;
                            }
                            if (item.getDatasetObject() == null || item.getDatasetObject().getMetric() == null) {
                                newSolutionSteps.add(step);
                                this.buildDataModels(step, dataModels);
                                this.buildDatasetStepAnalysis(newSolutionSteps, context, null, request, dataModels, lastStep);
                                continue;
                            }
                            for (KMMetricData kmData : kmMetricDataList) {
                                if (!item.getDatasetObject().getMetric().equals(kmData.getIndicatorId())) continue;
                                this.buildDataModels(step, dataModels);
                                newSolutionSteps.add(step);
                                this.buildDatasetStepAnalysis(newSolutionSteps, context, kmData, request, dataModels, lastStep);
                                continue block0;
                            }
                        }
                    }).whenComplete((res, e) -> {
                        if (!Objects.isNull(e)) {
                            JSONObject jsonObject = new JSONObject(4);
                            jsonObject.put("actionId", (Object)actionId);
                            LogUtils.buildAgileDataEngineLog((String)"convertSemantic", (String)"U.ADE.501.0122", (String)jsonObject.toJSONString(), (String)("\u7ec4\u88c5\u8c03\u8bd5\u4fe1\u606f\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u8bed\u4e49\u5206\u6790\u51fa\u7684\u5b57\u6bb5\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"\u53ef\u5c1d\u8bd5\u6392\u67e5\u95ee\u53e5\u4e2d\u5b58\u5728\u7c7b\u4f3c.*#\u7279\u6b8a\u7b26\u53f7\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u3002");
                        }
                        analyzerTL.remove();
                        dataModelTL.remove();
                        elementsTL.remove();
                        localeTL.remove();
                    }) : CompletableFuture.runAsync(() -> {
                        List solutionStepItems = context.getBizParams().getSolutionStepItems();
                        Boolean lastStep = false;
                        for (int i = 0; i < solutionStepItems.size(); ++i) {
                            SolutionStepItem item = (SolutionStepItem)solutionStepItems.get(i);
                            ArrayList<Map<String, Object>> newSolutionSteps = new ArrayList<Map<String, Object>>(1);
                            newSolutionSteps.add(JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)item)));
                            if (i == solutionStepItems.size() - 1) {
                                lastStep = true;
                            }
                            this.buildMetricStepAnalysis(newSolutionSteps, context, request, lastStep);
                        }
                    }).whenComplete((res, e) -> {
                        if (!Objects.isNull(e)) {
                            JSONObject jsonObject = new JSONObject(4);
                            jsonObject.put("actionId", (Object)actionId);
                            LogUtils.buildAgileDataEngineLog((String)"convertSemantic", (String)"U.ADE.501.0122", (String)jsonObject.toJSONString(), (String)("\u7ec4\u88c5\u8c03\u8bd5\u4fe1\u606f\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u8bed\u4e49\u5206\u6790\u51fa\u7684\u5b57\u6bb5\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"\u53ef\u5c1d\u8bd5\u6392\u67e5\u95ee\u53e5\u4e2d\u5b58\u5728\u7c7b\u4f3c.*#\u7279\u6b8a\u7b26\u53f7\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u3002");
                        }
                        analyzerTL.remove();
                        dataModelTL.remove();
                        elementsTL.remove();
                        localeTL.remove();
                    });
                    snapshot = this.adeService.buildMetricContext(context, request.getSnapshotId(), actionId, kmMetricDataList);
                    try {
                        ((CompletableFuture)asynCf).get();
                    }
                    catch (InterruptedException interception) {
                        LOGGER.info("Interrupted! {}", (Throwable)interception);
                        LOGGER.error("\u6784\u9020\u8bed\u4e49\u6807\u7b7e\u62a5\u9519\u4e86");
                    }
                    catch (Exception e2) {
                        LOGGER.error("\u6784\u9020\u8bed\u4e49\u6807\u7b7e\u62a5\u9519\u4e86");
                    }
                    if (!CollectionUtil.isEmpty((Collection)snapshot.getContext().getPullData()) && !StringUtil.isNotBlank((String)snapshot.getContext().getCode())) break block13;
                    Snapshot e2 = snapshot;
                    return e2;
                }
                if (org.springframework.util.StringUtils.hasLength((String)request.getSnapshotId())) {
                    snapshot.setSnapshotId(request.getSnapshotId());
                }
                Snapshot.hasData((Snapshot)snapshot);
                if (!request.getCreateSnap().booleanValue()) break block14;
                String snapshotId = this.adeService.saveDataSnapshot(request.getTenantId(), snapshot.getContext().getBizParams().getLocale(), request.getUserToken(), snapshot);
                if (org.springframework.util.StringUtils.hasLength((String)request.getSnapshotId()) || snapshotId.contains("ADE_Snapshot")) break block15;
                Snapshot snapshot2 = snapshot.setSnapshotId(snapshotId);
                return snapshot2;
            }
            try {
                context.getBizParams().setSnapshotTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
                HashMap<String, Object> params = new HashMap<String, Object>(4);
                params.put("snapshotId", snapshot.getSnapshotId());
                params.put("tenantId", request.getTenantId());
                params.put("isMock", request.getMock());
                params.put("token", request.getUserToken());
                this.sendService.sendMessage(JsonUtil.getJsonString(params), "direct", "athena.event.message.adt");
            }
            catch (Exception e3) {
                JSONObject logJson = new JSONObject(4);
                logJson.put("snapshotId", (Object)(snapshot != null ? snapshot.getSnapshotId() : null));
                LogUtils.buildAgileDataEngineLog((String)"doAnalyzeMetric", (String)"U.ADE.501.0121", (String)logJson.toJSONString(), (String)("\u6307\u6807\u6570\u636e\u89e3\u6790\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u6587\u6863\u4e2d\u5fc3\u670d\u52a1\u548cmq\u4e2d\u95f4\u4ef6\u5f02\u5e38\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e3.getMessage())), (String)"\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u4ecd\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
                Thread.currentThread().interrupt();
            }
        }
        return snapshot;
    }

    private void buildDataModels(Map<String, Object> step, Map<String, Object> dataModels) {
        if (!CollectionUtils.isEmpty((Collection)((Collection)step.get("select"))) && dataModels != null) {
            List selects = (List)step.get("select");
            for (Map select : selects) {
                Map dataObject = (Map)select.get("dataObject");
                if (CollectionUtils.isEmpty((Map)dataObject)) continue;
                String alias = (String)dataObject.get("alias");
                String content = (String)dataObject.get("content");
                String title = (String)dataObject.get("title");
                if (!org.springframework.util.StringUtils.isEmpty((Object)alias) && !org.springframework.util.StringUtils.isEmpty((Object)title)) {
                    dataModels.put(alias, title);
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)content) || org.springframework.util.StringUtils.isEmpty((Object)title)) continue;
                dataModels.put(content, title);
            }
        }
    }

    private void converDynamicTime(Context context, List<KMMetricData> kmDatas) {
        if (CollectionUtils.isEmpty((Collection)context.getSqlDataTimes()) || CollectionUtils.isEmpty(kmDatas)) {
            if (context.getFilterAnalysis().booleanValue() && !CollectionUtils.isEmpty((Collection)context.getStepFilterAnalysis())) {
                block0: for (AnalysisFilterItem filterItem : context.getStepFilterAnalysis()) {
                    for (SolutionStepItem stepItem : context.getBizParams().getSolutionStepItems()) {
                        if (!filterItem.getId().equalsIgnoreCase(stepItem.getAlias())) continue;
                        Context.setFilterItem((DataFilter)filterItem.getFilter(), (SolutionStepItem)stepItem);
                        Context.setSortItem((List)filterItem.getSort(), (SolutionStepItem)stepItem);
                        Context.setLimitItem((DataFilterItem)filterItem.getLimit(), (SolutionStepItem)stepItem);
                        continue block0;
                    }
                }
            }
            context.setStepFilterAnalysis(new ArrayList(1));
            return;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        for (String sql : context.getSqlDataTimes()) {
            sb.append(sql);
        }
        String ddl = sb.substring(0, sb.lastIndexOf(","));
        Map<String, String> dateTimes = this.dynamicMapper.selectDDL(ddl);
        Context.buildSolustionStepDataTime((List)context.getBizParams().getSolutionStepItems(), (List)context.getSqlDataTimes(), dateTimes);
        if (context.getBizParams().getShowDefine() != null) {
            Map dimensionInterval;
            HashMap<String, Map> showDefine = (HashMap<String, Map>)context.getBizParams().getShowDefine();
            if (!CollectionUtils.isEmpty((Map)showDefine)) {
                dimensionInterval = (Map)showDefine.get("dimensionInterval");
                if (CollectionUtils.isEmpty((Map)dimensionInterval) || CollectionUtils.isEmpty((Collection)((Collection)dimensionInterval.get("data")))) {
                    dimensionInterval = context.buildDimensionInterval(context.getBizParams().getSolutionStepItems());
                    if (!CollectionUtils.isEmpty((Map)dimensionInterval)) {
                        this.converDateFormat(dimensionInterval, kmDatas);
                        showDefine.put("dimensionInterval", dimensionInterval);
                        context.getBizParams().setDimensionInterval(dimensionInterval);
                    }
                } else {
                    showDefine.remove("dimensionInterval");
                    dimensionInterval = context.buildDimensionInterval(context.getBizParams().getSolutionStepItems());
                    if (!CollectionUtils.isEmpty((Map)dimensionInterval)) {
                        this.converDateFormat(dimensionInterval, kmDatas);
                        showDefine.put("dimensionInterval", dimensionInterval);
                        context.getBizParams().setDimensionInterval(dimensionInterval);
                    }
                }
            } else {
                showDefine = new HashMap<String, Map>(1);
                dimensionInterval = context.buildDimensionInterval(context.getBizParams().getSolutionStepItems());
                if (!CollectionUtils.isEmpty((Map)dimensionInterval)) {
                    this.converDateFormat(dimensionInterval, kmDatas);
                    showDefine.put("dimensionInterval", dimensionInterval);
                    context.getBizParams().setDimensionInterval(dimensionInterval);
                }
            }
        }
        if (context.getFilterAnalysis().booleanValue() && !CollectionUtils.isEmpty((Collection)context.getStepFilterAnalysis())) {
            block3: for (AnalysisFilterItem filterItem : context.getStepFilterAnalysis()) {
                for (SolutionStepItem stepItem : context.getBizParams().getSolutionStepItems()) {
                    if (!filterItem.getId().equalsIgnoreCase(stepItem.getAlias())) continue;
                    Context.setFilterItem((DataFilter)filterItem.getFilter(), (SolutionStepItem)stepItem);
                    Context.setSortItem((List)filterItem.getSort(), (SolutionStepItem)stepItem);
                    Context.setLimitItem((DataFilterItem)filterItem.getLimit(), (SolutionStepItem)stepItem);
                    continue block3;
                }
            }
        }
        context.setStepFilterAnalysis(new ArrayList(1));
    }

    private void converDateFormat(Map<String, Object> dimensionInterval, List<KMMetricData> kmDatas) {
        if (dimensionInterval.get("field") == null || kmDatas == null) {
            return;
        }
        String key = (String)dimensionInterval.get("field");
        String dataformat = null;
        if (!CollectionUtils.isEmpty(kmDatas)) {
            block0: for (KMMetricData kmData : kmDatas) {
                if (!CollectionUtils.isEmpty((Collection)kmData.getDimensions())) {
                    for (MetaDataResponseData data : kmData.getDimensions()) {
                        if (!key.equals(data.getData_name())) continue;
                        dataformat = data.getDateFormat();
                        continue block0;
                    }
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)kmData.getFieldSchema())) continue;
                for (FieldSchemaItem item : kmData.getFieldSchema()) {
                    if (!key.equals(item.getName())) continue;
                    dataformat = item.getDateGranularity();
                    continue block0;
                }
            }
        }
        if (org.springframework.util.StringUtils.hasText(dataformat)) {
            List data = (List)dimensionInterval.get("data");
            String interval = (String)((Map)data.get(0)).get("interval");
            ((Map)data.get(0)).put("interval", DateTimeUtil.convertDateString((String)interval, dataformat));
        }
    }

    private void buildMetricStepAnalysis(List<Map<String, Object>> newSolutionSteps, Context context, AdeRequest request, Boolean lastStep) {
        String gptExplain = request.getExplain4Gpt();
        SolutionStepConvertToSql solutionStepConvertToSql = new SolutionStepConvertToSql(newSolutionSteps);
        HashMap<String, Object> dataModels = new HashMap<String, Object>();
        Optional.ofNullable(context.getBizParams().getMetricList()).ifPresent(metricList -> {
            List metricListItems = JSON.parseArray((String)JSON.toJSONString((Object)context.getBizParams().getMetricList()), MetricListItem.class);
            metricListItems.stream().forEach(pie -> {
                String metricName = !CollectionUtils.isEmpty((Map)pie.getLang()) && pie.getLang().get("sceneTitle") != null ? ((LangItem.TitleItem)pie.getLang().get("sceneTitle")).getTitleByLocale(request.getLocale()) : pie.getMetricName();
                dataModels.put(pie.getMetricId(), metricName);
                if (CollectionUtil.isEmpty((Collection)pie.getFieldSchema())) {
                    return;
                }
                pie.getFieldSchema().stream().forEach(filed -> {
                    String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> request.getLocale().equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                    dataModels.put(filed.getName(), localeTitle);
                });
            });
        });
        elementsTL.set(new LinkedHashMap(8));
        String sqlExpression = solutionStepConvertToSql.solutionStepConvert();
        if (DebugMode.METRIC.getMode().equalsIgnoreCase(request.getDebugMode())) {
            context.setDebug(Arrays.asList(MetricDebugInfo.builder().semantic(solutionStepConvertToSql.convertSemantic(sqlExpression, dataModels, request.getLocale(), gptExplain)).applicationCode(context.getBizParams().getAppCode()).question(context.getBizParams().getQuestion()).build()));
        }
        if (CollectionUtils.isEmpty((Collection)context.getStepFilterAnalysis())) {
            context.getStepFilterAnalysis().add(new AnalysisFilterItem());
        }
        context.getStepAnalysis().add(GroupAnalysis.build(solutionStepConvertToSql.convertStepAnalysis(dataModels, request.getLocale())));
    }

    private void buildDatasetStepAnalysis(List<Map<String, Object>> solutionSteps, Context context, KMMetricData kmData, AdeRequest request, Map<String, Object> dataModels, Boolean lastStep) {
        try {
            SolutionStepConvertToSql solutionStepConvertToSql = new SolutionStepConvertToSql(solutionSteps);
            LOGGER.error("\u5f00\u59cb\u89e3\u6790\u5b57\u6bb5\u540d\u79f0");
            Optional.ofNullable(context.getBizParams().getDatasetList()).ifPresent(datasetList -> {
                List datasetListItems = JSON.parseArray((String)JSON.toJSONString((Object)context.getBizParams().getDatasetList()), DatasetListItem.class);
                datasetListItems.stream().forEach(pie -> {
                    dataModels.put(pie.getDatasetId(), pie.getDatasetName());
                    if (kmData == null || CollectionUtil.isEmpty((Collection)kmData.getFieldSchema()) && CollectionUtils.isEmpty((Collection)kmData.getDatasetFieldSchema())) {
                        return;
                    }
                    if (request.isDataSetV1().booleanValue()) {
                        kmData.getFieldSchema().stream().forEach(filed -> {
                            String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> request.getLocale().equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                            dataModels.put(filed.getName(), localeTitle);
                        });
                    } else {
                        kmData.getDatasetFieldSchema().stream().forEach(filed -> {
                            String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> request.getLocale().equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                            dataModels.put(filed.getName(), localeTitle);
                        });
                    }
                });
            });
            elementsTL.set(new LinkedHashMap(8));
            LOGGER.error("\u62bd\u53d6\u5b57\u6bb5\u8981\u7d20");
            solutionStepConvertToSql.solutionStepConvert();
            LOGGER.error("\u6784\u9020\u8bed\u4e49\u6807\u7b7e");
            if (CollectionUtils.isEmpty((Collection)context.getStepFilterAnalysis())) {
                context.getStepFilterAnalysis().add(new AnalysisFilterItem());
            }
            context.getStepAnalysis().add(GroupAnalysis.build(solutionStepConvertToSql.convertStepAnalysis(dataModels, request.getLocale())));
            if (!request.isDataSetV1().booleanValue()) {
                if (lastStep.booleanValue()) {
                    ((AnalysisFilterItem)context.getStepFilterAnalysis().get(0)).buildLastStep(dataModels, solutionSteps.get(0), request.getLocale(), context, this.adeService);
                    context.setStepAnalysis(Collections.EMPTY_LIST);
                } else {
                    ((AnalysisFilterItem)context.getStepFilterAnalysis().get(0)).buildStepAndGroup(dataModels, solutionSteps.get(0), request.getLocale());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6784\u9020\u8bed\u4e49\u6807\u7b7e\u51fa\u9519,\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
        }
    }

    private Object checkColumnPermission(ReportScene reportScene, Map<String, Object> queryColDataPermission, String locale) {
        List colPermissions;
        List dimensions = reportScene.getDimensions();
        List measures = reportScene.getMeasures();
        List<String> fields = new ArrayList<String>(8);
        if (!(CollectionUtils.isEmpty(queryColDataPermission) || ((Boolean)queryColDataPermission.get("superadmin")).booleanValue() || queryColDataPermission.get("colPermission") == null || CollectionUtils.isEmpty((Collection)(colPermissions = JsonUtil.listMapToListT((List)((List)queryColDataPermission.get("colPermission")), IAMColPermission.class))) || colPermissions.size() != 1)) {
            fields = ((IAMColPermission)colPermissions.get(0)).getFields();
        }
        return this.buildTableFieldMetaData(fields, dimensions, measures, locale);
    }

    private Object buildTableFieldMetaData(List<String> fields, List<MetaDataResponseData> dimensions, List<MetaDataResponseData> measures, String locale) {
        JSONObject jsonObject = new JSONObject();
        MetaDataResponse response = MetaDataResponse.buildData();
        MetaDataResponseData data = response.getData();
        List dataFields = data.getField();
        for (MetaDataResponseData field : dimensions) {
            if (!CollectionUtils.isEmpty(fields) && !fields.contains(field.getData_name())) continue;
            dataFields.add(MetaDataResponseData.buildMetaData((MetaDataResponseData)field, (String)locale, (String)"dimensions"));
        }
        for (MetaDataResponseData field : measures) {
            if (!CollectionUtils.isEmpty(fields) && !fields.contains(field.getData_name())) continue;
            dataFields.add(MetaDataResponseData.buildMetaData((MetaDataResponseData)field, (String)locale, (String)"measures"));
        }
        jsonObject.put("response", (Object)response);
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEssentialFactor(AdeInstantRequest request, String actionId) {
        try {
            List kmDataSetDataList;
            if (request.isMetric().booleanValue()) {
                ArrayList<String> ids = new ArrayList<String>(1);
                ids.add(actionId);
                KMMetricData kmData = Stream.of(this.themeMapService.queryMetricOrDataSetData(request.getTenantId(), request.getUserToken(), request.getLocale(), ids)).flatMap(Collection::stream).limit(1L).findFirst().orElse(null);
                if (kmData == null || !org.springframework.util.StringUtils.hasLength((String)kmData.getIndicatorId())) {
                    String string = null;
                    return string;
                }
                AdeRequest adeDataSetRequest = new AdeRequest();
                BeanUtils.copyProperties((Object)request, (Object)adeDataSetRequest);
                Context context = Context.processingRequest((AdeRequest)adeDataSetRequest, (String)"essentialFactor", null, (KMMetricData)kmData);
                ArrayList<KMMetricData> kmMetricDataList = new ArrayList<KMMetricData>(1);
                kmMetricDataList.add(kmData);
                this.converDynamicTime(context, kmMetricDataList);
                String string = Optional.ofNullable(request.getMetric()).map(item -> {
                    int lastInt;
                    String locale = Optional.ofNullable(request.getLocale()).orElse("zh_CN");
                    localeTL.set(locale);
                    List solutionStepItems = context.getBizParams().getSolutionStepItems();
                    if (CollectionUtils.isEmpty((Collection)solutionStepItems)) {
                        return null;
                    }
                    ArrayList<Map> newSolutionStepItems = new ArrayList<Map>(solutionStepItems.size());
                    for (SolutionStepItem item1 : solutionStepItems) {
                        newSolutionStepItems.add(JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)item1)));
                    }
                    SolutionStepConvertToSql solutionStepConvertToSql = new SolutionStepConvertToSql(newSolutionStepItems);
                    HashMap dataModels = new HashMap();
                    Optional.ofNullable(request.getMetricList()).ifPresent(metricList -> {
                        List metricListItems = JSON.parseArray((String)JSON.toJSONString((Object)request.getMetricList()), MetricListItem.class);
                        metricListItems.stream().forEach(pie -> {
                            String metricName = !CollectionUtils.isEmpty((Map)pie.getLang()) && pie.getLang().get("sceneTitle") != null ? ((LangItem.TitleItem)pie.getLang().get("sceneTitle")).getTitleByLocale(locale) : pie.getMetricName();
                            dataModels.put(pie.getMetricId(), metricName);
                            if (CollectionUtil.isEmpty((Collection)pie.getFieldSchema())) {
                                return;
                            }
                            pie.getFieldSchema().stream().forEach(filed -> {
                                String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> locale.equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                                dataModels.put(filed.getName(), localeTitle);
                            });
                        });
                    });
                    elementsTL.set(new LinkedHashMap(8));
                    solutionStepConvertToSql.solutionStepConvert();
                    dataModels.putAll(TemplateReplaceVars.getDataModels());
                    String originExpression = (String)analyzerTL.get();
                    if (originExpression.contains("<>")) {
                        originExpression = originExpression.replaceAll("<>", "\u4e0d\u7b49\u4e8e");
                    }
                    if (originExpression.substring(lastInt = originExpression.lastIndexOf("Step")).split(":").length == 1) {
                        originExpression = originExpression.substring(0, lastInt - 1);
                    }
                    while (originExpression.contains(":\nStep")) {
                        if (originExpression.split("\nStep ").length <= 1) continue;
                        StringBuilder newOriginExpression = new StringBuilder(4);
                        String[] os = originExpression.split("\nStep ");
                        int i = 0;
                        for (String step : os) {
                            if (!step.contains("\n")) continue;
                            step = step.contains("Step ") ? "Step " + i + step.substring(step.indexOf("Step ") + 6) : " " + ++i + step.substring(1);
                            newOriginExpression.append(step).append("\nStep");
                        }
                        if (newOriginExpression.length() - 4 != newOriginExpression.lastIndexOf("Step")) continue;
                        originExpression = newOriginExpression.toString().substring(0, newOriginExpression.lastIndexOf("\nStep"));
                    }
                    if (originExpression.contains("is not null")) {
                        originExpression = originExpression.replace("is not null", "\u4e0d\u4e3a\u7a7a");
                    }
                    if (originExpression.contains("is null")) {
                        originExpression = originExpression.replace("is null", "\u4e3a\u7a7a");
                    }
                    return StringReplaceUtil.replaceString((String)(StringUtils.equals((String)"zh_CN", (String)locale) ? originExpression : ZhTwConverterUtil.toTraditional((String)originExpression)), (Map)MapUtils.mergeMaps((Map)(dataModelTL.get() == null ? Collections.emptyMap() : (Map)dataModelTL.get()), dataModels));
                }).orElse("");
                return string;
            }
            String[] dataSetIdArray = actionId.split("-");
            int from = 1;
            if (dataSetIdArray.length == 1) {
                from = 0;
            }
            if (CollectionUtils.isEmpty((Collection)(kmDataSetDataList = this.themeMapService.queryMetricOrDataSetData(request.getTenantId(), request.getUserToken(), request.getLocale(), Arrays.asList(Arrays.copyOfRange(dataSetIdArray, from, dataSetIdArray.length)))))) {
                String context = null;
                return context;
            }
            AdeRequest adeDataSetRequest = new AdeRequest();
            BeanUtils.copyProperties((Object)request, (Object)adeDataSetRequest);
            Context context = Context.processingRequest((AdeRequest)adeDataSetRequest, (String)"essentialFactor", null, CollectionUtils.isEmpty((Collection)kmDataSetDataList) ? null : (KMMetricData)kmDataSetDataList.get(0));
            this.converDynamicTime(context, kmDataSetDataList);
            String string = Optional.ofNullable(request.getDataset()).map(item -> {
                int lastInt;
                String locale = Optional.ofNullable(request.getLocale()).orElse("zh_CN");
                localeTL.set(locale);
                List solutionStepItems = context.getBizParams().getSolutionStepItems();
                if (CollectionUtils.isEmpty((Collection)solutionStepItems)) {
                    return null;
                }
                ArrayList<Map> newSolutionStepItems = new ArrayList<Map>(solutionStepItems.size());
                HashMap<String, Object> dataModels = new HashMap<String, Object>();
                block0: for (SolutionStepItem item1 : solutionStepItems) {
                    Map step = JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)item1));
                    if (item1.getDatasetObject().getMetric() == null) {
                        newSolutionStepItems.add(step);
                        continue;
                    }
                    for (KMMetricData kmData : kmDataSetDataList) {
                        if (!item1.getDatasetObject().getMetric().equals(kmData.getIndicatorId())) continue;
                        this.buildStep(context.getBizParams().getDatasetList(), step, item1.getDatasetObject().getMetric(), dataModels);
                        newSolutionStepItems.add(step);
                        continue block0;
                    }
                }
                SolutionStepConvertToSql solutionStepConvertToSql = new SolutionStepConvertToSql(newSolutionStepItems);
                Optional.ofNullable(request.getDatasetList()).ifPresent(datasetList -> {
                    List datasetListItems = JSON.parseArray((String)JSON.toJSONString((Object)request.getDatasetList()), DatasetListItem.class);
                    datasetListItems.stream().forEach(pie -> {
                        for (KMMetricData kmData : kmDataSetDataList) {
                            if (!pie.getDatasetId().equals(kmData.getIndicatorId())) continue;
                            dataModels.put(pie.getDatasetId(), pie.getDatasetName());
                            if (CollectionUtil.isEmpty((Collection)kmData.getFieldSchema()) && CollectionUtils.isEmpty((Collection)kmData.getDatasetFieldSchema())) {
                                return;
                            }
                            if (request.isDataSetV1().booleanValue()) {
                                kmData.getFieldSchema().stream().forEach(filed -> {
                                    String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> request.getLocale().equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                                    dataModels.put(filed.getName(), localeTitle);
                                });
                                break;
                            }
                            kmData.getDatasetFieldSchema().stream().forEach(filed -> {
                                String localeTitle = Optional.ofNullable(filed.getLanguage()).map(LangItem::getTitle).map(tie -> request.getLocale().equalsIgnoreCase("zh_CN") ? tie.getZh_CN() : tie.getZh_TW()).orElse(filed.getTitle());
                                dataModels.put(filed.getName(), localeTitle);
                            });
                            break;
                        }
                    });
                });
                elementsTL.set(new LinkedHashMap(8));
                solutionStepConvertToSql.solutionStepConvert();
                dataModels.putAll(TemplateReplaceVars.getDataModels());
                String originExpression = (String)analyzerTL.get();
                if (originExpression.contains("<>")) {
                    originExpression = originExpression.replaceAll("<>", "\u4e0d\u7b49\u4e8e");
                }
                if (originExpression.substring(lastInt = originExpression.lastIndexOf("Step")).split(":").length == 1) {
                    originExpression = originExpression.substring(0, lastInt - 1);
                }
                while (originExpression.contains(":\nStep")) {
                    if (originExpression.split("\nStep ").length <= 1) continue;
                    StringBuilder newOriginExpression = new StringBuilder(4);
                    String[] os = originExpression.split("\nStep ");
                    int i = 0;
                    for (String step : os) {
                        if (!step.contains("\n")) continue;
                        step = step.contains("Step ") ? "Step " + i + step.substring(step.indexOf("Step ") + 6) : " " + ++i + step.substring(1);
                        newOriginExpression.append(step).append("\nStep");
                    }
                    if (newOriginExpression.length() - 4 != newOriginExpression.lastIndexOf("Step")) continue;
                    originExpression = newOriginExpression.toString().substring(0, newOriginExpression.lastIndexOf("\nStep"));
                }
                if (originExpression.contains("is not null")) {
                    originExpression = originExpression.replace("is not null", "\u4e0d\u4e3a\u7a7a");
                }
                if (originExpression.contains("is null")) {
                    originExpression = originExpression.replace("is null", "\u4e3a\u7a7a");
                }
                return StringReplaceUtil.replaceString((String)(StringUtils.equals((String)"zh_CN", (String)locale) ? originExpression : ZhTwConverterUtil.toTraditional((String)originExpression)), (Map)MapUtils.mergeMaps((Map)(dataModelTL.get() == null ? Collections.emptyMap() : (Map)dataModelTL.get()), dataModels));
            }).orElse("");
            return string;
        }
        finally {
            analyzerTL.remove();
            dataModelTL.remove();
            elementsTL.remove();
            localeTL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot doAnalyzeDataSet(AdeRequest request, String analyzetype) {
        Snapshot snapshot;
        block27: {
            Context context;
            block28: {
                block26: {
                    block25: {
                        if ("instant_table_fields".equals(analyzetype)) {
                            Map<String, Object> queryColDataPermission;
                            PullData pullData;
                            ReportScene reportScene;
                            Context context2;
                            Snapshot snapshot2;
                            block24: {
                                String actionId;
                                block23: {
                                    snapshot2 = new Snapshot();
                                    context2 = Context.processingRequest((AdeRequest)request, (String)analyzetype, null, null);
                                    snapshot2.setSnapshotId(request.getTenantId(), request.getRuleId() == null ? "" : request.getRuleId(), CollectionUtils.isEmpty((Collection)context2.getBizParams().getEocMaps()) ? null : (Map)context2.getBizParams().getEocMaps().get(0));
                                    actionId = request.getActionId();
                                    if (actionId.contains("-")) {
                                        actionId = actionId.split("-")[1];
                                    }
                                    if ((reportScene = this.themeMapService.querySceneMaps(request.getTenantId(), request.getUserToken(), request.getLocale(), actionId)) != null && org.springframework.util.StringUtils.hasLength((String)reportScene.getCode())) break block23;
                                    LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff0c\u95ee\u9898\u4f4d\u7f6e\uff1a\u83b7\u53d6\u6570\u636e\u96c6\u914d\u7f6e\uff0c\u6570\u636e\u96c6id:" + actionId + "\uff0c\u95ee\u9898\u63cf\u8ff0\uff1a\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff0c\u53d1\u751f\u65f6\u95f4\uff1a" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\uff0c\u9519\u8bef\u5185\u5bb9\uff1a\u6570\u636e\u96c6id:" + actionId + "\uff0c\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u6570\u636e\u96c6\u662f\u5426\u88ab\u8bef\u5220\u9664");
                                    this.agileDataEchoService.exceptionSubmit(request.getUserToken(), request.getTenantId(), request.getLocale(), AgileDataEchoUtil.buildSubmitParams((String)request.getMessageId(), (String)request.getPinpointId(), (String)"ade", (String)"ade", (String)"\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)->\u77e5\u8bc6\u56fe\u8c31\u7ec4\u4ef6(KM),\u6570\u636e\u96c6\u4e0d\u5b58\u5728", (String)("\u6570\u636e\u96c6id:" + actionId), (String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u6570\u636e\u96c6\u662f\u5426\u88ab\u8bef\u5220\u9664"));
                                    context2.setCode("empty_dataSet");
                                    snapshot2.setContext(context2);
                                    Snapshot snapshot3 = snapshot2;
                                    return snapshot3;
                                }
                                Boolean isSuperAdmin = context2.dealSuperAdmin(request, this.iamService);
                                context2.getBizParams().setSuperAdmin(isSuperAdmin.booleanValue());
                                pullData = (PullData)context2.getPullData().get(0);
                                queryColDataPermission = new HashMap<String, Object>(4);
                                if (isSuperAdmin.booleanValue() || !CollectionUtils.isEmpty(queryColDataPermission = this.iamService.queryColDataPermission(request.getUserToken(), request.getLocale(), request.getTenantId(), request.getUserId(), request.getAppCode(), "dataset", actionId, Boolean.valueOf(false)))) break block24;
                                context2.setCode("user_permissions_not_match");
                                snapshot2.setContext(context2);
                                Snapshot snapshot4 = snapshot2;
                                return snapshot4;
                            }
                            try {
                                pullData.setMetadata(this.checkColumnPermission(reportScene, queryColDataPermission, request.getLocale()));
                                snapshot2.setContext(context2);
                                Snapshot snapshot5 = snapshot2;
                                return snapshot5;
                            }
                            catch (Exception e2) {
                                LOGGER.error("\u83b7\u53d6\u6570\u636e\u96c6\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e2.getMessage());
                                break block25;
                            }
                        }
                        if (request.isDataSetV1().booleanValue()) {
                            return this.doAnalyzeMetric(request, analyzetype);
                        }
                    }
                    String actionId = Optional.ofNullable(request.getShowDefine()).map(df -> (List)((Map)df).get("showType")).map(stList -> {
                        if (CollectionUtil.isEmpty((Collection)stList)) {
                            return "";
                        }
                        return (String)((Map)stList.get(0)).get("actionId");
                    }).orElse("");
                    request.setActionId(actionId);
                    String[] dataSetIdArray = actionId.split("-");
                    List<String> dataSetIdList = Context.achieveDataSetIds((AdeRequest)request);
                    int from = 1;
                    if (dataSetIdArray.length == 1) {
                        from = 0;
                    }
                    ArrayList classifications = Lists.newArrayListWithCapacity((int)8);
                    snapshot = null;
                    List kmDataSetDataList = this.themeMapService.queryMetricOrDataSetData(request.getTenantId(), request.getUserToken(), request.getLocale(), (List)(CollectionUtil.isEmpty((Collection)dataSetIdList) ? Arrays.asList(Arrays.copyOfRange(dataSetIdArray, from, dataSetIdArray.length)) : dataSetIdList));
                    kmDataSetDataList.forEach(data -> {
                        if (Objects.nonNull(data.getClassification())) {
                            classifications.add(data.getClassification());
                        }
                    });
                    context = Context.processingRequest((AdeRequest)request, (String)analyzetype, null, CollectionUtils.isEmpty((Collection)kmDataSetDataList) ? null : (KMMetricData)kmDataSetDataList.get(0));
                    this.converDynamicTime(context, kmDataSetDataList);
                    context.getBizParams().setBuiltClassifications((List)classifications);
                    if (CollectionUtil.isEmpty((Collection)kmDataSetDataList)) {
                        snapshot = new Snapshot();
                        snapshot.setSnapshotId(request.getTenantId(), null, CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
                        context.setCode("empty_dataSet");
                        snapshot.setContext(context);
                        LogUtils.buildAgileDataEngineLog((String)"queryDataSet", (String)"U.ADE.501.2000", (String)JSON.toJSONString(dataSetIdList), (String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u96c6", (String)"1.\u91cd\u65b0\u6267\u884c\u7684\u53d1\u7248\u5207\u7248\u64cd\u4f5c\u3002\n2.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\u3002\n3.\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                        return snapshot;
                    }
                    String locale = Optional.ofNullable(request.getLocale()).orElse("zh_CN");
                    localeTL.set(locale);
                    CompletionStage asynCf = null;
                    DWServiceContext dwServiceContext = DWServiceContext.getContext();
                    if (request.getCreateFilterAnalysis().booleanValue()) {
                        asynCf = CompletableFuture.runAsync(() -> {
                            DWServiceContext.setContext((DWServiceContext)dwServiceContext);
                            List solutionStepItems = context.getBizParams().getSolutionStepItems();
                            LOGGER.error("\u5f02\u6b65\u8bf7\u6c42\u5f00\u59cb\uff1asolutionStepItems\uff1a{}", (Object)JsonUtil.getJsonString((Object)solutionStepItems));
                            HashMap<String, Object> dataModels = new HashMap<String, Object>();
                            int i = 1;
                            Boolean lastStep = false;
                            block0: for (int z = 0; z < solutionStepItems.size(); ++z) {
                                SolutionStepItem item = (SolutionStepItem)solutionStepItems.get(z);
                                ArrayList<Map<String, Object>> newSolutionSteps = new ArrayList<Map<String, Object>>(1);
                                Map step = JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)item));
                                LOGGER.error("\u5f00\u59cb\u6784\u9020\u7b2c{}\u6b65\u8bed\u4e49\u6807\u7b7e", (Object)(++i));
                                if (z == solutionStepItems.size() - 1) {
                                    lastStep = true;
                                }
                                if (item.getDatasetObject().getMetric() == null) {
                                    newSolutionSteps.add(step);
                                    this.buildDataModels(step, dataModels);
                                    this.buildDatasetStepAnalysis(newSolutionSteps, context, null, request, dataModels, lastStep);
                                    continue;
                                }
                                for (KMMetricData kmData : kmDataSetDataList) {
                                    if (!item.getDatasetObject().getMetric().equals(kmData.getIndicatorId())) continue;
                                    this.buildStep(context.getBizParams().getDatasetList(), step, item.getDatasetObject().getMetric(), dataModels);
                                    newSolutionSteps.add(step);
                                    this.buildDatasetStepAnalysis(newSolutionSteps, context, kmData, request, dataModels, lastStep);
                                    continue block0;
                                }
                            }
                        }).whenComplete((res, e) -> {
                            if (!Objects.isNull(e)) {
                                JSONObject jsonObject = new JSONObject(4);
                                jsonObject.put("actionId", (Object)actionId);
                                LogUtils.buildAgileDataEngineLog((String)"convertSemantic", (String)"U.ADE.501.2001", (String)jsonObject.toJSONString(), (String)("\u7ec4\u88c5\u8c03\u8bd5\u4fe1\u606f\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u8bed\u4e49\u5206\u6790\u51fa\u7684\u5b57\u6bb5\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"\u53ef\u5c1d\u8bd5\u6392\u67e5\u95ee\u53e5\u4e2d\u5b58\u5728\u7c7b\u4f3c.*#\u7279\u6b8a\u7b26\u53f7\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u3002");
                            }
                            DWServiceContext.setContext(null);
                            analyzerTL.remove();
                            dataModelTL.remove();
                            elementsTL.remove();
                            localeTL.remove();
                        });
                    }
                    snapshot = this.adeService.buildDataSetContext(context, request.getSnapshotId(), actionId, kmDataSetDataList);
                    try {
                        if (asynCf != null) {
                            ((CompletableFuture)asynCf).get();
                        }
                    }
                    catch (InterruptedException interception) {
                        LOGGER.info("Interrupted! {}", (Throwable)interception);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e3) {
                        LOGGER.info("\u6570\u636e\u96c6\u5f02\u6b65\u8bf7\u6c42\u5f02\u5e38,error:{}", (Object)e3.getMessage());
                    }
                    if (!CollectionUtil.isEmpty((Collection)snapshot.getContext().getPullData()) && !StringUtil.isNotBlank((String)snapshot.getContext().getCode())) break block26;
                    Snapshot e3 = snapshot;
                    return e3;
                }
                if (org.springframework.util.StringUtils.hasLength((String)request.getSnapshotId())) {
                    snapshot.setSnapshotId(request.getSnapshotId());
                }
                Snapshot.hasData((Snapshot)snapshot);
                if (!request.getCreateSnap().booleanValue()) break block27;
                String snapshotId = this.adeService.saveDataSnapshot(request.getTenantId(), snapshot.getContext().getBizParams().getLocale(), request.getUserToken(), snapshot);
                if (org.springframework.util.StringUtils.hasLength((String)request.getSnapshotId()) || snapshotId.contains("ADE_Snapshot")) break block28;
                Snapshot snapshot6 = snapshot.setSnapshotId(snapshotId);
                return snapshot6;
            }
            try {
                context.getBizParams().setSnapshotTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
                HashMap<String, Object> params = new HashMap<String, Object>(4);
                params.put("snapshotId", snapshot.getSnapshotId());
                params.put("tenantId", request.getTenantId());
                params.put("isMock", request.getMock());
                params.put("token", request.getUserToken());
                this.sendService.sendMessage(JsonUtil.getJsonString(params), "direct", "athena.event.message.adt");
            }
            catch (Exception e4) {
                JSONObject logJson = new JSONObject(4);
                logJson.put("snapshotId", (Object)(snapshot != null ? snapshot.getSnapshotId() : null));
                LogUtils.buildAgileDataEngineLog((String)"doAnalyzeDataSet", (String)"U.ADE.501.2003", (String)logJson.toJSONString(), (String)("\u6570\u636e\u96c6\u6570\u636e\u89e3\u6790\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u6587\u6863\u4e2d\u5fc3\u670d\u52a1\u548cmq\u4e2d\u95f4\u4ef6\u5f02\u5e38\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e4.getMessage())), (String)"\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u4ecd\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
                Thread.currentThread().interrupt();
            }
        }
        return snapshot;
    }

    public AttributionDimensionResponse getAttributionDimension(AttributionDimensionRequest request) {
        BizParams bizParams = BizParams.build((AttributionDimensionRequest)request);
        List kmDataSetDataList = this.themeMapService.queryMetricOrDataSetData(request.getTenantId(), request.getUserToken(), request.getLocale(), bizParams.getDatasetIds());
        AttributionDimensionResponse response = null;
        if (CollectionUtil.isEmpty((Collection)kmDataSetDataList)) {
            response = new AttributionDimensionResponse();
            response.setCode("empty_dataSet");
            LogUtils.buildAgileDataEngineLog((String)"getAttributionDimension", (String)"U.ADE.501.2000", (String)JSON.toJSONString((Object)bizParams.getDatasetIds()), (String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u96c6", (String)"1.\u91cd\u65b0\u6267\u884c\u7684\u53d1\u7248\u5207\u7248\u64cd\u4f5c\u3002\n2.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\u3002\n3.\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            return response;
        }
        return this.adeService.buildAttributionDimensionResponse(bizParams, request.getGroupedSolutionSteps(), JsonUtil.getList((String)JsonUtil.getJsonString((Object)request.getDatasetList()), DatasetListItem.class), request.getPullData(), kmDataSetDataList);
    }

    public String getFileDetailUrlV2(AdeRequest data) {
        List dataList;
        List kmDataSetDataList;
        String actionId = Optional.ofNullable(data.getShowDefine()).map(df -> (List)((Map)df).get("showType")).map(stList -> {
            if (CollectionUtil.isEmpty((Collection)stList)) {
                return "";
            }
            return (String)((Map)stList.get(0)).get("actionId");
        }).orElse("");
        data.setActionId(actionId);
        String[] dataSetIdArray = actionId.split("-");
        List<String> dataSetIdList = Context.achieveDataSetIds((AdeRequest)data);
        int from = 1;
        if (dataSetIdArray.length == 1) {
            from = 0;
        }
        if (CollectionUtils.isEmpty((Collection)(kmDataSetDataList = this.themeMapService.queryMetricOrDataSetData(data.getTenantId(), data.getUserToken(), data.getLocale(), (List)(CollectionUtil.isEmpty((Collection)dataSetIdList) ? Arrays.asList(Arrays.copyOfRange(dataSetIdArray, from, dataSetIdArray.length)) : dataSetIdList))))) {
            return null;
        }
        Context context = Context.processingRequest((AdeRequest)data, (String)"instant", null, CollectionUtils.isEmpty((Collection)kmDataSetDataList) ? null : (KMMetricData)kmDataSetDataList.get(0));
        this.converDynamicTime(context, kmDataSetDataList);
        try {
            dataList = this.adeService.getDatasetV2Data(context, data.getActionId(), kmDataSetDataList);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6307\u6807\u6216\u6570\u636e\u96c6\u660e\u7ec6\u6570\u636e\u5f02\u5e38{}", (Object)e.getMessage());
            return "download_error";
        }
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return "download_quantity_limit";
        }
        if (dataList instanceof ErrorCodeDto) {
            return "download_error";
        }
        String fileName = ExcelUtil.createExcel((String)data.getQuestion(), (Object)dataList, (String)data.getLocale());
        if (!org.springframework.util.StringUtils.hasLength((String)fileName)) {
            return "download_error";
        }
        String token = this.dmcService.getDMCUserToken(data.getTenantId(), "asada", "asadaM8@15f");
        if (!org.springframework.util.StringUtils.hasLength((String)token)) {
            return "download_error";
        }
        DmcFileResponse fileResponse = this.dmcService.uploadFile(token, data.getLocale(), data.getTenantId(), DmcFileRequest.build((String)fileName, (String)data.getQuestion(), (String)data.getTenantId()), "file");
        if (fileResponse != null) {
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setAllowCount(Integer.valueOf(1));
            fileRequest.setDeleteFile(Boolean.valueOf(true));
            fileRequest.setFileId(fileResponse.getId());
            String url = this.dmcService.getShareUrl(token, data.getLocale(), data.getTenantId(), fileRequest);
            if (org.springframework.util.StringUtils.hasLength((String)url)) {
                return url;
            }
        }
        return "download_error";
    }

    private void buildStep(List<Map<String, Object>> datasetList, Map<String, Object> step, String metric, Map<String, Object> dataModels) {
        for (Map<String, Object> dataset : datasetList) {
            if (!metric.equals(dataset.get("datasetId"))) continue;
            DatasetListItem item = (DatasetListItem)JsonUtil.getObject((String)JsonUtil.getJsonString(dataset), DatasetListItem.class);
            if (!CollectionUtils.isEmpty((Collection)((Collection)step.get("select"))) && dataModels != null) {
                List selects = (List)step.get("select");
                for (Map select : selects) {
                    Map dataObject = (Map)select.get("dataObject");
                    if (CollectionUtils.isEmpty((Map)dataObject)) continue;
                    String alias = (String)dataObject.get("alias");
                    String title = (String)dataObject.get("title");
                    String content = (String)dataObject.get("content");
                    if (!org.springframework.util.StringUtils.isEmpty((Object)content) && !org.springframework.util.StringUtils.isEmpty((Object)title)) {
                        dataModels.put(content, title);
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)alias) || org.springframework.util.StringUtils.isEmpty((Object)title)) continue;
                    if (alias.contains("#")) {
                        dataModels.put(alias.replace("#", ""), title);
                    }
                    dataModels.put(alias, title);
                }
            }
            if (item == null || CollectionUtils.isEmpty((Collection)item.getFieldSchema()) || CollectionUtil.isEmpty((Map)((Map)step.get("filter")))) continue;
            FilterItem filterItem = (FilterItem)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)step.get("filter")), FilterItem.class);
            block2: for (FilterItem.FilterPart filterPart : filterItem.getChildren()) {
                for (FieldSchemaItem schemaItem : item.getFieldSchema()) {
                    Boolean isFind = false;
                    if (schemaItem.getName().equals(filterPart.getLeft().getContent())) {
                        for (DataEnum dataEnum : schemaItem.getEnums()) {
                            if (!dataEnum.getValue().equals(((FilterItem.ConditionItemWrap)filterPart.getRight().get(0)).getDataObject().getContent())) continue;
                            ((FilterItem.ConditionItemWrap)filterPart.getRight().get(0)).getDataObject().setContent(dataEnum.getDescription());
                            isFind = true;
                            break;
                        }
                    }
                    if (!isFind.booleanValue()) continue;
                    continue block2;
                }
            }
            step.put("filter", JsonUtil.json2Map((String)JsonUtil.getJsonString((Object)filterItem)));
        }
    }
}

