/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze.impl;

import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.DatasetObject;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.SolutionStep;
import com.digiwin.smartdata.agiledataengine.service.analyze.ISolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="datasetObjectStep")
public class DatasetObjectSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetObjectSolutionStepAnalyzer.class);

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        DatasetObject datasetObject = solutionStep.getDatasetObject();
        String strStepIndex = stepIndex + "-" + solutionStep.getAlias();
        LOGGER.info("datasetObjectStep\u5f00\u59cb\u6267\u884cdatasetObject==null:{}", (Object)(datasetObject == null ? "true" : "false"));
        if (datasetObject != null) {
            String datasetType = datasetObject.getDatasetType();
            if ("metric".equalsIgnoreCase(datasetType) || "metricDataset".equalsIgnoreCase(datasetType) || "dataset".equals(datasetType)) {
                Object data = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                if (data == null) {
                    return;
                }
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null) {
                    dataMap.put(strStepIndex, data);
                } else {
                    dataMap = new HashMap<String, Object>();
                    dataMap.put(strStepIndex, data);
                }
                SolutionStepExecutionFacade.setTransDataMap(dataMap);
            } else if ("step".equals(datasetObject.getDatasetType())) {
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null && dataMap.containsKey(datasetObject.getStep())) {
                    dataMap.put(strStepIndex, dataMap.get(datasetObject.getStep()));
                }
            } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                datasetObject.getSubQuery().setAlias(solutionStep.getAlias());
                this.executeStep(datasetObject.getSubQuery(), stepIndex, context);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionStep.getJoin())) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"joinStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (solutionStep.getFilter() != null && CollectionUtils.isNotEmpty((Collection)solutionStep.getFilter().getChildren())) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"filterStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionStep.getSelect())) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"selectStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (solutionStep.isDistinct()) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"distinctStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionStep.getSort())) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"sortStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (solutionStep.getLimit() != null) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"limitStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionStep.getUnion())) {
            ((ISolutionStepAnalyzer)ContextUtils.getBean((String)"unionStep", ISolutionStepAnalyzer.class)).executeStep(solutionStep, stepIndex, context);
        }
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
        SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
    }
}

