/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.SolutionStep;
import com.digiwin.smartdata.agiledataengine.service.analyze.ISolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.convert.trans.ITransDefinitionConvertor;
import com.digiwin.smartdata.agiledataengine.service.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="distinctStep")
public class DistinctSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    @Autowired
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        Object data;
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object object = data = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        if (data == null) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(dataKey, data);
        List selects = solutionStep.getSelect();
        List distinctFields = selects.stream().map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"distinct");
        JSONObject schema = new JSONObject();
        schema.put("distinctFields", distinctFields);
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
        Object resultData = transEngine.runEngine(transDataManger);
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
    }
}

