/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.DatasetObject;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Join;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.SolutionStep;
import com.digiwin.smartdata.agiledataengine.service.analyze.ISolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.analyze.impl.DatasetObjectSolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.convert.trans.ITransDefinitionConvertor;
import com.digiwin.smartdata.agiledataengine.service.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="joinStep")
public class JoinSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        List joinList = solutionStep.getJoin();
        for (Join join : joinList) {
            Object joinData = null;
            DatasetObject datasetObject = join.getDatasetObject();
            if ("metric".equals(datasetObject.getDatasetType())) {
                joinData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
            } else if ("step".equals(datasetObject.getDatasetType())) {
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null && dataMap.containsKey(datasetObject.getStep())) {
                    joinData = dataMap.get(datasetObject.getStep());
                }
            } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = (DatasetObjectSolutionStepAnalyzer)ContextUtils.getBean((String)"datasetObjectStep", (Object[])new Object[0]);
                datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                if (dataMap != null && dataMap.containsKey(key)) {
                    joinData = dataMap.get(key);
                }
            }
            String leftDataKey = stepIndex + "-" + solutionStep.getAlias();
            Object leftData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(leftDataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(leftDataKey) : null;
            Object resultData = null;
            LOGGER.info("joinStep\u5f00\u59cbjoin\u64cd\u4f5cjoinData==null:{}\uff0cleftData==null:{}", (Object)(joinData == null ? "true" : "false"), (Object)(leftData == null ? "true" : "false"));
            if (joinData != null || leftData != null) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("DATA1", leftData == null ? new ArrayList() : leftData);
                dataMap.put("DATA2", joinData == null ? new ArrayList() : joinData);
                JSONObject criteriaDefinition = new JSONObject();
                criteriaDefinition.put("technique", (Object)"join");
                criteriaDefinition.put("schema", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)join)));
                JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("joinStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
                resultData = transEngine.runEngine(transDataManger);
            }
            SolutionStepExecutionFacade.getTransDataMap().put(leftDataKey, resultData);
        }
    }
}

