/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.BaseObject;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.DataObject;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.DatasetObject;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Filter;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.FilterHavingChildren;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.FilterHavingChildrenRight;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.GroupBy;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Having;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Select;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.SolutionStep;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Sort;
import com.digiwin.smartdata.agiledataengine.service.analyze.ISolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.analyze.impl.DatasetObjectSolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.convert.trans.ITransDefinitionConvertor;
import com.digiwin.smartdata.agiledataengine.service.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectStep")
public class SelectSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object selectData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("selectStep\u5f00\u59cb\u6267\u884cselectData==null:{}", (Object)(selectData == null ? "true" : "false"));
        if (selectData != null) {
            HashMap<String, Object> dataMap;
            List selectList = solutionStep.getSelect();
            ArrayList computeSelectList = new ArrayList();
            HashMap<String, Select> specialComputeSelectMap = new HashMap<String, Select>();
            selectList.forEach(select -> {
                if ("calculate".equals(select.getDataObject().getContentType())) {
                    String computeName = select.getDataObject().getContent();
                    JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                    for (int j = 0; j < computeArray.size(); ++j) {
                        JSONObject computeItem = computeArray.getJSONObject(j);
                        String computeType = computeItem.getString("calFunction");
                        if (computeItem.containsKey((Object)"overParams")) {
                            specialComputeSelectMap.put(computeType, (Select)select);
                            continue;
                        }
                        List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
                        if (!methodList.contains(computeType.toUpperCase()) || computeSelectList.contains(select)) continue;
                        computeSelectList.add(select);
                    }
                }
            });
            if (!specialComputeSelectMap.isEmpty()) {
                specialComputeSelectMap.forEach((key, select) -> {
                    switch (key) {
                        case "RowNumber": {
                            this.calRowNumber(solutionStep, context, (Select)select, dataKey);
                            break;
                        }
                        case "Sum": {
                            this.calCumulativeSum(solutionStep, context, (Select)select, dataKey);
                            break;
                        }
                    }
                });
            }
            if (!CollectionUtils.isNotEmpty((Collection)solutionStep.getGroupby())) {
                JSONArray newDataArray = new JSONArray();
                if (!computeSelectList.isEmpty()) {
                    for (Select select2 : computeSelectList) {
                        selectData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                        this.doSelectCalculate(select2, solutionStep.getComputeList(), selectData, context, dataKey);
                    }
                }
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)SolutionStepExecutionFacade.getTransDataMap().get(dataKey), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject data = dataArray.getJSONObject(i);
                    Set keys = data.keySet();
                    for (String key2 : keys) {
                        if (!selectList.stream().anyMatch(select -> key2.equals(select.getDataObject().getContent()))) continue;
                        newJsonObject.put(key2, data.get((Object)key2));
                    }
                    selectList.forEach(select -> {
                        if ("const".equals(select.getDataObject().getContentType())) {
                            DataObject dataObject = select.getDataObject();
                            newJsonObject.put(dataObject.getAlias(), (Object)dataObject.getContent());
                        }
                    });
                    if (newJsonObject.isEmpty()) continue;
                    newDataArray.add((Object)newJsonObject);
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
                if (newDataArray.isEmpty() && !dataArray.isEmpty()) {
                    List<String> selectFunctionName = selectList.stream().filter(select -> "calculate".equals(select.getDataObject().getContentType())).map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
                    JSONObject computeList = solutionStep.getComputeList();
                    JSONArray functionFields = this.createFunctionFields(selectFunctionName, computeList);
                    dataMap = new HashMap<String, Object>();
                    dataMap.put(dataKey, selectData);
                    if (CollectionUtils.isEmpty((Collection)functionFields)) {
                        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, selectData);
                    } else {
                        Object result = this.doGroupTrans(new JSONArray(), functionFields, dataMap, context);
                        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, result);
                    }
                }
            } else {
                JSONArray groupFields = new JSONArray();
                Iterator tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)tempData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (!dataArray.isEmpty()) {
                    JSONObject data = dataArray.getJSONObject(0);
                    Object fieldKeys = data.keySet();
                    for (GroupBy groupBy : solutionStep.getGroupby()) {
                        if ("field".equals(groupBy.getContentType())) {
                            groupFields.add((Object)groupBy.getContent());
                            continue;
                        }
                        if (!"calculate".equals(groupBy.getContentType())) continue;
                        tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                        GroupBy newGroupBy = this.doGroupCalculate(groupBy, solutionStep.getComputeList(), (Set<String>)fieldKeys, tempData, context, dataKey);
                        if (groupFields.contains((Object)newGroupBy.getContent())) continue;
                        groupFields.add((Object)newGroupBy.getContent());
                    }
                    dataMap = new HashMap();
                    dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    JSONObject computeList = solutionStep.getComputeList();
                    Set computeKeys = computeList.keySet();
                    JSONArray functionFields = this.createFunctionFields(new ArrayList<String>(computeKeys), computeList);
                    Object resultData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                    if (CollectionUtils.isNotEmpty((Collection)functionFields)) {
                        resultData = this.doGroupTrans(groupFields, functionFields, dataMap, context);
                        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, selectData);
                    }
                    if (solutionStep.getHaving() != null && resultData != null) {
                        Having having = solutionStep.getHaving();
                        List<FilterHavingChildren> newChildren = this.dealHavingChildren(having.getChildren(), computeList, context, stepIndex, solutionStep.getDatasetObject().getAlias());
                        JSONObject criteriaDefinition = new JSONObject();
                        criteriaDefinition.put("technique", (Object)"filter");
                        Filter filter = new Filter();
                        filter.setLogic(having.getLogic());
                        if (CollectionUtils.isNotEmpty(newChildren)) {
                            filter.setChildren(newChildren);
                            criteriaDefinition.put("schema", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)filter)));
                            JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                            LOGGER.info("filterStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                            dataMap = new HashMap();
                            dataMap.put(dataKey, resultData);
                            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                            TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
                            resultData = transEngine.runEngine(transDataManger);
                        }
                    }
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            ArrayList<String> columnList = new ArrayList<String>();
            block12: for (Select select3 : selectList) {
                if (select3.getDataObject() == null) continue;
                String contentType = select3.getDataObject().getContentType();
                switch (contentType) {
                    case "const": {
                        columnList.add(select3.getDataObject().getAlias());
                        continue block12;
                    }
                    case "calculate": {
                        String computeName = select3.getDataObject().getContent();
                        JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                        String newField = computeArray.getJSONObject(computeArray.size() - 1).getString("newField");
                        columnList.add(newField);
                        continue block12;
                    }
                }
                columnList.add(select3.getDataObject().getContent());
            }
            if (!columnList.isEmpty()) {
                Object data = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                JSONArray newDataArray = new JSONArray();
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject rowData = dataArray.getJSONObject(i);
                    Set keys = rowData.keySet();
                    for (String key3 : keys) {
                        if (!columnList.stream().anyMatch(key3::equals)) continue;
                        newJsonObject.put(key3, rowData.get((Object)key3));
                    }
                    if (newJsonObject.isEmpty()) continue;
                    newDataArray.add((Object)newJsonObject);
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
            }
        }
    }

    private void calCumulativeSum(SolutionStep solutionStep, SolutionStepContext context, Select select, String dataKey) {
        Object selectData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
        String computeName = select.getDataObject().getContent();
        JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
        JSONArray oderByJson = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("orderBy");
        JSONArray partitionArray = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("partition");
        List groupFields = Optional.ofNullable(partitionArray).map(t -> t.stream().map(obj -> ((JSONObject)obj).getString("content")).collect(Collectors.toList())).orElse(Collections.emptyList());
        JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)selectData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        List dataList = dataArray.stream().map(obj -> (Map)obj).collect(Collectors.toList());
        Map<String, List<Map>> grouped = dataList.stream().collect(Collectors.groupingBy(row -> groupFields.stream().map(f -> String.valueOf(row.get(f))).collect(Collectors.joining("||"))));
        ArrayList<Map> resultData = new ArrayList<Map>();
        for (List<Map> rows : grouped.values()) {
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", (Object)"sorts");
            JSONObject sortJson = new JSONObject();
            sortJson.put("sort", (Object)JSONArray.parseArray((String)JSONArray.toJSONString((Object)oderByJson)));
            criteriaDefinition.put("schema", (Object)sortJson);
            JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
            LOGGER.info("sortStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            HashMap<String, List<Map>> dataMap = new HashMap<String, List<Map>>();
            dataMap.put(dataKey, rows);
            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
            TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
            List data = (List)transEngine.runEngine(transDataManger);
            String newField = computeArray.getJSONObject(0).getString("newField");
            String content = computeArray.getJSONObject(0).getJSONArray("params").getJSONObject(0).getString("content");
            BigDecimal cumulativeSum = new BigDecimal(0);
            for (Map row2 : data) {
                Object val = row2.get(content);
                if (val instanceof Number) {
                    cumulativeSum = cumulativeSum.add(new BigDecimal(val.toString()));
                } else if (val instanceof String && StringUtils.isNotEmpty((CharSequence)((String)val))) {
                    cumulativeSum = cumulativeSum.add(new BigDecimal((String)val));
                }
                row2.put(newField, cumulativeSum);
                resultData.add(row2);
            }
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
    }

    private void calRowNumber(SolutionStep solutionStep, SolutionStepContext context, Select select, String dataKey) {
        Object selectData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
        JSONArray rowNumberGroupFields = new JSONArray();
        String computeName = select.getDataObject().getContent();
        JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
        JSONArray oderByJson = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("orderBy");
        JSONArray partitionArray = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("partition");
        if (partitionArray != null) {
            for (int j = 0; j < partitionArray.size(); ++j) {
                JSONObject partition = partitionArray.getJSONObject(j);
                String content = partition.getString("content");
                if ("field".equalsIgnoreCase(partition.getString("contentType"))) {
                    rowNumberGroupFields.add((Object)content);
                    DataObject dataObject = (DataObject)JSON.parseObject((String)partition.toJSONString(), DataObject.class);
                    Sort sort = new Sort();
                    sort.setDataObject(dataObject);
                    sort.setOrder("asc");
                    oderByJson.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sort)));
                    continue;
                }
                Object tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)tempData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (dataArray.isEmpty()) continue;
                JSONObject data = dataArray.getJSONObject(0);
                Set fieldKeys = data.keySet();
                String newField = this.doRowNumberCalculate(content, solutionStep.getComputeList(), fieldKeys, selectData, context, dataKey);
                rowNumberGroupFields.add((Object)newField);
                DataObject dataObject = (DataObject)JSON.parseObject((String)partition.toJSONString(), DataObject.class);
                dataObject.setContent(newField);
                dataObject.setContentType("field");
                Sort sort = new Sort();
                sort.setDataObject(dataObject);
                sort.setOrder("asc");
                oderByJson.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sort)));
            }
        }
        JSONObject sortJSON = new JSONObject();
        sortJSON.put("fields", (Object)rowNumberGroupFields);
        sortJSON.put("sort", (Object)oderByJson);
        sortJSON.put("mode", (Object)"custom");
        sortJSON.put("sortName", (Object)computeArray.getJSONObject(0).getString("newField"));
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"sorts");
        criteriaDefinition.put("schema", (Object)sortJSON);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
        TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
        Object resultData = transEngine.runEngine(transDataManger);
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
    }

    public Object doGroupTrans(JSONArray groupFields, JSONArray functionFields, Map<String, Object> dataMap, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("groupFields", (Object)groupFields);
        schema.put("functionFields", (Object)functionFields);
        JSONArray distinctFields = new JSONArray();
        for (int i = 0; i < functionFields.size(); ++i) {
            String methodName = functionFields.getJSONObject(i).getString("method");
            if (!"count,sum,average,min,max,group,variance,stddev,accSum".contains(methodName)) continue;
            distinctFields.add((Object)functionFields.getJSONObject(i).getString("newFields"));
        }
        distinctFields.addAll((Collection)groupFields);
        schema.put("distinctFields", (Object)distinctFields);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"group");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
        Object result = transEngine.runEngine(transDataManger);
        if (!distinctFields.isEmpty()) {
            distinctFields.addAll((Collection)groupFields);
            result = this.doDistinctTrans(distinctFields, result, context);
        }
        return result;
    }

    public Object doDistinctTrans(JSONArray distinctFields, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("distinctFields", (Object)distinctFields);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"distinct");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("distinctStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
        return transEngine.runEngine(transDataManger);
    }

    public JSONArray createFunctionFields(List<String> computeKeys, JSONObject computeList) {
        JSONArray functionFields = new JSONArray();
        for (String computeKey : computeKeys) {
            JSONArray computeArray = computeList.getJSONArray(computeKey);
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (computeArray.stream().anyMatch(compute -> {
                String functionName = ((JSONObject)compute).getString("calFunction");
                return methodList.contains(functionName.toUpperCase()) || functionName.equalsIgnoreCase("RowNumber");
            })) continue;
            for (int i = 0; i < computeArray.size(); ++i) {
                JSONObject compute2 = computeArray.getJSONObject(i);
                if (compute2.containsKey((Object)"FLAG")) continue;
                JSONObject function = new JSONObject();
                function.put("method", (Object)compute2.getString("calFunction").toLowerCase());
                JSONArray fields = new JSONArray();
                JSONArray parameters = compute2.getJSONArray("params");
                for (int j = 0; j < parameters.size(); ++j) {
                    JSONObject parameter = parameters.getJSONObject(j);
                    fields.add((Object)parameter.getString("content"));
                }
                function.put("fields", (Object)fields);
                function.put("valueType", (Object)compute2.getString("valueType"));
                function.put("newFields", (Object)compute2.getString("newField"));
                functionFields.add((Object)function);
            }
        }
        return functionFields;
    }

    public GroupBy doGroupCalculate(GroupBy groupBy, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        GroupBy newObject = new GroupBy();
        if (!"calculate".equals(groupBy.getContentType())) {
            return groupBy;
        }
        String computeName = groupBy.getContent();
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); ++i) {
            JSONObject compute = computeJsonArray.getJSONObject(i);
            if (compute.containsKey((Object)"FLAG")) continue;
            String calFunction = compute.getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u4e2d\u8ba1\u7b97\u6682\u4e0d\u652f\u6301:{}", (Object)compute.getString("calFunction"));
                continue;
            }
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); ++j) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (fieldKeys.contains(parameter.getString("content")) || !"field".equals(parameter.getString("contentType"))) continue;
                flag = true;
                LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u4e2d\u8ba1\u7b97\u5217\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u96c6\u4e2d:{}", (Object)parameter.toJSONString());
            }
            if (flag) continue;
            newComputeJsonArray.add((Object)compute);
        }
        if (CollectionUtils.isEmpty((Collection)newComputeJsonArray)) {
            return groupBy;
        }
        Object calculateResult = this.doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doGroupCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return groupBy;
        }
        JSONObject lastCalculateFunction = computeJsonArray.getJSONObject(computeJsonArray.size() - 1);
        newObject.setContent(lastCalculateFunction.getString("newField"));
        newObject.setSource(groupBy.getSource());
        newObject.setContentType("field");
        newObject.setDataType(lastCalculateFunction.getString("valueType"));
        newObject.setAlias(groupBy.getAlias());
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newObject;
    }

    public void doSelectCalculate(Select select, JSONObject computeList, Object data, SolutionStepContext context, String dataKey) {
        if (select.getDataObject() == null) {
            return;
        }
        if (!"calculate".equals(select.getDataObject().getContentType())) {
            return;
        }
        String computeName = select.getDataObject().getContent();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int j = 0; j < computeJsonArray.size(); ++j) {
            String computeType = computeJsonArray.getJSONObject(j).getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (methodList.contains(computeType.toUpperCase())) continue;
            return;
        }
        Object calculateResult = this.doCalculate(computeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doSelectCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
    }

    private Object doCalculate(JSONArray ruleJson, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("rule", (Object)ruleJson);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"calculate");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
        return transEngine.runEngine(transDataManger);
    }

    private List<FilterHavingChildren> dealHavingChildren(List<FilterHavingChildren> children, JSONObject computeList, SolutionStepContext context, int stepIndex, String alias) {
        ArrayList<FilterHavingChildren> newChildren = new ArrayList<FilterHavingChildren>();
        if (CollectionUtils.isEmpty(children)) {
            return newChildren;
        }
        for (FilterHavingChildren filterHavingChildren : children) {
            List<FilterHavingChildren> childChildren;
            FilterHavingChildren newChild = new FilterHavingChildren();
            newChild.setOperator(filterHavingChildren.getOperator());
            newChild.setLogic(filterHavingChildren.getLogic());
            BaseObject leftObject = this.createCalculateBaseObject(filterHavingChildren.getLeft(), computeList);
            if (leftObject != null) {
                newChild.setLeft(leftObject);
            }
            ArrayList<FilterHavingChildrenRight> newRightList = new ArrayList<FilterHavingChildrenRight>();
            List rightList = filterHavingChildren.getRight();
            for (FilterHavingChildrenRight filterHavingChildrenRight : rightList) {
                FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                if (filterHavingChildrenRight.getDataObject() != null) {
                    BaseObject rightObject = this.createCalculateBaseObject(filterHavingChildrenRight.getDataObject(), computeList);
                    if (rightObject != null) {
                        newChildRight.setDataObject(rightObject);
                    } else {
                        newChildRight = null;
                    }
                } else {
                    DatasetObject datasetObject = filterHavingChildrenRight.getDatasetObject();
                    Object rightData = null;
                    if ("metric".equals(datasetObject.getDatasetType())) {
                        rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                    } else if ("step".equals(datasetObject.getDatasetType())) {
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        if (dataMap.containsKey(datasetObject.getStep())) {
                            rightData = dataMap.get(datasetObject.getStep());
                        }
                    } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                        DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = (DatasetObjectSolutionStepAnalyzer)ContextUtils.getBean((String)"datasetObjectStep", (Object[])new Object[0]);
                        datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                        if (dataMap.containsKey(key)) {
                            rightData = dataMap.get(key);
                        }
                    }
                    BaseObject baseObject = new BaseObject();
                    baseObject.setContent(JSONObject.toJSONString((Object)rightData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    baseObject.setSource(alias);
                    baseObject.setContent("const");
                    baseObject.setDataType("string");
                    newChildRight.setDataObject(baseObject);
                }
                if (newChildRight == null) continue;
                newRightList.add(newChildRight);
            }
            if (CollectionUtils.isNotEmpty(newRightList)) {
                newChild.setRight(newRightList);
            }
            if (CollectionUtils.isNotEmpty(childChildren = this.dealHavingChildren(filterHavingChildren.getChildren(), computeList, context, stepIndex, alias))) {
                newChild.setChildren(childChildren);
            }
            if (newChild.getLeft() == null || !CollectionUtils.isNotEmpty((Collection)newChild.getRight())) continue;
            newChildren.add(newChild);
        }
        return newChildren;
    }

    private BaseObject createCalculateBaseObject(BaseObject baseObject, JSONObject computeList) {
        BaseObject newBaseObject = new BaseObject();
        if ("calculate".equals(baseObject.getContentType())) {
            newBaseObject = new BaseObject();
            JSONArray computeArray = computeList.getJSONArray(baseObject.getContent());
            JSONObject lastComputeJson = computeArray.getJSONObject(computeArray.size() - 1);
            String newFieldName = lastComputeJson.getString("newField");
            newBaseObject.setContent(newFieldName);
            newBaseObject.setContentType("field");
            newBaseObject.setSource(baseObject.getSource());
            newBaseObject.setDataType(baseObject.getDataType());
            return newBaseObject;
        }
        BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
        return newBaseObject;
    }

    public String doRowNumberCalculate(String computeName, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        String newFieldName = null;
        if (!computeList.containsKey((Object)computeName)) {
            return null;
        }
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); ++i) {
            JSONObject compute = computeJsonArray.getJSONObject(i);
            String calFunction = compute.getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep\u6267\u884cdoRowNumberCalculate.trans\u4e2d\u8ba1\u7b97\u6682\u4e0d\u652f\u6301:{}", (Object)compute.getString("calFunction"));
                continue;
            }
            newFieldName = compute.getString("newField");
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); ++j) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (fieldKeys.contains(parameter.getString("content")) || !"field".equals(parameter.getString("contentType"))) continue;
                flag = true;
                LOGGER.info("selectStep\u6267\u884cdoRowNumberCalculate.trans\u4e2d\u8ba1\u7b97\u5217\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u96c6\u4e2d:{}", (Object)parameter.toJSONString());
            }
            if (flag) continue;
            newComputeJsonArray.add((Object)compute);
        }
        Object calculateResult = this.doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doRowNumberCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return null;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newFieldName;
    }
}

