/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.analyze.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.SolutionStep;
import com.digiwin.smartdata.agiledataengine.pojo.solutionstep.Sort;
import com.digiwin.smartdata.agiledataengine.service.analyze.ISolutionStepAnalyzer;
import com.digiwin.smartdata.agiledataengine.service.convert.trans.ITransDefinitionConvertor;
import com.digiwin.smartdata.agiledataengine.service.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sortStep")
public class SortSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object sortData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("sortStep\u5f00\u59cb\u6267\u884csortData==null:{}", (Object)(sortData == null ? "true" : "false"));
        JSONArray sortDataArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)sortData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (sortDataArray != null && !sortDataArray.isEmpty()) {
            Object resultData;
            HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
            dataMap.put(dataKey, sortDataArray);
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", (Object)"sorts");
            JSONObject sortJson = new JSONObject();
            ArrayList<Sort> newSortList = new ArrayList<Sort>();
            for (Sort sort : solutionStep.getSort()) {
                String content;
                Sort newSort = new Sort();
                BeanUtils.copyProperties((Object)sort, (Object)newSort);
                if ("calculate".equals(sort.getDataObject().getContentType())) {
                    content = newSort.getDataObject().getContent();
                    newSort.getDataObject().setContent(this.getComputeColumnName(solutionStep.getComputeList(), content));
                    newSortList.add(newSort);
                    continue;
                }
                if (!"field".equals(sort.getDataObject().getContentType())) continue;
                content = sort.getDataObject().getContent();
                JSONObject data = sortDataArray.getJSONObject(0);
                Set dataFieldKeys = data.keySet();
                if (!dataFieldKeys.contains(content)) continue;
                newSortList.add(newSort);
            }
            if (CollectionUtils.isNotEmpty(newSortList)) {
                sortJson.put("sort", (Object)JSONArray.parseArray((String)JSONArray.toJSONString(newSortList)));
                criteriaDefinition.put("schema", (Object)sortJson);
                JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("sortStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                TransEngine transEngine = (TransEngine)ContextUtils.getBean(TransEngine.class, (Object[])new Object[0]);
                resultData = transEngine.runEngine(transDataManger);
            } else {
                resultData = sortData;
            }
            SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
        }
    }

    private String getComputeColumnName(JSONObject computeList, String computeName) {
        if (computeList == null || !computeList.containsKey((Object)computeName)) {
            return "";
        }
        JSONArray computeArray = computeList.getJSONArray(computeName);
        if (computeArray == null || computeArray.isEmpty()) {
            return "";
        }
        JSONObject firstCompute = computeArray.getJSONObject(computeArray.size() - 1);
        return firstCompute.getString("newField");
    }
}

