/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.attribution.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.core.util.ThreadPoolUtils;
import com.digiwin.smartdata.agiledataengine.dto.AttributeInquirerDto;
import com.digiwin.smartdata.agiledataengine.dto.QueryDto;
import com.digiwin.smartdata.agiledataengine.model.input.SolutionStepInput;
import com.digiwin.smartdata.agiledataengine.pojo.bo.AttributionDataBo;
import com.digiwin.smartdata.agiledataengine.service.attribution.IAttributeInquirer;
import com.digiwin.smartdata.agiledataengine.service.execution.ISolutionStepExecutionFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttributeInquirerImpl
implements IAttributeInquirer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeInquirerImpl.class);
    @Autowired
    private ISolutionStepExecutionFacade solutionStepExecutionFacade;

    @Override
    public List<AttributionDataBo> fetchAttributionData(AttributeInquirerDto attributeInquirerDto) throws Exception {
        if (CollectionUtils.isEmpty((Collection)attributeInquirerDto.getGroupedSolutionSteps())) {
            return Lists.newArrayList();
        }
        ArrayList callableList = new ArrayList(6);
        DWServiceContext context = DWServiceContext.getContext();
        attributeInquirerDto.getGroupedSolutionSteps().forEach(obj -> {
            JSONObject singleAttribute = (JSONObject)obj;
            JSONArray forwardSolutionStep = singleAttribute.getJSONObject("forward").getJSONArray("solutionStep");
            JSONArray reverseSolutionStep = singleAttribute.getJSONObject("reverse").getJSONArray("solutionStep");
            String dimension = singleAttribute.getString("dimension");
            callableList.add(() -> this.doQuery(this.buildQueryDto(attributeInquirerDto, dimension, forwardSolutionStep, "forward", context)));
            callableList.add(() -> this.doQuery(this.buildQueryDto(attributeInquirerDto, dimension, reverseSolutionStep, "reverse", context)));
        });
        List futureList = ThreadPoolUtils.getExecutorService().invokeAll(callableList);
        ArrayList<AttributionDataBo> AttributionDataBos = new ArrayList<AttributionDataBo>();
        for (Future future : futureList) {
            if (future.get() == null) continue;
            AttributionDataBos.add((AttributionDataBo)future.get());
        }
        return AttributionDataBos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributionDataBo doQuery(QueryDto queryDto) {
        try {
            DWServiceContext.setContext((DWServiceContext)queryDto.getDwServiceContext());
            Object obj = this.solutionStepExecutionFacade.execute(new SolutionStepInput(queryDto.getTenantId(), queryDto.getEocMaps(), queryDto.getSysParam(), queryDto.getSolutionStep(), queryDto.getExtension()));
            AttributionDataBo attributionDataBo = new AttributionDataBo(queryDto.getDimension(), queryDto.getDirection(), obj);
            return attributionDataBo;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
        finally {
            DWServiceContext.getContext().remove();
        }
        return new AttributionDataBo();
    }

    private QueryDto buildQueryDto(AttributeInquirerDto attributeInquirerDto, String dimension, JSONArray solutionStep, String direction, DWServiceContext context) {
        QueryDto queryDto = new QueryDto();
        queryDto.setDimension(dimension);
        queryDto.setDirection(direction);
        queryDto.setSolutionStep(solutionStep);
        queryDto.setTenantId(attributeInquirerDto.getTenantId());
        queryDto.setEocMaps(attributeInquirerDto.getEocMaps());
        queryDto.setSysParam(attributeInquirerDto.getSysParam());
        queryDto.setExtension(attributeInquirerDto.getExtension());
        queryDto.setDwServiceContext(context);
        return queryDto;
    }
}

