/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import com.digiwin.smartdata.agiledataengine.core.config.XxlJobConfig;
import com.digiwin.smartdata.agiledataengine.dto.DataCenterDto;
import com.digiwin.smartdata.agiledataengine.enumtype.ErrorCodeEnum;
import com.digiwin.smartdata.agiledataengine.exception.BusinessException;
import com.digiwin.smartdata.agiledataengine.property.ModuleProperty;
import com.digiwin.smartdata.agiledataengine.service.client.IDataCenterClient;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonResolverUtils;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataCenterClient
implements IDataCenterClient {
    @Autowired
    private XxlJobConfig xxlJobConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCenterClient.class);

    @Override
    public JSONArray getDataCenterData(DataCenterDto dataCenterDto) {
        JSONArray list = new JSONArray();
        int pageNo = 1;
        long startTime = System.currentTimeMillis();
        LOGGER.info("\u79c1\u6709\u5316\u914d\u7f6e:" + this.xxlJobConfig.getDeployCloud());
        boolean isDetailQuery = this.isDetailQuery(dataCenterDto);
        try {
            while (true) {
                JSONObject dataNode;
                JSONObject data;
                dataCenterDto.setPageNo(pageNo);
                if (isDetailQuery) {
                    dataCenterDto.setPageSize(this.getDetailPageSize(dataCenterDto));
                }
                if ((data = "local".equals(this.xxlJobConfig.getDeployCloud()) ? this.doQuery(dataCenterDto) : this.doQueryViaProxy(dataCenterDto)) != null && !data.isEmpty() && (dataNode = data.getJSONObject("data")) != null) {
                    dataCenterDto.setSelectSql(dataNode.getString("selectSql"));
                    dataCenterDto.setTotalSql(dataNode.getString("totalSql"));
                    Integer total = Integer.parseInt(dataNode.getString("totalCount"));
                    if (!(total == 0 || isDetailQuery && dataCenterDto.isDownload() && total > ModuleProperty.METRICS_DATA_SIZE)) {
                        if (!isDetailQuery && total >= 150000) {
                            throw new BusinessException(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW);
                        }
                        list.addAll((Collection)dataNode.getJSONArray("list"));
                        if (!isDetailQuery && list.size() < total) {
                            ++pageNo;
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u67e5\u8be2\u5f02\u5e38\uff0c\u67e5\u8be2sql:%s,\u67e5\u8be2\u603b\u6570sql:%s", dataCenterDto.getSelectSql(), dataCenterDto.getTotalSql()));
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.error("agiledata_datacenter_\u7684\u5165\u53c2:{}", (Object)String.format("\u67e5\u8be2\u65b9\u6848:%s,", dataCenterDto.getQuerySchema()));
        LOGGER.error("agiledata_datacenter_\u7684\u51fa\u53c2:{}", (Object)String.format("\u67e5\u8be2\u8017\u65f6:%sms\uff0c\u67e5\u8be2\u7b14\u6570:%s,\u67e5\u8be2\u6570\u636esql:%s,\u67e5\u8be2\u603b\u6570sql:%s", timeTaken, list.size(), dataCenterDto.getSelectSql(), dataCenterDto.getTotalSql()));
        LogUtils.buildAgileLog((String)LogUtils.MODULE_ADE, (String)"executeSqlAction", (String)LogUtils.SUCCESS, (String)("modelId:" + dataCenterDto.getModelId() + "\uff0c\u67e5\u8be2sql:" + dataCenterDto.getSelectSql() + ",\u67e5\u8be2\u603b\u6570sql\uff1a" + dataCenterDto.getTotalSql()), (String)("\u67e5\u8be2\u6570\u636e\u7b14\u6570\uff1a" + list.size()), (String)"");
        return list;
    }

    private int getDetailPageSize(DataCenterDto dataCenterDto) {
        if (dataCenterDto.isDownload()) {
            return ModuleProperty.METRICS_DATA_SIZE;
        }
        return 1000;
    }

    private boolean isDetailQuery(DataCenterDto dataCenterDto) {
        return "2".equals(dataCenterDto.getQuerySchema().getString("dataType"));
    }

    private JSONObject doQuery(DataCenterDto dataCenterDto) {
        Map<String, String> headerMap = DataCenterClient.getHeaderMap(dataCenterDto);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderColumn", JSONObject.toJSONString((Object)dataCenterDto.getOrderColumn()));
        param.put("pageNum", dataCenterDto.getPageNo());
        param.put("pageSize", dataCenterDto.getPageSize());
        param.put("modelId", dataCenterDto.getModelId());
        param.put("modelCode", dataCenterDto.getModelCode());
        param.put("totalEnable", true);
        param.put("queryInfo", JSONObject.toJSONString((Object)dataCenterDto.getQuerySchema()));
        String jsonParam = JsonResolverUtils.toJsonString(param);
        LOGGER.info("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u8bf7\u6c42\u5934\uff1a" + JSONObject.toJSONString(headerMap));
        LOGGER.info("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u8bf7\u6c42\u4f53\uff1a" + jsonParam);
        String httpRespContent = HttpClientUtil.doPost((String)(ModuleProperty.DATA_CENTER_DOMAIN + "/search/external/model/query-model-data"), headerMap, (String)jsonParam);
        return JSONObject.parseObject((String)httpRespContent);
    }

    private static Map<String, String> getHeaderMap(DataCenterDto dataCenterDto) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Digi-Middleware-Tenant-Id", String.valueOf(DWServiceContext.getContext().getProfile().get("tenantSid")));
        headerMap.put("Digi-Middleware-Auth-User", dataCenterDto.getToken());
        headerMap.put("Digi-Middleware-Auth-App", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6ImRtcCIsImluc2lkZSI6ZmFsc2UsInNpZCI6NDgzOTczNDM2NDQ1MjQ4fQ.qwhKIOpZzHE1k8rWa77tdOTtUaRVFjuQYYxx4WncfgE");
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", dataCenterDto.getRouterKey());
        headerMap.put("Accept", "application/json;charset=UTF-8");
        return headerMap;
    }

    private JSONObject doQueryViaProxy(DataCenterDto dataCenterDto) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", dataCenterDto.getToken());
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", dataCenterDto.getRouterKey());
        headerMap.put("Accept", "application/json;charset=UTF-8");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderColumn", dataCenterDto.getOrderColumn());
        param.put("pageNum", dataCenterDto.getPageNo());
        param.put("pageSize", dataCenterDto.getPageSize());
        param.put("modelId", dataCenterDto.getModelId());
        param.put("modelCode", dataCenterDto.getModelCode());
        param.put("totalEnable", true);
        param.put("queryInfo", dataCenterDto.getQuerySchema());
        String jsonParam = JsonResolverUtils.toJsonString(param);
        LOGGER.info("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u8bf7\u6c42\u5934\uff1a" + JSONObject.toJSONString(headerMap));
        LOGGER.info("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u8bf7\u6c42\u4f53\uff1a" + jsonParam);
        LOGGER.info("\u8c03\u7528\u6570\u636e\u4e2d\u53f0tenant_id\uff1a" + DWServiceContext.getContext().getProfile().get("tenantSid"));
        String httpRespContent = HttpClientUtil.doPost((String)(DatasourceUrl.dcpUrl + "/api/ddl/data-platform/api/datasets"), headerMap, (String)jsonParam);
        return JSONObject.parseObject((String)httpRespContent);
    }
}

