/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.property.ModuleProperty;
import com.digiwin.smartdata.agiledataengine.service.client.IThemeMapClient;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.ServiceResponseUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThemeMapClient
implements IThemeMapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IThemeMapClient.class);

    @Override
    public JSONObject getExecutionRules(String tenantId, List<String> actionIds, String token) {
        return null;
    }

    @Override
    public JSONObject querySmartDataVariable(String tenantId, List<String> variableIds, String token) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String routerKey = String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        headerMap.put("routerKey", StringUtils.isEmpty((CharSequence)routerKey) || "null".equalsIgnoreCase(routerKey) ? tenantId : routerKey);
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("variableIds", variableIds);
        reqMap.put("tenantId", tenantId);
        LOGGER.info(String.format("trans_%s_\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\u7684\u5165\u53c2:%s header:%s ", "querySmartDataVariable", JSON.toJSONString(reqMap), JSON.toJSONString(headerMap)));
        String httpContent = HttpClientUtil.doPost((String)ModuleProperty.THEMEMAP_ACTION_QUERYSMARTDATAVARIABLE, headerMap, (String)JSON.toJSONString(reqMap));
        LOGGER.info(String.format("trans_%s_\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\u7684\u51fa\u53c2:%s header:%s ", "querySmartDataVariable", httpContent, JSON.toJSONString(headerMap)));
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject queryMetricQuerySchema(Set<String> metricIds) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        String token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        headerMap.put("token", token);
        headerMap.put("locale", locale);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Set<String>> reqMap = new HashMap<String, Set<String>>(4);
        reqMap.put("indicatorIds", metricIds);
        LOGGER.info("\u8c03\u7528themeMap\u83b7\u53d6\u884c\u52a8\u903b\u8f91\u7684\u5165\u53c2:{}", (Object)JSON.toJSONString(reqMap));
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("trans_%s_\u8c03\u7528KM\u5165\u53c2:%s", "executionengine", JSON.toJSONString(reqMap)));
        }
        String httpContent = null;
        try {
            httpContent = HttpClientUtil.doPost((String)ModuleProperty.THEMEMAP_ACTION_METRICQUERYSCHEMA, headerMap, (String)JSON.toJSONString(reqMap));
        }
        catch (Exception e) {
            LOGGER.error("post queryMetricQuerySchema error", (Throwable)e);
        }
        LOGGER.info("ThemeMap\u8fd4\u56de\u6307\u6807\u4e0b\u7684querySchema\u7684\u5185\u5bb9:{}", (Object)httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject getUIMetaData(String actionId, String token, String tenantId, String locale) {
        HashMap<String, String> headerMap = new HashMap<String, String>(2);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("locale", locale);
        headerMap.put("routerKey", String.valueOf(DWServiceContext.getContext().getRequestHeader().get("routerKey")));
        headerMap.put("security-token", (String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        HashMap<String, Object> reqMap = new HashMap<String, Object>(4);
        reqMap.put("actionId", actionId);
        reqMap.put("tenantId", tenantId);
        reqMap.put("existingActionParams", Collections.EMPTY_LIST);
        reqMap.put("existingSysParams", Collections.EMPTY_LIST);
        LOGGER.info("\u8c03\u7528themeMap\u83b7\u53d6\u7528\u4e8e\u5c55\u793a\u754c\u9762\u7684\u5143\u6570\u636e:{}", (Object)JSON.toJSONString(reqMap));
        String httpContent = HttpClientUtil.doPost((String)ModuleProperty.THEMEMAP_ACTION_QUERYEXECUTIONPATH, headerMap, (String)JSON.toJSONString(reqMap));
        LOGGER.info("ThemeMap\u8fd4\u56de\u5143\u6570\u636e:{}", (Object)httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }
}

