/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.service.convert.trans.ICriteriaTransformer;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class FilterTransformer
implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", (Object)"filter");
        variable.put("condition", (Object)FilterTransformer.transformJson(schema));
        return variable;
    }

    public static JSONObject transformJson(JSONObject originalObject) {
        JSONObject transformedObject = new JSONObject();
        transformedObject.put("logitype", (Object)originalObject.getString("logic"));
        JSONArray items = new JSONArray();
        transformedObject.put("items", (Object)items);
        FilterTransformer.transformChildren(originalObject.getJSONArray("children"), items);
        return transformedObject;
    }

    public static void transformChildren(JSONArray children, JSONArray items) {
        for (int i = 0; i < children.size(); ++i) {
            JSONObject child = children.getJSONObject(i);
            JSONObject item = new JSONObject();
            item.put("logitype", (Object)child.getString("logic"));
            if (CollectionUtils.isNotEmpty((Collection)child.getJSONArray("children"))) {
                JSONArray subItems = new JSONArray();
                item.put("items", (Object)subItems);
                FilterTransformer.transformChildren(child.getJSONArray("children"), subItems);
            } else {
                String operate = child.getString("operator");
                item.put("op", (Object)operate);
                item.put("left", (Object)child.getJSONObject("left").getString("content"));
                String contentType = child.getJSONArray("right").getJSONObject(0).getJSONObject("dataObject").getString("contentType");
                item.put("right_value_type", FilterTransformer.getRightValueType(operate, child.getJSONArray("right")));
                item.put("right", FilterTransformer.getRightValue(operate, child.getJSONArray("right")));
                item.put("logitype", (Object)"single");
                if ("field".equals(contentType)) {
                    item.put("type", (Object)"column");
                } else if ("const".equals(contentType)) {
                    item.put("type", (Object)"constant");
                } else {
                    item.put("type", (Object)"constant");
                }
                item.put("left_value_type", (Object)child.getJSONObject("left").getString("contentType"));
            }
            items.add((Object)item);
        }
    }

    private static Object getRightValueType(String operate, JSONArray right) {
        if ("in".equals(operate) || "nin".equals(operate)) {
            return "collection";
        }
        return right.getJSONObject(0).getJSONObject("dataObject").getString("dataType");
    }

    private static Object getRightValue(String operate, JSONArray right) {
        if ("in".equals(operate) || "nin".equals(operate)) {
            JSONArray rightValue = new JSONArray();
            right.forEach(o -> rightValue.add((Object)((JSONObject)o).getJSONObject("dataObject").getString("content")));
            return rightValue;
        }
        return right.getJSONObject(0).getJSONObject("dataObject").getString("content");
    }
}

