/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.dto.DataCenterDto;
import com.digiwin.smartdata.agiledataengine.dto.DebugDto;
import com.digiwin.smartdata.agiledataengine.pojo.bo.DataCenterParamBo;
import com.digiwin.smartdata.agiledataengine.pojo.trans.DataDescription;
import com.digiwin.smartdata.agiledataengine.pojo.trans.SolutionStepMetric;
import com.digiwin.smartdata.agiledataengine.pojo.vo.MetricResultVo;
import com.digiwin.smartdata.agiledataengine.service.client.IDataCenterClient;
import com.digiwin.smartdata.agiledataengine.service.data.IScraper;
import com.digiwin.smartdata.agiledataengine.service.schema.ISchemaBuilder;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dataset")
public class DatasetScraper
implements IScraper {
    @Autowired
    private ISchemaBuilder schemaBuilder;
    @Autowired
    private IDataCenterClient dataCenterClient;

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty((Collection)metric.getGroupBy()) ? null : JSONArray.parseArray((String)JSONArray.toJSONString((Object)metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty((Collection)metric.getFilter().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty((Collection)metric.getHaving().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty((Collection)metric.getSort()) ? null : JSONArray.parseArray((String)JSONObject.toJSONString((Object)metric.getSort())));
        dynamicSchema.put("select", (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)metric.getSelect())));
        dynamicSchema.put("fieldMapping", (Object)context.getDatasetFieldsMapping().get(metric.getMetric()));
        dynamicSchema.put("distinct", (Object)metric.getDistinct());
        dataDescription.setDynamicSchema(dynamicSchema);
        dataDescription.setDatasetPermissions(this.getRow(context.getPermissions()));
        DataCenterParamBo dataCenterParamBo = this.schemaBuilder.buildDataCenterSchema(dataDescription);
        JSONArray dataCenterData = this.dataCenterClient.getDataCenterData(this.buildDataCenterParam(metric, context, dataCenterParamBo));
        JSONObject data = new JSONObject();
        data.put("data", (Object)dataCenterData);
        return new MetricResultVo((Object)data, new DebugDto());
    }

    private JSONArray getRow(Map<String, Object> permissions) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(permissions));
        if (jsonObject.containsKey((Object)"rows") && !CollectionUtils.isEmpty((Collection)jsonObject.getJSONArray("rows"))) {
            return jsonObject.getJSONArray("rows");
        }
        return null;
    }

    private DataCenterDto buildDataCenterParam(SolutionStepMetric metric, SolutionStepContext context, DataCenterParamBo dataCenterParamBo) {
        DataCenterDto dataCenterDto = new DataCenterDto();
        dataCenterDto.setTenantId(context.getTenantId());
        dataCenterDto.setPageSize(10000);
        dataCenterDto.setPageNo(1);
        dataCenterDto.setQuerySchema(dataCenterParamBo.getQuerySchema());
        dataCenterDto.setOrderColumn(CollectionUtils.isEmpty((Collection)dataCenterParamBo.getOrderColumn()) ? null : dataCenterParamBo.getOrderColumn());
        dataCenterDto.setModelId(metric.getModelId());
        dataCenterDto.setModelCode(metric.getModelCode());
        dataCenterDto.setToken(context.getToken());
        dataCenterDto.setRouterKey(context.getTenantId());
        dataCenterDto.setDownload(context.isDownload());
        return dataCenterDto;
    }
}

