/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.data.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.constant.StaticConstant;
import com.digiwin.smartdata.agiledataengine.core.container.SolutionStepContext;
import com.digiwin.smartdata.agiledataengine.dto.DebugDto;
import com.digiwin.smartdata.agiledataengine.model.input.ExecutionInputParamModule;
import com.digiwin.smartdata.agiledataengine.model.input.ExecutionInputParamModuleBuilder;
import com.digiwin.smartdata.agiledataengine.pojo.trans.DataDescription;
import com.digiwin.smartdata.agiledataengine.pojo.trans.SolutionStepMetric;
import com.digiwin.smartdata.agiledataengine.pojo.vo.MetricResultVo;
import com.digiwin.smartdata.agiledataengine.property.ModuleProperty;
import com.digiwin.smartdata.agiledataengine.service.data.IScraper;
import com.digiwin.smartdata.agiledataengine.service.execution.IExecutionFacade;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="metric")
public class MetricScraper
implements IScraper {
    @Autowired
    private IExecutionFacade executionFacade;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricScraper.class);

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", (Object)(CollectionUtils.isEmpty((Collection)metric.getGroupBy()) ? new JSONArray() : JSONArray.parseArray((String)JSONArray.toJSONString((Object)metric.getGroupBy()))));
        dynamicSchema.put("filter", (Object)(metric.getFilter() == null || CollectionUtils.isEmpty((Collection)metric.getFilter().getChildren()) ? new JSONObject() : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getFilter()))));
        dynamicSchema.put("having", (Object)(metric.getHaving() == null || CollectionUtils.isEmpty((Collection)metric.getHaving().getChildren()) ? new JSONObject() : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getHaving()))));
        dynamicSchema.put("computeList", (Object)(metric.getComputeList() == null || metric.getComputeList().isEmpty() ? new JSONObject() : metric.getComputeList()));
        dynamicSchema.put("sort", (Object)(CollectionUtils.isEmpty((Collection)metric.getSort()) ? new JSONArray() : JSONArray.parseArray((String)JSONObject.toJSONString((Object)metric.getSort()))));
        dataDescription.setDynamicSchema(dynamicSchema);
        dataDescription.setProductLineRows(context.getPermissions() == null || context.getPermissions().isEmpty() ? new JSONArray() : JSONArray.parseArray((String)JSONObject.toJSONString((Object)context.getPermissions().get("rows"))));
        dataDescription.setProductLineInfo(context.getProductLineInfo());
        ExecutionInputParamModuleBuilder inputParamModuleBuilder = new ExecutionInputParamModuleBuilder().setActionId(metric.getMetric()).setEocMaps(context.getEocMaps()).setSysParam(context.getParam()).setParam(new HashMap()).setTenantId(context.getTenantId()).setDataDescription(dataDescription).setRoles(context.getRoles());
        ExecutionInputParamModule inputParam = new ExecutionInputParamModule(inputParamModuleBuilder);
        LOGGER.info(String.format("trans_%s_\u53d6\u6307\u6807\u6570\u636e\u5165\u53c2:%s", "SolutionStepMetricAnalyzer.getMetricData", inputParam));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("token", context.getToken());
        header.put("routerKey", context.getTenantId());
        header.put("digi-middleware-auth-app", ModuleProperty.APP_TOKEN_VALUE);
        String resultData = HttpClientUtil.doPost((String)(StaticConstant.ATHENA_ADN_URL + "/restful/service/ExecutionEngine/execute/queryMetric"), header, (String)JSON.toJSONString((Object)inputParam));
        if (StringUtil.isEmpty((String)resultData)) {
            LOGGER.error("\u8c03\u7528EE\u83b7\u53d6\u6307\u6807\u6570\u636e:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)JSON.toJSONString((Object)inputParam));
            return new MetricResultVo((Object)new JSONObject(), new DebugDto());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)resultData);
        if (!jsonObject.containsKey((Object)"response")) {
            return new MetricResultVo((Object)new JSONObject(), new DebugDto());
        }
        JSONObject response = jsonObject.getJSONObject("response");
        if (CollectionUtils.isEmpty((Map)response)) {
            return new MetricResultVo((Object)new JSONObject(), new DebugDto());
        }
        return (MetricResultVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response), MetricResultVo.class);
    }
}

