/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.execution.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataMappingHandler;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.DataMappingManager;
import com.digiwin.smartdata.agiledataengine.component.mapping.data.MetaGenerator;
import com.digiwin.smartdata.agiledataengine.constant.StaticConstant;
import com.digiwin.smartdata.agiledataengine.model.input.ExecutionInputParamModule;
import com.digiwin.smartdata.agiledataengine.property.ModuleProperty;
import com.digiwin.smartdata.agiledataengine.service.client.IThemeMapClient;
import com.digiwin.smartdata.agiledataengine.service.execution.IExecutionFacade;
import com.digiwin.smartdata.agiledataengine.service.reporter.IReporter;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ExecutionFacade
implements IExecutionFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionFacade.class);
    public static final String METRIC_ACTION_PREFIX = "METRIC_";
    private IThemeMapClient themeMapClient;
    private IReporter reporter;

    public ExecutionFacade(IThemeMapClient themeMapClient, @Qualifier(value="errorLogReporter") IReporter reporter) {
        this.themeMapClient = themeMapClient;
        this.reporter = reporter;
    }

    @Override
    public Object execute(ExecutionInputParamModule inputParam) {
        DWServiceContext context = DWServiceContext.getContext();
        LOGGER.info(String.format("trans_%s_\u8001\u573a\u666f\u53d6\u6570\u63a5\u6536\u7684\u53c2\u6570:%s \nToken:%s", "ExecutionFacade.execute", JSON.toJSONString((Object)inputParam), context.getToken()));
        long startTime = System.currentTimeMillis();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("token", context.getToken());
        header.put("routerKey", inputParam.getTenantId());
        header.put("digi-middleware-auth-app", ModuleProperty.APP_TOKEN_VALUE);
        String resultData = HttpClientUtil.doPost((String)(StaticConstant.ATHENA_ADN_URL + "/restful/service/ExecutionEngine/execute"), header, (String)JSON.toJSONString((Object)inputParam));
        long timeTaken = System.currentTimeMillis() - startTime;
        if (resultData == null) {
            LOGGER.info(String.format("trans_%s_\u8c03\u7528\u6267\u884c\u5f15\u64ce\u8001\u573a\u666f\u51fa\u53c2:*\u672a\u67e5\u8be2\u5230\u6570\u636e* \nToken:%s", "ExecutionFacade.execute", context.getToken()));
            LogUtils.buildAgileLog((String)LogUtils.MODULE_ADE, (String)"getSceneData", (String)LogUtils.WARING, (String)JSONObject.toJSONString((Object)inputParam), (String)"", (String)"\u68c0\u67e5\u4e0b\u5165\u53c2\u4e0e\u6267\u884c\u5f15\u64ce\u65e5\u5fd7\uff0c\u68c0\u67e5\u662f\u5426\u53d6\u6570\u8fc7\u7a0b\u4e2d\u5b58\u5728\u95ee\u9898");
            return new JSONObject();
        }
        LOGGER.info("Trans\u8001\u573a\u666f\u8c03\u7528\u6267\u884c\u5f15\u64ce action:{} \u603b\u8017\u65f6 :{}ms", (Object)inputParam.getActionId(), (Object)timeTaken);
        LogUtils.buildAgileLog((String)LogUtils.MODULE_ADE, (String)"getSceneData", (String)LogUtils.SUCCESS, (String)JSONObject.toJSONString((Object)inputParam), (String)"\u573a\u666f\u53d6\u6570\u6210\u529f\uff0c\u5177\u4f53\u6570\u636e\u4e0d\u5c55\u793a", (String)"");
        return resultData;
    }

    @Override
    public Object generateMetaHandler(DataMappingManager dataMappingMgr, String actionId, String tenantId) {
        DataMappingHandler dataMappingHandler = dataMappingMgr.getDatMappingHandler("META", "ExecutionParam");
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (dataMappingHandler == null) {
            LOGGER.error("\u6784\u5efa\u6570\u636e\u7684dataMap\u7ed3\u6784\u5931\u8d25");
        }
        MetaGenerator metaGenerator = new MetaGenerator(dataMappingHandler, actionId);
        JSONObject newMeta = metaGenerator.generate();
        if (StringUtils.isBlank((CharSequence)actionId)) {
            return newMeta;
        }
        JSONObject uiMeta = this.themeMapClient.getUIMetaData(actionId, DWServiceContext.getContext().getToken(), tenantId, locale);
        newMeta = metaGenerator.merge(newMeta, uiMeta);
        return newMeta;
    }
}

