/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.smartdata.sdk.DatasourceProxyInitialize;
import com.digiwin.smartdata.agiledataengine.dto.ExportDataDto;
import com.digiwin.smartdata.agiledataengine.exception.BusinessException;
import com.digiwin.smartdata.agiledataengine.model.BasePage;
import com.digiwin.smartdata.agiledataengine.model.input.ExportInput;
import com.digiwin.smartdata.agiledataengine.pojo.trans.DataDescription;
import com.digiwin.smartdata.agiledataengine.pojo.trans.Metric;
import com.digiwin.smartdata.agiledataengine.property.ModuleProperty;
import com.digiwin.smartdata.agiledataengine.service.client.IThemeMapClient;
import com.digiwin.smartdata.agiledataengine.service.export.IExportFacade;
import com.digiwin.smartdata.agiledataengine.service.schema.ISchemaBuilder;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportFacade
implements IExportFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportFacade.class);
    @Autowired
    private IThemeMapClient themeMapClient;
    @Autowired
    private ISchemaBuilder schemaBuilder;

    @Override
    public List<ExportDataDto> exportData(ExportInput exportInput) {
        String token = DWServiceContext.getContext().getToken();
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        List metrics = exportInput.getMetrics();
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            return Lists.newArrayList();
        }
        Set<String> metricIds = metrics.parallelStream().map(Metric::getMetricId).collect(Collectors.toSet());
        if (metricIds.size() > ModuleProperty.METRICS_NUM) {
            LOGGER.warn("\u5bfc\u51fa\u6307\u6807\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e5\u4e2a");
            return Lists.newArrayList();
        }
        JSONObject jsonObject = this.themeMapClient.queryMetricQuerySchema(metricIds);
        if (!this.checkQuery(metrics, jsonObject, exportInput, token, locale)) {
            LOGGER.warn("\u5b58\u5728\u660e\u7ec6\u8d85\u8fc75000\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u5bfc\u51fa");
            return Lists.newArrayList();
        }
        HashMap dataMap = new HashMap();
        ArrayList exportDataDos = Lists.newArrayList();
        metrics.forEach(item -> {
            JSONArray metricQuerySchema = jsonObject.getJSONArray(item.getMetricId());
            JSONObject metricCondition = item.getMetricCondition();
            metricQuerySchema.parallelStream().forEach(metricDefine -> {
                JSONObject metricDefineObj = (JSONObject)metricDefine;
                String actionId = metricDefineObj.getString("actionId");
                String actionName = ((JSONObject)metricDefine).getString("actionName");
                String schema = metricDefineObj.getString("querySchema");
                String productLine = metricDefineObj.getString("productLine");
                JSONArray responseFields = new JSONArray();
                if (metricDefineObj.getJSONObject("response") != null) {
                    responseFields = metricDefineObj.getJSONObject("response").getJSONArray("field");
                }
                Map<String, Object> retMap = this.doQuery(schema, metricCondition, exportInput, token, locale, productLine);
                dataMap.computeIfAbsent(actionId, k -> Lists.newArrayList());
                List resultList = (List)dataMap.get(actionId);
                resultList.addAll((Collection)retMap.get("list"));
                List<Object> metadata = (List<Object>)retMap.get("metadata");
                metadata = this.buildMetadata(responseFields, metadata, locale);
                boolean exists = exportDataDos.stream().anyMatch(dto -> dto.getActionId().equals(actionId));
                if (!exists) {
                    exportDataDos.add(new ExportDataDto(actionId, actionName, metadata));
                }
            });
        });
        exportDataDos.forEach(dto -> dto.setData((List)dataMap.get(dto.getActionId())));
        return exportDataDos;
    }

    private List<Object> buildMetadata(JSONArray responseFields, List<Object> metadata, String locale) {
        ArrayList tempMetadata = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(metadata)) {
            block0: for (Object fieldObject : responseFields) {
                Map field = (Map)fieldObject;
                for (Object o : metadata) {
                    Map data = (Map)o;
                    if (!data.get("columnName").equals(field.get("data_name"))) continue;
                    tempMetadata.add(o);
                    continue block0;
                }
            }
        }
        return tempMetadata;
    }

    private boolean checkQuery(List<Metric> metrics, JSONObject jsonObject, ExportInput exportInput, String token, String locale) {
        Integer[] totalCnt = new Integer[]{0};
        metrics = Collections.synchronizedList(metrics);
        metrics.forEach(metric -> {
            JSONArray metricQuerySchema = jsonObject.getJSONArray(metric.getMetricId());
            metricQuerySchema.parallelStream().forEach(obj -> {
                JSONObject metricDefineObj = (JSONObject)obj;
                String schema = metricDefineObj.getString("querySchema");
                String productLine = metricDefineObj.getString("productLine");
                int count = this.doCount(schema, metric.getMetricCondition(), exportInput, token, locale, productLine);
                totalCnt[0] = totalCnt[0] + count;
            });
        });
        return totalCnt[0] <= ModuleProperty.METRICS_DATA_SIZE;
    }

    private int doCount(String schema, JSONObject metricCondition, ExportInput exportInput, String token, String locale, String productLine) {
        DataDescription dataDescription = new DataDescription();
        dataDescription.getDynamicSchema().putAll((Map)metricCondition);
        JSONObject permissions = exportInput.getPermissions();
        JSONArray roles = null;
        JSONArray rows = null;
        if (MapUtils.isNotEmpty((Map)permissions)) {
            roles = permissions.getJSONArray("roles");
            rows = permissions.getJSONArray("rows");
        }
        if (rows != null && !rows.isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                JSONObject rowJson = rows.getJSONObject(i);
                if (!productLine.equals(rowJson.getString("productLine"))) continue;
                dataDescription.setPermissions(rowJson.getJSONObject("row"));
                break;
            }
        }
        Map<String, Object> querySchema = this.schemaBuilder.buildExportQuerySchema(schema, new HashMap<String, Object>(), dataDescription);
        querySchema.put("productLine", productLine);
        String datasource = exportInput.getDatasource();
        String userId = exportInput.getUserId();
        Map bmd = DatasourceProxyInitialize.countData((String)datasource, querySchema, (String)exportInput.getTenantId(), (String)locale, (String)token, (String)userId, (String)exportInput.getTenantId(), (List)exportInput.getEocMaps(), (List)roles, (String)"");
        Map detail = (Map)bmd.get("data");
        if (detail == null || detail.isEmpty() || !detail.containsKey("total")) {
            return 0;
        }
        return (Integer)detail.get("total");
    }

    private Map<String, Object> doQuery(String schema, JSONObject metricCondition, ExportInput exportInput, String token, String locale, String productLine) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DataDescription dataDescription = new DataDescription();
        dataDescription.getDynamicSchema().putAll((Map)metricCondition);
        JSONObject permissions = exportInput.getPermissions();
        JSONArray roles = null;
        JSONArray rows = null;
        if (MapUtils.isNotEmpty((Map)permissions)) {
            roles = permissions.getJSONArray("roles");
            rows = permissions.getJSONArray("rows");
        }
        if (CollectionUtils.isNotEmpty(rows)) {
            for (int i = 0; i < rows.size(); ++i) {
                JSONObject rowJson = rows.getJSONObject(i);
                if (!productLine.equals(rowJson.getString("productLine"))) continue;
                dataDescription.setPermissions(rowJson.getJSONObject("row"));
                break;
            }
        }
        Map<String, Object> querySchema = this.schemaBuilder.buildExportQuerySchema(schema, new HashMap<String, Object>(), dataDescription);
        querySchema.put("productLine", productLine);
        try {
            BasePage basePage = this.createBasePage(querySchema);
            querySchema.put("page", basePage);
            ArrayList list = new ArrayList();
            String datasource = exportInput.getDatasource();
            String userId = exportInput.getUserId();
            long startTime = System.currentTimeMillis();
            List meta = null;
            while (true) {
                Integer total;
                Map detail;
                Map bmd = DatasourceProxyInitialize.getData((String)datasource, querySchema, (String)exportInput.getTenantId(), (String)locale, (String)token, (String)userId, (String)exportInput.getTenantId(), (List)exportInput.getEocMaps(), (List)roles, (String)"");
                LOGGER.error("bmd\u7684sql\u4e3a:{}", (Object)JsonUtil.getJsonString(((Map)bmd.get("data")).get("querySql")));
                if (bmd == null || bmd.isEmpty() || (detail = (Map)bmd.get("data")) == null || detail.isEmpty() || !detail.containsKey("total") || !detail.containsKey("data") || (total = Integer.valueOf("dcp".equals(datasource) ? Integer.parseInt((String)detail.get("total")) : (Integer)detail.get("total"))) == 0) break;
                if (total >= 150000) {
                    throw new BusinessException("\u5355\u4e2a\u67e5\u8be2\u65b9\u6848\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236");
                }
                meta = (List)detail.get("meta");
                list.addAll((List)detail.get("data"));
                if (list.size() >= total) break;
                basePage.setPageNo(Integer.valueOf(basePage.getPageNo() + 1));
                querySchema.put("page", basePage);
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            LOGGER.info(String.format("\u67e5\u8be2\u8017\u65f6:%sms\uff0c\u67e5\u8be2\u7b14\u6570:%s,\u67e5\u8be2\u65b9\u6848:%s", timeTaken, list.size(), JSONObject.toJSONString(querySchema)));
            result.put("list", list);
            result.put("metadata", meta);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528BMD\u83b7\u53d6\u6570\u636e\u5f02\u5e38,\u67e5\u8be2\u65b9\u6848:{}", (Object)JSONObject.toJSONString(querySchema), (Object)e);
            throw e;
        }
    }

    private BasePage createBasePage(Map<String, Object> querySchema) {
        BasePage pageObj = Optional.ofNullable(querySchema).map(map -> map.get("page")).map(page -> (BasePage)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)page), BasePage.class)).orElse(BasePage.createDefaultPage());
        return pageObj;
    }
}

