/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.facade.impl;

import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.smartdata.agiledataengine.client.ExecutorAdminClient;
import com.digiwin.smartdata.agiledataengine.client.IDwScheduleClient;
import com.digiwin.smartdata.agiledataengine.core.config.XxlJobConfig;
import com.digiwin.smartdata.agiledataengine.core.dict.TypeDict;
import com.digiwin.smartdata.agiledataengine.core.message.ErrorCode;
import com.digiwin.smartdata.agiledataengine.core.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.core.util.StringUtil;
import com.digiwin.smartdata.agiledataengine.dto.ScheduleCompareDto;
import com.digiwin.smartdata.agiledataengine.pojo.request.BatchScheduleReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.CrossReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ExeTriggerReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleDetailModel;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleUpdateReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.TriggerReq;
import com.digiwin.smartdata.agiledataengine.pojo.request.xxl.XxlJobInfo;
import com.digiwin.smartdata.agiledataengine.producer.MessageProducer;
import com.digiwin.smartdata.agiledataengine.scheduler.ExecutorBlockStrategyEnum;
import com.digiwin.smartdata.agiledataengine.scheduler.ExecutorRouteStrategyEnum;
import com.digiwin.smartdata.agiledataengine.scheduler.MisfireStrategyEnum;
import com.digiwin.smartdata.agiledataengine.scheduler.ScheduleTypeEnum;
import com.digiwin.smartdata.agiledataengine.service.facade.IScheduleFacadeService;
import com.digiwin.smartdata.agiledataengine.service.srp.db.IScheduleDefineService;
import com.digiwin.smartdata.agiledataengine.service.srp.db.IScheduleLogService;
import com.digiwin.smartdata.agiledataengine.trans.CronModel;
import com.digiwin.smartdata.agiledataengine.trans.CronUtil;
import com.digiwin.smartdata.agiledataengine.trans.JobEnum;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.glue.GlueTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleFacadeService
implements IScheduleFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleFacadeService.class);
    private IScheduleLogService logService;
    private IScheduleDefineService defineService;
    @Autowired
    private XxlJobConfig xxlJobConfig;
    @Autowired
    private MessageProducer rabbitMQProducer;
    @Autowired
    private ExecutorAdminClient executorAdminClient;
    @Autowired
    private IDwScheduleClient dapClient;

    public ScheduleFacadeService(IScheduleLogService logService, IScheduleDefineService defineService) {
        this.logService = logService;
        this.defineService = defineService;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public void createSchedule(BatchScheduleReq rule) {
        rule.getRuleList().forEach(request -> this.createQuartzSchedule(rule.getTenantId(), request.getRuleId(), request.getActionId(), StringUtil.isEmpty(request.getEnableStatus()) ? "Y" : request.getEnableStatus(), request.getTriggers(), request.getCaller(), request.getScheduleParam(), request.getAppCode()));
    }

    private void createQuartzSchedule(String tenantId, String ruleId, String actionId, String enableStatus, List<TriggerReq> triggerList, String caller, JSONObject param, String appCode) {
        ArrayList scheduleParamList = new ArrayList();
        triggerList.forEach(trigger -> {
            String instanceId = UUID.randomUUID().toString();
            Map<String, Object> scheduleParam = this.initScheduleParam(instanceId, tenantId, ruleId, enableStatus, caller, param, actionId, appCode);
            Map<String, Object> scheduleDetail = this.getScheduleDetail((TriggerReq)trigger);
            if ("local".equals(this.xxlJobConfig.getDeployCloud())) {
                scheduleParam.putAll(scheduleDetail);
                scheduleParamList.add(scheduleParam);
                this.saveScheduleDefine(tenantId, ruleId, actionId, instanceId, JsonUtil.getJsonString((Object)trigger), StringUtil.isEmpty(caller) ? "MonitorEngine" : caller, 1, null, null);
                String result = this.dapClient.addQuartz(scheduleParamList, "addSchedules");
                JSONObject resultObj = JsonUtil.getObject((String)result);
                boolean isSuccess = 200 == resultObj.getIntValue("status");
                scheduleParamList.forEach(scheduleParam1 -> this.logService.saveScheduleLog(String.valueOf(scheduleParam1.get("schedule_id")), 1, "MonitorEngine", isSuccess ? 1 : 0));
                if (!isSuccess) {
                    LOGGER.error("\u8c03\u7528api\u521b\u5efa\u6392\u7a0b\u5931\u8d25\uff01{}", (Object)result);
                    throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_CREATE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_CREATE_CODE.getMessage());
                }
            } else {
                scheduleParamList.add(scheduleParam);
                XxlJobInfo job = this.buildXXLJobPO(tenantId, instanceId, (TriggerReq)trigger, null);
                ReturnT<String> addJob = this.executorAdminClient.add(job);
                if (Objects.nonNull(addJob) && 200 == addJob.getCode()) {
                    this.saveScheduleDefine(tenantId, ruleId, actionId, instanceId, JsonUtil.getJsonString((Object)trigger), StringUtil.isEmpty(caller) ? "MonitorEngine" : caller, 1, (String)addJob.getContent(), JSON.toJSONString(scheduleParam));
                }
                scheduleParamList.forEach(scheduleParam1 -> this.logService.saveScheduleLog(String.valueOf(scheduleParam1.get("schedule_id")), 1, "MonitorEngine", 1));
            }
        });
    }

    private Map<String, Object> initScheduleParam(String scheduleId, String tenantId, String ruleId, String enableStatus, String caller, JSONObject param, String actionId, String appCode) {
        HashMap<String, Object> scheduleParam = new HashMap<String, Object>(4);
        scheduleParam.put("tenantId", tenantId);
        scheduleParam.put("ruleId", ruleId);
        scheduleParam.put("instance_id", scheduleId);
        scheduleParam.put("caller", caller);
        scheduleParam.put("appCode", appCode);
        scheduleParam.put("scheduleParam", param);
        if ("local".equals(this.xxlJobConfig.getDeployCloud())) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("schedule_param", scheduleParam);
            paramMap.put("actionId", actionId);
            paramMap.put("schedule_id", scheduleId);
            paramMap.put("job_name", "IExecuteService");
            paramMap.put("enable_status", enableStatus);
            paramMap.put("module_name", "AgileDataEngine");
            return paramMap;
        }
        return scheduleParam;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public void updateSchedule(ScheduleUpdateReq rule, String enableStatus) {
        List<ScheduleDetailModel> updateList = this.defineService.getScheduleInfoByRuleId(rule.getRuleId(), !"local".equals(this.xxlJobConfig.getDeployCloud()));
        this.updateTriggers(rule, enableStatus, updateList);
    }

    private void updateTriggers(ScheduleUpdateReq rule, String enableStatus, List<ScheduleDetailModel> sourceSchedule) {
        ScheduleCompareDto scheduleCompareDto = this.handleScheduleDifference(rule, sourceSchedule);
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getSourceScheduleMap())) {
            this.executeSchedule(scheduleCompareDto.getSourceScheduleMap().values(), 4);
        }
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getAddSchedules())) {
            if (StringUtil.isBlank(enableStatus)) {
                enableStatus = "Y";
            }
            this.createQuartzSchedule(rule.getTenantId(), rule.getRuleId(), rule.getActionId(), enableStatus, scheduleCompareDto.getAddSchedules(), rule.getCaller(), rule.getScheduleParam(), rule.getAppCode());
        }
        if (CollectionUtil.isNotEmpty(scheduleCompareDto.getExistsSchedules())) {
            int callType = "N".equals(enableStatus) ? 3 : 5;
            this.executeSchedule(scheduleCompareDto.getExistsSchedules(), callType);
        }
    }

    private ScheduleCompareDto handleScheduleDifference(ScheduleUpdateReq requestDetail, List<ScheduleDetailModel> sourceSchedule) {
        HashMap sourceScheduleMap = new HashMap(4);
        sourceSchedule.forEach(schedule -> sourceScheduleMap.put(JsonUtil.getObject((String)schedule.getTriggers()), schedule));
        ArrayList addSchedules = new ArrayList();
        ArrayList existsSchedules = new ArrayList();
        requestDetail.getTriggers().forEach(trigger -> {
            JSONObject key = JsonUtil.getObject((String)JsonUtil.getJsonString((Object)trigger));
            ScheduleDetailModel existsScheduleDetail = (ScheduleDetailModel)sourceScheduleMap.remove(key);
            if (null != existsScheduleDetail) {
                existsSchedules.add(existsScheduleDetail);
            } else {
                addSchedules.add(trigger);
            }
        });
        LOGGER.info("ScheduleFacadeService#handleScheduleDifference sourceScheduleMap  :{},addSchedules  :{}, existsSchedules  :{} ", new Object[]{sourceScheduleMap.size(), addSchedules.size(), existsSchedules.size()});
        ScheduleCompareDto scheduleCompareDto = new ScheduleCompareDto();
        scheduleCompareDto.setSourceScheduleMap(sourceScheduleMap);
        scheduleCompareDto.setAddSchedules(addSchedules);
        scheduleCompareDto.setExistsSchedules(existsSchedules);
        return scheduleCompareDto;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public void deleteSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 4);
    }

    @Override
    public void stopSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 3);
    }

    @Override
    public void startSchedule(ScheduleReq rule) {
        this.handleSchedule(rule, 5);
    }

    @Override
    public void deleteScheduleCross(CrossReq cross) {
        this.dapClient.deleteQuartzCross(cross);
    }

    @Override
    public JSONObject getSchedule(ScheduleReq rule) {
        List<ScheduleDetailModel> list = this.defineService.getScheduleInfoByRuleId(rule.getRuleId(), !"local".equals(this.xxlJobConfig.getDeployCloud()));
        if (CollectionUtil.isEmpty(list)) {
            return new JSONObject();
        }
        return this.getDapScheduleList(list);
    }

    private JSONObject getDapScheduleList(List<ScheduleDetailModel> list) {
        JSONObject result = new JSONObject();
        List<String> scheduleIdList = list.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        String response = this.dapClient.getQuartz(scheduleIdList);
        JSONObject resultObj = JsonUtil.getObject((String)response);
        JSONArray schedules = new JSONArray();
        if (200 == resultObj.getIntValue("status")) {
            schedules = resultObj.getJSONArray("response");
            result.put("dataList", (Object)schedules);
        }
        result.put("enable_status", (Object)(schedules.isEmpty() ? "" : schedules.getJSONObject(0).getJSONObject("data").getString("enable_status")));
        return result;
    }

    private void handleSchedule(ScheduleReq rule, int callType) {
        List<ScheduleDetailModel> list = "local".equals(this.xxlJobConfig.getDeployCloud()) ? this.defineService.getScheduleInfoByRuleId(rule.getRuleId(), false) : this.defineService.getScheduleInfoByRuleId(rule.getRuleId(), true);
        if (CollectionUtil.isEmpty(list)) {
            LOGGER.warn("\u901a\u8fc7\u6761\u4ef6{}\u67e5\u8be2\uff0c\u6682\u65e0\u5339\u914d\u6392\u7a0b\u8bb0\u5f55", (Object)rule);
            return;
        }
        boolean result = this.executeSchedule(list, callType);
        if (BooleanUtil.isFalse((Boolean)result)) {
            throw new DWRuntimeException(ErrorCode.ERROR_SCHEDULE_HANDLE_CODE.getCode(), ErrorCode.ERROR_SCHEDULE_HANDLE_CODE.getMessage());
        }
    }

    private boolean executeSchedule(Collection<ScheduleDetailModel> detailModels, int callType) {
        List<String> scheduleIdList = detailModels.stream().map(ScheduleDetailModel::getInstanceId).collect(Collectors.toList());
        if ("local".equals(this.xxlJobConfig.getDeployCloud())) {
            boolean isSuccess;
            String result = this.dapClient.executeQuartz(scheduleIdList, TypeDict.getMethodName(callType));
            JSONObject resultObj = JsonUtil.getObject((String)result);
            boolean bl = isSuccess = 200 == resultObj.getIntValue("status");
            if (4 == callType && isSuccess) {
                scheduleIdList.forEach(instanceId -> this.defineService.deleteScheduleDefine((String)instanceId));
            }
            int flag = isSuccess ? 1 : 0;
            scheduleIdList.forEach(instanceId -> this.logService.saveScheduleLog((String)instanceId, callType, "MonitorEngine", flag));
            return isSuccess;
        }
        if (callType == 2) {
            detailModels.stream().forEach(e -> {
                this.defineService.updateTrigger(e.getTriggers(), e.getScheduleParam(), e.getInstanceId());
                this.executorAdminClient.update(this.buildXXLJobPO(e.getTenantId(), e.getInstanceId(), (TriggerReq)JSON.parseObject((String)e.getTriggers(), TriggerReq.class), Integer.valueOf(e.getJobId())));
            });
        }
        if (callType == 4) {
            detailModels.stream().forEach(model -> this.executorAdminClient.remove(Integer.valueOf(model.getJobId())));
            CompletableFuture.runAsync(() -> scheduleIdList.forEach(instanceId -> this.defineService.deleteScheduleDefine((String)instanceId))).exceptionally(e -> {
                LOGGER.error("ScheduleFacadeService#executeSchedule delete ocuur error :{}", (Object)e.getMessage());
                return null;
            });
        }
        scheduleIdList.forEach(instanceId -> this.logService.saveScheduleLog((String)instanceId, callType, "MonitorEngine", 1));
        return true;
    }

    private Map<String, Object> getScheduleDetail(TriggerReq trigger) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        if (StringUtil.isNotBlank(trigger.getAssignTime())) {
            paramMap.put("schedule_type", 1);
            paramMap.put("assign_time", trigger.getAssignTime());
        } else if (StringUtil.isNotBlank(trigger.getMonth()) || StringUtil.isNotBlank(trigger.getWeekOfMonth()) || StringUtil.isNotBlank(trigger.getDayOfWeek()) || StringUtil.isNotBlank(trigger.getDayOfMonth()) || StringUtil.isNotBlank(trigger.getTime()) || StringUtil.isNotBlank(trigger.getTime2()) || StringUtil.isNotBlank(trigger.getTime3()) || StringUtil.isNotBlank(trigger.getTime1())) {
            paramMap.put("schedule_type", 2);
            paramMap.put("month", trigger.getMonth());
            paramMap.put("week_of_month", trigger.getMonth());
            paramMap.put("day_of_week", trigger.getDayOfWeek());
            paramMap.put("day_of_month", trigger.getDayOfMonth());
            paramMap.put("time", trigger.getTime());
            paramMap.put("time1", trigger.getTime1());
            paramMap.put("time2", trigger.getTime2());
            paramMap.put("time3", trigger.getTime3());
        } else if (StringUtil.isNotBlank(trigger.getRepeatType())) {
            paramMap.put("schedule_type", 3);
            paramMap.put("start_time", trigger.getStartTime());
            paramMap.put("end_time", trigger.getEndTime());
            paramMap.put("repeat_type", trigger.getRepeatType());
            paramMap.put("repeat_count", trigger.getRepeatCount());
            paramMap.put("frequency", trigger.getFrequency());
        } else {
            paramMap.put("schedule_type", 4);
            paramMap.put("start_time", trigger.getStartTime());
            paramMap.put("end_time", trigger.getEndTime());
            paramMap.put("repeat_count", trigger.getRepeatCount());
            paramMap.put("minutely", trigger.getMinutely());
            paramMap.put("hourly", trigger.getHourly());
            paramMap.put("daily", trigger.getDaily());
            paramMap.put("weekly", trigger.getWeekly());
            paramMap.put("byday", trigger.getByday());
            paramMap.put("monthly", trigger.getMonthly());
            paramMap.put("bymonthday", trigger.getBymonthday());
            paramMap.put("byWeeklyday", trigger.getByweeklyday());
            paramMap.put("r_rule", trigger.getRRule());
        }
        return paramMap;
    }

    private void saveScheduleDefine(String tenantId, String ruleId, String actionId, String scheduleId, String trigger, String caller, int valid, String jobId, String scheduleParam) {
        ScheduleDetailModel model = new ScheduleDetailModel(scheduleId, ruleId, tenantId, actionId, trigger, caller, Integer.valueOf(valid), jobId, scheduleParam);
        boolean isXxlJob = false;
        if (!StringUtil.isBlank(jobId) && !StringUtil.isBlank(scheduleParam)) {
            isXxlJob = true;
        }
        this.defineService.saveScheduleDefine(model, isXxlJob);
    }

    private XxlJobInfo buildXXLJobPO(String tenantId, String instanceId, TriggerReq trigger, Integer jobId) {
        JSONObject paramJson = new JSONObject(4);
        paramJson.put("instance_id", (Object)instanceId);
        new XxlJobInfo();
        return XxlJobInfo.builder().id(jobId).jobGroup(this.xxlJobConfig.getJobGroupId()).author(tenantId).jobDesc("agile subscribe").scheduleType(ScheduleTypeEnum.CRON.name()).glueType(GlueTypeEnum.BEAN.name()).executorRouteStrategy(ExecutorRouteStrategyEnum.ROUND.name()).executorBlockStrategy(ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name()).executorHandler("agileSubscribe").misfireStrategy(MisfireStrategyEnum.DO_NOTHING.name()).triggerStatus(1).scheduleConf(this.constructCronExpression(trigger)).executorParam(paramJson.toJSONString()).build();
    }

    private String constructCronExpression(TriggerReq trigger) {
        CronModel cronModel = new CronModel(trigger);
        if (Objects.nonNull(trigger.getDayOfWeek()) && trigger.getDayOfWeek().length() > 0) {
            cronModel.setJobType(JobEnum.WEEK);
        }
        if (Objects.nonNull(trigger.getDayOfMonth()) && trigger.getDayOfMonth().length() > 0) {
            cronModel.setJobType(JobEnum.MONTH);
        }
        return CronUtil.createCronExpression(cronModel);
    }

    @Override
    public void executeTrigger(ExeTriggerReq rule) {
        LOGGER.info("ScheduleFacadeService#executeTrigger :{}", (Object)JSON.toJSONString((Object)rule));
        this.rabbitMQProducer.sendMessage((Map)JSON.parseObject((String)JSON.toJSONString((Object)rule), HashMap.class));
    }
}

