/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.smartdata.sdk.DatasourceProxyInitialize;
import com.digiwin.smartdata.agiledataengine.constant.CommonConstant;
import com.digiwin.smartdata.agiledataengine.dto.AttributeInquirerDto;
import com.digiwin.smartdata.agiledataengine.exception.BusinessException;
import com.digiwin.smartdata.agiledataengine.metric.model.AliasGrain;
import com.digiwin.smartdata.agiledataengine.metric.model.ColDataPermissionField;
import com.digiwin.smartdata.agiledataengine.metric.model.DataObject;
import com.digiwin.smartdata.agiledataengine.metric.model.DataSetItem;
import com.digiwin.smartdata.agiledataengine.metric.model.DatasetListItem;
import com.digiwin.smartdata.agiledataengine.metric.model.FilterItem;
import com.digiwin.smartdata.agiledataengine.metric.model.KMMetricData;
import com.digiwin.smartdata.agiledataengine.metric.model.MetadataItem;
import com.digiwin.smartdata.agiledataengine.metric.model.MetricDebugInfo;
import com.digiwin.smartdata.agiledataengine.metric.model.SelectItem;
import com.digiwin.smartdata.agiledataengine.metric.model.SolutionStepItem;
import com.digiwin.smartdata.agiledataengine.metric.model.SortItem;
import com.digiwin.smartdata.agiledataengine.metric.model.TimeGrain;
import com.digiwin.smartdata.agiledataengine.model.ActionParams;
import com.digiwin.smartdata.agiledataengine.model.AttributionDimensionResponse;
import com.digiwin.smartdata.agiledataengine.model.BaseEntity;
import com.digiwin.smartdata.agiledataengine.model.BasePage;
import com.digiwin.smartdata.agiledataengine.model.BmdMeta;
import com.digiwin.smartdata.agiledataengine.model.BusinessTypeEnum;
import com.digiwin.smartdata.agiledataengine.model.CalculateRule;
import com.digiwin.smartdata.agiledataengine.model.Context;
import com.digiwin.smartdata.agiledataengine.model.DimensionSolutionStep;
import com.digiwin.smartdata.agiledataengine.model.DimensionSolutionStepResponse;
import com.digiwin.smartdata.agiledataengine.model.ErrorCodeDto;
import com.digiwin.smartdata.agiledataengine.model.ExcelPullingResonseModel;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponse;
import com.digiwin.smartdata.agiledataengine.model.MetaDataResponseData;
import com.digiwin.smartdata.agiledataengine.model.ReportScene;
import com.digiwin.smartdata.agiledataengine.model.Snapshot;
import com.digiwin.smartdata.agiledataengine.model.Statistic;
import com.digiwin.smartdata.agiledataengine.model.StructureModel;
import com.digiwin.smartdata.agiledataengine.pojo.BizParams;
import com.digiwin.smartdata.agiledataengine.pojo.DigiwinEocUserInfo;
import com.digiwin.smartdata.agiledataengine.pojo.DigiwinIamUserRole;
import com.digiwin.smartdata.agiledataengine.pojo.PullData;
import com.digiwin.smartdata.agiledataengine.pojo.Scene;
import com.digiwin.smartdata.agiledataengine.pojo.SceneShow;
import com.digiwin.smartdata.agiledataengine.pojo.ShowGraphConfig;
import com.digiwin.smartdata.agiledataengine.pojo.bo.AttributionDataBo;
import com.digiwin.smartdata.agiledataengine.provider.ISolutionStepExecuteProvider;
import com.digiwin.smartdata.agiledataengine.repository.dao.IDynamicDao;
import com.digiwin.smartdata.agiledataengine.service.AdeService;
import com.digiwin.smartdata.agiledataengine.service.AgileDataEchoService;
import com.digiwin.smartdata.agiledataengine.service.DataSnapshotService;
import com.digiwin.smartdata.agiledataengine.service.DmcService;
import com.digiwin.smartdata.agiledataengine.service.EdgeDataService;
import com.digiwin.smartdata.agiledataengine.service.EocService;
import com.digiwin.smartdata.agiledataengine.service.ExecuteEngineService;
import com.digiwin.smartdata.agiledataengine.service.IamService;
import com.digiwin.smartdata.agiledataengine.service.RecastService;
import com.digiwin.smartdata.agiledataengine.service.ThemeMapService;
import com.digiwin.smartdata.agiledataengine.service.attribution.IAttributeInquirer;
import com.digiwin.smartdata.agiledataengine.util.AgileDataEchoUtil;
import com.digiwin.smartdata.agiledataengine.util.ChartConvertUtil;
import com.digiwin.smartdata.agiledataengine.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.util.ColumnPermissionValidatorUtil;
import com.digiwin.smartdata.agiledataengine.util.DateTimeUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import com.digiwin.smartdata.agiledataengine.util.StringUtil;
import com.digiwin.smartdata.agiledataengine.util.TranCovertUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vavr.Tuple2;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

@Service(value="adeService")
public class AdeServiceImpl
implements AdeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdeServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private ExecuteEngineService executeEngineService;
    @Autowired
    private DataSnapshotService dataSnapshotService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private RecastService recastService;
    @Autowired
    private EocService eocService;
    @Autowired
    private AgileDataEchoService agileDataEchoService;
    @Autowired
    private EdgeDataService edgeDataService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ISolutionStepExecuteProvider solutionStepExecuteProvider;
    @Autowired
    private IAttributeInquirer iAttributeInquirer;
    @Autowired
    private IDynamicDao dynamicMapper;
    private static final boolean SCENE_FN_SWITCH = Boolean.parseBoolean(DWApplicationPropertiesUtils.getProperty((String)"application", (String)"scene.fn.switch"));
    private static final String INTERCEPT_SIZE = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"interceptSize");
    private static final String RATE_NAME = "rate123";
    private static final Map<String, String> TRANS_MAP = new HashMap<String, String>(2);

    public Snapshot buildContextByInstant(Context context, ReportScene reportScene, String snapshotId) {
        BizParams bizParams = context.getBizParams();
        this.permissionCheck(bizParams);
        Scene scene = context.getScene();
        Snapshot snapshot = new Snapshot();
        if (!org.springframework.util.StringUtils.hasLength((String)snapshotId)) {
            snapshotId = snapshot.setSnapshotId(bizParams.getTenantId(), bizParams.getRuleId() == null ? "" : bizParams.getRuleId(), CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
        }
        snapshot.setSnapshotId(snapshotId);
        List pullDatas = context.getPullData();
        List<Object> newPullDatas = new ArrayList<PullData>(4);
        PullData pullData = (PullData)pullDatas.get(0);
        String actionId = pullData.getActionId();
        scene.processingWhat(scene, "realTimeQuery", actionId);
        HashMap<String, Object> sysActionParam = new HashMap(4);
        if (context.getSysParam() != null) {
            sysActionParam = context.getSysParam();
        }
        if (!CollectionUtil.isEmpty((Map)bizParams.getQuerySchema())) {
            PullData newPullData = this.getBmdData(bizParams, reportScene);
            if (newPullData == null) {
                context.setCode("bmd_service_error");
                snapshot.setContext(context);
                return snapshot;
            }
            newPullDatas.add(newPullData);
        } else {
            if (StringUtil.isBlank((String)actionId)) {
                context.setCode("empty_actionId");
                snapshot.setContext(context);
                return snapshot;
            }
            if (bizParams.isMultiDataSource() && CollectionUtil.isEmpty((Collection)bizParams.getEocMaps())) {
                context.setCode("user_permissions_beyond");
                snapshot.setContext(context);
                return snapshot;
            }
            Boolean isDcpDS = Optional.ofNullable(context.getSysParam()).map(e -> e.get(actionId)).map(m -> ((Map)m).get("dataSource")).map(str -> "dcp".equalsIgnoreCase((String)str)).orElse(true);
            if (isDcpDS.booleanValue() && CollectionUtils.isEmpty((Collection)bizParams.getProductLineInfo())) {
                if (CollectionUtils.isEmpty((Collection)bizParams.getMissingProductLineInfos())) {
                    context.setCode("user_product_ground_beyond");
                } else {
                    context.setCode(String.format("user_product_beyond", String.join((CharSequence)"/", bizParams.getMissingProductLineInfos())));
                }
                snapshot.setContext(context);
                return snapshot;
            }
            if (!bizParams.isSuperAdmin() && !bizParams.isHasAuthorized() && SCENE_FN_SWITCH) {
                context.setCode("user_scene_permission_error");
                context.setPatternArguments(bizParams.getPatternArguments());
                snapshot.setContext(context);
                return snapshot;
            }
            newPullDatas = this.buildDataByActionId(actionId, bizParams, sysActionParam, reportScene);
            if (!CollectionUtils.isEmpty(newPullDatas) && ((PullData)newPullDatas.get(0)).getErrorCodeDto() != null) {
                return this.buildErrorSnapshot(context, snapshot, newPullDatas);
            }
        }
        context.setPullData(newPullDatas);
        snapshot.setContext(context);
        if (!"sync-instant".equalsIgnoreCase(bizParams.getRequestType())) {
            PullData pullData1 = (PullData)newPullDatas.get(0);
            bizParams.setMethod(StructureModel.DATAFLOW.getModel());
            bizParams.setShowDefine(reportScene.getShowType().get(0));
            ChartConvertUtil.handleChartConvert((DmcService)this.dmcService, (Context)context, (BizParams)bizParams, (PullData)pullData1, (Snapshot)snapshot);
        }
        return snapshot;
    }

    private PullData getBmdData(BizParams bizParams, ReportScene reportScene) {
        Object pullingData;
        PullData newPullData = new PullData();
        String startTime = DateTimeUtil.getTodayTimeUseDefaultPattern();
        try {
            pullingData = this.buildDataByQuerySchema(bizParams, reportScene);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4e1a\u52a1\u4e2d\u53f0\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)e.getMessage());
            pullingData = null;
        }
        if (pullingData == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("tenantId", bizParams.getTenantId());
        params.put("actionId", "");
        params.put("data", (String)((Map)pullingData).get("data"));
        Object metadata = this.executeEngineService.getPullData(bizParams.getUserToken(), bizParams.getLocale(), bizParams.getTenantId(), bizParams.getMessageId(), params);
        newPullData.setMetadata(this.buildBmdMetadata(metadata, bizParams.getBmdMetaList()));
        newPullData.setData(pullingData);
        newPullData.setModelId((String)bizParams.getQuerySchema().get("modelId"));
        newPullData.setStartTime(startTime);
        newPullData.setEndTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
        return newPullData;
    }

    private Object buildBmdMetadata(Object metadata, List<BmdMeta> bmdMetaList) {
        if (CollectionUtils.isEmpty(bmdMetaList)) {
            return metadata;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JsonUtil.getJsonString((Object)metadata));
        MetaDataResponse response = (MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)jsonObject.get((Object)"response")), MetaDataResponse.class);
        MetaDataResponseData data = response.getData();
        List fields = data.getField();
        block0: for (MetaDataResponseData field : fields) {
            for (BmdMeta bmdMeta : bmdMetaList) {
                if (!field.getData_name().equals(bmdMeta.getColumnName())) continue;
                field.setDescription(bmdMeta.getColumnComment());
                field.setCan_sort(Boolean.valueOf(false));
                field.setCan_filter(Boolean.valueOf(false));
                if ("0".equals(bmdMeta.getColumnDataType())) {
                    field.setData_type("string");
                    continue block0;
                }
                if ("1".equals(bmdMeta.getColumnDataType())) {
                    field.setData_type("date");
                    continue block0;
                }
                if (!"2".equals(bmdMeta.getColumnDataType()) && !"3".equals(bmdMeta.getColumnDataType())) continue block0;
                field.setData_type("numeric");
                field.setPercent("thousand");
                field.setDecimal("2");
                continue block0;
            }
        }
        jsonObject.put("response", (Object)response);
        return jsonObject;
    }

    private Object buildGptMetadata(Object metadata, SceneShow sceneShow, ArrayList<JSONObject> dataList, Object showDefine) {
        List fieldsOrders = sceneShow.getFieldsOrder();
        JSONObject jsonObject = JSONObject.parseObject((String)JsonUtil.getJsonString((Object)metadata));
        MetaDataResponse response = (MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)jsonObject.get((Object)"response")), MetaDataResponse.class);
        MetaDataResponseData data = response.getData();
        List fields = data.getField();
        Boolean hasRate = false;
        if ("0".equals(sceneShow.getShowType()) || "2".equals(sceneShow.getShowType())) {
            this.buildDefaultField(fields);
        } else {
            ShowGraphConfig graphConfig = sceneShow.getGraphConfig();
            if (graphConfig != null) {
                List x = graphConfig.getX();
                List y = graphConfig.getY();
                if (CollectionUtils.isEmpty((Collection)x) || CollectionUtils.isEmpty((Collection)y)) {
                    this.buildDefaultField(fields);
                } else {
                    Map data1 = (Map)dataList.get(0);
                    if ("3".equals(sceneShow.getShowType()) || "6".equals(sceneShow.getShowType())) {
                        if (y.size() == CommonConstant.INT_TWO.intValue() && "3".equals(sceneShow.getShowType())) {
                            hasRate = true;
                        }
                        for (MetaDataResponseData field : fields) {
                            if (y.contains(field.getData_name())) {
                                this.buildFieldToNumeric(field, data1);
                            }
                            field.setDescription(field.getData_name());
                        }
                    } else if ("5".equals(sceneShow.getShowType())) {
                        for (MetaDataResponseData field : fields) {
                            if (x.contains(field.getData_name())) {
                                this.buildFieldToDate(field);
                            } else if (y.contains(field.getData_name())) {
                                this.buildFieldToNumeric(field, data1);
                            }
                            field.setDescription(field.getData_name());
                        }
                    }
                }
                ArrayList<String> ny = new ArrayList<String>(1);
                for (Object orgData : dataList) {
                    Map data1 = (Map)orgData;
                    for (Map.Entry entry : data1.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!(entry.getValue() instanceof String)) continue;
                        String value = (String)entry.getValue();
                        if (value.contains(",")) {
                            data1.put(key, value.replace(",", ""));
                            continue;
                        }
                        if (!value.contains("%")) continue;
                        Double dvalue = Double.parseDouble(value.replace("%", ""));
                        dvalue = dvalue / 100.0;
                        data1.put(key, dvalue);
                    }
                }
                if (Boolean.TRUE.equals(hasRate)) {
                    if (!CollectionUtils.isEmpty((Collection)y) && !CollectionUtils.isEmpty(fieldsOrders) && fields.size() > 1 && fieldsOrders.size() >= fields.size()) {
                        fieldsOrders = fieldsOrders.stream().distinct().collect(Collectors.toList());
                        for (String orderField : fieldsOrders) {
                            for (String yk : y) {
                                if (!yk.equals(orderField)) continue;
                                ny.add(yk);
                                break;
                            }
                            if (ny.size() != y.size()) continue;
                            break;
                        }
                    }
                    for (Object orgData : dataList) {
                        Map od = (Map)orgData;
                        Double value1 = od.get(ny.get(0)) instanceof String ? Double.valueOf(Double.parseDouble((String)od.get(ny.get(0)))) : (Double)od.get(ny.get(0));
                        Double value2 = od.get(ny.get(1)) instanceof String ? Double.valueOf(Double.parseDouble((String)od.get(ny.get(1)))) : (Double)od.get(ny.get(1));
                        if (value1 == null || value2 == null) continue;
                        Double rate = (value2 - value1) / value1;
                        ((Map)orgData).put(RATE_NAME, rate);
                    }
                    if (!ObjectUtils.isEmpty((Object)showDefine)) {
                        List showType = (List)((Map)showDefine).get("showType");
                        ArrayList show = new ArrayList(1);
                        HashMap<String, Object> showMap = new HashMap<String, Object>(2);
                        if (!CollectionUtils.isEmpty((Collection)showType)) {
                            String actionId = (String)((Map)showType.get(0)).get("actionId");
                            List<Map<String, Object>> agileRule = this.buildAileRule(RATE_NAME, "growthRate");
                            showMap.put("actionId", actionId);
                            showMap.put("agileRule", agileRule);
                        }
                        show.add(showMap);
                        ((Map)showDefine).put("show", show);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)fieldsOrders) && fields.size() > 1 && fieldsOrders.size() >= fields.size()) {
            fieldsOrders = fieldsOrders.stream().distinct().collect(Collectors.toList());
            ArrayList<MetaDataResponseData> newfields = new ArrayList<MetaDataResponseData>(fields.size());
            block7: for (String sortField : fieldsOrders) {
                for (MetaDataResponseData field : fields) {
                    if (!field.getData_name().equals(sortField)) continue;
                    newfields.add(field);
                    continue block7;
                }
            }
            if (Boolean.TRUE.equals(hasRate)) {
                MetaDataResponseData rateData = new MetaDataResponseData();
                rateData.setData_name(RATE_NAME);
                rateData.setDescription("\u589e\u957f\u7387");
                rateData.setData_type("numeric");
                rateData.setPercent("percent");
                rateData.setDecimal("2");
                newfields.add(rateData);
            }
            data.setField(newfields);
        }
        jsonObject.put("response", (Object)response);
        return jsonObject;
    }

    private List<Map<String, Object>> buildAileRule(String applyToField, String type) {
        ArrayList<Map<String, Object>> agileRule = new ArrayList<Map<String, Object>>(1);
        HashMap<String, Object> rule = new HashMap<String, Object>(1);
        rule.put("type", type);
        ArrayList rules = new ArrayList();
        HashMap<String, String> rule1 = new HashMap<String, String>(1);
        rule1.put("applyToField", applyToField);
        rules.add(rule1);
        rule.put("rules", rules);
        agileRule.add(rule);
        return agileRule;
    }

    private void buildFieldToDate(MetaDataResponseData field) {
        field.setData_type("datetime");
    }

    private void buildFieldToNumeric(MetaDataResponseData field, Map<String, Object> data1) {
        field.setData_type("numeric");
        String value = (String)data1.get(field.getData_name());
        if (value.indexOf("%") > -1) {
            field.setPercent("percent");
            field.setDecimal(String.valueOf(value.split("\\.")[1].length()));
        } else if (value.indexOf(".") > -1) {
            field.setPercent("thousand");
            field.setDecimal(String.valueOf(value.split("\\.")[1].length()));
        }
    }

    private void buildDefaultField(List<MetaDataResponseData> fields) {
        for (MetaDataResponseData field : fields) {
            field.setDescription(field.getData_name());
        }
    }

    private List<PullData> buildDataByActionId(String actionId, BizParams bizParams, Map<String, Object> sysActionParam, ReportScene reportScene) {
        List actionParams = this.themeMapService.getActionParamsByActionIds(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), Arrays.asList(actionId.split(",")));
        if (CollectionUtils.isEmpty((Collection)actionParams)) {
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff0c\u95ee\u9898\u4f4d\u7f6e\uff1a\u83b7\u53d6\u573a\u666f\u914d\u7f6e\uff0c\u6570\u636e\u6d41id:" + actionId + "\uff0c\u95ee\u9898\u63cf\u8ff0\uff1a\u6570\u636e\u6d41\u4e0d\u5b58\u5728\uff0c\u53d1\u751f\u65f6\u95f4\uff1a" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\uff0c\u9519\u8bef\u5185\u5bb9\uff1a\u6570\u636e\u6d41id:" + actionId + "\uff0c\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u573a\u666f\u662f\u5426\u88ab\u8bef\u5220\u9664");
            this.agileDataEchoService.exceptionSubmit(bizParams.getUserToken(), bizParams.getTenantId(), bizParams.getLocale(), AgileDataEchoUtil.buildSubmitParams((String)bizParams.getMessageId(), (String)bizParams.getPinpointId(), (String)"ade", (String)"ade", (String)"\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)->\u77e5\u8bc6\u56fe\u8c31\u7ec4\u4ef6(KM),\u6570\u636e\u6d41\u4e0d\u5b58\u5728", (String)("\u6570\u636e\u6d41id:" + actionId), (String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u573a\u666f\u662f\u5426\u88ab\u8bef\u5220\u9664"));
        }
        List foreachActionId = new ArrayList<String>();
        if (actionId.contains(",")) {
            String[] actionIds = actionId.split(",");
            foreachActionId = CollectionUtils.arrayToList((Object)actionIds);
            foreachActionId = Collections.synchronizedList(foreachActionId);
        } else {
            foreachActionId.add(actionId);
        }
        HashMap<String, List<String>> configDemisions = new HashMap(4);
        if (!CollectionUtils.isEmpty((Collection)bizParams.getDimension())) {
            configDemisions = this.themeMapService.queryAssistDimension(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), bizParams.getAppCode(), bizParams.getDimension());
        }
        if ("sync-instant".equalsIgnoreCase(bizParams.getRequestType())) {
            CopyOnWriteArrayList<PullData> finalNewPullDatas = new CopyOnWriteArrayList<PullData>();
            HashMap finalConfigDemisions = configDemisions;
            foreachActionId.parallelStream().forEach(actionID -> {
                try {
                    finalNewPullDatas.add(this.buildPullData((String)actionID, reportScene, actionParams, (BizParams)BeanUtils.cloneBean((Object)bizParams), finalConfigDemisions, sysActionParam));
                }
                catch (Exception e) {
                    LOGGER.error("AdeServiceImpl#buildDataByActionId build bizparam error");
                }
            });
            return finalNewPullDatas;
        }
        ArrayList<PullData> newPullDatas = new ArrayList<PullData>(foreachActionId.size());
        for (String actionID2 : foreachActionId) {
            newPullDatas.add(this.buildPullData(actionID2, reportScene, actionParams, bizParams, configDemisions, sysActionParam));
        }
        return newPullDatas;
    }

    private PullData buildPullData(String actionID, ReportScene reportScene, List<ActionParams> actionParams, BizParams bizParams, Map<String, List<String>> finalConfigDemisions, Map<String, Object> sysActionParam) {
        Object pullingData;
        PullData newPullData = new PullData();
        newPullData.setActionId(actionID);
        newPullData.setSceneCode(reportScene.getCode());
        String startTime = DateTimeUtil.getTodayTimeUseDefaultPattern();
        ActionParams findActionParam = new ActionParams();
        for (ActionParams actionParam : actionParams) {
            if (!actionID.equals(actionParam.getActionId())) continue;
            findActionParam = actionParam;
            if (CollectionUtils.isEmpty((Collection)bizParams.getDimension())) break;
            bizParams.buildAllDemisons(finalConfigDemisions, actionParam);
            break;
        }
        Object defaultRecasts = reportScene.getRecast().get(actionID);
        List defaultObjectList = null;
        if (!ObjectUtils.isEmpty(defaultRecasts)) {
            defaultObjectList = JsonUtil.getList((String)JsonUtil.getJsonString(defaultRecasts), JSONObject.class);
        }
        if (defaultObjectList != null) {
            for (JSONObject recast : defaultObjectList) {
                if (!"show".equals(recast.get((Object)"type"))) continue;
                if (CollectionUtils.isEmpty((Collection)bizParams.getDimension()) && bizParams.getDimension().size() < bizParams.getAllDimension().size()) {
                    List fields = (List)recast.get((Object)"fields");
                    for (String key : bizParams.getDimension()) {
                        for (Map field : fields) {
                            if (!key.equals(field.get("field"))) continue;
                            List subField = (List)bizParams.getSupportDimension().get(key);
                            field.put("subField", subField);
                        }
                    }
                }
                this.addBusinessTypeInfo(bizParams, recast);
                newPullData.setDataTag((Object)recast);
                defaultObjectList.remove(recast);
                break;
            }
        }
        if ((pullingData = this.getPullDataByActionId(actionID, reportScene.getCode(), bizParams, findActionParam, !CollectionUtils.isEmpty((Map)((Map)sysActionParam.get(actionID))) ? (Map)sysActionParam.get(actionID) : null, defaultRecasts)) instanceof ErrorCodeDto) {
            if ("P.DCC.S001.PS001".equals(((ErrorCodeDto)pullingData).getErrorCode()) || "P.DCC.US002.PUS002".equals(((ErrorCodeDto)pullingData).getErrorCode()) || "P.DCC.AU001.PAU001".equals(((ErrorCodeDto)pullingData).getErrorCode())) {
                newPullData.setErrorCodeDto((ErrorCodeDto)pullingData);
                return newPullData;
            }
            this.agileDataEchoService.exceptionSubmit(bizParams.getUserToken(), bizParams.getTenantId(), bizParams.getLocale(), AgileDataEchoUtil.buildSubmitParams((String)bizParams.getMessageId(), (String)bizParams.getPinpointId(), (String)"ade", (String)"ade", (String)"\u6570\u636e\u62c9\u53d6\u7ec4\u4ef6(ADE)->\u6267\u884c\u5f15\u64ce\u7ec4\u4ef6(EE),\u6267\u884c\u5f15\u64ce\u62a5\u9519", (String)((ErrorCodeDto)pullingData).getMessage(), (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u4eba\u5458\u5904\u7406"));
            pullingData = null;
        }
        if (pullingData != null) {
            Object recastData = null;
            Object metadata = null;
            recastData = this.buildPullingData(bizParams, reportScene.getCode(), pullingData, actionID);
            if (!ObjectUtils.isEmpty((Object)recastData) && recastData instanceof Map && ((Map)recastData).get("data") instanceof List && CollectionUtil.isNotEmpty((Collection)((List)((Map)recastData).get("data")))) {
                newPullData.setData(recastData);
                if (CollectionUtil.isNotEmpty((Map)((Map)((Map)recastData).get("meta")))) {
                    metadata = ((Map)recastData).get("meta");
                    LOGGER.info("AdeServiceImpl#buildPullData achieve trans meta :{}", (Object)JSON.toJSONString(metadata));
                    ((Map)recastData).remove("meta");
                } else {
                    HashMap<String, String> params = new HashMap<String, String>(3);
                    params.put("tenantId", bizParams.getTenantId());
                    params.put("actionId", actionID);
                    params.put("data", (String)((Map)recastData).get("data"));
                    metadata = this.executeEngineService.getPullData(bizParams.getUserToken(), bizParams.getLocale(), bizParams.getTenantId(), bizParams.getMessageId(), params);
                }
                newPullData.setMetadata(this.buildSecondaryCalculationMetadata(metadata, bizParams, reportScene.getCode(), actionID));
            }
        }
        String endTime = DateTimeUtil.getTodayTimeUseDefaultPattern();
        newPullData.setStartTime(startTime);
        newPullData.setEndTime(endTime);
        return newPullData;
    }

    private void addBusinessTypeInfo(BizParams bizParams, JSONObject recast) {
        JSONArray jsonArray = recast.getJSONArray("fields");
        List bizTypes = null;
        if (!jsonArray.isEmpty()) {
            bizTypes = jsonArray.stream().map(js -> ((JSONObject)js).getString("businessType")).distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isEmpty(bizTypes)) {
            return;
        }
        Map code2BizTypeMap = this.themeMapService.metricBusinessByCode(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), bizTypes, bizParams.getSceneAppCode());
        if (CollectionUtil.isEmpty((Map)code2BizTypeMap)) {
            return;
        }
        HashMap filedName2BizType = new HashMap(8);
        recast.getJSONArray("fields").forEach(rt -> {
            JSONObject rtLast = (JSONObject)rt;
            if (rtLast.containsKey((Object)"businessType")) {
                String bzType = rtLast.getString("businessType");
                rtLast.put("decimalRule", code2BizTypeMap.containsKey(bzType) ? ((Map)code2BizTypeMap.get(bzType)).get("decimalRule") : null);
                rtLast.put("dataUnit", code2BizTypeMap.containsKey(bzType) ? ((Map)code2BizTypeMap.get(bzType)).get("dataUnit") : null);
                filedName2BizType.put(((JSONObject)rt).getString("field"), (Map)code2BizTypeMap.get(bzType));
            }
        });
        LOGGER.error("AdeServiceImpl#addBusinessTypeInfo recast info: {},filedName2BizType info: {} ", (Object)JSON.toJSONString((Object)recast), (Object)JSON.toJSONString(filedName2BizType));
        bizParams.setFiledName2BizType(filedName2BizType);
    }

    private Object buildSecondaryCalculationMetadata(Object metadata, BizParams bizParams, String senceCode, String actionId) {
        String scAndActionId;
        Map actionRecasts = bizParams.getRecast();
        if (actionRecasts.get(scAndActionId = senceCode.concat(actionId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)actionRecasts.get(scAndActionId)))) {
            List recasts = (List)actionRecasts.get(scAndActionId);
            Map<String, Object> measure = new HashMap(4);
            Map calculate = new HashMap(4);
            Map choose = new HashMap(4);
            Map sort = new HashMap(4);
            ArrayList<String> minusMeasure = new ArrayList<String>(4);
            for (Map recast : recasts) {
                if ("measure".equals(recast.get("name"))) {
                    List fields;
                    measure = recast;
                    Map condition = (Map)measure.get("condition");
                    if (CollectionUtils.isEmpty((Map)condition) || CollectionUtils.isEmpty((Collection)(fields = (List)condition.get("fields"))) || CollectionUtils.isEmpty((Collection)bizParams.getDimension())) continue;
                    for (String field : fields) {
                        if (bizParams.getDimension().contains(field)) continue;
                        minusMeasure.add(field);
                    }
                    continue;
                }
                if ("calculate".equals(recast.get("name"))) {
                    calculate = recast;
                    continue;
                }
                if ("choose".equals(recast.get("name"))) {
                    choose = recast;
                    continue;
                }
                if (!"sort".equals(recast.get("name"))) continue;
                sort = recast;
            }
            if (!(CollectionUtils.isEmpty(measure) && CollectionUtils.isEmpty(calculate) && CollectionUtils.isEmpty(choose) && CollectionUtils.isEmpty(sort))) {
                JSONObject jsonObject = JSONObject.parseObject((String)JsonUtil.getJsonString((Object)metadata));
                MetaDataResponse response = (MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)jsonObject.get((Object)"response")), MetaDataResponse.class);
                MetaDataResponseData data = response.getData();
                JSONObject orgMeta = this.themeMapService.getExecutionRule(actionId, bizParams.getTenantId(), Collections.emptySet(), Collections.emptySet(), bizParams.getUserToken(), bizParams.getLocale());
                if (orgMeta == null) {
                    LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff0c\u95ee\u9898\u4f4d\u7f6e\uff1a\u83b7\u53d6\u573a\u666f\u914d\u7f6e\uff0c\u6570\u636e\u6d41id:" + actionId + "\uff0c\u95ee\u9898\u63cf\u8ff0\uff1a\u6570\u636e\u6d41\u4e0d\u5b58\u5728\uff0c\u53d1\u751f\u65f6\u95f4\uff1a" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\uff0c\u9519\u8bef\u5185\u5bb9\uff1a\u6570\u636e\u6d41id:" + actionId + "\uff0c\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a\u8bf7\u786e\u8ba4\u5f53\u524d\u662f\u5426\u6b63\u5728\u53d1\u7248\uff0c\u6216\u8be5\u573a\u666f\u662f\u5426\u88ab\u8bef\u5220\u9664");
                } else {
                    List actionMetadatas = (List)orgMeta.get((Object)"actionMetadatas");
                    MetaDataResponseData orgResponseData = new MetaDataResponseData();
                    for (Object actionMetadata : actionMetadatas) {
                        if (!actionId.equals(actionMetadata.get("actionId"))) continue;
                        orgResponseData = ((MetaDataResponse)JsonUtil.getObject((String)JsonUtil.getJsonString(actionMetadata.get("response")), MetaDataResponse.class)).getData();
                        break;
                    }
                    if (!CollectionUtils.isEmpty(measure)) {
                        metadata = this.updateMeasureMetadata(jsonObject, response, data, orgResponseData, measure, metadata, bizParams.getFiledName2BizType());
                    }
                    if (!CollectionUtils.isEmpty(calculate)) {
                        List rules = JsonUtil.getList((String)JsonUtil.getJsonString(calculate.get("rule")), CalculateRule.class);
                        for (Object rule : rules) {
                            Object newRule;
                            if (!"true".equals(rule.getRetain()) || !org.springframework.util.StringUtils.hasLength((String)(newRule = rule).getNewField())) continue;
                            Object newFiledObject = this.buildFieldValue(orgResponseData.getField(), newRule.getNewField());
                            this.buildField((List<MetaDataResponseData>)data.getField(), (CalculateRule)newRule, newFiledObject, (Map<String, Map<String, Object>>)bizParams.getFiledName2BizType());
                            jsonObject.put("response", (Object)response);
                            metadata = jsonObject;
                        }
                    }
                    if (!CollectionUtils.isEmpty(sort)) {
                        Map condition = (Map)sort.get("condition");
                        List statistics = JsonUtil.getList((String)JsonUtil.getJsonString(condition.get("statistics")), Statistic.class);
                        block4: for (Statistic statistic : statistics) {
                            if (!org.springframework.util.StringUtils.hasLength((String)statistic.getTitle())) continue;
                            Iterator fields = data.getField();
                            Iterator iterator = fields.iterator();
                            while (iterator.hasNext()) {
                                MetaDataResponseData field = (MetaDataResponseData)iterator.next();
                                if (!statistic.getNewField().equals(field.getData_name())) continue;
                                field.setDescription(statistic.getTitle());
                                continue block4;
                            }
                        }
                        jsonObject.put("response", (Object)response);
                        metadata = jsonObject;
                    }
                    if (!CollectionUtils.isEmpty(choose) && "retain".equals(choose.get("type"))) {
                        List sortFields = (List)choose.get("fields");
                        LinkedList<String> finalFields = new LinkedList<String>();
                        if (CollectionUtils.isEmpty(minusMeasure)) {
                            for (String measureFinal : bizParams.getAllDimension()) {
                                if (sortFields.contains(measureFinal)) continue;
                                finalFields.add(measureFinal);
                            }
                            finalFields.addAll(sortFields);
                        } else {
                            sortFields.removeAll(minusMeasure);
                            finalFields.addAll(sortFields);
                        }
                        if (finalFields.contains("lineNumber")) {
                            finalFields.remove("lineNumber");
                            finalFields.add(0, "lineNumber");
                        }
                        if (!CollectionUtils.isEmpty((Collection)bizParams.getDimension()) && !CollectionUtils.isEmpty((Map)bizParams.getSupportDimension())) {
                            for (String key : bizParams.getDimension()) {
                                finalFields.addAll((Collection)bizParams.getSupportDimension().get(key));
                            }
                        }
                        if (!CollectionUtils.isEmpty(finalFields)) {
                            List fields = data.getField();
                            List<Object> newFields = new ArrayList<MetaDataResponseData>(fields.size());
                            block8: for (String sortField : finalFields) {
                                for (MetaDataResponseData metaDataResponseData : fields) {
                                    if (!sortField.equals(metaDataResponseData.getData_name())) continue;
                                    newFields.add(this.buildMetaDataField(metaDataResponseData, bizParams.getFiledName2BizType()));
                                    continue block8;
                                }
                            }
                            block10: for (String sortField : finalFields) {
                                for (MetaDataResponseData metaDataResponseData : orgResponseData.getField()) {
                                    if (!sortField.equals(metaDataResponseData.getData_name())) continue;
                                    newFields.add(this.buildMetaDataField(metaDataResponseData, bizParams.getFiledName2BizType()));
                                    continue block10;
                                }
                            }
                            ArrayList<String> keys = new ArrayList<String>(newFields.size());
                            ArrayList<MetaDataResponseData> finalData = new ArrayList<MetaDataResponseData>(newFields.size());
                            for (MetaDataResponseData metaDataResponseData : newFields) {
                                if (keys.contains(metaDataResponseData.getData_name())) continue;
                                keys.add(metaDataResponseData.getData_name());
                            }
                            ArrayList<String> hasKeys = new ArrayList<String>(newFields.size());
                            newFields = newFields.stream().map(e -> {
                                int i = finalFields.indexOf(e.getData_name());
                                return new Tuple2((Object)i, e);
                            }).sorted(Comparator.comparingInt(m -> (Integer)m._1())).map(l -> (MetaDataResponseData)l._2()).collect(Collectors.toList());
                            for (MetaDataResponseData metaDataResponseData : newFields) {
                                if (!keys.contains(metaDataResponseData.getData_name()) || hasKeys.contains(metaDataResponseData.getData_name())) continue;
                                hasKeys.add(metaDataResponseData.getData_name());
                                finalData.add(metaDataResponseData);
                            }
                            data.setField(finalData);
                        }
                        jsonObject.put("response", (Object)response);
                        metadata = jsonObject;
                    }
                }
            }
        }
        JSONObject logJson = new JSONObject(4);
        logJson.put("actionId", (Object)scAndActionId);
        LogUtils.buildAgileDataEngineLog((String)"buildMetadata", (String)LogUtils.SUCCESS, (String)logJson.toJSONString(), (String)JSON.toJSONString((Object)metadata), (String)"");
        bizParams.setFiledName2BizType(null);
        return metadata;
    }

    private MetaDataResponseData buildMetaDataField(MetaDataResponseData field, Map<String, Map<String, Object>> filedName2BizType) {
        if ("number".equals(field.getData_type())) {
            field.setData_type("numeric");
        }
        if ("percent".equals(field.getPercent())) {
            Integer decimal = 0;
            if (org.springframework.util.StringUtils.hasLength((String)field.getDecimal())) {
                decimal = Integer.parseInt(field.getDecimal()) - 2;
            }
            field.setDecimal(decimal.toString());
        }
        if (Objects.nonNull(filedName2BizType) && filedName2BizType.containsKey(field.getData_name())) {
            Map<String, Object> stringObjectMap = filedName2BizType.get(field.getData_name());
            field.setDecimal(stringObjectMap.containsKey("decimal") ? String.valueOf(stringObjectMap.get("decimal")) : field.getDecimal());
            field.setPercent(stringObjectMap.containsKey("showType") ? String.valueOf(stringObjectMap.get("showType")) : field.getPercent());
        }
        return field;
    }

    private void buildField(List<MetaDataResponseData> fields, CalculateRule newRule, Object newFieldObject, Map<String, Map<String, Object>> filedName2BizType) {
        MetaDataResponseData newFieldDate = (MetaDataResponseData)newFieldObject;
        if (!CollectionUtils.isEmpty(fields)) {
            for (MetaDataResponseData field : fields) {
                if (newRule.getNewField().equals(field.getData_name())) {
                    if ("number".equals(newRule.getValueType())) {
                        newFieldDate.setData_type("numeric");
                    } else {
                        newFieldDate.setData_type(newRule.getValueType());
                    }
                    if (!org.springframework.util.StringUtils.hasLength((String)newFieldDate.getData_type())) {
                        newFieldDate.setDescription(newRule.getTitle());
                        newFieldDate.setData_name(newRule.getNewField());
                    }
                    field.buildMetaDataResponseData(newFieldDate);
                    field.setDescription(newRule.getTitle());
                    if (org.springframework.util.StringUtils.hasLength((String)newRule.getPercent())) {
                        field.setPercent(newRule.getPercent());
                        field.setDecimal(newRule.getPrecision());
                    }
                } else {
                    this.buildField((List<MetaDataResponseData>)field.getField(), newRule, newFieldObject, filedName2BizType);
                }
                if (!Objects.nonNull(filedName2BizType) || !filedName2BizType.containsKey(field.getData_name())) continue;
                Map<String, Object> stringObjectMap = filedName2BizType.get(field.getData_name());
                field.setDecimal(stringObjectMap.containsKey("decimal") ? String.valueOf(stringObjectMap.get("decimal")) : field.getDecimal());
                field.setPercent(stringObjectMap.containsKey("showType") ? String.valueOf(stringObjectMap.get("showType")) : field.getPercent());
            }
        }
    }

    private Object updateMeasureMetadata(JSONObject jsonObject, MetaDataResponse response, MetaDataResponseData data, MetaDataResponseData orgResponseData, Map<String, Object> measure, Object metadata, Map<String, Map<String, Object>> filedName2BizType) {
        Map condition = (Map)measure.get("condition");
        List statistics = JsonUtil.getList((String)JsonUtil.getJsonString(condition.get("statistics")), Statistic.class);
        if (CollectionUtils.isEmpty((Collection)statistics)) {
            return metadata;
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>(statistics.size());
        for (Statistic statistic : statistics) {
            if (!StringUtil.isNotBlank((String)statistic.getNewField()) || "nRECEIVABLEDOCAMT_abc".equals(statistic.getNewField()) || "nPAYBACKAMT_abc".equals(statistic.getNewField())) continue;
            String oldField = (String)statistic.getStatisticalFields().get(0);
            fieldValues.put(statistic.getNewField(), this.buildFieldValue(orgResponseData.getField(), oldField));
        }
        for (Statistic statistic : statistics) {
            if (!StringUtil.isNotBlank((String)statistic.getNewField())) continue;
            this.buildField((List<MetaDataResponseData>)data.getField(), statistic, fieldValues, filedName2BizType);
        }
        jsonObject.put("response", (Object)response);
        return jsonObject;
    }

    private Object buildFieldValue(List<MetaDataResponseData> fields, String oldField) {
        if (!CollectionUtils.isEmpty(fields)) {
            for (MetaDataResponseData field : fields) {
                if (oldField.equals(field.getData_name())) {
                    return field;
                }
                this.buildFieldValue(field.getField(), oldField);
            }
        }
        return new MetaDataResponseData();
    }

    private void buildField(List<MetaDataResponseData> fields, Statistic statistic, Map<String, Object> fieldValues, Map<String, Map<String, Object>> filedName2BizType) {
        if (!CollectionUtils.isEmpty(fields)) {
            for (MetaDataResponseData field : fields) {
                if (statistic.getNewField().equals(field.getData_name())) {
                    MetaDataResponseData data = (MetaDataResponseData)fieldValues.get(statistic.getNewField());
                    if (data.getData_type() != null) {
                        field.buildMetaDataResponseData(data);
                    }
                    if (org.springframework.util.StringUtils.hasLength((String)statistic.getType())) {
                        if ("number".equals(statistic.getType())) {
                            field.setData_type("numeric");
                        } else {
                            field.setData_type(statistic.getType());
                        }
                    }
                    if (org.springframework.util.StringUtils.hasLength((String)statistic.getPercent())) {
                        field.setPercent(statistic.getPercent());
                    }
                    field.setDescription(statistic.getTitle());
                } else {
                    this.buildField((List<MetaDataResponseData>)field.getField(), statistic, fieldValues, filedName2BizType);
                }
                if (!Objects.nonNull(filedName2BizType) || !filedName2BizType.containsKey(field.getData_name())) continue;
                Map<String, Object> stringObjectMap = filedName2BizType.get(field.getData_name());
                field.setDecimal(stringObjectMap.containsKey("decimal") ? String.valueOf(stringObjectMap.get("decimal")) : field.getDecimal());
                field.setPercent(stringObjectMap.containsKey("showType") ? String.valueOf(stringObjectMap.get("showType")) : field.getPercent());
            }
        }
    }

    private Object buildDataByQuerySchema(BizParams bizParams, ReportScene reportScene) throws Exception {
        Boolean dataEnd = false;
        JSONArray totalJsonArray = new JSONArray();
        List bmdMetaList = new ArrayList(8);
        Map<String, Object> queryLogic = this.convertLogicToSchema(bizParams.getQuerySchema());
        while (Boolean.TRUE.equals(dataEnd == false)) {
            BasePage basePage = (BasePage)queryLogic.get("page");
            Map bmdData = org.springframework.util.StringUtils.hasLength((String)reportScene.getDataSource()) ? DatasourceProxyInitialize.getData((String)reportScene.getDataSource(), queryLogic, (String)bizParams.getTenantId(), (String)bizParams.getLocale(), (String)bizParams.getUserToken(), (String)((String)DWServiceContext.getContext().getRequestHeader().get("routerKey"))) : Collections.EMPTY_MAP;
            if (200 != Integer.valueOf(String.valueOf(bmdData.get("code")))) {
                return null;
            }
            bmdData = (Map)bmdData.get("data");
            if (CollectionUtils.isEmpty(bmdMetaList)) {
                bmdMetaList = JsonUtil.listMapToListT((List)((List)bmdData.get("meta")), BmdMeta.class);
                bizParams.setBmdMetaList(bmdMetaList);
            }
            Integer totalSize = bmdData.get("total") == null ? Integer.valueOf("0") : (Integer)bmdData.get("total");
            totalJsonArray.addAll((Collection)bmdData.get("data"));
            if (totalJsonArray.size() >= totalSize) {
                dataEnd = true;
                continue;
            }
            basePage.setPageNo(Integer.valueOf(basePage.getPageNo() + 1));
            queryLogic.put("page", basePage);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)totalJsonArray);
        return jsonObject;
    }

    private Object buildPullingData(BizParams bizParams, String senceCode, Object pullingData, String actionId) {
        Map executionRecast = bizParams.getRecast();
        String scAndActionId = senceCode.concat(actionId);
        if (executionRecast != null && executionRecast.keySet().contains(scAndActionId) && executionRecast.get(scAndActionId) != null) {
            pullingData = this.recastPullingData(pullingData, (List)executionRecast.get(scAndActionId), bizParams, actionId);
        }
        return pullingData;
    }

    private Object recastPullingData(Object pullingData, List<Map<String, Object>> inputRecasts, BizParams bizParams, String actionId) {
        Map data;
        if (CollectionUtils.isEmpty(inputRecasts)) {
            return pullingData;
        }
        Boolean hasOthers = false;
        Boolean filterEmpty = true;
        for (Map<String, Object> recast : inputRecasts) {
            if (!"filter".equals(recast.get("name"))) {
                hasOthers = true;
                continue;
            }
            if (recast.get("condition") != null) {
                Map condition = (Map)recast.get("condition");
                if (condition.get("items") != null) {
                    List items = (List)condition.get("items");
                    if (CollectionUtil.isEmpty((Collection)items)) {
                        filterEmpty = true;
                        continue;
                    }
                    filterEmpty = false;
                    continue;
                }
                filterEmpty = true;
                continue;
            }
            filterEmpty = true;
        }
        if (Boolean.TRUE.equals(hasOthers == false && filterEmpty != false)) {
            return pullingData;
        }
        if (pullingData == null || ((Map)pullingData).get("data") == null) {
            return pullingData;
        }
        Long startTime = System.currentTimeMillis();
        if (!CollectionUtils.isEmpty(inputRecasts)) {
            Object recastData = this.executeEngineService.postRunTrans(inputRecasts, pullingData, bizParams.getTenantId(), bizParams.getLocale(), bizParams.getUserToken(), bizParams.getMessageId(), actionId);
            data = TranCovertUtils.buildPullingData((Object)Optional.ofNullable(recastData).map(rd -> ((Map)rd).get("data")).orElse(Lists.newArrayListWithCapacity((int)0)));
            if (Objects.nonNull(recastData) && recastData instanceof Map && Objects.nonNull(data)) {
                ((Map)recastData).putAll(data);
            }
            LogUtils.buildAgileDataEngineRecastLog((String)"postRunTrans", (String)"U.ADE.501.0130", (String)("\u8017\u65f6\u65f6\u95f4\uff1a" + String.valueOf(System.currentTimeMillis() - startTime)), (String)JSON.toJSONString((Object)data), (String)"");
            return recastData;
        }
        data = (Map)pullingData;
        Long endTime = System.currentTimeMillis();
        Long time = endTime - startTime;
        if (data instanceof Map && data.get("data") instanceof List) {
            if (((List)data.get("data")).size() > 50) {
                LOGGER.error("agiledata_ade_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6{}\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a:{}", (Object)time, (Object)("total:" + ((List)data.get("data")).size()));
            } else {
                LOGGER.error("agiledata_ade_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6{}\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a:{}", (Object)time, (Object)JsonUtil.getJsonString((Object)data));
            }
        }
        return data;
    }

    private Map<String, Object> convertLogicToSchema(Map<String, Object> queryLogic) {
        BasePage basePage = BasePage.createDefaultPage();
        if (queryLogic.containsKey("page")) {
            basePage = (BasePage)JsonUtil.getObject((String)JsonUtil.getJsonString((Object)queryLogic.get("page")), BasePage.class);
        }
        if (basePage.getPageSize() == null || basePage.getPageSize() == 0) {
            basePage.setPageSize(Integer.valueOf(10000));
        }
        queryLogic.put("page", basePage);
        if (!queryLogic.containsKey("params")) {
            queryLogic.put("params", new JSONArray());
        }
        return queryLogic;
    }

    private List<DigiwinIamUserRole> getUser(Context context, BizParams bizParams) {
        ArrayList<DigiwinIamUserRole> userInRoleList = new ArrayList<DigiwinIamUserRole>(4);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String logRoleId = "";
        if (context.getScene() != null && context.getScene().getWho() != null) {
            for (BaseEntity function : context.getScene().getWho()) {
                if ("function".equals(function.getType())) {
                    String roleId = (String)function.getValue();
                    logRoleId = roleId + ",";
                    params.put("roleId", roleId);
                    params.put("pageNum", 1);
                    params.put("pageSize", 9999);
                    try {
                        userInRoleList.addAll(this.iamService.getUserInRoleList(bizParams.getUserToken(), bizParams.getLocale(), bizParams.getTenantId(), params));
                    }
                    catch (Exception e) {
                        LOGGER.error("\u901a\u8fc7\u79df\u6237\u89d2\u8272\u83b7\u53d6\u7528\u6237\u5217\u8868\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Object)e.getMessage());
                    }
                    continue;
                }
                if (!"user".equals(function.getType())) continue;
                userInRoleList.addAll(JsonUtil.getList((String)JsonUtil.getJsonString((Object)function.getValue()), DigiwinIamUserRole.class));
            }
        }
        if (CollectionUtils.isEmpty(userInRoleList)) {
            LOGGER.error("\u901a\u8fc7\u79df\u6237\u89d2\u8272\u83b7\u53d6\u7528\u6237\u5217\u8868\u5931\u8d25\uff0croleId=" + logRoleId + "\u79df\u6237ID\uff1a" + bizParams.getTenantId());
        }
        return userInRoleList;
    }

    public Snapshot buildContextBySnapshot(Context context, ReportScene reportScene, String snapshotId) {
        BizParams bizParams = context.getBizParams();
        List<DigiwinIamUserRole> userInRoleList = this.getUser(context, bizParams);
        Scene scene = context.getScene();
        if (CollectionUtils.isEmpty(userInRoleList)) {
            return new Snapshot();
        }
        scene.processingWho(scene, userInRoleList);
        Snapshot snapshot = new Snapshot();
        if (!org.springframework.util.StringUtils.hasLength((String)snapshotId)) {
            snapshotId = snapshot.setSnapshotId(bizParams.getTenantId(), bizParams.getRuleId() == null ? "" : bizParams.getRuleId(), CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
        }
        snapshot.setSnapshotId(snapshotId);
        List pullDatas = context.getPullData();
        PullData pullData = (PullData)pullDatas.get(0);
        String actionId = pullData.getActionId();
        scene.processingWhat(scene, "periodExpress", actionId);
        if (StringUtil.isBlank((String)actionId)) {
            context.setCode("empty_actionId");
            snapshot.setContext(context);
            return snapshot;
        }
        HashMap<String, Object> sysActionParam = new HashMap(4);
        if (context.getSysParam() != null) {
            sysActionParam = context.getSysParam();
        }
        List<PullData> newPullDatas = this.buildDataByActionId(actionId, bizParams, sysActionParam, reportScene);
        context.setPullData(newPullDatas);
        snapshot.setContext(context);
        return snapshot;
    }

    public String saveDataSnapshot(String tenantId, String locale, String userToken, Snapshot snapshot) {
        return this.dataSnapshotService.saveDataSnapshot(tenantId, locale, userToken, snapshot);
    }

    public Snapshot buildContextBySpecial(Context context, ReportScene reportScene, String snapshotId) {
        BizParams bizParams = context.getBizParams();
        Scene scene = context.getScene();
        Snapshot snapshot = new Snapshot();
        if (!org.springframework.util.StringUtils.hasLength((String)snapshotId)) {
            snapshotId = snapshot.setSnapshotId(bizParams.getTenantId(), bizParams.getRuleId() == null ? "" : bizParams.getRuleId(), CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
        }
        snapshot.setSnapshotId(snapshotId);
        List pullDatas = context.getPullData();
        ArrayList<PullData> newPullDatas = new ArrayList<PullData>(4);
        PullData pullData = (PullData)pullDatas.get(0);
        String actionId = pullData.getActionId();
        scene.processingWhat(scene, "realTimeQuery", actionId);
        if (!CollectionUtils.isEmpty((Map)bizParams.getRecastDefine()) && bizParams.getRecastDefine().get(actionId) != null) {
            PullData newPullData = new PullData();
            List recastDefine = (List)bizParams.getRecastDefine().get(actionId);
            if (!CollectionUtils.isEmpty((Collection)recastDefine)) {
                String startTime = DateTimeUtil.getTodayTimeUseDefaultPattern();
                ArrayList data = (ArrayList)JsonUtil.getList((String)JsonUtil.getJsonString(((Map)recastDefine.get(0)).get("data")), JSONObject.class);
                SceneShow show = (SceneShow)JsonUtil.getObject((String)JsonUtil.getJsonString(((Map)recastDefine.get(0)).get("show")), SceneShow.class);
                if (!ObjectUtils.isEmpty((Object)data)) {
                    HashMap<String, ArrayList> newData = new HashMap<String, ArrayList>(1);
                    newData.put("data", data);
                    HashMap<String, ArrayList> pullingData = newData;
                    HashMap<String, String> params = new HashMap<String, String>(3);
                    params.put("tenantId", bizParams.getTenantId());
                    params.put("actionId", "");
                    params.put("data", (String)((Map)pullingData).get("data"));
                    Object metadata = this.executeEngineService.getPullData(bizParams.getUserToken(), bizParams.getLocale(), bizParams.getTenantId(), bizParams.getMessageId(), params);
                    newPullData.setMetadata(this.buildGptMetadata(metadata, show, data, bizParams.getShowDefine()));
                    newPullData.setData(pullingData);
                    newPullData.setActionId(actionId);
                    newPullData.setStartTime(startTime);
                    newPullData.setEndTime(DateTimeUtil.getTodayTimeUseDefaultPattern());
                    newPullDatas.add(newPullData);
                }
            }
        }
        context.setPullData(newPullDatas);
        context.getBizParams().setRequestType("metricInstant");
        snapshot.setContext(context);
        return snapshot;
    }

    private Object getPullDataByActionId(String actionId, String senceCode, BizParams bizParams, ActionParams findActionParam, Map<String, Object> sysParam, Object defaultRecasts) {
        Map executionRecast;
        HashMap<String, Object> pullDataParams = new HashMap<String, Object>(5);
        pullDataParams.put("tenantId", bizParams.getTenantId());
        pullDataParams.put("actionId", actionId);
        Map pullingParams = new HashMap(2);
        if (!CollectionUtils.isEmpty((Map)bizParams.getRecast()) && (executionRecast = bizParams.getRecast()).keySet().contains(senceCode) && executionRecast.get(senceCode) != null) {
            Map recastAndPullingParam = Context.buildParam(executionRecast.get(senceCode), (Map)bizParams.getParam(), (ActionParams)findActionParam, (Object)defaultRecasts, (BizParams)bizParams, (List)bizParams.getEocMaps());
            pullingParams = (Map)recastAndPullingParam.get("param");
            bizParams.setDataDescription((Map)recastAndPullingParam.get("dataDescription"));
            executionRecast.put(senceCode.concat(actionId), recastAndPullingParam.get("recast"));
        }
        if (!CollectionUtils.isEmpty((Map)bizParams.getDataDescription())) {
            pullDataParams.put("dataDescription", bizParams.getDataDescription());
        } else {
            pullDataParams.put("dataDescription", Maps.newHashMapWithExpectedSize((int)4));
        }
        HashMap<String, List<Object>> permissionMap = new HashMap<String, List<Object>>(4);
        permissionMap.put("rows", this.buildPermissionsParam(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), "appData", actionId, bizParams.getSceneAppCode(), bizParams));
        ((Map)pullDataParams.get("dataDescription")).put("permissions", permissionMap);
        ((Map)pullDataParams.get("dataDescription")).put("productLineInfo", bizParams.getProductLineInfo());
        pullDataParams.put("sysParam", sysParam);
        pullDataParams.put("param", pullingParams);
        if (bizParams.isHasScreen()) {
            ArrayList results = new ArrayList();
            Optional.ofNullable((List)bizParams.getScreen().get("eocMaps")).ifPresent(list -> list.stream().forEach(item -> {
                Map<String, Object> collect = item.entrySet().stream().collect(Collectors.toMap(e -> TRANS_MAP.getOrDefault(e.getKey(), (String)e.getKey()), e -> e.getValue()));
                results.add(collect);
            }));
            Optional.ofNullable((Map)bizParams.getScreen().get("fixedParams")).ifPresent(child -> {
                if (CollectionUtil.isNotEmpty((Collection)results)) {
                    ((Map)results.get(0)).putAll(child);
                }
            });
            pullingParams.putAll(!CollectionUtils.isEmpty(results) ? (Map)results.get(0) : new HashMap(1));
        }
        pullDataParams.put("eocMaps", bizParams.getEocMaps() == null ? Collections.emptyMap() : bizParams.getEocMaps());
        pullDataParams.put("roles", bizParams.getRoles() == null ? Collections.emptyList() : bizParams.getRoles());
        bizParams.getParam().putAll(pullingParams);
        return this.executeEngineService.getPullData(bizParams.getUserToken(), bizParams.getLocale(), bizParams.getTenantId(), bizParams.getMessageId(), pullDataParams);
    }

    private void permissionCheck(BizParams bizParams) {
        CompletionStage resultCompletableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.iamService.getRoleListByUser(bizParams.getTenantId(), bizParams.getLocale(), bizParams.getUserToken(), bizParams.getUserId())).thenAcceptBoth(CompletableFuture.supplyAsync(() -> this.eocService.getUserInfoByIds(bizParams.getTenantId(), bizParams.getLocale(), bizParams.getUserToken(), Arrays.asList(bizParams.getUserId()))), (r1, r2) -> {
            List roleIds = r1.stream().peek(e -> {
                if ("superadmin".equals(e.getId())) {
                    bizParams.setSuperAdmin(true);
                }
                if (StringUtil.isBlank((String)bizParams.getTenantSid()) && StringUtil.isNotBlank((String)e.getTenantSid())) {
                    bizParams.setTenantSid(e.getTenantSid());
                }
            }).map(m -> m.getId()).collect(Collectors.toList());
            ArrayList iamUserCompanyIds = new ArrayList();
            List iamEocMaps = r2.stream().map(DigiwinEocUserInfo::getDepts).flatMap(Collection::stream).peek(i -> {
                if (Objects.nonNull(i.get("corpId"))) {
                    iamUserCompanyIds.add((String)i.get("corpId"));
                }
            }).map(m -> {
                HashMap newMap = new HashMap(4);
                newMap.put("eocCompanyId", m.get("corpId"));
                newMap.put("eocCompanyName", m.get("corpName"));
                return newMap;
            }).collect(Collectors.toList());
            if (bizParams.isSuperAdmin()) {
                List compInfos = this.eocService.getCompInfoBySuperAdmin(bizParams.getTenantId(), bizParams.getLocale(), bizParams.getUserToken());
                iamEocMaps.clear();
                iamUserCompanyIds.clear();
                compInfos.stream().forEach(e -> {
                    HashMap<String, String> newMap = new HashMap<String, String>(4);
                    newMap.put("eocCompanyId", e.getId());
                    newMap.put("eocCompanyName", e.getName());
                    iamEocMaps.add(newMap);
                    iamUserCompanyIds.add(e.getId());
                });
            }
            if (!bizParams.isDataSetV2().booleanValue()) {
                List edgeDBTypeInfo = this.edgeDataService.getEdgeDBTypeInfo(bizParams.getTenantId(), bizParams.getLocale(), bizParams.getUserToken(), bizParams.getTenantSid());
                bizParams.setEdgeInfo(edgeDBTypeInfo);
                edgeDBTypeInfo.stream().findAny().ifPresent(info -> {
                    if (!"single".equalsIgnoreCase((String)info.get("chatBIMode"))) {
                        bizParams.setMultiDataSource(true);
                    }
                });
            }
            LOGGER.info("AdeServiceImpl#fillRoleAndEocMaps remote response eocMaps \uff1a{}", iamEocMaps);
            bizParams.setRoles(roleIds);
            if (!CollectionUtil.isEmpty((Collection)bizParams.getEocMaps())) {
                List intersectionMaps = bizParams.getEocMaps().stream().filter(m -> iamUserCompanyIds.contains((String)m.get("eocCompanyId"))).collect(Collectors.toList());
                bizParams.setEocMaps(intersectionMaps);
            } else {
                bizParams.setEocMaps(iamEocMaps);
            }
            LOGGER.info("AdeServiceImpl#fillRoleAndEocMaps roles :{}, eocMaps \uff1a{}", roleIds, (Object)bizParams.getEocMaps());
        })).thenRunAsync(() -> {
            if (!bizParams.isDataSetV2().booleanValue()) {
                this.fillProductLineInfo(bizParams);
                if (bizParams.isMultiDataSource() && CollectionUtil.isEmpty((Collection)bizParams.getEocMaps()) || bizParams.isSuperAdmin() || !SCENE_FN_SWITCH) {
                    return;
                }
            } else if (bizParams.isSuperAdmin() || !SCENE_FN_SWITCH) {
                return;
            }
            List resultL = this.themeMapService.queryPermissionSceneByCode(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), (List)StructureModel.handleQueryPermissionParam((BizParams)bizParams), bizParams.getUserId());
            LOGGER.info("AdeServiceImpl#fillRoleAndEocMaps km scene permission reulst\uff1a{}", (Object)resultL);
            resultL.stream().forEach(m -> {
                if (Objects.nonNull(bizParams.getSceneCode()) && bizParams.getSceneCode().equalsIgnoreCase((String)m.get("code")) || Objects.nonNull(bizParams.getMetricIds()) && bizParams.getMetricIds().contains((String)m.get("code")) || Objects.nonNull(bizParams.getDatasetIds()) && bizParams.getDatasetIds().contains((String)m.get("code"))) {
                    bizParams.setHasAuthorized(((Boolean)m.get("isAuthorized")).booleanValue());
                    bizParams.setPatternArguments(Arrays.asList(Optional.ofNullable((Map)m.get("language")).map(item -> (Map)item.get("sceneTitle")).map(p -> (String)p.get(bizParams.getLocale())).orElse(null == m.get("sceneTitle") ? String.valueOf(m.get("sceneTitle")) : "")));
                }
            });
        });
        try {
            ((CompletableFuture)resultCompletableFuture).get(12L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.error("AdeServiceImpl#fillRoleAndEocMaps overtime");
        }
    }

    private void fillProductLineInfo(BizParams bizParams) {
        if (CollectionUtils.isEmpty((Collection)bizParams.getEdgeInfo())) {
            bizParams.setProductLineInfo(null);
            LOGGER.error("\u5730\u7aef\u65e0\u4ea7\u54c1\u4fe1\u606f");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)bizParams.getProductLineInfo())) {
            HashMap productLineInfo2 = Maps.newHashMap();
            productLineInfo2.put("productLine", "ERP");
            bizParams.setProductLineInfo((List)Lists.newArrayList((Object[])new Map[]{productLineInfo2}));
        }
        AtomicReference<Boolean> isHasProductLine = new AtomicReference<Boolean>(true);
        Map<String, List<Map>> productCodes = bizParams.getEdgeInfo().stream().collect(Collectors.groupingBy(map -> MapUtils.getString((Map)map, (Object)"chatBIProductLine", (String)"")));
        List<Object> companyList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)bizParams.getEocMaps())) {
            companyList = bizParams.getEocMaps().stream().map(map -> MapUtils.getString((Map)map, (Object)"eocCompanyId")).collect(Collectors.toList());
        }
        ArrayList missingProductLineInfos = Lists.newArrayList();
        ArrayList hasProductLineInfos = Lists.newArrayList();
        ArrayList finalCompanyList = companyList;
        bizParams.getProductLineInfo().stream().forEach(productLineInfo -> {
            boolean isNotExist;
            String productCodeLine = MapUtils.getString((Map)productLineInfo, (Object)"productLine");
            List productLineInfoList = (List)productCodes.get(productCodeLine);
            if (CollectionUtils.isEmpty((Collection)productLineInfoList)) {
                isHasProductLine.set(false);
                missingProductLineInfos.add(productCodeLine);
                return;
            }
            if (bizParams.isMultiDataSource() && !(isNotExist = productLineInfoList.stream().anyMatch(product -> finalCompanyList.contains(MapUtils.getString((Map)product, (Object)"chatBIEocCompanyId"))))) {
                isHasProductLine.set(false);
                missingProductLineInfos.add(productCodeLine);
                LOGGER.error("\u5730\u7aef\u65e0\u6b64\u516c\u53f8\u4fe1\u606f");
                return;
            }
            productLineInfoList.stream().forEach(item -> {
                HashMap productLineInfoMap = Maps.newHashMap();
                productLineInfoMap.put("productLine", MapUtils.getString((Map)item, (Object)"chatBIProductLine"));
                productLineInfoMap.put("productCode", MapUtils.getString((Map)item, (Object)"chatBIProductCode"));
                productLineInfoMap.put("dbType", MapUtils.getString((Map)item, (Object)"dbType"));
                hasProductLineInfos.add(productLineInfoMap);
            });
        });
        if (!isHasProductLine.get().booleanValue()) {
            LOGGER.error("\u7f3a\u5931\u7684\u4ea7\u54c1\u6743\u9650:{}", (Object)JsonUtil.getJsonString((Object)missingProductLineInfos));
            bizParams.setProductLineInfo(null);
            bizParams.setMissingProductLineInfos((List)missingProductLineInfos);
            return;
        }
        bizParams.setProductLineInfo((List)hasProductLineInfos);
    }

    public Snapshot buildScreenContextBySnapshot(Context context, ReportScene reportScene, String snapshotId) {
        BizParams bizParams = context.getBizParams();
        if (StringUtil.isBlank((String)bizParams.getRequestPerson())) {
            bizParams.setRequestPerson((String)DWServiceContext.getContext().getProfile().get("userId"));
            bizParams.setRequestPersonName((String)DWServiceContext.getContext().getProfile().get("username"));
        }
        Scene scene = Optional.ofNullable(context.getScene()).orElseGet(() -> {
            Scene scene1 = new Scene();
            context.setScene(scene1);
            return scene1;
        });
        Snapshot snapshot = new Snapshot();
        if (!org.springframework.util.StringUtils.hasLength((String)snapshotId)) {
            snapshotId = snapshot.setSnapshotId(bizParams.getTenantId(), bizParams.getRuleId() == null ? "" : bizParams.getRuleId(), CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
        }
        snapshot.setSnapshotId(snapshotId);
        List pullDatas = context.getPullData();
        List<Object> newPullDatas = new ArrayList<PullData>(4);
        PullData pullData = (PullData)pullDatas.get(0);
        String actionId = pullData.getActionId();
        scene.processingWhat(scene, "realTimeQuery", actionId);
        HashMap<String, Object> sysActionParam = new HashMap(4);
        if (context.getSysParam() != null) {
            sysActionParam = context.getSysParam();
        }
        if (!CollectionUtil.isEmpty((Map)bizParams.getQuerySchema())) {
            PullData newPullData = this.getBmdData(bizParams, reportScene);
            if (newPullData == null) {
                context.setCode("bmd_service_error");
                snapshot.setContext(context);
                return snapshot;
            }
            newPullDatas.add(newPullData);
        } else {
            if (StringUtil.isBlank((String)actionId)) {
                context.setCode("empty_actionId");
                snapshot.setContext(context);
                return snapshot;
            }
            newPullDatas = this.buildDataByActionId(actionId, bizParams, sysActionParam, reportScene);
            if (!CollectionUtils.isEmpty(newPullDatas) && ((PullData)newPullDatas.get(0)).getErrorCodeDto() != null) {
                return this.buildErrorSnapshot(context, snapshot, newPullDatas);
            }
        }
        context.setPullData(newPullDatas);
        snapshot.setContext(context);
        return snapshot;
    }

    private Snapshot buildErrorSnapshot(Context context, Snapshot snapshot, List<PullData> newPullDatas) {
        context.setErrorCode(newPullDatas.get(0).getErrorCodeDto().getErrorCode());
        context.setErrorMessage(newPullDatas.get(0).getErrorCodeDto().getMessage());
        snapshot.setContext(context);
        return snapshot;
    }

    private List<Object> buildPermissionsParam(String tenantId, String userToken, String locale, String appData, String actionId, String sysId, BizParams bizParams) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (bizParams.isDataSetV2().booleanValue() || bizParams.isDataSetV1().booleanValue()) {
            List datasetIds = bizParams.getDatasetIds();
            for (String datasetId : datasetIds) {
                if (!SCENE_FN_SWITCH) continue;
                list.add(Optional.ofNullable(this.iamService.queryRowDataPermission(tenantId, userToken, locale, appData, datasetId, sysId, "", StructureModel.DATASET.getModel())).filter(item -> item.containsKey("rowPermission")).map(item -> item.get("rowPermission")).orElse(new HashMap(1)));
            }
        } else {
            HashMap productLineInfo = Maps.newHashMap();
            if (CollectionUtils.isEmpty((Collection)bizParams.getProductLineInfo())) {
                productLineInfo.put("productLine", "ERP");
                bizParams.setProductLineInfo((List)Lists.newArrayList((Object[])new Map[]{productLineInfo}));
            }
            for (Map stringObjectMap : bizParams.getProductLineInfo()) {
                HashMap rowItems = Maps.newHashMapWithExpectedSize((int)8);
                String pdCode = (String)stringObjectMap.get("productLine");
                rowItems.put("productCode", stringObjectMap.get("productCode"));
                rowItems.put("productLine", pdCode);
                if (SCENE_FN_SWITCH) {
                    rowItems.put("row", Optional.ofNullable(this.iamService.queryRowDataPermission(tenantId, userToken, locale, appData, actionId, sysId, pdCode, StructureModel.METRIC.getModel())).filter(item -> item.containsKey("rowPermission")).map(item -> item.get("rowPermission")).orElse(new HashMap(1)));
                }
                list.add(rowItems);
            }
        }
        return list;
    }

    public Snapshot buildMetricContext(Context context, String snapshotId, String actionId, List<KMMetricData> kmMetricDataList) {
        Snapshot snapshot = null;
        try {
            Object metricData;
            snapshot = this.snapshotParamsPreprocessing(context, snapshotId);
            BizParams bizParams = context.getBizParams();
            List solutionStepItems = context.getBizParams().getSolutionStepItems();
            if (CollectionUtils.isEmpty((Collection)solutionStepItems)) {
                context.setCode("empty_solutionStep");
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"solutionStepItems_is_empty", (String)"U.ADE.501.2000", (String)JSON.toJSONString((Object)solutionStepItems), (String)"\u6267\u884c\u6b65\u9aa4\u4e3a\u7a7a", (String)"\u8bf7\u68c0\u67e5\u8bed\u4e49\u89e3\u6790\u662f\u5426\u6b63\u786e");
                return snapshot;
            }
            SolutionStepItem solutionStepItem = (SolutionStepItem)solutionStepItems.get(solutionStepItems.size() - 1);
            if (bizParams.isMultiDataSource() && CollectionUtil.isEmpty((Collection)bizParams.getEocMaps())) {
                context.setCode("user_permissions_beyond");
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"userPermissionsBeyond", (String)"U.ADE.501.0111", (String)JSON.toJSONString((Object)bizParams.getMissingProductLineInfos()), (String)"\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5728\u9f0e\u6377\u4e91\u914d\u7f6e\u90e8\u95e8\u6216\u8005\u516c\u53f8\u522b", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u90e8\u95e8\u6216\u8005\u516c\u53f8\u522b\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                return snapshot;
            }
            Boolean isDcpDS = Optional.ofNullable(context.getSysParam()).map(e -> e.get(actionId)).map(m -> ((Map)m).get("dataSource")).map(str -> "dcp".equalsIgnoreCase((String)str)).orElse(true);
            if (isDcpDS.booleanValue() && CollectionUtils.isEmpty((Collection)bizParams.getProductLineInfo())) {
                if (CollectionUtils.isEmpty((Collection)bizParams.getMissingProductLineInfos())) {
                    context.setCode("user_product_ground_beyond");
                } else {
                    context.setCode("user_product_beyond");
                    ArrayList productLineInfos = Lists.newArrayList();
                    productLineInfos.add(String.join((CharSequence)"/", bizParams.getMissingProductLineInfos()));
                    context.setPatternArguments((List)productLineInfos);
                }
                LogUtils.buildAgileDataEngineLog((String)"getMissingProductLineInfos", (String)"U.ADE.501.0110", (String)JSON.toJSONString((Object)bizParams.getMissingProductLineInfos()), (String)"\u5730\u7aefMQ\u4e0d\u5728\u7ebf\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u7f51\u7edc\u95ee\u9898\u6216MQ\u670d\u52a1\u5b95\u673a/\u672a\u542f\u52a8", (String)"\u8bf7\u7b49\u5f851\u5206\u949f\u540e\u91cd\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u4f9d\u7136\u5b58\u5728\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406.");
                snapshot.setContext(context);
                return snapshot;
            }
            if (!bizParams.isSuperAdmin() && !bizParams.isHasAuthorized() && SCENE_FN_SWITCH) {
                context.setCode("user_metric_permission_error");
                context.setPatternArguments(bizParams.getPatternArguments());
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"user_metric_permission_error", (String)"U.ADE.501.0112", (String)JSON.toJSONString((Object)bizParams.getMissingProductLineInfos()), (String)"\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u5bf9\u5e94\u6307\u6807", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5bf9\u5e94\u6307\u6807\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                return snapshot;
            }
            if (bizParams.isDataSetV1().booleanValue()) {
                ColumnPermissionValidatorUtil.validateColumnPermissions((IamService)this.iamService, (Context)context, kmMetricDataList, (BizParams)bizParams, (List)solutionStepItems, (Snapshot)snapshot);
                if (!org.springframework.util.StringUtils.isEmpty((Object)context.getCode())) {
                    LogUtils.buildAgileDataEngineLog((String)"userColPermissionsBeyond", (String)"U.ADE.501.2007", (String)"", (String)"\u5217\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5728\u9f0e\u6377\u4e91\u914d\u7f6e\u90e8\u95e8\u6216\u8005\u516c\u53f8\u522b", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5217\u6743\u9650\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                    return snapshot;
                }
            }
            if ((metricData = this.queryTransDataByMetric(context, solutionStepItems, actionId, "getData")) == null || metricData instanceof ErrorCodeDto || metricData instanceof Map && CollectionUtils.isEmpty((Map)((Map)metricData)) || CollectionUtil.isEmpty((Collection)ChartConvertUtil.parseDataList((Object)metricData)) || ((Map)ChartConvertUtil.parseDataList((Object)metricData).get(0)).isEmpty()) {
                if (metricData == null) {
                    context.setCode("empty_metric");
                    LogUtils.buildAgileDataEngineLog((String)"queryTransDataByMetric", (String)"U.ADE.501.2008", (String)actionId, (String)"\u53d6\u6570\u5f15\u64ce\u5f02\u5e38,", (String)"1.\u6253\u5f00\u6570\u636e\u6d41\u67e5\u8be2\u8282\u70b9\u7684\u67e5\u8be2\u65b9\u6848\uff0c\u8c03\u5927\u5206\u9875\u6570\u3002\n2.\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86\u95ee\u53e5\u6240\u9700\u7684\u65f6\u95f4\u8303\u56f4\u3002\n3.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                } else if (CollectionUtil.isEmpty((Collection)ChartConvertUtil.parseDataList((Object)metricData))) {
                    PullData pullData = new PullData();
                    pullData.setActionId(actionId);
                    context.setPullData(Collections.singletonList(pullData));
                } else if (metricData instanceof ErrorCodeDto && "P.EE.500.0011".equalsIgnoreCase(((ErrorCodeDto)metricData).getErrorCode())) {
                    context.setCode("execute_engine_over_data_limit");
                    LogUtils.buildAgileDataEngineLog((String)"queryTransDataByMetric", (String)"U.ADE.501.0104", (String)actionId, (String)"\u53d6\u6570\u5f15\u64ce\u5f02\u5e38,".concat(((ErrorCodeDto)metricData).getMessage()), (String)"1.\u6253\u5f00\u6570\u636e\u6d41\u67e5\u8be2\u8282\u70b9\u7684\u67e5\u8be2\u65b9\u6848\uff0c\u8c03\u5927\u5206\u9875\u6570\u3002\n2.\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86\u95ee\u53e5\u6240\u9700\u7684\u65f6\u95f4\u8303\u56f4\u3002\n3.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                } else {
                    context.setCode("execute_engine_get_data_error");
                    LogUtils.buildAgileDataEngineLog((String)"queryTransDataByMetric", (String)"U.ADE.501.2008", (String)actionId, (String)"\u53d6\u6570\u5f15\u64ce\u5f02\u5e38,", (String)"1.\u6253\u5f00\u6570\u636e\u6d41\u67e5\u8be2\u8282\u70b9\u7684\u67e5\u8be2\u65b9\u6848\uff0c\u8c03\u5927\u5206\u9875\u6570\u3002\n2.\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86\u95ee\u53e5\u6240\u9700\u7684\u65f6\u95f4\u8303\u56f4\u3002\n3.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                }
                snapshot.setContext(context);
                return snapshot;
            }
            if (Objects.nonNull(metricData) && metricData instanceof Map) {
                Optional.ofNullable(context.getDebug()).filter(CollectionUtil::isNotEmpty).ifPresent(debugInfos -> {
                    if (((Map)metricData).containsKey("debug")) {
                        Map debugInfoMap = (Map)((Map)metricData).remove("debug");
                        ((MetricDebugInfo)debugInfos.get(0)).setMetricRunningList(this.postProcessMetricName((List)debugInfoMap.get("metricRunningInfo"), bizParams.getMetricList()));
                        ((MetricDebugInfo)debugInfos.get(0)).setMetricRunningDetail((Map)debugInfoMap.get("metricRunningDetail"));
                    }
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)bizParams.getMetricList())) {
                bizParams.setMetricList(bizParams.getMetricList().stream().map(map -> {
                    HashMap metricItemMap = Maps.newHashMapWithExpectedSize((int)4);
                    metricItemMap.put("metricId", map.get("metricId"));
                    metricItemMap.put("metricName", map.get("metricName"));
                    return metricItemMap;
                }).collect(Collectors.toList()));
            }
            PullData newPullData = new PullData();
            newPullData.setDataTag(this.buildDatatagParam(context));
            Object metadata = this.buildMetaData(solutionStepItem, kmMetricDataList, context, actionId);
            newPullData.setMetadata(metadata);
            newPullData.setData(metricData);
            newPullData.setActionId(actionId);
            newPullData.setMetricList(bizParams.getMetricList());
            Optional.ofNullable((List)((Map)bizParams.getShowDefine()).get("showType")).ifPresent(sts -> sts.stream().forEach(st -> Optional.ofNullable((List)st.get("type")).ifPresent(m -> m.stream().forEach(mchild -> mchild.put("title", Optional.ofNullable((Map)mchild.get("language")).map(lchild -> ((Map)lchild.get("title")).get(bizParams.getLocale())).orElse(mchild.get("title")))))));
            context.setPullData(Collections.singletonList(newPullData));
            snapshot.setContext(context);
            ChartConvertUtil.handleChartConvert((DmcService)this.dmcService, (Context)context, (BizParams)bizParams, (PullData)newPullData, (Snapshot)snapshot);
        }
        catch (Exception e2) {
            if (context.getBizParams().isDataSetV1().booleanValue()) {
                LOGGER.error("Analyzer#doAnalyzeDataset build context error: {}", (Object)e2.getMessage());
                LogUtils.buildAgileDataEngineLog((String)"doAnalyzeDataset", (String)"U.ADE.501.xxxx", (String)JSON.toJSONString(kmMetricDataList), (String)("\u7ec4\u88c5\u6570\u636e\u96c6\u6570\u636e\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u53d6\u6570\u7aef\u8fd0\u884c\u8d85\u65f6\u6240\u81f4\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e2.getMessage())), (String)"1.\u6839\u636e\u9519\u8bef\u4fe1\u606f\uff0c\u68c0\u67e5SQL\u8bed\u53e5\u6d89\u53ca\u7684\u6a21\u578b\u3001\u6570\u636e\u96c6\u3001\u6570\u636e\u5e93\u8868\u548c\u5b57\u6bb5\u3002\n2.\u786e\u8ba4\u8868\u662f\u5426\u5b58\u5728\uff0c\u5b57\u6bb5\u662f\u5426\u53ef\u7528\uff0c\u6570\u636e\u662f\u5426\u5408\u7406\u3002\n3.\u4fee\u6539SQL\u6216\u76f8\u5173\u914d\u7f6e\uff0c\u91cd\u65b0\u8fd0\u884c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            }
            LOGGER.error("Analyzer#doAnalyzeMetric build context error: {}", (Object)e2.getMessage());
            LogUtils.buildAgileDataEngineLog((String)"doAnalyzeMetric", (String)"U.ADE.501.0101", (String)JSON.toJSONString(kmMetricDataList), (String)("\u7ec4\u88c5\u6307\u6807\u6570\u636e\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u53d6\u6570\u7aef\u8fd0\u884c\u8d85\u65f6\u6240\u81f4\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e2.getMessage())), (String)"1.\u6839\u636e\u9519\u8bef\u4fe1\u606f\uff0c\u68c0\u67e5SQL\u8bed\u53e5\u6d89\u53ca\u7684\u6a21\u578b\u3001\u6307\u6807\u3001\u6570\u636e\u5e93\u8868\u548c\u5b57\u6bb5\u3002\n2.\u786e\u8ba4\u8868\u662f\u5426\u5b58\u5728\uff0c\u5b57\u6bb5\u662f\u5426\u53ef\u7528\uff0c\u6570\u636e\u662f\u5426\u5408\u7406\u3002\n3.\u4fee\u6539SQL\u6216\u76f8\u5173\u914d\u7f6e\uff0c\u91cd\u65b0\u8fd0\u884c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
        }
        return snapshot;
    }

    public Snapshot buildDataSetContext(Context context, String snapshotId, String actionId, List<KMMetricData> kmMetricDataList) {
        Snapshot snapshot = new Snapshot();
        try {
            snapshot = this.snapshotParamsPreprocessing(context, snapshotId);
            List solutionStepItems = context.getBizParams().getSolutionStepItems();
            if (CollectionUtils.isEmpty((Collection)solutionStepItems)) {
                context.setCode("empty_solutionStep");
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"solutionStepItems_is_empty", (String)"U.ADE.501.2000", (String)JSON.toJSONString((Object)solutionStepItems), (String)"\u6267\u884c\u6b65\u9aa4\u4e3a\u7a7a", (String)"\u8bf7\u68c0\u67e5\u8bed\u4e49\u89e3\u6790\u662f\u5426\u6b63\u786e");
                return snapshot;
            }
            BizParams bizParams = context.getBizParams();
            SolutionStepItem solutionStepItem = (SolutionStepItem)solutionStepItems.get(solutionStepItems.size() - 1);
            if (!bizParams.isSuperAdmin() && !bizParams.isHasAuthorized() && SCENE_FN_SWITCH) {
                context.setCode("user_dataset_permission_error");
                ArrayList patternArguments = Lists.newArrayList();
                patternArguments.add(String.join((CharSequence)"/", bizParams.getPatternArguments()));
                context.setPatternArguments((List)patternArguments);
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"user_dataset_permission_error", (String)"U.ADE.501.2005", (String)JSON.toJSONString((Object)bizParams.getMissingProductLineInfos()), (String)"\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u5bf9\u5e94\u6570\u636e\u96c6", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5bf9\u5e94\u6307\u6807\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                return snapshot;
            }
            ColumnPermissionValidatorUtil.validateColumnPermissions((IamService)this.iamService, (Context)context, kmMetricDataList, (BizParams)bizParams, (List)solutionStepItems, (Snapshot)snapshot);
            if (!org.springframework.util.StringUtils.isEmpty((Object)context.getCode())) {
                LogUtils.buildAgileDataEngineLog((String)"userColPermissionsBeyond", (String)"U.ADE.501.2007", (String)"", (String)"\u5217\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5728\u9f0e\u6377\u4e91\u914d\u7f6e\u90e8\u95e8\u6216\u8005\u516c\u53f8\u522b", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5217\u6743\u9650\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
                return snapshot;
            }
            Object datasetData = this.queryTransDataByMetric(context, solutionStepItems, actionId, "getData");
            if (datasetData == null || datasetData instanceof ErrorCodeDto || datasetData instanceof Map && CollectionUtils.isEmpty((Map)((Map)datasetData)) || CollectionUtil.isEmpty((Collection)ChartConvertUtil.parseDataList((Object)datasetData)) || ((Map)ChartConvertUtil.parseDataList((Object)datasetData).get(0)).isEmpty()) {
                String message = "";
                if (datasetData == null) {
                    context.setCode("empty_dataSet");
                } else {
                    if (CollectionUtil.isEmpty((Collection)ChartConvertUtil.parseDataList((Object)datasetData))) {
                        PullData pullData = new PullData();
                        pullData.setActionId(actionId);
                        context.setPullData(Collections.singletonList(pullData));
                        snapshot.setContext(context);
                        return snapshot;
                    }
                    if (!(datasetData instanceof Map) && datasetData instanceof ErrorCodeDto && "P.EE.500.0011".equalsIgnoreCase(((ErrorCodeDto)datasetData).getErrorCode())) {
                        message = ((ErrorCodeDto)datasetData).getMessage();
                        context.setCode("execute_engine_over_data_limit");
                    } else {
                        context.setCode("execute_engine_get_data_error");
                    }
                }
                snapshot.setContext(context);
                LogUtils.buildAgileDataEngineLog((String)"queryTransDataByDataset", (String)"U.ADE.501.2008", (String)actionId, (String)"\u53d6\u6570\u5f15\u64ce\u5f02\u5e38,".concat(message), (String)"1.\u6253\u5f00\u6570\u636e\u6d41\u67e5\u8be2\u8282\u70b9\u7684\u67e5\u8be2\u65b9\u6848\uff0c\u8c03\u5927\u5206\u9875\u6570\u3002\n2.\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86\u95ee\u53e5\u6240\u9700\u7684\u65f6\u95f4\u8303\u56f4\u3002\n3.\u7b49\u5f8530\u79d2\u540e\u91cd\u65b0\u6d4b\u8bd5\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
                return snapshot;
            }
            PullData newPullData = new PullData();
            Object metadata = this.buildMetaData(solutionStepItem, kmMetricDataList, context, actionId);
            newPullData.setMetadata(metadata);
            newPullData.setData(datasetData);
            newPullData.setDataTag(this.buildDatatagParam(context));
            newPullData.setActionId(actionId);
            newPullData.setDatasetList(bizParams.getDatasetList());
            Optional.ofNullable((List)((Map)bizParams.getShowDefine()).get("showType")).ifPresent(sts -> sts.stream().forEach(st -> Optional.ofNullable((List)st.get("type")).ifPresent(m -> m.stream().forEach(mchild -> mchild.put("title", Optional.ofNullable((Map)mchild.get("language")).map(lchild -> ((Map)lchild.get("title")).get(bizParams.getLocale())).orElse(mchild.get("title")))))));
            context.setPullData(Collections.singletonList(newPullData));
            context.setStepAnalysis(Collections.EMPTY_LIST);
            snapshot.setContext(context);
            if (Boolean.FALSE.equals(bizParams.getTablePreviewIf()) || bizParams.getCreateSnap().booleanValue()) {
                ChartConvertUtil.handleChartConvert((DmcService)this.dmcService, (Context)context, (BizParams)bizParams, (PullData)newPullData, (Snapshot)snapshot);
            }
        }
        catch (Exception e) {
            LOGGER.error("Analyzer#doAnalyzeDataSet build context error: {}", (Object)e.getMessage());
            LogUtils.buildAgileDataEngineLog((String)"doAnalyzeDataSet", (String)"U.ADE.501.2002", (String)JSON.toJSONString(kmMetricDataList), (String)("\u7ec4\u88c5\u6570\u636e\u96c6\u6570\u636e\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u53d6\u6570\u7aef\u8fd0\u884c\u8d85\u65f6\u6240\u81f4\u3002\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"1.\u6839\u636e\u9519\u8bef\u4fe1\u606f\uff0c\u68c0\u67e5SQL\u8bed\u53e5\u6d89\u53ca\u7684\u6a21\u578b\u3001\u6307\u6807\u3001\u6570\u636e\u5e93\u8868\u548c\u5b57\u6bb5\u3002\n2.\u786e\u8ba4\u8868\u662f\u5426\u5b58\u5728\uff0c\u5b57\u6bb5\u662f\u5426\u53ef\u7528\uff0c\u6570\u636e\u662f\u5426\u5408\u7406\u3002\n3.\u4fee\u6539SQL\u6216\u76f8\u5173\u914d\u7f6e\uff0c\u91cd\u65b0\u8fd0\u884c\uff0c\u82e5\u4e0d\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
        }
        return snapshot;
    }

    public List<ExcelPullingResonseModel> getDatasetV2Data(Context context, String actionId, List<KMMetricData> kmMetricData) {
        ArrayList<ExcelPullingResonseModel> excelData = new ArrayList<ExcelPullingResonseModel>(2);
        if (context.getSysParam() == null) {
            context.setSysParam(new HashMap(2));
        }
        context.getSysParam().put("download", true);
        if (CollectionUtils.isEmpty((Collection)context.getBizParams().getDatasetList()) || context.getBizParams().getDatasetList().size() >= 5) {
            return Collections.emptyList();
        }
        try {
            List solutionStepItems = context.getBizParams().getSolutionStepItems();
            BizParams bizParams = context.getBizParams();
            HashMap allowFieldByDataSetId = new HashMap(2);
            List datasetList = context.getBizParams().getDatasetList();
            for (SolutionStepItem stepItem : solutionStepItems) {
                ExcelPullingResonseModel resonseModel;
                String datasetId = stepItem.getDatasetObject().getMetric();
                if (!org.springframework.util.StringUtils.hasText((String)datasetId)) continue;
                if (CollectionUtils.isEmpty(excelData)) {
                    resonseModel = new ExcelPullingResonseModel();
                    resonseModel.setActionId(datasetId);
                    resonseModel.setActionName((String)((Map)datasetList.stream().filter(a -> a.get("datasetId").equals(datasetId)).collect(Collectors.toList()).get(0)).get("datasetName"));
                } else {
                    List models = excelData.stream().filter(a -> a.getActionId().equals(datasetId)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(models)) {
                        resonseModel = (ExcelPullingResonseModel)models.get(0);
                    } else {
                        resonseModel = new ExcelPullingResonseModel();
                        resonseModel.setActionId(datasetId);
                        resonseModel.setActionName((String)((Map)datasetList.stream().filter(a -> a.get("datasetId").equals(datasetId)).collect(Collectors.toList()).get(0)).get("datasetName"));
                    }
                }
                if (!"dataset".equals(stepItem.getDatasetObject().getDatasetType())) continue;
                List allowField = allowFieldByDataSetId.containsKey(datasetId) ? (List)allowFieldByDataSetId.get(datasetId) : ColumnPermissionValidatorUtil.getColumnPermissionsByDataset((IamService)this.iamService, (BizParams)bizParams, (SolutionStepItem)stepItem, kmMetricData);
                this.buildNewSelectForV2(stepItem, kmMetricData, allowField);
                if (stepItem.getFilter() != null && stepItem.getFilter().getChildren() != null) {
                    stepItem.getFilter().getChildren().removeIf(child -> {
                        if (((FilterItem.ConditionItemWrap)child.getRight().get(0)).getDataObject() == null) {
                            return true;
                        }
                        String contentType = ((FilterItem.ConditionItemWrap)child.getRight().get(0)).getDataObject().getContentType();
                        return !"const".equalsIgnoreCase(contentType);
                    });
                    if (stepItem.getFilter().getChildren().isEmpty()) {
                        stepItem.setFilter(null);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)stepItem.getGroupby())) {
                    stepItem.setGroupby(null);
                }
                if (!CollectionUtils.isEmpty((Collection)stepItem.getSort())) {
                    stepItem.setSort(null);
                }
                if (stepItem.getLimit() != null) {
                    stepItem.setLimit(null);
                }
                ArrayList<SolutionStepItem> newStep = new ArrayList<SolutionStepItem>(1);
                newStep.add(stepItem);
                Object datasetData = this.queryTransDataByMetric(context, newStep, actionId, "getData");
                if ((datasetData == null || datasetData instanceof ErrorCodeDto || datasetData instanceof Map && CollectionUtils.isEmpty((Map)((Map)datasetData)) || CollectionUtil.isEmpty((Collection)ChartConvertUtil.parseDataList((Object)datasetData)) || ((Map)ChartConvertUtil.parseDataList((Object)datasetData).get(0)).isEmpty()) && datasetData == null) {
                    return Collections.EMPTY_LIST;
                }
                if (datasetData instanceof Map) {
                    if (!ObjectUtils.isEmpty((Object)(datasetData = ((Map)datasetData).get("data")))) {
                        if (CollectionUtils.isEmpty((Collection)resonseModel.getData())) {
                            resonseModel.setData((List)datasetData);
                            List<Map<String, Object>> metadata = this.buildExcelMetaData(stepItem);
                            resonseModel.setMetadata(metadata);
                        } else {
                            resonseModel.getData().addAll((Collection)datasetData);
                        }
                    } else {
                        return Collections.EMPTY_LIST;
                    }
                }
                excelData.add(resonseModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u660e\u7ec6\u6570\u636e\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)e.getMessage());
        }
        return excelData;
    }

    private List<Map<String, Object>> buildExcelMetaData(SolutionStepItem stepItem) {
        ArrayList<Map<String, Object>> metadatas = new ArrayList<Map<String, Object>>(stepItem.getSelect().size());
        for (SelectItem item : stepItem.getSelect()) {
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>(2);
            metadata.put("columnName", item.getDataObject().getContent());
            metadata.put("columnComment", item.getDataObject().getTitle());
            metadatas.add(metadata);
        }
        return metadatas;
    }

    public AttributionDimensionResponse buildAttributionDimensionResponse(BizParams bizParams, List<DimensionSolutionStep> groupedSolutionSteps, List<DatasetListItem> datasetList, List<PullData> pullData, List<KMMetricData> kmDataSetDataList) {
        AttributionDimensionResponse response = new AttributionDimensionResponse();
        this.permissionCheck(bizParams);
        if (!bizParams.isSuperAdmin() && !bizParams.isHasAuthorized() && SCENE_FN_SWITCH) {
            response.setCode("user_dataset_permission_error");
            ArrayList patternArguments = Lists.newArrayList();
            patternArguments.add(String.join((CharSequence)"/", bizParams.getPatternArguments()));
            response.setPatternArguments((List)patternArguments);
            LogUtils.buildAgileDataEngineLog((String)"user_dataset_permission_error", (String)"U.ADE.501.2005", (String)JSON.toJSONString((Object)bizParams.getMissingProductLineInfos()), (String)"\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u5bf9\u5e94\u6570\u636e\u96c6", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5bf9\u5e94\u6307\u6807\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
            return response;
        }
        ColumnPermissionValidatorUtil.validateColumnPermissionsByAnalysis((IamService)this.iamService, (BizParams)bizParams, (AttributionDimensionResponse)response, groupedSolutionSteps, kmDataSetDataList);
        if (!org.springframework.util.StringUtils.isEmpty((Object)response.getCode())) {
            LogUtils.buildAgileDataEngineLog((String)"userColPermissionsBeyond", (String)"U.ADE.501.2007", (String)"", (String)"\u5217\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u5728\u9f0e\u6377\u4e91\u914d\u7f6e\u90e8\u95e8\u6216\u8005\u516c\u53f8\u522b", (String)"\u8bf7\u767b\u5f55\u9f0e\u6377\u4e91\u5e73\u53f0\uff0c\u914d\u7f6e\u5217\u6743\u9650\uff0c\u5982\u8fd8\u672a\u89e3\u51b3\uff0c\u5219\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
            return response;
        }
        List<AttributionDataBo> attributionDatas = this.queryTransDataByAnalysis(bizParams, groupedSolutionSteps);
        if (CollectionUtils.isEmpty(attributionDatas)) {
            response.setCode("empty_data");
            return response;
        }
        List data = response.getGroupedSolutionSteps();
        for (DimensionSolutionStep solutionStep : groupedSolutionSteps) {
            DimensionSolutionStepResponse stepResponse = new DimensionSolutionStepResponse();
            stepResponse.setDimension(solutionStep.getDimension());
            for (AttributionDataBo attributionData : attributionDatas) {
                if (!solutionStep.getDimension().equals(attributionData.getDimension())) continue;
                if (!ObjectUtils.isEmpty((Object)attributionData.getData()) && !CollectionUtils.isEmpty((Collection)((Collection)((Map)attributionData.getData()).get("data")))) {
                    Map attributeData = (Map)((List)((Map)attributionData.getData()).get("data")).get(0);
                    PullData forwardDataOrReverseData = new PullData();
                    forwardDataOrReverseData.setData(attributionData.getData());
                    forwardDataOrReverseData.setDataTag(this.buildDataTagParamByAnalysis(solutionStep.getDataTag()));
                    if ("forward".equals(attributionData.getDirection())) {
                        forwardDataOrReverseData.setMetadata(this.buildMetadataByAnalysis(solutionStep.getForward().getSolutionStep(), kmDataSetDataList, bizParams, solutionStep.getDataTag()));
                        stepResponse.setForward(forwardDataOrReverseData);
                        continue;
                    }
                    forwardDataOrReverseData.setMetadata(this.buildMetadataByAnalysis(solutionStep.getReverse().getSolutionStep(), kmDataSetDataList, bizParams, solutionStep.getDataTag()));
                    stepResponse.setReverse(forwardDataOrReverseData);
                    continue;
                }
                if ("forward".equals(attributionData.getDirection())) {
                    stepResponse.setForward(this.buildEmptyPullData());
                    continue;
                }
                stepResponse.setReverse(this.buildEmptyPullData());
            }
            data.add(stepResponse);
        }
        return response;
    }

    private Object buildMetadataByAnalysis(List<SolutionStepItem> solutionStep, List<KMMetricData> kmMetricDataList, BizParams bizParams, List<Map<String, Object>> dataTagParams) {
        ArrayList<MetaDataResponseData> nullStyleFieldList = new ArrayList<MetaDataResponseData>(8);
        SolutionStepItem solutionStepItem = solutionStep.get(solutionStep.size() - 1);
        if (!CollectionUtils.isEmpty(kmMetricDataList) && solutionStepItem.getDatasetObject() != null) {
            for (KMMetricData kmMetricData : kmMetricDataList) {
                if (!kmMetricData.getIndicatorId().equals(solutionStepItem.getDatasetObject().getMetric())) continue;
                if (!CollectionUtils.isEmpty((Collection)kmMetricData.getDimensions())) {
                    for (MetaDataResponseData responseData : kmMetricData.getDimensions()) {
                        if (!org.springframework.util.StringUtils.hasText((String)responseData.getNullStyle())) continue;
                        nullStyleFieldList.add(responseData);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)kmMetricData.getMeasures())) continue;
                for (MetaDataResponseData responseData : kmMetricData.getMeasures()) {
                    if (!org.springframework.util.StringUtils.hasText((String)responseData.getNullStyle())) continue;
                    nullStyleFieldList.add(responseData);
                }
            }
        }
        String locale = Optional.ofNullable(bizParams.getLocale()).orElse("zh_CN");
        if (CollectionUtil.isEmpty((Collection)solutionStepItem.getSelect())) {
            return null;
        }
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setActionId("");
        HashMap alias2BizTypeMap = new HashMap(8);
        List bizTypes = Optional.ofNullable(dataTagParams).filter(e -> CollectionUtil.isNotEmpty((Collection)e)).map(ls -> ls.stream().peek(childMp -> alias2BizTypeMap.put((String)childMp.get("alias"), (String)childMp.get("businessType"))).map(mp -> (String)mp.get("businessType")).distinct().collect(Collectors.toList())).orElse(Collections.emptyList());
        Map code2BizTypeMap = bizParams.isDataSetV1() != false ? this.themeMapService.metricBusinessByCode(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), bizTypes, bizParams.getAppCode()) : this.buildBizTypeToV2(dataTagParams);
        LOGGER.info("AdeServiceImpl#buildMetaData achieve TM bizCode :{}, bizTypes :{}, appCode :{}", new Object[]{code2BizTypeMap, bizTypes, bizParams.getAppCode()});
        LogUtils.buildAgileDataEngineLog((String)"buildMetaData", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)code2BizTypeMap), (String)JSON.toJSONString(bizTypes), (String)"");
        List sortList = solutionStepItem.getSort();
        Map<Object, Object> resultMap = CollectionUtil.isNotEmpty((Collection)sortList) ? sortList.stream().collect(Collectors.toMap(item -> item.getDataObject().getContent(), SortItem::getOrder)) : new HashMap();
        solutionStepItem.getSelect().stream().forEach(item -> {
            Optional<MetaDataResponseData> data;
            DataObject dataObject = item.getDataObject();
            MetadataItem.MetadataRespData metadataRespData = new MetadataItem.MetadataRespData();
            metadataRespData.setData_name(dataObject.getAlias());
            if (!CollectionUtils.isEmpty((Collection)nullStyleFieldList) && (data = nullStyleFieldList.stream().filter(metaDataResponseData -> dataObject.getContent().contains(metaDataResponseData.getData_name())).findFirst()).isPresent()) {
                metadataRespData.setNullStyle(data.get().getNullStyle());
            }
            if ("calculate".equals(dataObject.getContentType())) {
                metadataRespData.setData_type(AdeServiceImpl.getFieldOriginalType(solutionStepItem, dataObject));
            } else {
                metadataRespData.setData_type(TRANS_MAP.getOrDefault(dataObject.getDataType(), dataObject.getDataType()));
            }
            if ("decimal".equals(metadataRespData.getData_type())) {
                metadataRespData.setData_type("numeric");
            }
            if (dataObject.getLanguage() != null) {
                metadataRespData.setDescription(Optional.ofNullable((Map)dataObject.getLanguage().get("title")).map(e -> (String)e.get(locale)).orElse(dataObject.getTitle()));
            } else {
                metadataRespData.setDescription(dataObject.getTitle());
            }
            if (!resultMap.isEmpty() && StringUtil.isNotBlank((String)((String)resultMap.get(dataObject.getContent())))) {
                metadataRespData.setSort((String)resultMap.get(dataObject.getContent()));
            }
            if (alias2BizTypeMap.containsKey(dataObject.getAlias()) && (code2BizTypeMap.containsKey(alias2BizTypeMap.get(dataObject.getAlias())) || code2BizTypeMap.containsKey(dataObject.getAlias()))) {
                String unit;
                String decimalRule;
                Integer decimal;
                String showType;
                Boolean isTime = null;
                Boolean isMainDimension = null;
                String businessType = "";
                if (bizParams.isDataSetV1().booleanValue()) {
                    showType = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("showType")).orElse("");
                    decimal = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (Integer)mp.get("decimal")).orElse(null);
                    decimalRule = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("decimalRule")).orElse(null);
                    unit = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("dataUnit")).orElse(null);
                    isTime = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> mp.get("isTime")).orElse(null);
                    isMainDimension = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> mp.get("isMainDimension")).orElse(null);
                    businessType = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("businessType")).orElse("");
                } else {
                    Map dataTag = (Map)code2BizTypeMap.get(dataObject.getAlias());
                    if (!CollectionUtils.isEmpty((Map)dataTag)) {
                        businessType = (String)dataTag.get("businessType");
                        if (dataTag.get("isGroupBy") != null && ((Boolean)dataTag.get("isGroupBy")).booleanValue()) {
                            showType = null;
                            decimal = null;
                            decimalRule = null;
                            unit = null;
                        } else if (BusinessTypeEnum.AMOUNT.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "thousand";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = "0";
                        } else if (BusinessTypeEnum.RATE.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "percent";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = null;
                        } else if (BusinessTypeEnum.QUANTITY.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "thousand";
                            decimal = CommonConstant.INT_MINUS_ONE;
                            decimalRule = "";
                            unit = "";
                        } else {
                            showType = "thousand";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = "0";
                        }
                        isTime = dataTag.get("isTime") == null ? null : (Boolean)dataTag.get("isTime");
                        isMainDimension = dataTag.get("isMainDimension") == null ? null : (Boolean)dataTag.get("isMainDimension");
                    } else {
                        showType = "thousand";
                        decimal = CommonConstant.INT_TWO;
                        decimalRule = "round";
                        unit = "0";
                    }
                }
                metadataRespData.setBusinessType(businessType);
                metadataRespData.setIsTime(isTime);
                metadataRespData.setIsMainDimension(isMainDimension);
                if (Boolean.TRUE.equals(isTime) && StringUtils.equals((CharSequence)"string", (CharSequence)metadataRespData.getData_type())) {
                    metadataRespData.setData_type("date");
                }
                Optional.ofNullable(dataTagParams).map(dtp -> dtp).ifPresent(op -> op.forEach(opitem -> {
                    if (StringUtils.equals((CharSequence)((String)opitem.get("alias")), (CharSequence)dataObject.getAlias())) {
                        opitem.put("decimalRule", decimalRule);
                        opitem.put("dataUnit", unit);
                    }
                }));
                metadataRespData.setPercent(TRANS_MAP.getOrDefault(showType, showType));
                metadataRespData.setDecimal(decimal);
            }
            metadataRespData.setField(Collections.emptyList());
            Optional.ofNullable(metadataItem.getResponse().getData()).ifPresent(ls -> {
                if (Objects.isNull(ls.getField())) {
                    ls.setField(new ArrayList(2));
                    ls.setData_name("data");
                    ls.setData_type("object");
                }
                ls.getField().add(metadataRespData);
            });
        });
        return metadataItem;
    }

    private PullData buildEmptyPullData() {
        PullData data = new PullData();
        data.setData((Object)Collections.EMPTY_LIST);
        data.setMetadata((Object)Collections.EMPTY_MAP);
        return data;
    }

    public Object getMetricData(Context context, String actionId, KMMetricData kmMetricData) throws Throwable {
        List solutionStepItems = context.getBizParams().getSolutionStepItems();
        for (SolutionStepItem stepItem : solutionStepItems) {
            if (stepItem.getFilter() == null || stepItem.getFilter().getChildren() == null) continue;
            stepItem.getFilter().getChildren().removeIf(child -> {
                if (((FilterItem.ConditionItemWrap)child.getRight().get(0)).getDataObject() == null) {
                    return true;
                }
                String contentType = ((FilterItem.ConditionItemWrap)child.getRight().get(0)).getDataObject().getContentType();
                return !"const".equalsIgnoreCase(contentType);
            });
            if (!stepItem.getFilter().getChildren().isEmpty()) continue;
            stepItem.setFilter(null);
        }
        return this.queryTransDataByMetric(context, solutionStepItems, actionId, "download");
    }

    private List<MetricDebugInfo.MetricRunningListItem> postProcessMetricName(List<Map<String, Object>> metricRunningInfo, List<Map<String, Object>> metricList) {
        Map<String, String> mtrId2Tlist = metricList.stream().peek(mp -> mp.remove("fieldSchema")).collect(Collectors.toMap(mp -> (String)mp.get("metricId"), mp -> (String)mp.get("metricName")));
        List metricRunningListItems = JSON.parseArray((String)JSON.toJSONString(metricRunningInfo), MetricDebugInfo.MetricRunningListItem.class);
        if (CollectionUtil.isNotEmpty((Collection)metricRunningListItems)) {
            this.recAssign(metricRunningListItems, mtrId2Tlist);
        }
        return metricRunningListItems;
    }

    private void recAssign(List<MetricDebugInfo.MetricRunningListItem> metricRunningListItems, Map<String, String> mtrId2Tlist) {
        if (CollectionUtil.isEmpty(metricRunningListItems)) {
            return;
        }
        metricRunningListItems.stream().forEach(item -> item.setMetricName(mtrId2Tlist.getOrDefault(item.getMetricId(), "")));
    }

    public Object queryTransDataByMetric(Context context, List<SolutionStepItem> solutionStepItems, String actionId, String type) {
        HashMap<String, List<Object>> permissionMap = new HashMap<String, List<Object>>(4);
        HashMap<String, Object> extensionMap = new HashMap<String, Object>(4);
        BizParams bizParams = context.getBizParams();
        permissionMap.put("roles", bizParams.getRoles());
        ArrayList dataSetList = new ArrayList();
        if (bizParams.isDataSetV2().booleanValue()) {
            List datasetListItems = JSON.parseArray((String)JSON.toJSONString((Object)bizParams.getDatasetList()), DatasetListItem.class);
            for (DatasetListItem item : datasetListItems) {
                HashMap<String, Object> datasetMap = new HashMap<String, Object>(8);
                datasetMap.put("datasetId", item.getDatasetId());
                datasetMap.put("mappingFields", item.getMappingFields());
                datasetMap.put("modelCode", item.getModelCode());
                datasetMap.put("modelId", item.getModelId());
                datasetMap.put("dictionary", item.getFieldSchema() == null ? Collections.emptyList() : item.getFieldSchema());
                dataSetList.add(datasetMap);
            }
            extensionMap.put("datasets", dataSetList);
        }
        permissionMap.put("rows", this.buildPermissionsParam(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), context.isDataSet() != false ? "dataset" : "appData", actionId, bizParams.getAppCode(), bizParams));
        extensionMap.put("permissions", permissionMap);
        extensionMap.put("productLineInfo", context.getBizParams().getProductLineInfo());
        Map sysParam = Optional.ofNullable(context.getSysParam()).map(e -> e.get(actionId)).orElse(new HashMap(1));
        sysParam.put("userId", bizParams.getUserId());
        if (context.getSysParam() != null && context.getSysParam().get("download") != null) {
            sysParam.put("download", context.getSysParam().get("download"));
        }
        if ("download".equals(type)) {
            return this.solutionStepExecuteProvider.postExport(bizParams.getTenantId(), JsonUtil.coverListMapObjectToListMapString((List)bizParams.getEocMaps()), sysParam, JsonUtil.getList((String)JsonUtil.getJsonString(solutionStepItems)), JsonUtil.getObject((String)JsonUtil.getJsonString(extensionMap)));
        }
        return this.solutionStepExecuteProvider.post(bizParams.getTenantId(), JsonUtil.coverListMapObjectToListMapString((List)bizParams.getEocMaps()), sysParam, JsonUtil.getList((String)JsonUtil.getJsonString(solutionStepItems)), JsonUtil.getObject((String)JsonUtil.getJsonString(extensionMap)));
    }

    public List<AttributionDataBo> queryTransDataByAnalysis(BizParams bizParams, List<DimensionSolutionStep> groupedSolutionSteps) {
        HashMap<String, List<Object>> permissionMap = new HashMap<String, List<Object>>(4);
        HashMap<String, Object> extensionMap = new HashMap<String, Object>(4);
        permissionMap.put("roles", bizParams.getRoles());
        ArrayList dataSetList = new ArrayList();
        if (bizParams.isDataSetV2().booleanValue()) {
            List datasetListItems = JSON.parseArray((String)JSON.toJSONString((Object)bizParams.getDatasetList()), DatasetListItem.class);
            Iterator iterator = datasetListItems.iterator();
            while (iterator.hasNext()) {
                DatasetListItem item = (DatasetListItem)iterator.next();
                HashMap<String, Object> datasetMap = new HashMap<String, Object>(8);
                datasetMap.put("datasetId", item.getDatasetId());
                datasetMap.put("mappingFields", item.getMappingFields());
                datasetMap.put("modelCode", item.getModelCode());
                datasetMap.put("modelId", item.getModelId());
                datasetMap.put("dictionary", item.getFieldSchema() == null ? Collections.emptyList() : item.getFieldSchema());
                dataSetList.add(datasetMap);
            }
            extensionMap.put("datasets", dataSetList);
        }
        for (Object actionId : bizParams.getDatasetIds()) {
            permissionMap.put("rows", this.buildPermissionsParam(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), bizParams.isDataSetV2() != false ? "dataset" : "appData", (String)actionId, bizParams.getAppCode(), bizParams));
        }
        extensionMap.put("permissions", permissionMap);
        extensionMap.put("productLineInfo", bizParams.getProductLineInfo());
        HashMap<String, String> sysParam = new HashMap<String, String>(0);
        sysParam.put("userId", bizParams.getUserId());
        for (DimensionSolutionStep step : groupedSolutionSteps) {
            this.dealGroupStep(step.getForward());
            this.dealGroupStep(step.getReverse());
        }
        AttributeInquirerDto attributeInquirerDto = new AttributeInquirerDto();
        attributeInquirerDto.setEocMaps(JsonUtil.coverListMapObjectToListMapString((List)bizParams.getEocMaps()));
        attributeInquirerDto.setExtension(JsonUtil.getObject((String)JsonUtil.getJsonString(extensionMap)));
        attributeInquirerDto.setSysParam(sysParam);
        attributeInquirerDto.setTenantId(bizParams.getTenantId());
        attributeInquirerDto.setGroupedSolutionSteps(JsonUtil.getList((String)JsonUtil.getJsonString(groupedSolutionSteps)));
        List<AttributionDataBo> response = null;
        try {
            response = this.iAttributeInquirer.fetchAttributionData(attributeInquirerDto);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u7ef4\u5ea6\u5f52\u56e0\u83b7\u53d6\u6570\u636e\u6709\u8bef\uff0c\u5165\u53c2\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JsonUtil.getJsonString((Object)attributeInquirerDto), (Object)e.getMessage());
        }
        return response;
    }

    private void dealGroupStep(DataSetItem dataSetItem) {
        List solutionStep = dataSetItem.getSolutionStep();
        ArrayList<String> sqlDataTimes = new ArrayList<String>(4);
        if (!CollectionUtils.isEmpty((Collection)solutionStep)) {
            for (SolutionStepItem stepItem : solutionStep) {
                if (stepItem.getFilter() == null) continue;
                Context.buildSolustionStepDataTime((List)solutionStep, sqlDataTimes, null);
                break;
            }
        }
        this.converDynamicTime(sqlDataTimes, solutionStep);
    }

    private void converDynamicTime(List<String> sqlDataTimes, List<SolutionStepItem> solutionStep) {
        StringBuilder sb = new StringBuilder("SELECT ");
        for (String sql : sqlDataTimes) {
            sb.append(sql);
        }
        String ddl = sb.substring(0, sb.lastIndexOf(","));
        Map<String, String> dateTimes = this.dynamicMapper.selectDDL(ddl);
        Context.buildSolustionStepDataTime(solutionStep, sqlDataTimes, dateTimes);
    }

    private Object buildMetaData(SolutionStepItem solutionStepItem, List<KMMetricData> kmMetricDataList, Context context, String actionId) {
        ArrayList<MetaDataResponseData> nullStyleFieldList = new ArrayList<MetaDataResponseData>(8);
        if (!CollectionUtils.isEmpty(kmMetricDataList) && solutionStepItem.getDatasetObject() != null) {
            for (KMMetricData kmMetricData : kmMetricDataList) {
                if (!kmMetricData.getIndicatorId().equals(solutionStepItem.getDatasetObject().getMetric())) continue;
                if (!CollectionUtils.isEmpty((Collection)kmMetricData.getDimensions())) {
                    for (MetaDataResponseData responseData : kmMetricData.getDimensions()) {
                        if (!org.springframework.util.StringUtils.hasText((String)responseData.getNullStyle())) continue;
                        nullStyleFieldList.add(responseData);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)kmMetricData.getMeasures())) continue;
                for (MetaDataResponseData responseData : kmMetricData.getMeasures()) {
                    if (!org.springframework.util.StringUtils.hasText((String)responseData.getNullStyle())) continue;
                    nullStyleFieldList.add(responseData);
                }
            }
        }
        BizParams bizParams = context.getBizParams();
        String locale = Optional.ofNullable(context.getBizParams().getLocale()).orElse("zh_CN");
        if (CollectionUtil.isEmpty((Collection)solutionStepItem.getSelect())) {
            return null;
        }
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setActionId(actionId);
        HashMap alias2BizTypeMap = new HashMap(8);
        List bizTypes = Optional.ofNullable(context.getBizParams().getDataTagParam()).filter(e -> CollectionUtil.isNotEmpty((Collection)((List)e))).map(ls -> ((List)ls).stream().filter(map -> map.get("businessType") != null).peek(childMp -> alias2BizTypeMap.put((String)childMp.get("alias"), (String)childMp.get("businessType"))).map(mp -> (String)mp.get("businessType")).distinct().collect(Collectors.toList())).orElse(Collections.emptyList());
        Map code2BizTypeMap = context.isDataSetV1() != false ? this.themeMapService.metricBusinessByCode(bizParams.getTenantId(), bizParams.getUserToken(), bizParams.getLocale(), bizTypes, bizParams.getAppCode()) : this.buildBizTypeToV2(context.getBizParams().getDataTagParam());
        LOGGER.info("AdeServiceImpl#buildMetaData achieve TM bizCode :{}, bizTypes :{}, appCode :{}", new Object[]{code2BizTypeMap, bizTypes, bizParams.getAppCode()});
        LogUtils.buildAgileDataEngineLog((String)"buildMetaData", (String)LogUtils.SUCCESS, (String)JSON.toJSONString((Object)code2BizTypeMap), (String)JSON.toJSONString(bizTypes), (String)"");
        List sortList = solutionStepItem.getSort();
        Map<Object, Object> resultMap = CollectionUtil.isNotEmpty((Collection)sortList) ? sortList.stream().collect(Collectors.toMap(item -> item.getDataObject().getContent(), SortItem::getOrder)) : new HashMap();
        List dataTagList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)context.getBizParams().getDataTagParam())) {
            dataTagList = (List)context.getBizParams().getDataTagParam();
        }
        ArrayList finalDataTagList = dataTagList;
        solutionStepItem.getSelect().stream().forEach(item -> {
            Optional<MetaDataResponseData> data;
            DataObject dataObject = item.getDataObject();
            MetadataItem.MetadataRespData metadataRespData = new MetadataItem.MetadataRespData();
            metadataRespData.setData_name(dataObject.getAlias());
            List dataTags = finalDataTagList.stream().filter(tag -> StringUtils.equals((CharSequence)((String)tag.get("alias")), (CharSequence)dataObject.getAlias())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dataTags)) {
                Map dataTag = (Map)dataTags.get(0);
                Boolean isTime = dataTag.get("isTime") == null ? null : (Boolean)dataTag.get("isTime");
                Boolean isMainDimension = dataTag.get("isMainDimension") == null ? null : (Boolean)dataTag.get("isMainDimension");
                metadataRespData.setIsTime(isTime);
                metadataRespData.setIsMainDimension(isMainDimension);
            }
            if (!CollectionUtils.isEmpty((Collection)nullStyleFieldList) && (data = nullStyleFieldList.stream().filter(metaDataResponseData -> dataObject.getContent().contains(metaDataResponseData.getData_name())).findFirst()).isPresent()) {
                metadataRespData.setNullStyle(data.get().getNullStyle());
            }
            if ("calculate".equals(dataObject.getContentType())) {
                metadataRespData.setData_type(AdeServiceImpl.getFieldOriginalType(solutionStepItem, dataObject));
            } else {
                metadataRespData.setData_type(TRANS_MAP.getOrDefault(dataObject.getDataType(), dataObject.getDataType()));
            }
            if (Boolean.TRUE.equals(metadataRespData.getIsTime()) && StringUtils.equals((CharSequence)"string", (CharSequence)metadataRespData.getData_type())) {
                metadataRespData.setData_type("date");
            }
            if ("decimal".equals(metadataRespData.getData_type())) {
                metadataRespData.setData_type("numeric");
            }
            if (dataObject.getLanguage() != null) {
                metadataRespData.setDescription(Optional.ofNullable((Map)dataObject.getLanguage().get("title")).map(e -> (String)e.get(locale)).orElse(dataObject.getTitle()));
            } else {
                metadataRespData.setDescription(dataObject.getTitle());
            }
            if (!resultMap.isEmpty() && StringUtil.isNotBlank((String)((String)resultMap.get(dataObject.getContent())))) {
                metadataRespData.setSort((String)resultMap.get(dataObject.getContent()));
            }
            if (alias2BizTypeMap.containsKey(dataObject.getAlias()) && org.springframework.util.StringUtils.hasText((String)((String)alias2BizTypeMap.get(dataObject.getAlias()))) && (code2BizTypeMap.containsKey(alias2BizTypeMap.get(dataObject.getAlias())) || code2BizTypeMap.containsKey(dataObject.getAlias()))) {
                String unit;
                String decimalRule;
                Integer decimal;
                String showType;
                String businessType = "";
                if (context.isDataSetV1().booleanValue()) {
                    showType = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("showType")).orElse("");
                    decimal = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (Integer)mp.get("decimal")).orElse(null);
                    decimalRule = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("decimalRule")).orElse(null);
                    unit = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("dataUnit")).orElse(null);
                    businessType = Optional.ofNullable((Map)code2BizTypeMap.get(alias2BizTypeMap.get(dataObject.getAlias()))).map(mp -> (String)mp.get("businessType")).orElse("");
                } else {
                    Map dataTag = (Map)code2BizTypeMap.get(dataObject.getAlias());
                    if (!CollectionUtils.isEmpty((Map)dataTag)) {
                        businessType = (String)dataTag.get("businessType");
                        if (dataTag.get("isGroupBy") != null && ((Boolean)dataTag.get("isGroupBy")).booleanValue()) {
                            showType = null;
                            decimal = null;
                            decimalRule = null;
                            unit = null;
                        } else if (BusinessTypeEnum.AMOUNT.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "thousand";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = "0";
                        } else if (BusinessTypeEnum.RATE.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "percent";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = null;
                        } else if (BusinessTypeEnum.QUANTITY.getMethod().equalsIgnoreCase(businessType)) {
                            showType = "thousand";
                            decimal = CommonConstant.INT_MINUS_ONE;
                            decimalRule = "";
                            unit = "";
                        } else {
                            showType = "thousand";
                            decimal = CommonConstant.INT_TWO;
                            decimalRule = "round";
                            unit = "0";
                        }
                    } else {
                        showType = "thousand";
                        decimal = CommonConstant.INT_TWO;
                        decimalRule = "round";
                        unit = "0";
                    }
                }
                metadataRespData.setBusinessType(businessType);
                Optional.ofNullable(context.getBizParams().getDataTagParam()).map(dtp -> (List)dtp).ifPresent(op -> op.forEach(opitem -> {
                    if (StringUtils.equals((CharSequence)((String)opitem.get("alias")), (CharSequence)dataObject.getAlias())) {
                        opitem.put("decimalRule", decimalRule);
                        opitem.put("dataUnit", unit);
                    }
                }));
                metadataRespData.setPercent(TRANS_MAP.getOrDefault(showType, showType));
                metadataRespData.setDecimal(decimal);
            }
            metadataRespData.setField(Collections.emptyList());
            Optional.ofNullable(metadataItem.getResponse().getData()).ifPresent(ls -> {
                if (Objects.isNull(ls.getField())) {
                    ls.setField(new ArrayList(2));
                    ls.setData_name("data");
                    ls.setData_type("object");
                }
                ls.getField().add(metadataRespData);
            });
        });
        return metadataItem;
    }

    private Map<String, Object> buildBizTypeToV2(@Nullable Object dataTagParam) {
        if (ObjectUtils.isEmpty((Object)dataTagParam)) {
            return Collections.EMPTY_MAP;
        }
        List dataTags = (List)dataTagParam;
        if (CollectionUtils.isEmpty((Collection)dataTags)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> newDataTags = new HashMap<String, Object>(dataTags.size());
        for (Map dataTag : dataTags) {
            if (!MapUtils.isNotEmpty((Map)dataTag)) continue;
            newDataTags.put((String)dataTag.get("alias"), dataTag);
        }
        return newDataTags;
    }

    private Map<String, Object> buildDatatagParam(Context context) {
        HashMap<String, Object> dataTagParam = new HashMap<String, Object>();
        dataTagParam.put("name", "dataDisplay");
        dataTagParam.put("fields", Optional.ofNullable(context.getBizParams().getDataTagParam()).map(m -> ((List)m).stream().map(mp -> mp.keySet().stream().filter(key -> Objects.nonNull(mp.get(key))).collect(Collectors.toMap(key -> TRANS_MAP.getOrDefault(key, (String)key), mp::get))).collect(Collectors.toList())).orElse(new ArrayList(1)));
        dataTagParam.put("type", "show");
        LogUtils.buildAgileDataEngineLog((String)"buildDatatagParam", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(Optional.ofNullable(context.getBizParams().getDataTagParam()).orElse(new HashMap(1))), (String)JSON.toJSONString(dataTagParam), (String)"");
        return dataTagParam;
    }

    private Map<String, Object> buildDataTagParamByAnalysis(Object dataTagParams) {
        HashMap<String, Object> dataTagParam = new HashMap<String, Object>();
        dataTagParam.put("name", "dataDisplay");
        dataTagParam.put("fields", Optional.ofNullable(dataTagParams).map(m -> ((List)m).stream().map(mp -> mp.keySet().stream().filter(key -> Objects.nonNull(mp.get(key))).collect(Collectors.toMap(key -> TRANS_MAP.getOrDefault(key, (String)key), mp::get))).collect(Collectors.toList())).orElse(new ArrayList(1)));
        dataTagParam.put("type", "show");
        LogUtils.buildAgileDataEngineLog((String)"buildDatatagParam", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(Optional.ofNullable(dataTagParams).orElse(new HashMap(1))), (String)JSON.toJSONString(dataTagParam), (String)"");
        return dataTagParam;
    }

    private static String getFieldOriginalType(SolutionStepItem step, DataObject dataObject) {
        Iterator iterator = Optional.ofNullable(step.getComputeList()).map(map -> (List)map.get(dataObject.getContent())).orElseGet(Collections::emptyList).iterator();
        if (iterator.hasNext()) {
            Map computeMap = (Map)iterator.next();
            if ("DateFormat".equals(computeMap.get("calFunction"))) {
                return "datetime";
            }
            return TRANS_MAP.getOrDefault(dataObject.getDataType(), dataObject.getDataType());
        }
        return "string";
    }

    private static List<Map<String, Object>> getParamsFromCompute(Map<String, Object> computeMap) {
        return Optional.ofNullable((List)computeMap.get("params")).orElseGet(Collections::emptyList);
    }

    private Object buildProductInfoParam(String tenantId, String userToken, String locale) {
        return this.edgeDataService.getEdgeDBTypeInfo(tenantId, locale, userToken, locale);
    }

    private void completeTimeUnit(List<Map<String, Object>> data, BizParams bizParams) {
        List aliasGrains = (List)((Map)bizParams.getShowDefine()).get("aliasGrain");
        List agList = JSON.parseArray((String)JSON.toJSONString((Object)aliasGrains), AliasGrain.class);
        Optional.ofNullable(agList).ifPresent(ags -> {
            Map<String, String> alias2GrainMap = ags.stream().collect(Collectors.toMap(AliasGrain::getAlias, m -> Optional.ofNullable(m.getGrain()).orElse("")));
            for (Map item : data) {
                alias2GrainMap.entrySet().stream().forEach(ag -> {
                    if (item.containsKey(ag.getKey())) {
                        Object targetValue = item.get(ag.getKey());
                        item.put(ag.getKey(), Strings.concat((String)(targetValue instanceof String ? (String)targetValue : String.valueOf(targetValue)), (String)TimeGrain.getDespByGrain((String)((String)ag.getValue()))));
                    }
                });
            }
        });
    }

    private Snapshot snapshotParamsPreprocessing(Context context, String snapshotId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("permissionCheck");
        this.permissionCheck(context.getBizParams());
        stopWatch.stop();
        LOGGER.info("AdeServiceImpl#permissionCheck elapse time: {}", (Object)stopWatch.getTotalTimeMillis());
        BizParams bizParams = context.getBizParams();
        bizParams.setDimensionInterval((Map)Optional.ofNullable(bizParams.getShowDefine()).map(sdf -> (Map)((Map)sdf).get("dimensionInterval")).orElse(null));
        Snapshot snapshot = new Snapshot();
        if (!org.springframework.util.StringUtils.hasLength((String)snapshotId)) {
            snapshotId = snapshot.setSnapshotId(bizParams.getTenantId(), bizParams.getRuleId() == null ? "" : bizParams.getRuleId(), CollectionUtils.isEmpty((Collection)context.getBizParams().getEocMaps()) ? null : (Map)context.getBizParams().getEocMaps().get(0));
        }
        snapshot.setSnapshotId(snapshotId);
        return snapshot;
    }

    private void buildNewSelectForV2(SolutionStepItem stepItem, List<KMMetricData> kmMetricData, List<ColDataPermissionField> allowField) {
        String datasetId = stepItem.getDatasetObject().getMetric();
        KMMetricData matchedMetricData = kmMetricData.stream().filter(data -> datasetId.equals(data.getIndicatorId())).findFirst().orElse(null);
        if (matchedMetricData == null) {
            throw new BusinessException("\u6570\u636e\u96c6\u5143\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u6784\u9020\u67e5\u8be2\u5b57\u6bb5");
        }
        if (CollectionUtils.isEmpty(allowField)) {
            throw new BusinessException("\u65e0\u6570\u636e\u8bbf\u95ee\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u5bfc\u51fa");
        }
        Set allowedFieldNames = allowField.stream().map(ColDataPermissionField::getField).filter(Objects::nonNull).collect(Collectors.toSet());
        ArrayList<SelectItem> newSelectList = new ArrayList<SelectItem>();
        if (!CollectionUtils.isEmpty((Collection)matchedMetricData.getDimensions())) {
            for (MetaDataResponseData dimension : matchedMetricData.getDimensions()) {
                if (!allowedFieldNames.contains(dimension.getData_name())) continue;
                newSelectList.add(this.buildSelectItem(dimension, stepItem));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)matchedMetricData.getMeasures())) {
            for (MetaDataResponseData measure : matchedMetricData.getMeasures()) {
                if (!allowedFieldNames.contains(measure.getData_name())) continue;
                newSelectList.add(this.buildSelectItem(measure, stepItem));
            }
        }
        if (CollectionUtils.isEmpty(newSelectList)) {
            throw new BusinessException("\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u5b57\u6bb5");
        }
        stepItem.setSelect(newSelectList);
    }

    private SelectItem buildSelectItem(MetaDataResponseData fieldData, SolutionStepItem stepItem) {
        SelectItem selectItem = new SelectItem();
        DataObject dataObject = new DataObject();
        dataObject.setDataType(fieldData.getData_type());
        dataObject.setAlias(fieldData.getData_name());
        dataObject.setSource(stepItem.getDatasetObject().getAlias());
        dataObject.setContentType("field");
        dataObject.setTitle(fieldData.getName());
        dataObject.setContent(fieldData.getData_name());
        selectItem.setDataObject(dataObject);
        return selectItem;
    }

    static {
        TRANS_MAP.put("eocCompanyId", "eoc_company_id");
        TRANS_MAP.put("eocSiteId", "eoc_site_id");
        TRANS_MAP.put("number", "numeric");
        TRANS_MAP.put("none", "");
        TRANS_MAP.put("alias", "field");
    }
}

