/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.service.AgileDataEchoService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="agileDataEchoService")
public class AgileDataEchoServiceImpl
implements AgileDataEchoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgileDataEchoServiceImpl.class);
    private final HttpService httpService;

    public AgileDataEchoServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public Boolean exceptionSubmit(String userToken, String tenantId, String locale, Map<String, Object> params) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.agiledataecho.url") + "/api/ai/agile/echo" + "/exception/submit";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            return responseEntity.getStatusCode().is2xxSuccessful() && ((Map)responseEntity.getBody()).get("status").equals(200);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u9519\u8bef\u4e2d\u5fc3\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            return false;
        }
    }
}

