/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.smartdata.agiledataengine.core.config.RemoteApiConfig;
import com.digiwin.smartdata.agiledataengine.core.util.StringUtil;
import com.digiwin.smartdata.agiledataengine.pojo.request.ScheduleDetailModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component
public class CustomHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);
    private static final String APP_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";
    private static final String DO_POST_PREFIX = "doPost\u8bf7\u6c42";
    private static final String ERROR_5XX = "\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01";
    private static final String ERROR_UNKNOWN = "\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01";
    private static final String PASS_FOR_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";
    private static final String PASS_FOR_HASH_KEY = "passwordHash";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteApiConfig remoteApiConfig;

    public String doPost(String url, Map<String, Object> body, String token, String routerKey) {
        ResponseEntity content;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.set("routerKey", routerKey);
        if (StringUtil.isNotBlank(token)) {
            headers.set("token", token);
        }
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            content = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("doPost\u8bf7\u6c42\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9: " + e.getResponseBodyAsString(), (Throwable)e);
            throw new DWRuntimeException("doPost\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        catch (HttpServerErrorException e) {
            LOGGER.error("doPost\u8bf7\u6c42[" + url + "]" + ERROR_5XX + "\u62a5\u6587\u4f53\u5185\u5bb9: " + e.getResponseBodyAsString(), (Throwable)e);
            throw new DWRuntimeException("doPost\u8bf7\u6c42[" + url + "]" + ERROR_5XX);
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error("doPost\u8bf7\u6c42[" + url + "]" + ERROR_UNKNOWN + "\u62a5\u6587\u4f53\u5185\u5bb9: " + e.getResponseBodyAsString(), (Throwable)e);
            throw new DWRuntimeException("doPost\u8bf7\u6c42[" + url + "]" + ERROR_UNKNOWN);
        }
        if (HttpStatus.OK != content.getStatusCode()) {
            throw new DWRuntimeException("doPost\u8bf7\u6c42:" + url + "\u8fd4\u56deHttpStatus\u4e3a" + content.getStatusCode());
        }
        return (String)content.getBody();
    }

    public String getRealTimeTenantToken(String tenantId) {
        String uri = this.remoteApiConfig.getIamAddr();
        LOGGER.error("\u8c03\u7528iam\u63a5\u53e3,uri :{}", (Object)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", APP_TOKEN);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put(PASS_FOR_HASH_KEY, PASS_FOR_HASH);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<JSONObject>(){}, param);
        JSONObject result = (JSONObject)responseEntity.getBody();
        String tenantToken = result.getString("token");
        if (StringUtils.isEmpty((CharSequence)tenantToken)) {
            LOGGER.error("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token\u5f02\u5e38");
            throw new RuntimeException(String.format("\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7\u79df\u6237token:%s\u63a5\u53e3\u5f02\u5e38", APP_TOKEN));
        }
        return tenantToken;
    }

    public String postExecuteTrigger(ScheduleDetailModel scheduleDetailModel, String token) {
        String uri = this.remoteApiConfig.getAsmAddr();
        LOGGER.info("postExecuteTrigger#uri :{}", (Object)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.add("routerKey", scheduleDetailModel.getTenantId());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)scheduleDetailModel, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<JSONObject>(){}, new Object[0]);
        JSONObject result = (JSONObject)responseEntity.getBody();
        LOGGER.info("postExecuteTrigger#result :{}", (Object)result);
        String tenantToken = result.getString("code");
        return tenantToken;
    }
}

