/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.model.ErrorCodeDto;
import com.digiwin.smartdata.agiledataengine.model.Snapshot;
import com.digiwin.smartdata.agiledataengine.service.DataSnapshotService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.GsonUtil;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service(value="dataSnapshotService")
public class DataSnapshotServiceImpl
implements DataSnapshotService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSnapshotServiceImpl.class);
    private final HttpService httpService;

    public DataSnapshotServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public String saveDataSnapshot(String tenantId, String locale, String userToken, Snapshot snapshot) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"athena.adt.url") + "/api/ai" + "/agileData/report/process";
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), GsonUtil.getJsonString((Object)snapshot), Object.class);
            LogUtils.buildAgileDataEngineLog((String)"saveDataSnapshot", (String)LogUtils.SUCCESS, (String)JsonUtil.getJsonString((Object)snapshot), (String)snapshot.getSnapshotId(), (String)"");
            return responseEntity.getStatusCode().is2xxSuccessful() ? snapshot.getSnapshotId() : "";
        }
        catch (Exception e) {
            LOGGER.error("\u5b58\u50a8\u5feb\u7167\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f----url\uff1a" + url + "bodys\uff1a" + JsonUtil.getJsonString((Object)snapshot));
            ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpServerErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u5b58\u50a8\u5feb\u7167\u5931\u8d25"));
            JSONObject jsonObject = new JSONObject(4);
            jsonObject.put("tenantId", (Object)tenantId);
            LogUtils.buildAgileDataEngineLog((String)"saveDataSnapshot", (String)"U.ADE.501.0121", (String)jsonObject.toJSONString(), (String)("\u7ec4\u88c5\u5feb\u7167\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u6587\u6863\u4e2d\u5fc3\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"\u8bf7\u7b49\u5f8530\u79d2\u518d\u91cd\u8bd5\uff0c\u5982\u679c\u4ecd\u6ca1\u6709\u6062\u590d\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u3002");
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff1a" + errorCodeDto.getMessage());
            return snapshot.getSnapshotId();
        }
    }

    public Map<String, Object> getScene(String tenantId, String locale, String userToken, String question) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"athena.adt.url") + "/api/ai" + "/assist/data/getADEParams/" + question;
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), Collections.EMPTY_MAP, (ParameterizedTypeReference)responseType);
            return responseEntity.getStatusCode().is2xxSuccessful() ? (Map)((Map)((Map)((Map)responseEntity.getBody()).get("response")).get("body")).get("response") : Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u573a\u666f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Collections.EMPTY_MAP;
        }
    }

    public Map<String, Object> getSceneByMore(String tenantId, String locale, String userToken, Map<String, Object> body) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"athena.adt.url") + "/api/ai" + "/assist/data/getADEParams";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(body), (ParameterizedTypeReference)responseType);
            return responseEntity.getStatusCode().is2xxSuccessful() ? (Map)((Map)((Map)((Map)responseEntity.getBody()).get("response")).get("body")).get("response") : Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u591a\u573a\u666f\u4e0b\u6307\u5b9a\u573a\u666f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Collections.EMPTY_MAP;
        }
    }
}

