/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.constant.BusinessConstant;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.service.DcpService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dcpService")
public class DcpServiceImpl
implements DcpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpServiceImpl.class);
    private final HttpService httpService;

    public DcpServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public Map<String, Object> getDcpModelDataQuery(Map<String, Object> querySchema, String tenantId, String locale, String userToken, String routerKey) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dcp.url") + "/api/ddl/parse/and/return";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(routerKey), JsonUtil.getJsonString(querySchema), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("data") instanceof Map && ((Map)responseEntity.getBody()).get("data") != null) {
                return (Map)((Map)((Map)responseEntity.getBody()).get("data")).get(BusinessConstant.DETAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u51fa\u9519\u4e86\uff0cquerySchema\uff1a{},\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)JsonUtil.getJsonString(querySchema), (Object)e.getMessage());
            throw e;
        }
        return null;
    }
}

