/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.dmc.sdk.util.JsonUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.model.DmcFileRequest;
import com.digiwin.smartdata.agiledataengine.model.DmcFileResponse;
import com.digiwin.smartdata.agiledataengine.model.DmcShareFileRequest;
import com.digiwin.smartdata.agiledataengine.model.Snapshot;
import com.digiwin.smartdata.agiledataengine.service.DmcService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.CommonInputStreamResourceUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import io.seata.common.util.CollectionUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;

@Service(value="dmcService")
public class DmcServiceImpl
implements DmcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmcServiceImpl.class);
    private final HttpService httpService;

    public DmcServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public DmcFileResponse uploadFile(String userToken, String locale, String tenantId, DmcFileRequest file, String fileType) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dmc.url") + "/api/dmc/v2/" + "file/" + "asada" + "/upload";
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        if ("file".equals(fileType)) {
            builder.part("file", (Object)new FileSystemResource(file.getFile()));
        }
        if ("stream".equals(fileType)) {
            CommonInputStreamResourceUtil inputStreamResource = new CommonInputStreamResourceUtil(file.getInputStream(), file.getFileInfo().getDescription() + ".json");
            builder.part("file", (Object)inputStreamResource);
        }
        builder.part("fileInfo", (Object)JsonUtils.writeValueAsString((Object)file.getFileInfo())).header("Content-Type", new String[]{"application/json;charset=UTF-8"});
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setContentType("multipart/form-data"), (Object)builder.build(), Map.class);
            if (!CollectionUtils.isEmpty((Map)response)) {
                DmcFileResponse fileResponse = (DmcFileResponse)JsonUtil.getObject((String)JsonUtil.getJsonString(response.get("data")), DmcFileResponse.class);
                return fileResponse;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public String getShareUrl(String userToken, String locale, String tenantId, DmcShareFileRequest file) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dmc.url") + "/api/dmc/v2/" + "file/" + "asada" + "/share";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString((Object)file), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody()))) {
                Map data = (Map)((Map)responseEntity.getBody()).get("data");
                return (String)data.get("url");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u5206\u4eab\u94fe\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public String getDMCUserToken(String tenantId, String agileDataUsername, String agileDataPassword) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dmc.url") + "/api/dmc/v1/" + "auth/login";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        HashMap<String, String> pars = new HashMap<String, String>(3);
        pars.put("tenantId", tenantId);
        pars.put("username", agileDataUsername);
        pars.put("pwdhash", this.buildPassword(agileDataPassword));
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setTenantId(tenantId), JsonUtil.getJsonString(pars), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody()))) {
                Map data = (Map)responseEntity.getBody();
                return (String)data.get("userToken");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237token\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public DmcFileResponse getDmcFileInfo(String userToken, String locale, String tenantId, String fileId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dmc.url") + "/api/dmc/v2/" + "fileinfo/" + "asada" + "/" + fileId;
        try {
            Map body;
            ResponseEntity response = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){});
            if (response.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)(body = (Map)response.getBody()))) {
                DmcFileResponse fileResponse = (DmcFileResponse)JsonUtil.getObject((String)JsonUtil.getJsonString(body.get("data")), DmcFileResponse.class);
                return fileResponse;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public Snapshot downloadDmcFile(String userToken, String locale, String tenantId, String bucket, String fileId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.dmc.url") + "/api/dmc/v2/" + "file/" + bucket + "/download/" + fileId;
        try {
            Snapshot body;
            ResponseEntity response = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), (ParameterizedTypeReference)new ParameterizedTypeReference<Snapshot>(){});
            if (response.getStatusCode().is2xxSuccessful() && ObjectUtil.isNotEmpty((Object)(body = (Snapshot)response.getBody()))) {
                return body;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6DMC\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    private String buildPassword(String agileDataPassword) {
        try {
            MessageDigest sha256MessageDigest = MessageDigest.getInstance("SHA-256");
            sha256MessageDigest.update(agileDataPassword.getBytes(StandardCharsets.UTF_8));
            byte[] tempByte = sha256MessageDigest.digest();
            sha256MessageDigest.update(tempByte);
            return new String(Base64.getEncoder().encode(sha256MessageDigest.digest()));
        }
        catch (Exception e) {
            LOGGER.error("dmc\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            return agileDataPassword;
        }
    }
}

