/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.service.EdgeDataService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="edgeDataService")
public class EdgeDataServiceImpl
implements EdgeDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeDataServiceImpl.class);
    private final HttpService httpService;

    public EdgeDataServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getEdgeInfo(String tenantId, String locale, String userToken, String tenantSid) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.edgedata.url") + "/dcdpgateway/dcdpitms" + "/v2/device/valid/app/setting/by/map";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("eid", tenantSid);
        params.put("deviceAppType", "ChatBI");
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            LOGGER.info("EdgeDataServiceImpl#getEdgeInfo {}", (Object)JSON.toJSONString(((Map)responseEntity.getBody()).get("data")));
            List list = responseEntity.getStatusCode().is2xxSuccessful() ? (List)((Map)responseEntity.getBody()).get("data") : Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u83b7\u53d6\u7528\u6237\u6570\u636e\u6e90\u7c7b\u578b\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        finally {
            LOGGER.info("EdgeDataServiceImpl#getEdgeInfo elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getEdgeDBTypeInfo(String tenantId, String locale, String userToken, String tenantSid) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.edgedata2.url") + "/api/ddl/valid/db/setting/by/map";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), (ParameterizedTypeReference)responseType);
            LOGGER.info("EdgeDataServiceImpl#getEdgeDBTypeInfo {}", (Object)JSON.toJSONString(((Map)responseEntity.getBody()).get("data")));
            List list = responseEntity.getStatusCode().is2xxSuccessful() ? (List)((Map)responseEntity.getBody()).get("data") : Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u83b7\u53d6DBType\u6570\u636e\u6e90\u7c7b\u578b\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        finally {
            LOGGER.info("EdgeDataServiceImpl#getEdgeDBTypeInfo elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }
}

