/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.pojo.DigiwinEocCompanyInfo;
import com.digiwin.smartdata.agiledataengine.pojo.DigiwinEocUserInfo;
import com.digiwin.smartdata.agiledataengine.service.EocService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="eocService")
public class EocServiceImpl
implements EocService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EocServiceImpl.class);
    private final HttpService httpService;

    public EocServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DigiwinEocUserInfo> getUserInfoByIds(String tenantId, String locale, String userToken, List<String> userIds) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.eoc.url") + "/api/eoc/v2" + "/emp/infos";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(2);
        params.put("userIds", userIds);
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            List list = responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)responseEntity.getBody()).get("data")), DigiwinEocUserInfo.class) : Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u7684eoc\u76f8\u5173\u4fe1\u606f\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        finally {
            LOGGER.error("EocService#getUserInfoByIds elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DigiwinEocCompanyInfo> getCompInfoBySuperAdmin(String tenantId, String locale, String userToken) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.eoc.url") + "/api/eoc/v2" + "/corp/company";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(new HashMap(2)), (ParameterizedTypeReference)responseType);
            List list = responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)responseEntity.getBody()).get("data")), DigiwinEocCompanyInfo.class) : Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u7684eoc\u7684company\u4fe1\u606f\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        finally {
            LOGGER.error("EocService#getCompInfoBySuperAdmin elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }
}

