/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.exception.ResponseStatusException;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.model.ErrorCodeDto;
import com.digiwin.smartdata.agiledataengine.service.AgileDataEchoService;
import com.digiwin.smartdata.agiledataengine.service.ExecuteEngineService;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.util.AgileDataEchoUtil;
import com.digiwin.smartdata.agiledataengine.util.DateTimeUtil;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service(value="executeEngineService")
public class ExecuteEngineServiceImpl
implements ExecuteEngineService {
    @Autowired
    private AgileDataEchoService agileDataEchoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteEngineServiceImpl.class);
    private final HttpService httpService;

    public ExecuteEngineServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public Object getPullData(String userToken, String locale, String tenantId, String messageId, Map<String, Object> params) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.adn.url") + "/restful/service/ExecutionEngine/execute";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setMessageId(messageId).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")).setSource("agiledata"), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            LOGGER.info("EE_\u5165\u53c2\u6570\u636e\uff1a{}  \uff0c\u8fd4\u56de\u7684\u6570\u636e\u662f\uff1a{}", (Object)JsonUtil.getJsonString(params), (Object)JsonUtil.getJsonString((Object)responseEntity.getBody()));
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") instanceof Map) {
                LogUtils.buildAgileDataEngineLog((String)"reqQueryTransDataByMetric", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(params), (String)JSON.toJSONString(((Map)responseEntity.getBody()).get("response")), (String)"");
                return ((Map)responseEntity.getBody()).get("response");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u51fa\u9519\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},body\uff1a{}", (Object)url, (Object)JsonUtil.getJsonString(params));
            ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpServerErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u51fa\u9519\u4e86"));
            LOGGER.error("EE_\u8bf7\u6c42\u7684\u56de\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)errorCodeDto));
            return errorCodeDto;
        }
        return null;
    }

    public Object getSencePullData(String userToken, String locale, String tenantId, String messageId, Map<String, Object> params) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.adn.url") + "/restful/standard/trans/v1/getOldData";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setMessageId(messageId).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")).setSource("agiledata"), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            LOGGER.info("\u5165\u53c2\u6570\u636e\uff1a{}  \uff0c\u8fd4\u56de\u7684\u6570\u636e\u662f\uff1a{}", (Object)JsonUtil.getJsonString(params), (Object)JsonUtil.getJsonString((Object)responseEntity.getBody()));
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") instanceof Map) {
                LogUtils.buildAgileDataEngineLog((String)"reqQueryTransDataByMetric", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(params), (String)JSON.toJSONString(((Map)responseEntity.getBody()).get("response")), (String)"");
                return ((Map)responseEntity.getBody()).get("response");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u51fa\u9519\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},body{\uff1a{}}", (Object)url, (Object)JsonUtil.getJsonString(params));
            ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpServerErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u51fa\u9519\u4e86"));
            LOGGER.error("EE_\u8bf7\u6c42\u7684\u56de\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)errorCodeDto));
            return errorCodeDto;
        }
        return null;
    }

    public Object getPullDataDetail(String userToken, String locale, String tenantId, String messageId, Map<String, Object> params) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.adn.url") + "/restful/service/ExecutionEngine/execute/export";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setMessageId(messageId).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")).setSource("agiledata"), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            LOGGER.info("\u5165\u53c2\u6570\u636e\uff1a{}  \uff0c\u8fd4\u56de\u7684\u6570\u636e\u662f\uff1a{}", (Object)JsonUtil.getJsonString(params), (Object)JsonUtil.getJsonString((Object)responseEntity.getBody()));
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") instanceof List) {
                return ((Map)responseEntity.getBody()).get("response");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u83b7\u53d6\u6307\u6807\u660e\u7ec6\u51fa\u9519\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},body{\uff1a{}}", (Object)url, (Object)JsonUtil.getJsonString(params));
            ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpServerErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u8c03\u7528\u62c9\u53d6\u5f15\u64ce\u83b7\u53d6\u6307\u6807\u660e\u7ec6\u51fa\u9519"));
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff1a{}", (Object)errorCodeDto.getMessage());
            return errorCodeDto;
        }
        return null;
    }

    public Object postRunTrans(List<Map<String, Object>> recasts, Object data, String tenantId, String locale, String userToken, String messageId, String actionId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.adn.url") + "/restful/service/ExecutionEngine/trans/postRunTrans";
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("recasts", recasts);
        params.put("data", data);
        params.put("actionId", actionId);
        params.put("tenantId", tenantId);
        try {
            Long startTime = System.currentTimeMillis();
            LOGGER.error("agiledata_recast_\u8bf7\u6c42\u7684\u5165\u53c2\u4e3a:{}", (Object)JsonUtil.getJsonString(params));
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setSource("agiledata").setMessageId(messageId), JsonUtil.getJsonString(params), String.class);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                LogUtils.buildAgileDataEngineRecastLog((String)"postRunTrans", (String)"U.ADE.501.0129", (String)JSONObject.toJSONString(params), (String)JSON.toJSONString((Object)JsonUtil.getObject((String)((String)responseEntity.getBody())).get((Object)"response")), (String)"");
                Long endTime = System.currentTimeMillis();
                LOGGER.error("agiledata_recast_\u8bf7\u6c42\u7684\u56de\u53c2\u8017\u65f6{}\u6beb\u79d2\uff0c\u56de\u53c2\u4e3a:{}", (Object)(endTime - startTime), JsonUtil.getObject((String)((String)responseEntity.getBody())).get((Object)"response"));
                return JsonUtil.getObject((String)((String)responseEntity.getBody())).get((Object)"response");
            }
        }
        catch (Exception e) {
            ErrorCodeDto errorCodeDto;
            LOGGER.error("\u8bf7\u6c42\u6267\u884c\u5f15\u64ce-trans\u63a5\u53e3\u62a5\u9519\u4e86\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            if (e instanceof HttpClientErrorException) {
                errorCodeDto = HttpClientUtil.parseErrorInfo((String)((HttpClientErrorException)((Object)e)).getResponseBodyAsString());
            } else if (e instanceof HttpServerErrorException) {
                errorCodeDto = HttpClientUtil.parseErrorInfo((String)((HttpServerErrorException)((Object)e)).getResponseBodyAsString());
            } else {
                errorCodeDto = new ErrorCodeDto("500", "\u8bf7\u6c42\u6267\u884c\u5f15\u64ce-trans\u63a5\u53e3\u62a5\u9519\u4e86");
                this.agileDataEchoService.exceptionSubmit(userToken, tenantId, locale, AgileDataEchoUtil.buildSubmitParams((String)messageId, (String)ThreadContext.get((String)"PtxId"), (String)"ade", (String)"ade", (String)"\u7ec4\u4ef6(ADE)->\u6267\u884c\u5f15\u64ce\u7ec4\u4ef6(EE),\u8bf7\u6c42\u62a5\u9519\u4e86", (String)JSON.toJSONString(params), (String)"\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"));
            }
            LogUtils.buildAgileDataEngineRecastLog((String)"postRunTrans", (String)"U.ADE.501.0129", (String)JSONObject.toJSONString(params), (String)("\u7ec4\u4ef6(ADE)->\u6267\u884c\u5f15\u64ce\u7ec4\u4ef6(EE) \u4e8c\u6b21\u8ba1\u7b97\u62a5\u9519\uff0c\u5931\u8d25\u539f\u56e0:" + LogUtils.appendBracket((String)e.getMessage())), (String)"");
            LOGGER.error("agiledata_ade_\u8bf7\u6c42\u7684\u56de\u53c2\uff0c\u95ee\u9898\u4f4d\u7f6e\uff1a\u7ec4\u4ef6(ADE)->\u6267\u884c\u5f15\u64ce\u7ec4\u4ef6(EE)\uff0c\u95ee\u9898\u63cf\u8ff0\uff1a\u8d85\u65f6\uff0c\u53d1\u751f\u65f6\u95f4\uff1a" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + JSON.toJSONString(params) + "\uff0c\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\uff1a\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406");
            throw new ResponseStatusException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage());
        }
        return data;
    }
}

